import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">:host{white-space:nowrap}:host-context([dir=rtl]) cr-input.phone-number-input::part(input){direction:ltr;text-align:end}.address-row{display:flex}.address-column{margin-inline-end:16px;width:calc((var(--cr-default-input-max-width) - 16px) / 2)}#select-row{display:block;outline:none;transform:translate3d(0,0,0)}.md-select{--md-select-width:var(--cr-default-input-max-width)}.long{width:var(--cr-default-input-max-width)}cr-input{--cr-input-error-display:none}cr-input:not(.last-row),cr-textarea,.md-select{margin-bottom:var(--cr-form-field-bottom-spacing)}#dialog::part(body-container){max-height:550px}@media all and (max-height:714px){#dialog::part(body-container){max-height:270px}}#notices{margin-bottom:4px;margin-top:20px;white-space:initial}#validationError{color:var(--google-red-600)}@media (prefers-color-scheme:dark){#validationError{color:var(--google-red-300)}}

    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <div id="select-row" class="address-row">
          <label id="select-label" class="cr-form-field-label">
            $i18n{addressCountry}
          </label>
          <select id="country" class="md-select" aria-labelledby="select-label"
              value="[[countryCode_]]" on-change="onCountryCodeSelectChange_"
              autofocus>
            <!-- TODO(crbug.com/403312087): Use
                 $i18n{autofillDropdownNoOptionSelected} as a text for this
                 option once the string is approved. -->
            <option value="" hidden="[[isAccountAddress_]]"></option>
            <template is="dom-repeat" items="[[countries_]]">
              <option value="[[getCode_(item)]]"
                  disabled="[[isDivision_(item)]]">
                [[getName_(item)]]
              </option>
            </template>
          </select>
        </div>
        <template is="dom-repeat" items="[[components_]]">
          <div class="address-row">
            <template is="dom-repeat" items="[[item]]">
              <template is="dom-if" if="[[item.isTextarea]]">
                <cr-textarea label="[[item.label]]"
                    value="{{item.value}}"
                    class$="address-column [[item.additionalClassName]]"
                    spellcheck="false" maxlength="1000"
                    required="[[item.isRequired]]"
                    invalid="[[isVisuallyInvalid_(item.isValidatable,
                                                  item.isValid)]]">
                </cr-textarea>
              </template>
              <template is="dom-if" if="[[!item.isTextarea]]">
                <cr-input type="text" label="[[item.label]]"
                    value="{{item.value}}" spellcheck="false"
                    maxlength="1000"
                    class$="address-column [[item.additionalClassName]]
                    [[getPhoneNumberInputClass_(item.fieldType)]]"
                    required="[[item.isRequired]]"
                    invalid="[[isVisuallyInvalid_(item.isValidatable,
                                                  item.isValid)]]">
                </cr-input>
              </template>
            </template>
          </div>
        </template>
        <div id="notices" hidden="[[!isAccountAddress_]]">
          <div id="validationError" hidden="[[!validationError_]]">
            [[validationError_]]
          </div>
          <div id="accountRecordTypeNotice"
              hidden="[[!accountAddressRecordTypeNotice_]]">
            [[accountAddressRecordTypeNotice_]]
          </div>
        </div>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="saveButton" class="action-button"
            disabled="[[!canSave_]]" on-click="onSaveButtonClick_">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}