import './value_display.js';
import './mojo_timestamp.js';
import './mojo_timedelta.js';
import './text_copy_button.js';
import type { Time, TimeDelta } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { CustomElement } from 'chrome://resources/js/custom_element.js';
import type { Value } from 'chrome://resources/mojo/mojo/public/mojom/base/values.mojom-webui.js';
import type { ContentSettingPatternSource as MojoContentSettingPatternSource } from './content_settings.mojom-webui.js';
import type { PageHandlerInterface } from './privacy_sandbox_internals.mojom-webui.js';
import type { LogicalFn } from './value_display.js';
export declare class ContentSettingPatternSourceElement extends CustomElement {
    static get template(): string | TrustedHTML;
    getFieldElement(key: string): HTMLElement | null;
    setField(key: string, value: string): void;
    setFieldValue(key: string, value: Value, logicalFn?: LogicalFn): void;
    setFieldTime(key: string, time: Time): void;
    setFieldDuration(key: string, time: TimeDelta): void;
    private getSearchableContent;
    configure(pageHandler: PageHandlerInterface, cs: MojoContentSettingPatternSource): Promise<string>;
}
declare global {
    interface HTMLElementTagNameMap {
        'content-setting-pattern-source': ContentSettingPatternSourceElement;
    }
}
