// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_ripple/cr_ripple.js';
import '//resources/cr_elements/cr_menu_selector/cr_menu_selector.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './sidebar.css.js';
import { getHtml } from './sidebar.html.js';
export class PrivateStateTokensSidebarElement extends CrLitElement {
    static get is() {
        return 'private-state-tokens-sidebar';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            menuItems: { type: Array },
        };
    }
    #menuItems_accessor_storage = [
        {
            icon: 'cr:settings_icon',
            name: 'Settings',
            path: 'chrome://settings',
        },
    ];
    get menuItems() { return this.#menuItems_accessor_storage; }
    set menuItems(value) { this.#menuItems_accessor_storage = value; }
    getMenuItemsForTesting() {
        return this.menuItems;
    }
}
customElements.define(PrivateStateTokensSidebarElement.is, PrivateStateTokensSidebarElement);
