// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_button/cr_button.js';
import './list_item.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './list_container.css.js';
import { getHtml } from './list_container.html.js';
export class PrivateStateTokensListContainerElement extends CrLitElement {
    static get is() {
        return 'private-state-tokens-list-container';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            data: { type: Array },
            isAnyRowCollapsed: { type: Boolean },
        };
    }
    #data_accessor_storage = [];
    get data() { return this.#data_accessor_storage; }
    set data(value) { this.#data_accessor_storage = value; }
    #isAnyRowCollapsed_accessor_storage = true;
    get isAnyRowCollapsed() { return this.#isAnyRowCollapsed_accessor_storage; }
    set isAnyRowCollapsed(value) { this.#isAnyRowCollapsed_accessor_storage = value; }
    rowExpandedStates_ = new Map();
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        this.isAnyRowCollapsed = Array.from(this.rowExpandedStates_.values())
            .some(expanded => !expanded);
    }
    onClick_() {
        const rows = this.shadowRoot.querySelectorAll('private-state-tokens-list-item');
        for (const row of rows) {
            (row).expanded =
                this.isAnyRowCollapsed;
        }
    }
    onExpandedToggled_(e) {
        this.rowExpandedStates_.set(e.detail.id, e.detail.expanded);
        this.requestUpdate();
    }
    expandCollapseButtonText_() {
        return this.isAnyRowCollapsed ? 'Expand All' : 'Collapse All';
    }
}
customElements.define(PrivateStateTokensListContainerElement.is, PrivateStateTokensListContainerElement);
