// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_collapse/cr_collapse.js";import"//resources/cr_elements/cr_expand_button/cr_expand_button.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./list_item.css.js";import{getHtml}from"./list_item.html.js";import{nullMetadataObj}from"./types.js";export class PrivateStateTokensListItemElement extends CrLitElement{static get is(){return"private-state-tokens-list-item"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{expanded:{type:Boolean},issuerOrigin:{type:String},numTokens:{type:Number},redemptions:{type:Array},index:{type:Number},metadata:{type:Object}}}#expanded_accessor_storage=false;get expanded(){return this.#expanded_accessor_storage}set expanded(value){this.#expanded_accessor_storage=value}#issuerOrigin_accessor_storage="";get issuerOrigin(){return this.#issuerOrigin_accessor_storage}set issuerOrigin(value){this.#issuerOrigin_accessor_storage=value}#numTokens_accessor_storage=0;get numTokens(){return this.#numTokens_accessor_storage}set numTokens(value){this.#numTokens_accessor_storage=value}#redemptions_accessor_storage=[];get redemptions(){return this.#redemptions_accessor_storage}set redemptions(value){this.#redemptions_accessor_storage=value}#index_accessor_storage=-1;get index(){return this.#index_accessor_storage}set index(value){this.#index_accessor_storage=value}#metadata_accessor_storage=nullMetadataObj;get metadata(){return this.#metadata_accessor_storage}set metadata(value){this.#metadata_accessor_storage=value}onExpandedChanged_(e){this.expanded=e.detail.value;this.dispatchEvent(new CustomEvent("expanded-toggled",{detail:{id:this.issuerOrigin,expanded:this.expanded}}))}updateMetadataUrlParams(){const metadataUrlParam=new URLSearchParams(window.location.search);metadataUrlParam.set("id",this.index.toString());window.history.pushState({},"",`${window.location.pathname}?${metadataUrlParam}`);window.dispatchEvent(new CustomEvent("navigate-to-metadata",{detail:this.metadata}))}getNumTokensString_(){if(this.numTokens>0){return` ${this.numTokens} token${this.redemptions.length>0?"s,":""}`}return""}getRedemptionsString_(){if(this.redemptions.length===0){return""}return`${this.redemptions.length} recent redemption${this.redemptions.length>1?"s":""}`}}customElements.define(PrivateStateTokensListItemElement.is,PrivateStateTokensListItemElement);