export interface PromoCard {
    id: string;
    title: string;
    description: string;
    actionButtonText?: string;
}
export interface PromoCardsProxy {
    /**
     * Returns promo card to show, or null if there are no available promo cards.
     */
    getAvailablePromoCard(): Promise<PromoCard | null>;
    /**
     * Records dismissal of a promo card. This is important to determine whether
     * promo should be shown in the future.
     */
    recordPromoDismissed(id: string): void;
}
export declare class PromoCardsProxyImpl implements PromoCardsProxy {
    getAvailablePromoCard(): Promise<any>;
    recordPromoDismissed(id: string): void;
    static getInstance(): PromoCardsProxy;
    static setInstance(obj: PromoCardsProxy): void;
}
