import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import '../shared_style.css.js';
import '../user_utils_mixin.js';
import './password_preview_item.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
/**
 * This should be kept in sync with the enum in
 * components/password_manager/core/browser/password_manager_metrics_util.h.
 * These values are persisted to logs. Entries should not be renumbered and
 * numeric values should never be reused.
 * @enum {number}
 */
export declare enum MoveToAccountStoreTrigger {
    SUCCESSFUL_LOGIN_WITH_PROFILE_STORE_PASSWORD = 0,
    EXPLICITLY_TRIGGERED_IN_SETTINGS = 1,
    EXPLICITLY_TRIGGERED_FOR_MULTIPLE_PASSWORDS_IN_SETTINGS = 2,
    USER_OPTED_IN_AFTER_SAVING_LOCALLY = 3,
    EXPLICITLY_TRIGGERED_FOR_SINGLE_PASSWORD_IN_DETAILS_IN_SETTINGS = 4,
    COUNT = 5
}
export interface MoveSinglePasswordDialogElement {
    $: {
        accountEmail: HTMLElement;
        avatar: HTMLImageElement;
        cancel: CrButtonElement;
        dialog: CrDialogElement;
        move: CrButtonElement;
        title: HTMLElement;
        description: HTMLElement;
    };
}
declare const MovePasswordsDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../user_utils_mixin.js").UserUtilMixinInterface);
export declare class MoveSinglePasswordDialogElement extends MovePasswordsDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Password UI entry.
         */
        password: ObjectConstructor;
    };
    password: chrome.passwordsPrivate.PasswordUiEntry;
    connectedCallback(): void;
    private onCancel_;
    private onMoveButtonClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'move-single-password-dialog': MoveSinglePasswordDialogElement;
    }
}
export {};
