import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-input-style cr-shared-style">#noteField{background:var(--cr-input-background-color);border-radius:10px;display:flex;flex-direction:column;padding:10px 12px}#noteValue{border:0;color:var(--cr-input-color);flex:1;opacity:var(--cr-input-readonly-opacity,0.6);overflow:hidden;padding:0;resize:none;text-overflow:ellipsis;white-space:pre-line}#noteValue[limit-note]{max-height:3lh}#noteValue[empty]{color:var(--cr-input-placeholder-color,var(--cr-secondary-text-color));letter-spacing:var(--cr-input-placeholder-letter-spacing);user-select:none}#showMore{color:var(--cr-link-color)}#noteValue,#showMore{font-family:inherit;letter-spacing:0.15px;font-size:inherit}.cr-form-field-label{margin-bottom:8px}#label{color:var(--cr-input-label-color);font-size:11px;line-height:16px}</style>

<div id="label" class="cr-form-field-label">$i18n{noteLabel}</div>
<div id="noteField" class="input-field">
  <div id="noteValue" role="textbox" limit-note$="[[!showNoteFully_]]"
      empty$="[[noteIsEmpty_(note)]]">
    <span>[[getNoteValue_(note)]]</span>
  </div>
  <a id="showMore" href="/" on-click="onshowMoreClick_"
      hidden="[[isNoteFullyVisible_(showNoteFully_, note)]]">
    $i18n{showMore}
  </a>
</div>
<!--_html_template_end_-->`;
}