import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import './iframe.js';
import './doodle_share_dialog.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { Doodle, DoodleShareChannel, ImageDoodle, Theme } from './new_tab_page.mojom-webui.js';
export declare class LogoElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        /**
         * If true displays the Google logo single-colored.
         */
        singleColored: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        /**
         * Used to determine if we should display a dark mode doodle.
         */
        theme: {
            type: ObjectConstructor;
        };
        loaded_: {
            type: BooleanConstructor;
        };
        doodle_: {
            type: ObjectConstructor;
        };
        imageDoodle_: {
            type: ObjectConstructor;
        };
        showLogo_: {
            type: BooleanConstructor;
        };
        showDoodle_: {
            type: BooleanConstructor;
        };
        doodleBoxed_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        imageUrl_: {
            type: StringConstructor;
        };
        showAnimation_: {
            type: BooleanConstructor;
        };
        animationUrl_: {
            type: StringConstructor;
        };
        iframeUrl_: {
            type: StringConstructor;
        };
        duration_: {
            type: StringConstructor;
        };
        height_: {
            type: StringConstructor;
        };
        width_: {
            type: StringConstructor;
        };
        expanded_: {
            type: BooleanConstructor;
        };
        showShareDialog_: {
            type: BooleanConstructor;
        };
        imageDoodleTabIndex_: {
            type: NumberConstructor;
        };
    };
    accessor singleColored: boolean;
    accessor theme: Theme | null;
    private accessor loaded_;
    protected accessor doodle_: Doodle | null;
    protected accessor imageDoodle_: ImageDoodle | null;
    protected accessor showLogo_: boolean;
    protected accessor showDoodle_: boolean;
    private accessor doodleBoxed_;
    protected accessor imageUrl_: string;
    protected accessor showAnimation_: boolean;
    protected accessor animationUrl_: string;
    protected accessor iframeUrl_: string;
    private accessor duration_;
    private accessor height_;
    private accessor width_;
    protected accessor expanded_: boolean;
    protected accessor showShareDialog_: boolean;
    protected accessor imageDoodleTabIndex_: number;
    private eventTracker_;
    private pageHandler_;
    private imageClickParams_;
    private interactionLogUrl_;
    private shareId_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    firstUpdated(): void;
    updated(changedProperties: PropertyValues<this>): void;
    private onImageDoodleChange_;
    private computeImageDoodle_;
    private computeShowLogo_;
    private computeShowDoodle_;
    /**
     * @returns The NTP's background color or null if the NTP does not have
     * a single background color, e.g. when a background image is set.
     */
    private computeBackgroundColor_;
    private computeDoodleBoxed_;
    /**
     * Called when a simple or animated doodle was clicked. Starts animation if
     * clicking preview image of animated doodle. Otherwise, opens
     * doodle-associated URL in new tab/window.
     */
    protected onImageClick_(): void;
    protected onImageLoad_(): void;
    private logImageRendered_;
    protected onImageKeydown_(e: KeyboardEvent): void;
    protected onShare_(e: CustomEvent<DoodleShareChannel>): void;
    private isCtaImageShown_;
    /**
     * Sends a postMessage to the interactive doodle whether the current theme is
     * dark or light. Won't do anything if we don't have an interactive doodle or
     * we haven't been told yet whether the current theme is dark or light.
     */
    private sendMode_;
    private computeImageUrl_;
    private computeAnimationUrl_;
    private computeIframeUrl_;
    protected onShareButtonClick_(e: Event): void;
    protected onShareDialogClose_(): void;
    private onDurationHeightWidthChange_;
    private computeImageDoodleTabIndex_;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-logo': LogoElement;
    }
}
