// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import { ComposeboxMode } from 'chrome://resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './action_chips.css.js';
import { getHtml } from './action_chips.html.js';
/**
 * The element for displaying Action Chips.
 */
export class ActionChipsElement extends CrLitElement {
    static get is() {
        return 'ntp-action-chips';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    onCreateImageClick_() {
        this.onActionChipClick_('Create an image ', ComposeboxMode.CREATE_IMAGE);
    }
    onDeepSearchClick_() {
        this.onActionChipClick_('Help me research ', ComposeboxMode.DEEP_SEARCH);
    }
    onActionChipClick_(query, mode) {
        this.fire('action-chip-click', { searchboxText: query, contextFiles: [], mode });
    }
}
customElements.define(ActionChipsElement.is, ActionChipsElement);
