import {html} from '//resources/lit/v3_0/lit.rollup.js';
import type {LensFormElement} from './lens_form.js';

export function getHtml(this: LensFormElement) {
  return html`<!--_html_template_start_--><form id="fileForm"
      .action="${this.uploadFileAction_}"
      enctype="multipart/form-data"
      method="POST">
  <input id="fileInput"
         name="encoded_image"
         type="file"
         .accept="${this.supportedFileTypes_}"
         @change="${this.handleFileInputChange_}"></input>
</form>
<form id="urlForm"
      .action="${this.uploadUrlAction_}"
      method="GET">
  <input name="url" .value="${this.uploadUrl_}"></input>
  <input name="ep" .value="${this.uploadUrlEntrypoint_}"></input>
  <input name="hl" .value="${this.language_}"></input>
  <input name="st" .value="${this.startTime_}"><input>
  <input name="cd" .value="${this.clientData_}"><input>
  <input name="re" .value="${this.renderingEnvironment_}"></input>
  <input name="s" .value="${this.chromiumSurface_}"></input>
</form>
<!-- Hit a simple gen204 on Lens' servers to prewarm DNS lookup and thus
     decrease latency. -->
<iframe src="https://lens.google.com/gen204" style="display:none;" alt="">
</iframe>
<!--_html_template_end_-->`;
}