// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{addWebUiListener,sendWithPromise}from"chrome://resources/js/cr.js";import{getRequiredElement}from"chrome://resources/js/util.js";function requestProcessList(){sendWithPromise("requestProcessList").then(onProcessListReceived)}function saveDump(){chrome.send("saveDump")}function startProfiling(pid){sendWithPromise("startProfiling",pid).then(onProcessListReceived)}function addListRow(table,celltype,cols){const tr=document.createElement("tr");for(const col of cols){const cell=document.createElement(celltype);if(col){cell.appendChild(col)}tr.appendChild(cell)}table.appendChild(tr)}function onProcessListReceived(data){getRequiredElement("message").innerText=data["message"];const proclist=getRequiredElement("proclist");proclist.innerText="";const processes=data["processes"];if(processes.length===0){return}const table=document.createElement("table");addListRow(table,"th",[null,document.createTextNode("Process ID"),document.createTextNode("Name")]);for(const proc of processes){const procId=proc[0];const procIdText=document.createTextNode(procId.toString());const description=document.createTextNode(proc[1]);const profiled=proc[2];const button=document.createElement("button");if(profiled){button.innerText="Profiling..."}else{button.innerText="☀ Start profiling";button.onclick=()=>startProfiling(procId)}addListRow(table,"td",[button,procIdText,description])}proclist.appendChild(table)}document.addEventListener("DOMContentLoaded",(()=>{getRequiredElement("refresh").onclick=requestProcessList;getRequiredElement("save").onclick=saveDump;addWebUiListener("save-dump-progress",(progress=>{getRequiredElement("save-dump-text").innerText=progress}));requestProcessList()}));