// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{BrowserProxyImpl}from"./browser_proxy.js";let instance=null;export class ScreenshotBitmapBrowserProxyImpl{screenshot;screenshotListenerId;callbacks=[];constructor(){this.screenshotListenerId=BrowserProxyImpl.getInstance().callbackRouter.screenshotDataReceived.addListener(this.screenshotDataReceived.bind(this))}static getInstance(){return instance||(instance=new ScreenshotBitmapBrowserProxyImpl)}static setInstance(obj){instance=obj}fetchScreenshot(callback){this.callbacks.push(callback);if(this.screenshot){createImageBitmap(this.screenshot).then((bitmap=>{callback(bitmap)}));return}}async screenshotDataReceived(screenshotData){const data=screenshotData.pixelData;if(data.invalidBuffer){return}let pixelData;if(Array.isArray(data.bytes)){pixelData=new Uint8ClampedArray(data.bytes)}else{assert(data.sharedMemory);const sharedMemory=data.sharedMemory;const{buffer:buffer,result:result}=sharedMemory.bufferHandle.mapBuffer(0,sharedMemory.size);assert(result===Mojo.RESULT_OK);pixelData=new Uint8ClampedArray(buffer)}const imageWidth=screenshotData.imageInfo.width;const imageHeight=screenshotData.imageInfo.height;const imageData=new ImageData(pixelData,imageWidth,imageHeight);const imageBitmap=await createImageBitmap(imageData);this.screenshot=imageBitmap;for(const callback of this.callbacks){createImageBitmap(this.screenshot).then((bitmap=>{callback(bitmap)}))}}}