// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{assert,assertInstanceof}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getFallbackTheme,skColorToRgbaWithCustomAlpha}from"./color_utils.js";import{CursorTooltipType}from"./cursor_tooltip.js";import{CenterRotatedBox_CoordinateType}from"./geometry.mojom-webui.js";import{UserAction}from"./lens.mojom-webui.js";import{INVOCATION_SOURCE}from"./lens_overlay_app.js";import{recordLensOverlayInteraction}from"./metrics_utils.js";import{getTemplate}from"./object_layer.html.js";import{Polygon_CoordinateType}from"./polygon.mojom-webui.js";import{ScreenshotBitmapBrowserProxyImpl}from"./screenshot_bitmap_browser_proxy.js";import{renderScreenshot}from"./screenshot_utils.js";import{CursorType,focusShimmerOnRegion,ShimmerControlRequester,unfocusShimmer}from"./selection_utils.js";import{toPercent}from"./values_converter.js";const FULLSCREEN_OBJECT_THRESHOLD_PERCENT=.95;const CURSOR_FADE_OUT_TRANSITION_DURATION=150;function isObjectRenderable(object){const objectBoundingBox=object.geometry?.boundingBox;if(!objectBoundingBox){return false}if(objectBoundingBox.box.width>=FULLSCREEN_OBJECT_THRESHOLD_PERCENT&&objectBoundingBox.box.height>=FULLSCREEN_OBJECT_THRESHOLD_PERCENT){return false}return objectBoundingBox.coordinateType!==CenterRotatedBox_CoordinateType.kImage}function hasSegmentationMask(object){assert(object.geometry);return object.geometry.segmentationPolygon.length>0}function compareArea(object1,object2){assert(object1.geometry);assert(object2.geometry);return object2.geometry.boundingBox.box.width*object2.geometry.boundingBox.box.height-object1.geometry.boundingBox.box.width*object1.geometry.boundingBox.box.height}function compareSegmentationMaskArea(object1,object2){assert(object1.geometry);assert(object2.geometry);return getSegmentationMaskArea(object2)-getSegmentationMaskArea(object1)}function getSegmentationMaskArea(object){let area=0;for(const polygon of object.geometry.segmentationPolygon){const vertices=polygon.vertex;for(let i=0;i<vertices.length;i++){if(i<vertices.length-1){area+=vertices[i].x*vertices[i+1].y-vertices[i+1].x*vertices[i].y}else{area+=vertices[i].x*vertices[0].y-vertices[0].x*vertices[i].y}}}return.5*area}function toCssClipPath(object){const polygons=object.geometry.segmentationPolygon;if(!polygons){return"none"}const points=[];for(const polygon of polygons){if(polygon.coordinateType!==Polygon_CoordinateType.kNormalized){continue}for(const vertex of polygon.vertex){points.push(toCssPolygonVertex(object,vertex))}points.push(toCssPolygonVertex(object,polygon.vertex[0]))}if(points.length===0){return"none"}return"polygon(evenodd, "+points.join(", ")+")"}function toCssPolygonVertex(object,vertex){const objectBoundingBox=object.geometry.boundingBox;return toPercent(.5+(vertex.x-objectBoundingBox.box.x)/objectBoundingBox.box.width)+" "+toPercent(.5+(vertex.y-objectBoundingBox.box.y)/objectBoundingBox.box.height)}export class ObjectLayerElement extends PolymerElement{static get is(){return"lens-object-layer"}static get template(){return getTemplate()}static get properties(){return{canvasHeight:Number,canvasWidth:Number,canvasPhysicalHeight:Number,canvasPhysicalWidth:Number,renderedObjects:{type:Array,value:()=>[]},debugMode:{type:Boolean,value:()=>loadTimeData.getBoolean("enableDebuggingMode"),reflectToAttribute:true},theme:{type:Object,value:getFallbackTheme}}}eventTracker_=new EventTracker;context;lastPostSelection=null;fadeOutAnimations=[];fadeOutTimeoutIds=[];postSelectionComparisonThreshold=loadTimeData.getValue("postSelectionComparisonThreshold");router=BrowserProxyImpl.getInstance().callbackRouter;objectsReceivedListenerId=null;browserProxy=BrowserProxyImpl.getInstance();ready(){super.ready();this.context=this.$.objectSelectionCanvas.getContext("2d")}connectedCallback(){super.connectedCallback();this.eventTracker_.add(document,"post-selection-updated",(e=>{this.lastPostSelection=e.detail}));this.objectsReceivedListenerId=this.router.objectsReceived.addListener(this.onObjectsReceived.bind(this));ScreenshotBitmapBrowserProxyImpl.getInstance().fetchScreenshot((screenshot=>{renderScreenshot(this.$.highlightImgCanvas,screenshot)}))}disconnectedCallback(){super.disconnectedCallback();assert(this.objectsReceivedListenerId);this.router.removeListener(this.objectsReceivedListenerId);this.objectsReceivedListenerId=null}handleGestureEnd(event){const objectIndex=this.objectIndexFromPoint(event.clientX,event.clientY);if(objectIndex===null){return false}const object=this.renderedObjects[objectIndex];const selectionRegion=object.geometry.boundingBox;this.browserProxy.handler.issueLensObjectRequest(selectionRegion,hasSegmentationMask(object));this.dispatchEvent(new CustomEvent("render-post-selection",{bubbles:true,composed:true,detail:this.getPostSelectionRegion(selectionRegion)}));this.dispatchEvent(new CustomEvent("detect-text-in-region",{bubbles:true,composed:true,detail:selectionRegion}));this.handlePointerLeave();recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kObjectClick);return true}handlePointerEnter(event){assertInstanceof(event.target,HTMLElement);const object=this.$.objectsContainer.itemForElement(event.target);if(object===null||!hasSegmentationMask(object)||this.isRegionAlreadySelected(this.getPostSelectionRegion(object.geometry.boundingBox))){return}this.clearAndCancelAnimation();this.drawObject(this.context,object);this.focusShimmer(object);this.dispatchEvent(new CustomEvent("set-cursor",{bubbles:true,composed:true,detail:{cursor:CursorType.POINTER}}));this.dispatchEvent(new CustomEvent("set-cursor-tooltip",{bubbles:true,composed:true,detail:{tooltipType:CursorTooltipType.CLICK_SEARCH}}));this.dispatchEvent(new CustomEvent("darken-extra-scrim-opacity",{bubbles:true,composed:true}));this.style.cursor="pointer"}isRegionAlreadySelected(boundingBox){if(this.lastPostSelection===null){return false}return Math.abs(boundingBox.top-this.lastPostSelection.top)<=this.postSelectionComparisonThreshold&&Math.abs(boundingBox.left-this.lastPostSelection.left)<=this.postSelectionComparisonThreshold&&Math.abs(boundingBox.width-this.lastPostSelection.width)<=this.postSelectionComparisonThreshold&&Math.abs(boundingBox.height-this.lastPostSelection.height)<=this.postSelectionComparisonThreshold}handlePointerLeave(){this.fadeOutAnimations.push(this.$.objectSelectionCanvas.animate({opacity:0},{duration:CURSOR_FADE_OUT_TRANSITION_DURATION,fill:"forwards"}));this.fadeOutTimeoutIds.push(setTimeout((()=>{this.clearCanvas(this.context)}),CURSOR_FADE_OUT_TRANSITION_DURATION));unfocusShimmer(this,ShimmerControlRequester.SEGMENTATION);this.dispatchEvent(new CustomEvent("set-cursor",{bubbles:true,composed:true,detail:{cursor:CursorType.DEFAULT}}));this.dispatchEvent(new CustomEvent("set-cursor-tooltip",{bubbles:true,composed:true,detail:{tooltipType:CursorTooltipType.REGION_SEARCH}}));this.dispatchEvent(new CustomEvent("lighten-extra-scrim-opacity",{bubbles:true,composed:true}));this.style.cursor="unset"}setCanvasSizeTo(width,height){this.canvasWidth=width;this.canvasHeight=height;this.canvasPhysicalWidth=width*window.devicePixelRatio;this.canvasPhysicalHeight=height*window.devicePixelRatio;this.context.setTransform(window.devicePixelRatio,0,0,window.devicePixelRatio,0,0)}drawObject(context,object){const polygons=object.geometry.segmentationPolygon;if(!polygons){return}context.beginPath();const cornerRadius=loadTimeData.getInteger("segmentationMaskCornerRadius");for(const polygon of polygons){if(polygon.coordinateType!==Polygon_CoordinateType.kNormalized){continue}const firstVertex=polygon.vertex[0];context.moveTo(firstVertex.x*this.canvasWidth,firstVertex.y*this.canvasHeight);for(let i=1;i<polygon.vertex.length;i++){const currentVertex=polygon.vertex[i];const previousVertex=polygon.vertex[i-1];const dx=currentVertex.x-previousVertex.x;const dy=currentVertex.y-previousVertex.y;const distance=Math.sqrt(dx*dx+dy*dy);const controlPointDistance=Math.min(distance/2,cornerRadius/this.canvasWidth);const controlPoint1x=previousVertex.x+dx*controlPointDistance/distance;const controlPoint1y=previousVertex.y+dy*controlPointDistance/distance;const controlPoint2x=currentVertex.x-dx*controlPointDistance/distance;const controlPoint2y=currentVertex.y-dy*controlPointDistance/distance;context.lineTo(controlPoint1x*this.canvasWidth,controlPoint1y*this.canvasHeight);context.arcTo(controlPoint1x*this.canvasWidth,controlPoint1y*this.canvasHeight,controlPoint2x*this.canvasWidth,controlPoint2y*this.canvasHeight,cornerRadius)}}context.closePath();context.save();context.filter="none";context.clip();context.drawImage(this.$.highlightImgCanvas,0,0,this.canvasWidth,this.canvasHeight);context.restore();context.lineCap="round";context.lineJoin="round";context.lineWidth=6;context.filter="blur(8px)";const objectBoundingBox=object.geometry.boundingBox;const longestEdge=Math.max(objectBoundingBox.box.width,objectBoundingBox.box.height);const left=(objectBoundingBox.box.x-longestEdge/2)*this.canvasWidth;const top=(objectBoundingBox.box.y-longestEdge/2)*this.canvasHeight;const right=(objectBoundingBox.box.x+longestEdge/2)*this.canvasWidth;const bottom=(objectBoundingBox.box.y+longestEdge/2)*this.canvasHeight;const gradient=context.createLinearGradient(left,top,right,bottom);const segmentationColor=skColorToRgbaWithCustomAlpha(this.theme.selectionElement,.65);gradient.addColorStop(0,segmentationColor);gradient.addColorStop(1,segmentationColor);context.strokeStyle=gradient;context.stroke()}clearCanvas(context){context.clearRect(0,0,this.canvasWidth,this.canvasHeight);context.beginPath();context.closePath()}focusShimmer(object){const polygons=object.geometry.segmentationPolygon;if(!polygons){return}const firstVertex=polygons[0].vertex[0];let topMostPoint=firstVertex.y;let bottomMostPoint=firstVertex.y;let leftMostPoint=firstVertex.x;let rightMostPoint=firstVertex.x;for(const polygon of polygons){if(polygon.coordinateType!==Polygon_CoordinateType.kNormalized){continue}for(const vertex of polygon.vertex.slice(1)){topMostPoint=Math.min(topMostPoint,vertex.y);bottomMostPoint=Math.max(bottomMostPoint,vertex.y);leftMostPoint=Math.min(leftMostPoint,vertex.x);rightMostPoint=Math.max(rightMostPoint,vertex.x)}}focusShimmerOnRegion(this,topMostPoint,leftMostPoint,rightMostPoint-leftMostPoint,bottomMostPoint-topMostPoint,ShimmerControlRequester.SEGMENTATION)}onObjectsReceived(objects){const renderableObjects=objects.filter((o=>isObjectRenderable(o)));const objectsWithMask=[];const objectsWithoutMask=[];for(const object of renderableObjects){if(hasSegmentationMask(object)){objectsWithMask.push(object)}else{objectsWithoutMask.push(object)}}objectsWithMask.sort(compareSegmentationMaskArea);objectsWithoutMask.sort(compareArea);this.renderedObjects=objectsWithoutMask.concat(objectsWithMask)}getObjectStyle(object){const objectBoundingBox=object.geometry.boundingBox;if(objectBoundingBox.coordinateType===CenterRotatedBox_CoordinateType.kImage){return""}const styles=[`width: ${toPercent(objectBoundingBox.box.width)}`,`height: ${toPercent(objectBoundingBox.box.height)}`,`top: ${toPercent(objectBoundingBox.box.y-objectBoundingBox.box.height/2)}`,`left: ${toPercent(objectBoundingBox.box.x-objectBoundingBox.box.width/2)}`,`transform: rotate(${objectBoundingBox.rotation}rad)`,`clip-path: ${toCssClipPath(object)}`];return styles.join(";")}getPostSelectionRegion(box){const boundingBox=box.box;const top=boundingBox.y-boundingBox.height/2;const left=boundingBox.x-boundingBox.width/2;return{top:top,left:left,width:boundingBox.width,height:boundingBox.height}}objectIndexFromPoint(x,y){const elementsAtPoint=this.shadowRoot.elementsFromPoint(x,y);for(const element of elementsAtPoint){if(!(element instanceof HTMLElement)){continue}const index=this.$.objectsContainer.indexForElement(element);if(index!==null){return index}}return null}clearAndCancelAnimation(){for(let i=0;i<this.fadeOutAnimations.length;i++){this.fadeOutAnimations[i].cancel()}this.fadeOutAnimations=[];this.clearCanvas(this.context);for(let i=0;i<this.fadeOutTimeoutIds.length;i++){clearTimeout(this.fadeOutTimeoutIds[i])}this.fadeOutTimeoutIds=[]}getObjectNodesForTesting(){return this.shadowRoot.querySelectorAll(".object")}}customElements.define(ObjectLayerElement.is,ObjectLayerElement);