// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PageCallbackRouter, PageHandler } from 'chrome://resources/cr_components/history/history.mojom-webui.js';
import { sendWithPromise } from 'chrome://resources/js/cr.js';
export class BrowserServiceImpl {
    handler;
    callbackRouter;
    constructor(handler, callbackRouter) {
        this.handler = handler;
        this.callbackRouter = callbackRouter;
    }
    static getInstance() {
        if (instance) {
            return instance;
        }
        const handler = PageHandler.getRemote();
        const callbackRouter = new PageCallbackRouter();
        handler.setPage(callbackRouter.$.bindNewPipeAndPassRemote());
        return instance = new BrowserServiceImpl(handler, callbackRouter);
    }
    static setInstance(obj) {
        instance = obj;
    }
    getForeignSessions() {
        return sendWithPromise('getForeignSessions');
    }
    openForeignSessionAllTabs(sessionTag) {
        chrome.send('openForeignSessionAllTabs', [sessionTag]);
    }
    openForeignSessionTab(sessionTag, tabId, e) {
        chrome.send('openForeignSessionTab', [
            sessionTag,
            String(tabId),
            e.button || 0,
            e.altKey,
            e.ctrlKey,
            e.metaKey,
            e.shiftKey,
        ]);
    }
    deleteForeignSession(sessionTag) {
        chrome.send('deleteForeignSession', [sessionTag]);
    }
    recordHistogram(histogram, value, max) {
        chrome.send('metricsHandler:recordInHistogram', [histogram, value, max]);
    }
    recordBooleanHistogram(histogram, value) {
        chrome.metricsPrivate.recordBoolean(histogram, value);
    }
    /**
     * Record an action in UMA.
     * @param action The name of the action to be logged.
     */
    recordAction(action) {
        if (action.indexOf('_') === -1) {
            action = `HistoryPage_${action}`;
        }
        chrome.send('metricsHandler:recordAction', [action]);
    }
    recordTime(histogram, time) {
        chrome.send('metricsHandler:recordTime', [histogram, time]);
    }
    recordLongTime(histogram, time) {
        // It's a bit odd that this is the only one to use chrome.metricsPrivate,
        // but that's because the other code predates chrome.metricsPrivate.
        // In any case, the MetricsHandler doesn't support long time histograms.
        chrome.metricsPrivate.recordLongTime(histogram, time);
    }
    navigateToUrl(url, target, e) {
        chrome.send('navigateToUrl', [url, target, e.button, e.altKey, e.ctrlKey, e.metaKey, e.shiftKey]);
    }
    otherDevicesInitialized() {
        chrome.send('otherDevicesInitialized');
    }
    startTurnOnSyncFlow() {
        chrome.send('startTurnOnSyncFlow');
    }
}
let instance = null;
