// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_icon/cr_iconset.js';
import { getTrustedHTML } from '//resources/js/static_types.js';
const div = document.createElement('div');
div.innerHTML = getTrustedHTML `
<cr-iconset name="glic">
  <svg>
    <defs>
      <g id="offline">
        <path d="M20.25 20.1L10.85 10.65C10.0667 10.8333 9.33333 11.1083 8.65
11.475C7.98333 11.8417 7.38333 12.3 6.85 12.85L4.75 10.7C5.28333 10.1667 5.85833
9.7 6.475 9.3C7.09167 8.9 7.75 8.55 8.45 8.25L6.2 6C5.51667 6.35 4.875 6.74167
4.275 7.175C3.69167 7.59167 3.13333 8.06667 2.6 8.6L0.5 6.45C1.03333 5.91667
1.58333 5.44167 2.15 5.025C2.73333 4.59167 3.35 4.18333 4 3.8L1.9 1.7L3.3
0.299999L21.7 18.7L20.25 20.1ZM12.5 18.5C11.8 18.5 11.2083 18.2583 10.725
17.775C10.2417 17.275 10 16.6833 10 16C10 15.3 10.2417 14.7083 10.725
14.225C11.2083 13.7417 11.8 13.5 12.5 13.5C13.2 13.5 13.7917 13.7417 14.275
14.225C14.7583 14.7083 15 15.3 15 16C15 16.6833 14.7583 17.275 14.275
17.775C13.7917 18.2583 13.2 18.5 12.5 18.5ZM18.4 12.55C18.1167 12.2667 17.875
12.025 17.675 11.825C17.475 11.625 17.2333 11.3833 16.95 11.1L13.35 7.5C14.7
7.63333 15.9583 7.975 17.125 8.525C18.3083 9.075 19.35 9.8 20.25 10.7L18.4
12.55ZM22.4 8.6C21.1167 7.31667 19.625 6.31667 17.925 5.6C16.2417 4.86667
14.4333 4.5 12.5 4.5C12.15 4.5 11.8083 4.51667 11.475 4.55C11.1583 4.56667
10.8333 4.6 10.5 4.65L7.95 2.1C8.68333 1.9 9.425 1.75 10.175 1.65C10.9417 1.55
11.7167 1.5 12.5 1.5C14.8667 1.5 17.075 1.94167 19.125 2.825C21.175 3.70833
22.9667 4.91667 24.5 6.45L22.4 8.6Z" fill="currentColor"/>
      </g>
      <g id="error">
        <path d="M10 15.75C10.2833 15.75 10.5167 15.6583 10.7 15.475C10.9
15.275 11 15.0333 11 14.75C11 14.4667 10.9 14.2333 10.7 14.05C10.5167 13.85
10.2833 13.75 10 13.75C9.71667 13.75 9.475 13.85 9.275 14.05C9.09167 14.2333 9
14.4667 9 14.75C9 15.0333 9.09167 15.275 9.275 15.475C9.475 15.6583 9.71667
15.75 10 15.75ZM10 11.75C10.2833 11.75 10.5167 11.6583 10.7 11.475C10.9 11.275
11 11.0333 11 10.75V6.75C11 6.46667 10.9 6.23333 10.7 6.05C10.5167 5.85 10.2833
5.75 10 5.75C9.71667 5.75 9.475 5.85 9.275 6.05C9.09167 6.23333 9 6.46667 9
6.75V10.75C9 11.0333 9.09167 11.275 9.275 11.475C9.475 11.6583 9.71667 11.75 10
11.75ZM10 20.75C8.61667 20.75 7.31667 20.4917 6.1 19.975C4.88333 19.4417 3.825
18.725 2.925 17.825C2.025 16.925 1.30833 15.8667 0.775 14.65C0.258333 13.4333
5.96046e-08 12.1333 5.96046e-08 10.75C5.96046e-08 9.36667 0.258333 8.06667
0.775 6.85C1.30833 5.63333 2.025 4.575 2.925 3.675C3.825 2.775 4.88333 2.06667
6.1 1.55C7.31667 1.01667 8.61667 0.75 10 0.75C11.3833 0.75 12.6833 1.01667 13.9
1.55C15.1167 2.06667 16.175 2.775 17.075 3.675C17.975 4.575 18.6833 5.63333
19.2 6.85C19.7333 8.06667 20 9.36667 20 10.75C20 12.1333 19.7333 13.4333 19.2
14.65C18.6833 15.8667 17.975 16.925 17.075 17.825C16.175 18.725 15.1167 19.4417
13.9 19.975C12.6833 20.4917 11.3833 20.75 10 20.75ZM10 18.75C12.2333 18.75
14.125 17.975 15.675 16.425C17.225 14.875 18 12.9833 18 10.75C18 8.51667 17.225
6.625 15.675 5.075C14.125 3.525 12.2333 2.75 10 2.75C7.76667 2.75 5.875 3.525
4.325 5.075C2.775 6.625 2 8.51667 2 10.75C2 12.9833 2.775 14.875 4.325
16.425C5.875 17.975 7.76667 18.75 10 18.75Z" fill="currentColor"/>
      </g>
      <g id="person-alert">
        <path d="M20 11Q19.575 11 19.2875 10.7125T19 10Q19 9.575 19.2875
9.2875T20 9Q20.425 9 20.7125 9.2875T21 10Q21 10.425 20.7125 10.7125T20 11ZM19
8V3H21V8H19ZM9 12Q7.35 12 6.175 10.825T5 8Q5 6.35 6.175 5.175T9 4Q10.65 4 11.825
5.175T13 8Q13 9.65 11.825 10.825T9 12ZM1 20V17.2Q1 16.35 1.4375 15.6375T2.6
14.55Q4.15 13.775 5.75 13.3875T9 13Q10.65 13 12.25 13.3875T15.4 14.55Q16.125
14.925 16.5625 15.6375T17 17.2V20H1ZM3 18H15V17.2Q15 16.925 14.8625 16.7T14.5
16.35Q13.15 15.675 11.775 15.3375T9 15Q7.6 15 6.225 15.3375T3.5 16.35Q3.275
16.475 3.1375 16.7T3 17.2V18ZM9 10Q9.825 10 10.4125 9.4125T11 8Q11 7.175 10.4125
6.5875T9 6Q8.175 6 7.5875 6.5875T7 8Q7 8.825 7.5875 9.4125T9 10ZM9 8ZM9 18Z"
fill="currentColor"/>
      </g>
    </defs>
  </svg>
</cr-iconset>`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
    document.head.appendChild(iconset);
}
