// chrome/browser/glic/host/glic.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { SelectCredentialDialogRequestSpec as actor_webui_mojom_SelectCredentialDialogRequestSpec, SelectCredentialDialogResponseSpec as actor_webui_mojom_SelectCredentialDialogResponseSpec, TaskOptionsSpec as actor_webui_mojom_TaskOptionsSpec, UserConfirmationDialogRequestSpec as actor_webui_mojom_UserConfirmationDialogRequestSpec, UserConfirmationDialogResponseSpec as actor_webui_mojom_UserConfirmationDialogResponseSpec } from './actor_webui.mojom-webui.js';
import { PageMetadataSpec as blink_mojom_PageMetadataSpec } from './ai_page_content_metadata.mojom-webui.js';
import { ContentSettingsTypeSpec as contentSettings_mojom_ContentSettingsTypeSpec } from './content_settings_types.mojom-webui.js';
import { BigBufferSpec as mojoBase_mojom_BigBufferSpec } from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import { ProtoWrapperSpec as mojoBase_mojom_ProtoWrapperSpec } from '//resources/mojo/mojo/public/mojom/base/proto_wrapper.mojom-webui.js';
import { TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import { VersionSpec as mojoBase_mojom_VersionSpec } from '//resources/mojo/mojo/public/mojom/base/version.mojom-webui.js';
import { BitmapN32Spec as skia_mojom_BitmapN32Spec } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import { RectSpec as gfx_mojom_RectSpec, SizeSpec as gfx_mojom_SizeSpec } from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import { OriginSpec as url_mojom_OriginSpec } from '//resources/mojo/url/mojom/origin.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const ProfileReadyStateSpec = { $: mojo.internal.Enum() };
export var ProfileReadyState;
(function (ProfileReadyState) {
    ProfileReadyState[ProfileReadyState["MIN_VALUE"] = 0] = "MIN_VALUE";
    ProfileReadyState[ProfileReadyState["MAX_VALUE"] = 4] = "MAX_VALUE";
    ProfileReadyState[ProfileReadyState["kUnknownError"] = 0] = "kUnknownError";
    ProfileReadyState[ProfileReadyState["kSignInRequired"] = 1] = "kSignInRequired";
    ProfileReadyState[ProfileReadyState["kReady"] = 2] = "kReady";
    ProfileReadyState[ProfileReadyState["kIneligible"] = 3] = "kIneligible";
    ProfileReadyState[ProfileReadyState["kDisabledByAdmin"] = 4] = "kDisabledByAdmin";
})(ProfileReadyState || (ProfileReadyState = {}));
export const WebUiStateSpec = { $: mojo.internal.Enum() };
export var WebUiState;
(function (WebUiState) {
    WebUiState[WebUiState["MIN_VALUE"] = 0] = "MIN_VALUE";
    WebUiState[WebUiState["MAX_VALUE"] = 12] = "MAX_VALUE";
    WebUiState[WebUiState["kUninitialized"] = 0] = "kUninitialized";
    WebUiState[WebUiState["kBeginLoad"] = 1] = "kBeginLoad";
    WebUiState[WebUiState["kShowLoading"] = 2] = "kShowLoading";
    WebUiState[WebUiState["kHoldLoading"] = 3] = "kHoldLoading";
    WebUiState[WebUiState["kFinishLoading"] = 4] = "kFinishLoading";
    WebUiState[WebUiState["kError"] = 5] = "kError";
    WebUiState[WebUiState["kOffline"] = 6] = "kOffline";
    WebUiState[WebUiState["kUnavailable"] = 7] = "kUnavailable";
    WebUiState[WebUiState["kReady"] = 8] = "kReady";
    WebUiState[WebUiState["kUnresponsive"] = 9] = "kUnresponsive";
    WebUiState[WebUiState["kSignIn"] = 10] = "kSignIn";
    WebUiState[WebUiState["kGuestError"] = 11] = "kGuestError";
    WebUiState[WebUiState["kDisabledByAdmin"] = 12] = "kDisabledByAdmin";
})(WebUiState || (WebUiState = {}));
export const MetricUserInputReactionTypeSpec = { $: mojo.internal.Enum() };
export var MetricUserInputReactionType;
(function (MetricUserInputReactionType) {
    MetricUserInputReactionType[MetricUserInputReactionType["MIN_VALUE"] = 0] = "MIN_VALUE";
    MetricUserInputReactionType[MetricUserInputReactionType["MAX_VALUE"] = 2] = "MAX_VALUE";
    MetricUserInputReactionType[MetricUserInputReactionType["kUnknown"] = 0] = "kUnknown";
    MetricUserInputReactionType[MetricUserInputReactionType["kCanned"] = 1] = "kCanned";
    MetricUserInputReactionType[MetricUserInputReactionType["kModel"] = 2] = "kModel";
})(MetricUserInputReactionType || (MetricUserInputReactionType = {}));
export const PrepareForClientResultSpec = { $: mojo.internal.Enum() };
export var PrepareForClientResult;
(function (PrepareForClientResult) {
    PrepareForClientResult[PrepareForClientResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    PrepareForClientResult[PrepareForClientResult["MAX_VALUE"] = 2] = "MAX_VALUE";
    PrepareForClientResult[PrepareForClientResult["kSuccess"] = 0] = "kSuccess";
    PrepareForClientResult[PrepareForClientResult["kErrorResyncingCookies"] = 1] = "kErrorResyncingCookies";
    PrepareForClientResult[PrepareForClientResult["kRequiresSignIn"] = 2] = "kRequiresSignIn";
})(PrepareForClientResult || (PrepareForClientResult = {}));
export const PerformActionsErrorReasonSpec = { $: mojo.internal.Enum() };
export var PerformActionsErrorReason;
(function (PerformActionsErrorReason) {
    PerformActionsErrorReason[PerformActionsErrorReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    PerformActionsErrorReason[PerformActionsErrorReason["MAX_VALUE"] = 2] = "MAX_VALUE";
    PerformActionsErrorReason[PerformActionsErrorReason["kUnknown"] = 0] = "kUnknown";
    PerformActionsErrorReason[PerformActionsErrorReason["kInvalidProto"] = 1] = "kInvalidProto";
    PerformActionsErrorReason[PerformActionsErrorReason["kMissingTaskId"] = 2] = "kMissingTaskId";
})(PerformActionsErrorReason || (PerformActionsErrorReason = {}));
export const CreateTaskErrorReasonSpec = { $: mojo.internal.Enum() };
export var CreateTaskErrorReason;
(function (CreateTaskErrorReason) {
    CreateTaskErrorReason[CreateTaskErrorReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    CreateTaskErrorReason[CreateTaskErrorReason["MAX_VALUE"] = 1] = "MAX_VALUE";
    CreateTaskErrorReason[CreateTaskErrorReason["kUnknown"] = 0] = "kUnknown";
    CreateTaskErrorReason[CreateTaskErrorReason["kTaskSystemUnavailable"] = 1] = "kTaskSystemUnavailable";
})(CreateTaskErrorReason || (CreateTaskErrorReason = {}));
export const ActorTaskStateSpec = { $: mojo.internal.Enum() };
export var ActorTaskState;
(function (ActorTaskState) {
    ActorTaskState[ActorTaskState["MIN_VALUE"] = 0] = "MIN_VALUE";
    ActorTaskState[ActorTaskState["MAX_VALUE"] = 4] = "MAX_VALUE";
    ActorTaskState[ActorTaskState["kUnknown"] = 0] = "kUnknown";
    ActorTaskState[ActorTaskState["kIdle"] = 1] = "kIdle";
    ActorTaskState[ActorTaskState["kActing"] = 2] = "kActing";
    ActorTaskState[ActorTaskState["kPaused"] = 3] = "kPaused";
    ActorTaskState[ActorTaskState["kStopped"] = 4] = "kStopped";
})(ActorTaskState || (ActorTaskState = {}));
export const ActorTaskPauseReasonSpec = { $: mojo.internal.Enum() };
export var ActorTaskPauseReason;
(function (ActorTaskPauseReason) {
    ActorTaskPauseReason[ActorTaskPauseReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    ActorTaskPauseReason[ActorTaskPauseReason["MAX_VALUE"] = 1] = "MAX_VALUE";
    ActorTaskPauseReason[ActorTaskPauseReason["kPausedByModel"] = 0] = "kPausedByModel";
    ActorTaskPauseReason[ActorTaskPauseReason["kPausedByUser"] = 1] = "kPausedByUser";
})(ActorTaskPauseReason || (ActorTaskPauseReason = {}));
export const ActorTaskStopReasonSpec = { $: mojo.internal.Enum() };
export var ActorTaskStopReason;
(function (ActorTaskStopReason) {
    ActorTaskStopReason[ActorTaskStopReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    ActorTaskStopReason[ActorTaskStopReason["MAX_VALUE"] = 1] = "MAX_VALUE";
    ActorTaskStopReason[ActorTaskStopReason["kTaskComplete"] = 0] = "kTaskComplete";
    ActorTaskStopReason[ActorTaskStopReason["kStoppedByUser"] = 1] = "kStoppedByUser";
})(ActorTaskStopReason || (ActorTaskStopReason = {}));
export const CaptureScreenshotErrorReasonSpec = { $: mojo.internal.Enum() };
export var CaptureScreenshotErrorReason;
(function (CaptureScreenshotErrorReason) {
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["MAX_VALUE"] = 2] = "MAX_VALUE";
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["kUnknown"] = 0] = "kUnknown";
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["kScreenCaptureRequestThrottled"] = 1] = "kScreenCaptureRequestThrottled";
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["kUserCancelledScreenPickerDialog"] = 2] = "kUserCancelledScreenPickerDialog";
})(CaptureScreenshotErrorReason || (CaptureScreenshotErrorReason = {}));
export const ScrollToErrorReasonSpec = { $: mojo.internal.Enum() };
export var ScrollToErrorReason;
(function (ScrollToErrorReason) {
    ScrollToErrorReason[ScrollToErrorReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    ScrollToErrorReason[ScrollToErrorReason["MAX_VALUE"] = 8] = "MAX_VALUE";
    ScrollToErrorReason[ScrollToErrorReason["kNotSupported"] = 0] = "kNotSupported";
    ScrollToErrorReason[ScrollToErrorReason["kNewerScrollToCall"] = 1] = "kNewerScrollToCall";
    ScrollToErrorReason[ScrollToErrorReason["kNoFocusedTab"] = 2] = "kNoFocusedTab";
    ScrollToErrorReason[ScrollToErrorReason["kNoMatchFound"] = 3] = "kNoMatchFound";
    ScrollToErrorReason[ScrollToErrorReason["kFocusedTabChangedOrNavigated"] = 4] = "kFocusedTabChangedOrNavigated";
    ScrollToErrorReason[ScrollToErrorReason["kNoMatchingDocument"] = 5] = "kNoMatchingDocument";
    ScrollToErrorReason[ScrollToErrorReason["kSearchRangeInvalid"] = 6] = "kSearchRangeInvalid";
    ScrollToErrorReason[ScrollToErrorReason["kTabContextPermissionDisabled"] = 7] = "kTabContextPermissionDisabled";
    ScrollToErrorReason[ScrollToErrorReason["kDroppedByWebClient"] = 8] = "kDroppedByWebClient";
})(ScrollToErrorReason || (ScrollToErrorReason = {}));
export const SwitchConversationErrorReasonSpec = { $: mojo.internal.Enum() };
export var SwitchConversationErrorReason;
(function (SwitchConversationErrorReason) {
    SwitchConversationErrorReason[SwitchConversationErrorReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    SwitchConversationErrorReason[SwitchConversationErrorReason["MAX_VALUE"] = 0] = "MAX_VALUE";
    SwitchConversationErrorReason[SwitchConversationErrorReason["kUnknown"] = 0] = "kUnknown";
})(SwitchConversationErrorReason || (SwitchConversationErrorReason = {}));
export const RegisterConversationErrorReasonSpec = { $: mojo.internal.Enum() };
export var RegisterConversationErrorReason;
(function (RegisterConversationErrorReason) {
    RegisterConversationErrorReason[RegisterConversationErrorReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    RegisterConversationErrorReason[RegisterConversationErrorReason["MAX_VALUE"] = 1] = "MAX_VALUE";
    RegisterConversationErrorReason[RegisterConversationErrorReason["kUnknown"] = 0] = "kUnknown";
    RegisterConversationErrorReason[RegisterConversationErrorReason["kInstanceAlreadyHasConversationId"] = 1] = "kInstanceAlreadyHasConversationId";
})(RegisterConversationErrorReason || (RegisterConversationErrorReason = {}));
export const InvocationSourceSpec = { $: mojo.internal.Enum() };
export var InvocationSource;
(function (InvocationSource) {
    InvocationSource[InvocationSource["MIN_VALUE"] = 0] = "MIN_VALUE";
    InvocationSource[InvocationSource["MAX_VALUE"] = 13] = "MAX_VALUE";
    InvocationSource[InvocationSource["kOsButton"] = 0] = "kOsButton";
    InvocationSource[InvocationSource["kOsButtonMenu"] = 1] = "kOsButtonMenu";
    InvocationSource[InvocationSource["kOsHotkey"] = 2] = "kOsHotkey";
    InvocationSource[InvocationSource["kTopChromeButton"] = 3] = "kTopChromeButton";
    InvocationSource[InvocationSource["kFre"] = 4] = "kFre";
    InvocationSource[InvocationSource["kProfilePicker"] = 5] = "kProfilePicker";
    InvocationSource[InvocationSource["kNudge"] = 6] = "kNudge";
    InvocationSource[InvocationSource["kThreeDotsMenu"] = 7] = "kThreeDotsMenu";
    InvocationSource[InvocationSource["kUnsupported"] = 8] = "kUnsupported";
    InvocationSource[InvocationSource["kWhatsNew"] = 9] = "kWhatsNew";
    InvocationSource[InvocationSource["kAfterSignIn"] = 10] = "kAfterSignIn";
    InvocationSource[InvocationSource["kSharedTab"] = 11] = "kSharedTab";
    InvocationSource[InvocationSource["kActorTaskIcon"] = 12] = "kActorTaskIcon";
    InvocationSource[InvocationSource["kSharedImage"] = 13] = "kSharedImage";
})(InvocationSource || (InvocationSource = {}));
export const WebClientModeSpec = { $: mojo.internal.Enum() };
export var WebClientMode;
(function (WebClientMode) {
    WebClientMode[WebClientMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    WebClientMode[WebClientMode["MAX_VALUE"] = 2] = "MAX_VALUE";
    WebClientMode[WebClientMode["kUnknown"] = 2] = "kUnknown";
    WebClientMode[WebClientMode["kText"] = 0] = "kText";
    WebClientMode[WebClientMode["kAudio"] = 1] = "kAudio";
})(WebClientMode || (WebClientMode = {}));
export const WebClientModelSpec = { $: mojo.internal.Enum() };
export var WebClientModel;
(function (WebClientModel) {
    WebClientModel[WebClientModel["MIN_VALUE"] = 0] = "MIN_VALUE";
    WebClientModel[WebClientModel["MAX_VALUE"] = 1] = "MAX_VALUE";
    WebClientModel[WebClientModel["kDefault"] = 0] = "kDefault";
    WebClientModel[WebClientModel["kActor"] = 1] = "kActor";
})(WebClientModel || (WebClientModel = {}));
export const ResponseStopCauseSpec = { $: mojo.internal.Enum() };
export var ResponseStopCause;
(function (ResponseStopCause) {
    ResponseStopCause[ResponseStopCause["MIN_VALUE"] = 0] = "MIN_VALUE";
    ResponseStopCause[ResponseStopCause["MAX_VALUE"] = 2] = "MAX_VALUE";
    ResponseStopCause[ResponseStopCause["kUnknown"] = 0] = "kUnknown";
    ResponseStopCause[ResponseStopCause["kUser"] = 1] = "kUser";
    ResponseStopCause[ResponseStopCause["kOther"] = 2] = "kOther";
})(ResponseStopCause || (ResponseStopCause = {}));
export const SettingsPageFieldSpec = { $: mojo.internal.Enum() };
export var SettingsPageField;
(function (SettingsPageField) {
    SettingsPageField[SettingsPageField["MIN_VALUE"] = 0] = "MIN_VALUE";
    SettingsPageField[SettingsPageField["MAX_VALUE"] = 2] = "MAX_VALUE";
    SettingsPageField[SettingsPageField["kNone"] = 0] = "kNone";
    SettingsPageField[SettingsPageField["kOsHotkey"] = 1] = "kOsHotkey";
    SettingsPageField[SettingsPageField["kOsEntrypointToggle"] = 2] = "kOsEntrypointToggle";
})(SettingsPageField || (SettingsPageField = {}));
export const HostCapabilitySpec = { $: mojo.internal.Enum() };
export var HostCapability;
(function (HostCapability) {
    HostCapability[HostCapability["MIN_VALUE"] = 0] = "MIN_VALUE";
    HostCapability[HostCapability["MAX_VALUE"] = 3] = "MAX_VALUE";
    HostCapability[HostCapability["kScrollToPdf"] = 0] = "kScrollToPdf";
    HostCapability[HostCapability["kResetSizeAndLocationOnOpen"] = 1] = "kResetSizeAndLocationOnOpen";
    HostCapability[HostCapability["kGetModelQualityClientId"] = 2] = "kGetModelQualityClientId";
    HostCapability[HostCapability["kMultiInstance"] = 3] = "kMultiInstance";
})(HostCapability || (HostCapability = {}));
export const CurrentViewSpec = { $: mojo.internal.Enum() };
export var CurrentView;
(function (CurrentView) {
    CurrentView[CurrentView["MIN_VALUE"] = 0] = "MIN_VALUE";
    CurrentView[CurrentView["MAX_VALUE"] = 1] = "MAX_VALUE";
    CurrentView[CurrentView["kConversation"] = 0] = "kConversation";
    CurrentView[CurrentView["kActuation"] = 1] = "kActuation";
})(CurrentView || (CurrentView = {}));
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    intentToShow() {
        this.proxy.sendMessage(0, Page_IntentToShow_ParamsSpec.$, null, [], false);
    }
    setProfileReadyState(readyState) {
        this.proxy.sendMessage(1, Page_SetProfileReadyState_ParamsSpec.$, null, [
            readyState
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_IntentToShow_ParamsSpec.$, null, impl.intentToShow.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_SetProfileReadyState_ParamsSpec.$, null, impl.setProfileReadyState.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "glic.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    intentToShow;
    setProfileReadyState;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.intentToShow =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_IntentToShow_ParamsSpec.$, null, this.intentToShow.createReceiverHandler(false /* expectsResponse */), false);
        this.setProfileReadyState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_SetProfileReadyState_ParamsSpec.$, null, this.setProfileReadyState.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(receiver, page) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            receiver,
            page
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "glic.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createWebClient(webClientReceiver) {
        this.proxy.sendMessage(0, PageHandler_CreateWebClient_ParamsSpec.$, null, [
            webClientReceiver
        ], false);
    }
    prepareForClient() {
        return this.proxy.sendMessage(1, PageHandler_PrepareForClient_ParamsSpec.$, PageHandler_PrepareForClient_ResponseParamsSpec.$, [], false);
    }
    webviewCommitted(url) {
        this.proxy.sendMessage(2, PageHandler_WebviewCommitted_ParamsSpec.$, null, [
            url
        ], false);
    }
    closePanel() {
        return this.proxy.sendMessage(3, PageHandler_ClosePanel_ParamsSpec.$, PageHandler_ClosePanel_ResponseParamsSpec.$, [], false);
    }
    openProfilePickerAndClosePanel() {
        this.proxy.sendMessage(4, PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$, null, [], false);
    }
    openDisabledByAdminLinkAndClosePanel() {
        this.proxy.sendMessage(5, PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$, null, [], false);
    }
    signInAndClosePanel() {
        this.proxy.sendMessage(6, PageHandler_SignInAndClosePanel_ParamsSpec.$, null, [], false);
    }
    resizeWidget(size, duration) {
        return this.proxy.sendMessage(7, PageHandler_ResizeWidget_ParamsSpec.$, PageHandler_ResizeWidget_ResponseParamsSpec.$, [
            size,
            duration
        ], false);
    }
    enableDragResize(enabled) {
        this.proxy.sendMessage(8, PageHandler_EnableDragResize_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    webUiStateChanged(newState) {
        this.proxy.sendMessage(9, PageHandler_WebUiStateChanged_ParamsSpec.$, null, [
            newState
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_CreateWebClient_ParamsSpec.$, null, impl.createWebClient.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_PrepareForClient_ParamsSpec.$, PageHandler_PrepareForClient_ResponseParamsSpec.$, impl.prepareForClient.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_WebviewCommitted_ParamsSpec.$, null, impl.webviewCommitted.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_ClosePanel_ParamsSpec.$, PageHandler_ClosePanel_ResponseParamsSpec.$, impl.closePanel.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$, null, impl.openProfilePickerAndClosePanel.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$, null, impl.openDisabledByAdminLinkAndClosePanel.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_SignInAndClosePanel_ParamsSpec.$, null, impl.signInAndClosePanel.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_ResizeWidget_ParamsSpec.$, PageHandler_ResizeWidget_ResponseParamsSpec.$, impl.resizeWidget.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_EnableDragResize_ParamsSpec.$, null, impl.enableDragResize.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_WebUiStateChanged_ParamsSpec.$, null, impl.webUiStateChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "glic.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    createWebClient;
    prepareForClient;
    webviewCommitted;
    closePanel;
    openProfilePickerAndClosePanel;
    openDisabledByAdminLinkAndClosePanel;
    signInAndClosePanel;
    resizeWidget;
    enableDragResize;
    webUiStateChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createWebClient =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_CreateWebClient_ParamsSpec.$, null, this.createWebClient.createReceiverHandler(false /* expectsResponse */), false);
        this.prepareForClient =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_PrepareForClient_ParamsSpec.$, PageHandler_PrepareForClient_ResponseParamsSpec.$, this.prepareForClient.createReceiverHandler(true /* expectsResponse */), false);
        this.webviewCommitted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_WebviewCommitted_ParamsSpec.$, null, this.webviewCommitted.createReceiverHandler(false /* expectsResponse */), false);
        this.closePanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_ClosePanel_ParamsSpec.$, PageHandler_ClosePanel_ResponseParamsSpec.$, this.closePanel.createReceiverHandler(true /* expectsResponse */), false);
        this.openProfilePickerAndClosePanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$, null, this.openProfilePickerAndClosePanel.createReceiverHandler(false /* expectsResponse */), false);
        this.openDisabledByAdminLinkAndClosePanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$, null, this.openDisabledByAdminLinkAndClosePanel.createReceiverHandler(false /* expectsResponse */), false);
        this.signInAndClosePanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_SignInAndClosePanel_ParamsSpec.$, null, this.signInAndClosePanel.createReceiverHandler(false /* expectsResponse */), false);
        this.resizeWidget =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_ResizeWidget_ParamsSpec.$, PageHandler_ResizeWidget_ResponseParamsSpec.$, this.resizeWidget.createReceiverHandler(true /* expectsResponse */), false);
        this.enableDragResize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_EnableDragResize_ParamsSpec.$, null, this.enableDragResize.createReceiverHandler(false /* expectsResponse */), false);
        this.webUiStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_WebUiStateChanged_ParamsSpec.$, null, this.webUiStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PinCandidatesObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.PinCandidatesObserver', scope);
    }
}
export class PinCandidatesObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PinCandidatesObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPinCandidatesChanged(candidates) {
        this.proxy.sendMessage(0, PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$, null, [
            candidates
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PinCandidatesObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PinCandidatesObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PinCandidatesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$, null, impl.onPinCandidatesChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PinCandidatesObserver {
    static get $interfaceName() {
        return "glic.mojom.PinCandidatesObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PinCandidatesObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PinCandidatesObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PinCandidatesObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onPinCandidatesChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PinCandidatesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPinCandidatesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$, null, this.onPinCandidatesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class WebClientHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.WebClientHandler', scope);
    }
}
export class WebClientHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WebClientHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    webClientCreated(webClient) {
        return this.proxy.sendMessage(0, WebClientHandler_WebClientCreated_ParamsSpec.$, WebClientHandler_WebClientCreated_ResponseParamsSpec.$, [
            webClient
        ], false);
    }
    webClientInitialized() {
        this.proxy.sendMessage(1, WebClientHandler_WebClientInitialized_ParamsSpec.$, null, [], false);
    }
    webClientInitializeFailed() {
        this.proxy.sendMessage(2, WebClientHandler_WebClientInitializeFailed_ParamsSpec.$, null, [], false);
    }
    createTab(url, openInBackground, windowId) {
        return this.proxy.sendMessage(3, WebClientHandler_CreateTab_ParamsSpec.$, WebClientHandler_CreateTab_ResponseParamsSpec.$, [
            url,
            openInBackground,
            windowId
        ], false);
    }
    openGlicSettingsPage(options) {
        this.proxy.sendMessage(4, WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$, null, [
            options
        ], false);
    }
    closePanel() {
        this.proxy.sendMessage(5, WebClientHandler_ClosePanel_ParamsSpec.$, null, [], false);
    }
    closePanelAndShutdown() {
        this.proxy.sendMessage(6, WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$, null, [], false);
    }
    attachPanel() {
        this.proxy.sendMessage(7, WebClientHandler_AttachPanel_ParamsSpec.$, null, [], false);
    }
    detachPanel() {
        this.proxy.sendMessage(8, WebClientHandler_DetachPanel_ParamsSpec.$, null, [], false);
    }
    showProfilePicker() {
        this.proxy.sendMessage(9, WebClientHandler_ShowProfilePicker_ParamsSpec.$, null, [], false);
    }
    getModelQualityClientId() {
        return this.proxy.sendMessage(10, WebClientHandler_GetModelQualityClientId_ParamsSpec.$, WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$, [], false);
    }
    getContextFromFocusedTab(options) {
        return this.proxy.sendMessage(11, WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$, WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$, [
            options
        ], false);
    }
    getContextFromTab(tabId, options) {
        return this.proxy.sendMessage(12, WebClientHandler_GetContextFromTab_ParamsSpec.$, WebClientHandler_GetContextFromTab_ResponseParamsSpec.$, [
            tabId,
            options
        ], false);
    }
    getContextForActorFromTab(tabId, options) {
        return this.proxy.sendMessage(13, WebClientHandler_GetContextForActorFromTab_ParamsSpec.$, WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$, [
            tabId,
            options
        ], false);
    }
    setMaximumNumberOfPinnedTabs(requestedMax) {
        return this.proxy.sendMessage(14, WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$, WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$, [
            requestedMax
        ], false);
    }
    pinTabs(tabIds) {
        return this.proxy.sendMessage(15, WebClientHandler_PinTabs_ParamsSpec.$, WebClientHandler_PinTabs_ResponseParamsSpec.$, [
            tabIds
        ], false);
    }
    unpinTabs(tabIds) {
        return this.proxy.sendMessage(16, WebClientHandler_UnpinTabs_ParamsSpec.$, WebClientHandler_UnpinTabs_ResponseParamsSpec.$, [
            tabIds
        ], false);
    }
    unpinAllTabs() {
        this.proxy.sendMessage(17, WebClientHandler_UnpinAllTabs_ParamsSpec.$, null, [], false);
    }
    subscribeToPinCandidates(options, observer) {
        this.proxy.sendMessage(18, WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$, null, [
            options,
            observer
        ], false);
    }
    createTask(taskOptions) {
        return this.proxy.sendMessage(19, WebClientHandler_CreateTask_ParamsSpec.$, WebClientHandler_CreateTask_ResponseParamsSpec.$, [
            taskOptions
        ], true);
    }
    performActions(actionsProto) {
        return this.proxy.sendMessage(20, WebClientHandler_PerformActions_ParamsSpec.$, WebClientHandler_PerformActions_ResponseParamsSpec.$, [
            actionsProto
        ], true);
    }
    stopActorTask(taskId, stopReason) {
        this.proxy.sendMessage(21, WebClientHandler_StopActorTask_ParamsSpec.$, null, [
            taskId,
            stopReason
        ], false);
    }
    pauseActorTask(taskId, pauseReason) {
        this.proxy.sendMessage(22, WebClientHandler_PauseActorTask_ParamsSpec.$, null, [
            taskId,
            pauseReason
        ], false);
    }
    resumeActorTask(taskId, contextOptions) {
        return this.proxy.sendMessage(23, WebClientHandler_ResumeActorTask_ParamsSpec.$, WebClientHandler_ResumeActorTask_ResponseParamsSpec.$, [
            taskId,
            contextOptions
        ], false);
    }
    resizeWidget(size, duration) {
        return this.proxy.sendMessage(24, WebClientHandler_ResizeWidget_ParamsSpec.$, WebClientHandler_ResizeWidget_ResponseParamsSpec.$, [
            size,
            duration
        ], false);
    }
    captureScreenshot() {
        return this.proxy.sendMessage(25, WebClientHandler_CaptureScreenshot_ParamsSpec.$, WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$, [], false);
    }
    setAudioDucking(enable) {
        return this.proxy.sendMessage(26, WebClientHandler_SetAudioDucking_ParamsSpec.$, WebClientHandler_SetAudioDucking_ResponseParamsSpec.$, [
            enable
        ], false);
    }
    setPanelDraggableAreas(draggableAreas) {
        return this.proxy.sendMessage(27, WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$, WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$, [
            draggableAreas
        ], false);
    }
    setMinimumPanelSize(size) {
        this.proxy.sendMessage(28, WebClientHandler_SetMinimumPanelSize_ParamsSpec.$, null, [
            size
        ], false);
    }
    setMicrophonePermissionState(enabled) {
        return this.proxy.sendMessage(29, WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$, WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$, [
            enabled
        ], false);
    }
    setLocationPermissionState(enabled) {
        return this.proxy.sendMessage(30, WebClientHandler_SetLocationPermissionState_ParamsSpec.$, WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$, [
            enabled
        ], false);
    }
    setTabContextPermissionState(enabled) {
        return this.proxy.sendMessage(31, WebClientHandler_SetTabContextPermissionState_ParamsSpec.$, WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$, [
            enabled
        ], false);
    }
    setClosedCaptioningSetting(enabled) {
        return this.proxy.sendMessage(32, WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$, WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$, [
            enabled
        ], false);
    }
    shouldAllowMediaPermissionRequest() {
        return this.proxy.sendMessage(33, WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$, WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$, [], false);
    }
    shouldAllowGeolocationPermissionRequest() {
        return this.proxy.sendMessage(34, WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$, WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$, [], false);
    }
    setContextAccessIndicator(enabled) {
        this.proxy.sendMessage(35, WebClientHandler_SetContextAccessIndicator_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    getUserProfileInfo() {
        return this.proxy.sendMessage(36, WebClientHandler_GetUserProfileInfo_ParamsSpec.$, WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$, [], false);
    }
    syncCookies() {
        return this.proxy.sendMessage(37, WebClientHandler_SyncCookies_ParamsSpec.$, WebClientHandler_SyncCookies_ResponseParamsSpec.$, [], false);
    }
    logBeginAsyncEvent(eventAsyncId, taskId, event, details) {
        this.proxy.sendMessage(38, WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$, null, [
            eventAsyncId,
            taskId,
            event,
            details
        ], false);
    }
    logEndAsyncEvent(eventAsyncId, details) {
        this.proxy.sendMessage(39, WebClientHandler_LogEndAsyncEvent_ParamsSpec.$, null, [
            eventAsyncId,
            details
        ], false);
    }
    logInstantEvent(taskId, event, details) {
        this.proxy.sendMessage(40, WebClientHandler_LogInstantEvent_ParamsSpec.$, null, [
            taskId,
            event,
            details
        ], false);
    }
    journalClear() {
        this.proxy.sendMessage(41, WebClientHandler_JournalClear_ParamsSpec.$, null, [], false);
    }
    journalSnapshot(clearJournal) {
        return this.proxy.sendMessage(42, WebClientHandler_JournalSnapshot_ParamsSpec.$, WebClientHandler_JournalSnapshot_ResponseParamsSpec.$, [
            clearJournal
        ], false);
    }
    journalStart(maxBytes, captureScreenshots) {
        this.proxy.sendMessage(43, WebClientHandler_JournalStart_ParamsSpec.$, null, [
            maxBytes,
            captureScreenshots
        ], false);
    }
    journalStop() {
        this.proxy.sendMessage(44, WebClientHandler_JournalStop_ParamsSpec.$, null, [], false);
    }
    journalRecordFeedback(positive, reason) {
        this.proxy.sendMessage(45, WebClientHandler_JournalRecordFeedback_ParamsSpec.$, null, [
            positive,
            reason
        ], false);
    }
    onUserInputSubmitted(mode) {
        this.proxy.sendMessage(46, WebClientHandler_OnUserInputSubmitted_ParamsSpec.$, null, [
            mode
        ], false);
    }
    onContextUploadStarted() {
        this.proxy.sendMessage(47, WebClientHandler_OnContextUploadStarted_ParamsSpec.$, null, [], false);
    }
    onContextUploadCompleted() {
        this.proxy.sendMessage(48, WebClientHandler_OnContextUploadCompleted_ParamsSpec.$, null, [], false);
    }
    onReaction(reactionType) {
        this.proxy.sendMessage(49, WebClientHandler_OnReaction_ParamsSpec.$, null, [
            reactionType
        ], false);
    }
    onResponseStarted() {
        this.proxy.sendMessage(50, WebClientHandler_OnResponseStarted_ParamsSpec.$, null, [], false);
    }
    onResponseStopped(details) {
        this.proxy.sendMessage(51, WebClientHandler_OnResponseStopped_ParamsSpec.$, null, [
            details
        ], false);
    }
    onSessionTerminated() {
        this.proxy.sendMessage(52, WebClientHandler_OnSessionTerminated_ParamsSpec.$, null, [], false);
    }
    onTurnCompleted(model, duration) {
        this.proxy.sendMessage(53, WebClientHandler_OnTurnCompleted_ParamsSpec.$, null, [
            model,
            duration
        ], false);
    }
    onModelChanged(model) {
        this.proxy.sendMessage(54, WebClientHandler_OnModelChanged_ParamsSpec.$, null, [
            model
        ], false);
    }
    onResponseRated(positive) {
        this.proxy.sendMessage(55, WebClientHandler_OnResponseRated_ParamsSpec.$, null, [
            positive
        ], false);
    }
    onClosedCaptionsShown() {
        this.proxy.sendMessage(56, WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$, null, [], false);
    }
    scrollTo(params) {
        return this.proxy.sendMessage(57, WebClientHandler_ScrollTo_ParamsSpec.$, WebClientHandler_ScrollTo_ResponseParamsSpec.$, [
            params
        ], false);
    }
    dropScrollToHighlight() {
        this.proxy.sendMessage(58, WebClientHandler_DropScrollToHighlight_ParamsSpec.$, null, [], false);
    }
    setSyntheticExperimentState(trialName, groupName) {
        this.proxy.sendMessage(59, WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$, null, [
            trialName,
            groupName
        ], false);
    }
    openOsPermissionSettingsMenu(type) {
        this.proxy.sendMessage(60, WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$, null, [
            type
        ], false);
    }
    getOsMicrophonePermissionStatus() {
        return this.proxy.sendMessage(61, WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$, WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$, [], false);
    }
    getZeroStateSuggestionsAndSubscribe(isLive, options) {
        return this.proxy.sendMessage(62, WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$, WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$, [
            isLive,
            options
        ], false);
    }
    getZeroStateSuggestionsForFocusedTab(isFirstRun) {
        return this.proxy.sendMessage(63, WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$, WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$, [
            isFirstRun
        ], false);
    }
    maybeRefreshUserStatus() {
        this.proxy.sendMessage(64, WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$, null, [], false);
    }
    isDebuggerAttached() {
        return this.proxy.sendMessage(65, WebClientHandler_IsDebuggerAttached_ParamsSpec.$, WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$, [], false);
    }
    onViewChanged(notification) {
        this.proxy.sendMessage(66, WebClientHandler_OnViewChanged_ParamsSpec.$, null, [
            notification
        ], false);
    }
    subscribeToPageMetadata(tabId, names) {
        return this.proxy.sendMessage(67, WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$, WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$, [
            tabId,
            names
        ], false);
    }
    switchConversation(info) {
        return this.proxy.sendMessage(68, WebClientHandler_SwitchConversation_ParamsSpec.$, WebClientHandler_SwitchConversation_ResponseParamsSpec.$, [
            info
        ], false);
    }
    registerConversation(info) {
        return this.proxy.sendMessage(69, WebClientHandler_RegisterConversation_ParamsSpec.$, WebClientHandler_RegisterConversation_ResponseParamsSpec.$, [
            info
        ], false);
    }
}
;
/**
 * An object which receives request messages for the WebClientHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebClientHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebClientHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WebClientHandler_WebClientCreated_ParamsSpec.$, WebClientHandler_WebClientCreated_ResponseParamsSpec.$, impl.webClientCreated.bind(impl), false);
        this.helper_internal_.registerHandler(1, WebClientHandler_WebClientInitialized_ParamsSpec.$, null, impl.webClientInitialized.bind(impl), false);
        this.helper_internal_.registerHandler(2, WebClientHandler_WebClientInitializeFailed_ParamsSpec.$, null, impl.webClientInitializeFailed.bind(impl), false);
        this.helper_internal_.registerHandler(3, WebClientHandler_CreateTab_ParamsSpec.$, WebClientHandler_CreateTab_ResponseParamsSpec.$, impl.createTab.bind(impl), false);
        this.helper_internal_.registerHandler(4, WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$, null, impl.openGlicSettingsPage.bind(impl), false);
        this.helper_internal_.registerHandler(5, WebClientHandler_ClosePanel_ParamsSpec.$, null, impl.closePanel.bind(impl), false);
        this.helper_internal_.registerHandler(6, WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$, null, impl.closePanelAndShutdown.bind(impl), false);
        this.helper_internal_.registerHandler(7, WebClientHandler_AttachPanel_ParamsSpec.$, null, impl.attachPanel.bind(impl), false);
        this.helper_internal_.registerHandler(8, WebClientHandler_DetachPanel_ParamsSpec.$, null, impl.detachPanel.bind(impl), false);
        this.helper_internal_.registerHandler(9, WebClientHandler_ShowProfilePicker_ParamsSpec.$, null, impl.showProfilePicker.bind(impl), false);
        this.helper_internal_.registerHandler(10, WebClientHandler_GetModelQualityClientId_ParamsSpec.$, WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$, impl.getModelQualityClientId.bind(impl), false);
        this.helper_internal_.registerHandler(11, WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$, WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$, impl.getContextFromFocusedTab.bind(impl), false);
        this.helper_internal_.registerHandler(12, WebClientHandler_GetContextFromTab_ParamsSpec.$, WebClientHandler_GetContextFromTab_ResponseParamsSpec.$, impl.getContextFromTab.bind(impl), false);
        this.helper_internal_.registerHandler(13, WebClientHandler_GetContextForActorFromTab_ParamsSpec.$, WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$, impl.getContextForActorFromTab.bind(impl), false);
        this.helper_internal_.registerHandler(14, WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$, WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$, impl.setMaximumNumberOfPinnedTabs.bind(impl), false);
        this.helper_internal_.registerHandler(15, WebClientHandler_PinTabs_ParamsSpec.$, WebClientHandler_PinTabs_ResponseParamsSpec.$, impl.pinTabs.bind(impl), false);
        this.helper_internal_.registerHandler(16, WebClientHandler_UnpinTabs_ParamsSpec.$, WebClientHandler_UnpinTabs_ResponseParamsSpec.$, impl.unpinTabs.bind(impl), false);
        this.helper_internal_.registerHandler(17, WebClientHandler_UnpinAllTabs_ParamsSpec.$, null, impl.unpinAllTabs.bind(impl), false);
        this.helper_internal_.registerHandler(18, WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$, null, impl.subscribeToPinCandidates.bind(impl), false);
        this.helper_internal_.registerHandler(19, WebClientHandler_CreateTask_ParamsSpec.$, WebClientHandler_CreateTask_ResponseParamsSpec.$, impl.createTask.bind(impl), true);
        this.helper_internal_.registerHandler(20, WebClientHandler_PerformActions_ParamsSpec.$, WebClientHandler_PerformActions_ResponseParamsSpec.$, impl.performActions.bind(impl), true);
        this.helper_internal_.registerHandler(21, WebClientHandler_StopActorTask_ParamsSpec.$, null, impl.stopActorTask.bind(impl), false);
        this.helper_internal_.registerHandler(22, WebClientHandler_PauseActorTask_ParamsSpec.$, null, impl.pauseActorTask.bind(impl), false);
        this.helper_internal_.registerHandler(23, WebClientHandler_ResumeActorTask_ParamsSpec.$, WebClientHandler_ResumeActorTask_ResponseParamsSpec.$, impl.resumeActorTask.bind(impl), false);
        this.helper_internal_.registerHandler(24, WebClientHandler_ResizeWidget_ParamsSpec.$, WebClientHandler_ResizeWidget_ResponseParamsSpec.$, impl.resizeWidget.bind(impl), false);
        this.helper_internal_.registerHandler(25, WebClientHandler_CaptureScreenshot_ParamsSpec.$, WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$, impl.captureScreenshot.bind(impl), false);
        this.helper_internal_.registerHandler(26, WebClientHandler_SetAudioDucking_ParamsSpec.$, WebClientHandler_SetAudioDucking_ResponseParamsSpec.$, impl.setAudioDucking.bind(impl), false);
        this.helper_internal_.registerHandler(27, WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$, WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$, impl.setPanelDraggableAreas.bind(impl), false);
        this.helper_internal_.registerHandler(28, WebClientHandler_SetMinimumPanelSize_ParamsSpec.$, null, impl.setMinimumPanelSize.bind(impl), false);
        this.helper_internal_.registerHandler(29, WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$, WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$, impl.setMicrophonePermissionState.bind(impl), false);
        this.helper_internal_.registerHandler(30, WebClientHandler_SetLocationPermissionState_ParamsSpec.$, WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$, impl.setLocationPermissionState.bind(impl), false);
        this.helper_internal_.registerHandler(31, WebClientHandler_SetTabContextPermissionState_ParamsSpec.$, WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$, impl.setTabContextPermissionState.bind(impl), false);
        this.helper_internal_.registerHandler(32, WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$, WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$, impl.setClosedCaptioningSetting.bind(impl), false);
        this.helper_internal_.registerHandler(33, WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$, WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$, impl.shouldAllowMediaPermissionRequest.bind(impl), false);
        this.helper_internal_.registerHandler(34, WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$, WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$, impl.shouldAllowGeolocationPermissionRequest.bind(impl), false);
        this.helper_internal_.registerHandler(35, WebClientHandler_SetContextAccessIndicator_ParamsSpec.$, null, impl.setContextAccessIndicator.bind(impl), false);
        this.helper_internal_.registerHandler(36, WebClientHandler_GetUserProfileInfo_ParamsSpec.$, WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$, impl.getUserProfileInfo.bind(impl), false);
        this.helper_internal_.registerHandler(37, WebClientHandler_SyncCookies_ParamsSpec.$, WebClientHandler_SyncCookies_ResponseParamsSpec.$, impl.syncCookies.bind(impl), false);
        this.helper_internal_.registerHandler(38, WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$, null, impl.logBeginAsyncEvent.bind(impl), false);
        this.helper_internal_.registerHandler(39, WebClientHandler_LogEndAsyncEvent_ParamsSpec.$, null, impl.logEndAsyncEvent.bind(impl), false);
        this.helper_internal_.registerHandler(40, WebClientHandler_LogInstantEvent_ParamsSpec.$, null, impl.logInstantEvent.bind(impl), false);
        this.helper_internal_.registerHandler(41, WebClientHandler_JournalClear_ParamsSpec.$, null, impl.journalClear.bind(impl), false);
        this.helper_internal_.registerHandler(42, WebClientHandler_JournalSnapshot_ParamsSpec.$, WebClientHandler_JournalSnapshot_ResponseParamsSpec.$, impl.journalSnapshot.bind(impl), false);
        this.helper_internal_.registerHandler(43, WebClientHandler_JournalStart_ParamsSpec.$, null, impl.journalStart.bind(impl), false);
        this.helper_internal_.registerHandler(44, WebClientHandler_JournalStop_ParamsSpec.$, null, impl.journalStop.bind(impl), false);
        this.helper_internal_.registerHandler(45, WebClientHandler_JournalRecordFeedback_ParamsSpec.$, null, impl.journalRecordFeedback.bind(impl), false);
        this.helper_internal_.registerHandler(46, WebClientHandler_OnUserInputSubmitted_ParamsSpec.$, null, impl.onUserInputSubmitted.bind(impl), false);
        this.helper_internal_.registerHandler(47, WebClientHandler_OnContextUploadStarted_ParamsSpec.$, null, impl.onContextUploadStarted.bind(impl), false);
        this.helper_internal_.registerHandler(48, WebClientHandler_OnContextUploadCompleted_ParamsSpec.$, null, impl.onContextUploadCompleted.bind(impl), false);
        this.helper_internal_.registerHandler(49, WebClientHandler_OnReaction_ParamsSpec.$, null, impl.onReaction.bind(impl), false);
        this.helper_internal_.registerHandler(50, WebClientHandler_OnResponseStarted_ParamsSpec.$, null, impl.onResponseStarted.bind(impl), false);
        this.helper_internal_.registerHandler(51, WebClientHandler_OnResponseStopped_ParamsSpec.$, null, impl.onResponseStopped.bind(impl), false);
        this.helper_internal_.registerHandler(52, WebClientHandler_OnSessionTerminated_ParamsSpec.$, null, impl.onSessionTerminated.bind(impl), false);
        this.helper_internal_.registerHandler(53, WebClientHandler_OnTurnCompleted_ParamsSpec.$, null, impl.onTurnCompleted.bind(impl), false);
        this.helper_internal_.registerHandler(54, WebClientHandler_OnModelChanged_ParamsSpec.$, null, impl.onModelChanged.bind(impl), false);
        this.helper_internal_.registerHandler(55, WebClientHandler_OnResponseRated_ParamsSpec.$, null, impl.onResponseRated.bind(impl), false);
        this.helper_internal_.registerHandler(56, WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$, null, impl.onClosedCaptionsShown.bind(impl), false);
        this.helper_internal_.registerHandler(57, WebClientHandler_ScrollTo_ParamsSpec.$, WebClientHandler_ScrollTo_ResponseParamsSpec.$, impl.scrollTo.bind(impl), false);
        this.helper_internal_.registerHandler(58, WebClientHandler_DropScrollToHighlight_ParamsSpec.$, null, impl.dropScrollToHighlight.bind(impl), false);
        this.helper_internal_.registerHandler(59, WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$, null, impl.setSyntheticExperimentState.bind(impl), false);
        this.helper_internal_.registerHandler(60, WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$, null, impl.openOsPermissionSettingsMenu.bind(impl), false);
        this.helper_internal_.registerHandler(61, WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$, WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$, impl.getOsMicrophonePermissionStatus.bind(impl), false);
        this.helper_internal_.registerHandler(62, WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$, WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$, impl.getZeroStateSuggestionsAndSubscribe.bind(impl), false);
        this.helper_internal_.registerHandler(63, WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$, WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$, impl.getZeroStateSuggestionsForFocusedTab.bind(impl), false);
        this.helper_internal_.registerHandler(64, WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$, null, impl.maybeRefreshUserStatus.bind(impl), false);
        this.helper_internal_.registerHandler(65, WebClientHandler_IsDebuggerAttached_ParamsSpec.$, WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$, impl.isDebuggerAttached.bind(impl), false);
        this.helper_internal_.registerHandler(66, WebClientHandler_OnViewChanged_ParamsSpec.$, null, impl.onViewChanged.bind(impl), false);
        this.helper_internal_.registerHandler(67, WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$, WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$, impl.subscribeToPageMetadata.bind(impl), false);
        this.helper_internal_.registerHandler(68, WebClientHandler_SwitchConversation_ParamsSpec.$, WebClientHandler_SwitchConversation_ResponseParamsSpec.$, impl.switchConversation.bind(impl), false);
        this.helper_internal_.registerHandler(69, WebClientHandler_RegisterConversation_ParamsSpec.$, WebClientHandler_RegisterConversation_ResponseParamsSpec.$, impl.registerConversation.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WebClientHandler {
    static get $interfaceName() {
        return "glic.mojom.WebClientHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WebClientHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WebClientHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebClientHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    webClientCreated;
    webClientInitialized;
    webClientInitializeFailed;
    createTab;
    openGlicSettingsPage;
    closePanel;
    closePanelAndShutdown;
    attachPanel;
    detachPanel;
    showProfilePicker;
    getModelQualityClientId;
    getContextFromFocusedTab;
    getContextFromTab;
    getContextForActorFromTab;
    setMaximumNumberOfPinnedTabs;
    pinTabs;
    unpinTabs;
    unpinAllTabs;
    subscribeToPinCandidates;
    createTask;
    performActions;
    stopActorTask;
    pauseActorTask;
    resumeActorTask;
    resizeWidget;
    captureScreenshot;
    setAudioDucking;
    setPanelDraggableAreas;
    setMinimumPanelSize;
    setMicrophonePermissionState;
    setLocationPermissionState;
    setTabContextPermissionState;
    setClosedCaptioningSetting;
    shouldAllowMediaPermissionRequest;
    shouldAllowGeolocationPermissionRequest;
    setContextAccessIndicator;
    getUserProfileInfo;
    syncCookies;
    logBeginAsyncEvent;
    logEndAsyncEvent;
    logInstantEvent;
    journalClear;
    journalSnapshot;
    journalStart;
    journalStop;
    journalRecordFeedback;
    onUserInputSubmitted;
    onContextUploadStarted;
    onContextUploadCompleted;
    onReaction;
    onResponseStarted;
    onResponseStopped;
    onSessionTerminated;
    onTurnCompleted;
    onModelChanged;
    onResponseRated;
    onClosedCaptionsShown;
    scrollTo;
    dropScrollToHighlight;
    setSyntheticExperimentState;
    openOsPermissionSettingsMenu;
    getOsMicrophonePermissionStatus;
    getZeroStateSuggestionsAndSubscribe;
    getZeroStateSuggestionsForFocusedTab;
    maybeRefreshUserStatus;
    isDebuggerAttached;
    onViewChanged;
    subscribeToPageMetadata;
    switchConversation;
    registerConversation;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebClientHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.webClientCreated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WebClientHandler_WebClientCreated_ParamsSpec.$, WebClientHandler_WebClientCreated_ResponseParamsSpec.$, this.webClientCreated.createReceiverHandler(true /* expectsResponse */), false);
        this.webClientInitialized =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WebClientHandler_WebClientInitialized_ParamsSpec.$, null, this.webClientInitialized.createReceiverHandler(false /* expectsResponse */), false);
        this.webClientInitializeFailed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WebClientHandler_WebClientInitializeFailed_ParamsSpec.$, null, this.webClientInitializeFailed.createReceiverHandler(false /* expectsResponse */), false);
        this.createTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, WebClientHandler_CreateTab_ParamsSpec.$, WebClientHandler_CreateTab_ResponseParamsSpec.$, this.createTab.createReceiverHandler(true /* expectsResponse */), false);
        this.openGlicSettingsPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$, null, this.openGlicSettingsPage.createReceiverHandler(false /* expectsResponse */), false);
        this.closePanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, WebClientHandler_ClosePanel_ParamsSpec.$, null, this.closePanel.createReceiverHandler(false /* expectsResponse */), false);
        this.closePanelAndShutdown =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$, null, this.closePanelAndShutdown.createReceiverHandler(false /* expectsResponse */), false);
        this.attachPanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, WebClientHandler_AttachPanel_ParamsSpec.$, null, this.attachPanel.createReceiverHandler(false /* expectsResponse */), false);
        this.detachPanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, WebClientHandler_DetachPanel_ParamsSpec.$, null, this.detachPanel.createReceiverHandler(false /* expectsResponse */), false);
        this.showProfilePicker =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, WebClientHandler_ShowProfilePicker_ParamsSpec.$, null, this.showProfilePicker.createReceiverHandler(false /* expectsResponse */), false);
        this.getModelQualityClientId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, WebClientHandler_GetModelQualityClientId_ParamsSpec.$, WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$, this.getModelQualityClientId.createReceiverHandler(true /* expectsResponse */), false);
        this.getContextFromFocusedTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$, WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$, this.getContextFromFocusedTab.createReceiverHandler(true /* expectsResponse */), false);
        this.getContextFromTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, WebClientHandler_GetContextFromTab_ParamsSpec.$, WebClientHandler_GetContextFromTab_ResponseParamsSpec.$, this.getContextFromTab.createReceiverHandler(true /* expectsResponse */), false);
        this.getContextForActorFromTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, WebClientHandler_GetContextForActorFromTab_ParamsSpec.$, WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$, this.getContextForActorFromTab.createReceiverHandler(true /* expectsResponse */), false);
        this.setMaximumNumberOfPinnedTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$, WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$, this.setMaximumNumberOfPinnedTabs.createReceiverHandler(true /* expectsResponse */), false);
        this.pinTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, WebClientHandler_PinTabs_ParamsSpec.$, WebClientHandler_PinTabs_ResponseParamsSpec.$, this.pinTabs.createReceiverHandler(true /* expectsResponse */), false);
        this.unpinTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, WebClientHandler_UnpinTabs_ParamsSpec.$, WebClientHandler_UnpinTabs_ResponseParamsSpec.$, this.unpinTabs.createReceiverHandler(true /* expectsResponse */), false);
        this.unpinAllTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, WebClientHandler_UnpinAllTabs_ParamsSpec.$, null, this.unpinAllTabs.createReceiverHandler(false /* expectsResponse */), false);
        this.subscribeToPinCandidates =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$, null, this.subscribeToPinCandidates.createReceiverHandler(false /* expectsResponse */), false);
        this.createTask =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, WebClientHandler_CreateTask_ParamsSpec.$, WebClientHandler_CreateTask_ResponseParamsSpec.$, this.createTask.createReceiverHandler(true /* expectsResponse */), true);
        this.performActions =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, WebClientHandler_PerformActions_ParamsSpec.$, WebClientHandler_PerformActions_ResponseParamsSpec.$, this.performActions.createReceiverHandler(true /* expectsResponse */), true);
        this.stopActorTask =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, WebClientHandler_StopActorTask_ParamsSpec.$, null, this.stopActorTask.createReceiverHandler(false /* expectsResponse */), false);
        this.pauseActorTask =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, WebClientHandler_PauseActorTask_ParamsSpec.$, null, this.pauseActorTask.createReceiverHandler(false /* expectsResponse */), false);
        this.resumeActorTask =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, WebClientHandler_ResumeActorTask_ParamsSpec.$, WebClientHandler_ResumeActorTask_ResponseParamsSpec.$, this.resumeActorTask.createReceiverHandler(true /* expectsResponse */), false);
        this.resizeWidget =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, WebClientHandler_ResizeWidget_ParamsSpec.$, WebClientHandler_ResizeWidget_ResponseParamsSpec.$, this.resizeWidget.createReceiverHandler(true /* expectsResponse */), false);
        this.captureScreenshot =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, WebClientHandler_CaptureScreenshot_ParamsSpec.$, WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$, this.captureScreenshot.createReceiverHandler(true /* expectsResponse */), false);
        this.setAudioDucking =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(26, WebClientHandler_SetAudioDucking_ParamsSpec.$, WebClientHandler_SetAudioDucking_ResponseParamsSpec.$, this.setAudioDucking.createReceiverHandler(true /* expectsResponse */), false);
        this.setPanelDraggableAreas =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(27, WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$, WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$, this.setPanelDraggableAreas.createReceiverHandler(true /* expectsResponse */), false);
        this.setMinimumPanelSize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(28, WebClientHandler_SetMinimumPanelSize_ParamsSpec.$, null, this.setMinimumPanelSize.createReceiverHandler(false /* expectsResponse */), false);
        this.setMicrophonePermissionState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(29, WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$, WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$, this.setMicrophonePermissionState.createReceiverHandler(true /* expectsResponse */), false);
        this.setLocationPermissionState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(30, WebClientHandler_SetLocationPermissionState_ParamsSpec.$, WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$, this.setLocationPermissionState.createReceiverHandler(true /* expectsResponse */), false);
        this.setTabContextPermissionState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(31, WebClientHandler_SetTabContextPermissionState_ParamsSpec.$, WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$, this.setTabContextPermissionState.createReceiverHandler(true /* expectsResponse */), false);
        this.setClosedCaptioningSetting =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(32, WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$, WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$, this.setClosedCaptioningSetting.createReceiverHandler(true /* expectsResponse */), false);
        this.shouldAllowMediaPermissionRequest =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(33, WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$, WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$, this.shouldAllowMediaPermissionRequest.createReceiverHandler(true /* expectsResponse */), false);
        this.shouldAllowGeolocationPermissionRequest =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(34, WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$, WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$, this.shouldAllowGeolocationPermissionRequest.createReceiverHandler(true /* expectsResponse */), false);
        this.setContextAccessIndicator =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(35, WebClientHandler_SetContextAccessIndicator_ParamsSpec.$, null, this.setContextAccessIndicator.createReceiverHandler(false /* expectsResponse */), false);
        this.getUserProfileInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(36, WebClientHandler_GetUserProfileInfo_ParamsSpec.$, WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$, this.getUserProfileInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.syncCookies =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(37, WebClientHandler_SyncCookies_ParamsSpec.$, WebClientHandler_SyncCookies_ResponseParamsSpec.$, this.syncCookies.createReceiverHandler(true /* expectsResponse */), false);
        this.logBeginAsyncEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(38, WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$, null, this.logBeginAsyncEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.logEndAsyncEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(39, WebClientHandler_LogEndAsyncEvent_ParamsSpec.$, null, this.logEndAsyncEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.logInstantEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(40, WebClientHandler_LogInstantEvent_ParamsSpec.$, null, this.logInstantEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.journalClear =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(41, WebClientHandler_JournalClear_ParamsSpec.$, null, this.journalClear.createReceiverHandler(false /* expectsResponse */), false);
        this.journalSnapshot =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(42, WebClientHandler_JournalSnapshot_ParamsSpec.$, WebClientHandler_JournalSnapshot_ResponseParamsSpec.$, this.journalSnapshot.createReceiverHandler(true /* expectsResponse */), false);
        this.journalStart =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(43, WebClientHandler_JournalStart_ParamsSpec.$, null, this.journalStart.createReceiverHandler(false /* expectsResponse */), false);
        this.journalStop =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(44, WebClientHandler_JournalStop_ParamsSpec.$, null, this.journalStop.createReceiverHandler(false /* expectsResponse */), false);
        this.journalRecordFeedback =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(45, WebClientHandler_JournalRecordFeedback_ParamsSpec.$, null, this.journalRecordFeedback.createReceiverHandler(false /* expectsResponse */), false);
        this.onUserInputSubmitted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(46, WebClientHandler_OnUserInputSubmitted_ParamsSpec.$, null, this.onUserInputSubmitted.createReceiverHandler(false /* expectsResponse */), false);
        this.onContextUploadStarted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(47, WebClientHandler_OnContextUploadStarted_ParamsSpec.$, null, this.onContextUploadStarted.createReceiverHandler(false /* expectsResponse */), false);
        this.onContextUploadCompleted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(48, WebClientHandler_OnContextUploadCompleted_ParamsSpec.$, null, this.onContextUploadCompleted.createReceiverHandler(false /* expectsResponse */), false);
        this.onReaction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(49, WebClientHandler_OnReaction_ParamsSpec.$, null, this.onReaction.createReceiverHandler(false /* expectsResponse */), false);
        this.onResponseStarted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(50, WebClientHandler_OnResponseStarted_ParamsSpec.$, null, this.onResponseStarted.createReceiverHandler(false /* expectsResponse */), false);
        this.onResponseStopped =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(51, WebClientHandler_OnResponseStopped_ParamsSpec.$, null, this.onResponseStopped.createReceiverHandler(false /* expectsResponse */), false);
        this.onSessionTerminated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(52, WebClientHandler_OnSessionTerminated_ParamsSpec.$, null, this.onSessionTerminated.createReceiverHandler(false /* expectsResponse */), false);
        this.onTurnCompleted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(53, WebClientHandler_OnTurnCompleted_ParamsSpec.$, null, this.onTurnCompleted.createReceiverHandler(false /* expectsResponse */), false);
        this.onModelChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(54, WebClientHandler_OnModelChanged_ParamsSpec.$, null, this.onModelChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onResponseRated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(55, WebClientHandler_OnResponseRated_ParamsSpec.$, null, this.onResponseRated.createReceiverHandler(false /* expectsResponse */), false);
        this.onClosedCaptionsShown =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(56, WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$, null, this.onClosedCaptionsShown.createReceiverHandler(false /* expectsResponse */), false);
        this.scrollTo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(57, WebClientHandler_ScrollTo_ParamsSpec.$, WebClientHandler_ScrollTo_ResponseParamsSpec.$, this.scrollTo.createReceiverHandler(true /* expectsResponse */), false);
        this.dropScrollToHighlight =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(58, WebClientHandler_DropScrollToHighlight_ParamsSpec.$, null, this.dropScrollToHighlight.createReceiverHandler(false /* expectsResponse */), false);
        this.setSyntheticExperimentState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(59, WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$, null, this.setSyntheticExperimentState.createReceiverHandler(false /* expectsResponse */), false);
        this.openOsPermissionSettingsMenu =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(60, WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$, null, this.openOsPermissionSettingsMenu.createReceiverHandler(false /* expectsResponse */), false);
        this.getOsMicrophonePermissionStatus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(61, WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$, WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$, this.getOsMicrophonePermissionStatus.createReceiverHandler(true /* expectsResponse */), false);
        this.getZeroStateSuggestionsAndSubscribe =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(62, WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$, WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$, this.getZeroStateSuggestionsAndSubscribe.createReceiverHandler(true /* expectsResponse */), false);
        this.getZeroStateSuggestionsForFocusedTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(63, WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$, WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$, this.getZeroStateSuggestionsForFocusedTab.createReceiverHandler(true /* expectsResponse */), false);
        this.maybeRefreshUserStatus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(64, WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$, null, this.maybeRefreshUserStatus.createReceiverHandler(false /* expectsResponse */), false);
        this.isDebuggerAttached =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(65, WebClientHandler_IsDebuggerAttached_ParamsSpec.$, WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$, this.isDebuggerAttached.createReceiverHandler(true /* expectsResponse */), false);
        this.onViewChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(66, WebClientHandler_OnViewChanged_ParamsSpec.$, null, this.onViewChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.subscribeToPageMetadata =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(67, WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$, WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$, this.subscribeToPageMetadata.createReceiverHandler(true /* expectsResponse */), false);
        this.switchConversation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(68, WebClientHandler_SwitchConversation_ParamsSpec.$, WebClientHandler_SwitchConversation_ResponseParamsSpec.$, this.switchConversation.createReceiverHandler(true /* expectsResponse */), false);
        this.registerConversation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(69, WebClientHandler_RegisterConversation_ParamsSpec.$, WebClientHandler_RegisterConversation_ResponseParamsSpec.$, this.registerConversation.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class WebClientPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.WebClient', scope);
    }
}
export class WebClientRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WebClientPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    notifyPanelWillOpen(panelOpeningData) {
        return this.proxy.sendMessage(0, WebClient_NotifyPanelWillOpen_ParamsSpec.$, WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$, [
            panelOpeningData
        ], false);
    }
    notifyPanelWasClosed() {
        return this.proxy.sendMessage(1, WebClient_NotifyPanelWasClosed_ParamsSpec.$, WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$, [], false);
    }
    notifyPanelStateChange(panelState) {
        this.proxy.sendMessage(2, WebClient_NotifyPanelStateChange_ParamsSpec.$, null, [
            panelState
        ], false);
    }
    notifyPanelActiveChange(panelActive) {
        this.proxy.sendMessage(3, WebClient_NotifyPanelActiveChange_ParamsSpec.$, null, [
            panelActive
        ], false);
    }
    notifyPanelCanAttachChange(canAttach) {
        this.proxy.sendMessage(4, WebClient_NotifyPanelCanAttachChange_ParamsSpec.$, null, [
            canAttach
        ], false);
    }
    notifyMicrophonePermissionStateChanged(enabled) {
        this.proxy.sendMessage(5, WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    notifyLocationPermissionStateChanged(enabled) {
        this.proxy.sendMessage(6, WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    notifyTabContextPermissionStateChanged(enabled) {
        this.proxy.sendMessage(7, WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    notifyOsLocationPermissionStateChanged(enabled) {
        this.proxy.sendMessage(8, WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    notifyFocusedTabChanged(focusedTabData) {
        this.proxy.sendMessage(9, WebClient_NotifyFocusedTabChanged_ParamsSpec.$, null, [
            focusedTabData
        ], false);
    }
    notifyManualResizeChanged(resizing) {
        this.proxy.sendMessage(10, WebClient_NotifyManualResizeChanged_ParamsSpec.$, null, [
            resizing
        ], false);
    }
    notifyOsHotkeyStateChanged(hotkey) {
        this.proxy.sendMessage(11, WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$, null, [
            hotkey
        ], false);
    }
    notifyBrowserIsOpenChanged(browserIsOpen) {
        this.proxy.sendMessage(12, WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$, null, [
            browserIsOpen
        ], false);
    }
    notifyBrowserIsActiveChanged(browserActive) {
        this.proxy.sendMessage(13, WebClient_NotifyBrowserIsActiveChanged_ParamsSpec.$, null, [
            browserActive
        ], false);
    }
    notifyActiveBrowserChanged(activeBrowserInfo) {
        this.proxy.sendMessage(14, WebClient_NotifyActiveBrowserChanged_ParamsSpec.$, null, [
            activeBrowserInfo
        ], false);
    }
    notifyClosedCaptioningSettingChanged(enabled) {
        this.proxy.sendMessage(15, WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    notifyPinnedTabsChanged(tabData) {
        this.proxy.sendMessage(16, WebClient_NotifyPinnedTabsChanged_ParamsSpec.$, null, [
            tabData
        ], false);
    }
    notifyPinnedTabDataChanged(tabData) {
        this.proxy.sendMessage(17, WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$, null, [
            tabData
        ], false);
    }
    notifyZeroStateSuggestionsChanged(suggestions, options) {
        this.proxy.sendMessage(18, WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$, null, [
            suggestions,
            options
        ], false);
    }
    notifyActorTaskStateChanged(taskId, state) {
        this.proxy.sendMessage(19, WebClient_NotifyActorTaskStateChanged_ParamsSpec.$, null, [
            taskId,
            state
        ], false);
    }
    requestViewChange(request) {
        this.proxy.sendMessage(20, WebClient_RequestViewChange_ParamsSpec.$, null, [
            request
        ], false);
    }
    notifyPageMetadataChanged(tabId, metadata) {
        this.proxy.sendMessage(21, WebClient_NotifyPageMetadataChanged_ParamsSpec.$, null, [
            tabId,
            metadata
        ], false);
    }
    notifyDefaultTabContextPermissionStateChanged(enabled) {
        this.proxy.sendMessage(22, WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    requestToShowCredentialSelectionDialog(request) {
        return this.proxy.sendMessage(23, WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$, WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$, [
            request
        ], false);
    }
    requestToShowUserConfirmationDialog(request) {
        return this.proxy.sendMessage(24, WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$, WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$, [
            request
        ], false);
    }
    notifyAdditionalContext(context) {
        this.proxy.sendMessage(25, WebClient_NotifyAdditionalContext_ParamsSpec.$, null, [
            context
        ], false);
    }
}
;
/**
 * An object which receives request messages for the WebClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebClientReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WebClient_NotifyPanelWillOpen_ParamsSpec.$, WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$, impl.notifyPanelWillOpen.bind(impl), false);
        this.helper_internal_.registerHandler(1, WebClient_NotifyPanelWasClosed_ParamsSpec.$, WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$, impl.notifyPanelWasClosed.bind(impl), false);
        this.helper_internal_.registerHandler(2, WebClient_NotifyPanelStateChange_ParamsSpec.$, null, impl.notifyPanelStateChange.bind(impl), false);
        this.helper_internal_.registerHandler(3, WebClient_NotifyPanelActiveChange_ParamsSpec.$, null, impl.notifyPanelActiveChange.bind(impl), false);
        this.helper_internal_.registerHandler(4, WebClient_NotifyPanelCanAttachChange_ParamsSpec.$, null, impl.notifyPanelCanAttachChange.bind(impl), false);
        this.helper_internal_.registerHandler(5, WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$, null, impl.notifyMicrophonePermissionStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(6, WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$, null, impl.notifyLocationPermissionStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(7, WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$, null, impl.notifyTabContextPermissionStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(8, WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$, null, impl.notifyOsLocationPermissionStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(9, WebClient_NotifyFocusedTabChanged_ParamsSpec.$, null, impl.notifyFocusedTabChanged.bind(impl), false);
        this.helper_internal_.registerHandler(10, WebClient_NotifyManualResizeChanged_ParamsSpec.$, null, impl.notifyManualResizeChanged.bind(impl), false);
        this.helper_internal_.registerHandler(11, WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$, null, impl.notifyOsHotkeyStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(12, WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$, null, impl.notifyBrowserIsOpenChanged.bind(impl), false);
        this.helper_internal_.registerHandler(13, WebClient_NotifyBrowserIsActiveChanged_ParamsSpec.$, null, impl.notifyBrowserIsActiveChanged.bind(impl), false);
        this.helper_internal_.registerHandler(14, WebClient_NotifyActiveBrowserChanged_ParamsSpec.$, null, impl.notifyActiveBrowserChanged.bind(impl), false);
        this.helper_internal_.registerHandler(15, WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$, null, impl.notifyClosedCaptioningSettingChanged.bind(impl), false);
        this.helper_internal_.registerHandler(16, WebClient_NotifyPinnedTabsChanged_ParamsSpec.$, null, impl.notifyPinnedTabsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(17, WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$, null, impl.notifyPinnedTabDataChanged.bind(impl), false);
        this.helper_internal_.registerHandler(18, WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$, null, impl.notifyZeroStateSuggestionsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(19, WebClient_NotifyActorTaskStateChanged_ParamsSpec.$, null, impl.notifyActorTaskStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(20, WebClient_RequestViewChange_ParamsSpec.$, null, impl.requestViewChange.bind(impl), false);
        this.helper_internal_.registerHandler(21, WebClient_NotifyPageMetadataChanged_ParamsSpec.$, null, impl.notifyPageMetadataChanged.bind(impl), false);
        this.helper_internal_.registerHandler(22, WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$, null, impl.notifyDefaultTabContextPermissionStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(23, WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$, WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$, impl.requestToShowCredentialSelectionDialog.bind(impl), false);
        this.helper_internal_.registerHandler(24, WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$, WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$, impl.requestToShowUserConfirmationDialog.bind(impl), false);
        this.helper_internal_.registerHandler(25, WebClient_NotifyAdditionalContext_ParamsSpec.$, null, impl.notifyAdditionalContext.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WebClient {
    static get $interfaceName() {
        return "glic.mojom.WebClient";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WebClientRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WebClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebClientCallbackRouter {
    helper_internal_;
    $;
    router_;
    notifyPanelWillOpen;
    notifyPanelWasClosed;
    notifyPanelStateChange;
    notifyPanelActiveChange;
    notifyPanelCanAttachChange;
    notifyMicrophonePermissionStateChanged;
    notifyLocationPermissionStateChanged;
    notifyTabContextPermissionStateChanged;
    notifyOsLocationPermissionStateChanged;
    notifyFocusedTabChanged;
    notifyManualResizeChanged;
    notifyOsHotkeyStateChanged;
    notifyBrowserIsOpenChanged;
    notifyBrowserIsActiveChanged;
    notifyActiveBrowserChanged;
    notifyClosedCaptioningSettingChanged;
    notifyPinnedTabsChanged;
    notifyPinnedTabDataChanged;
    notifyZeroStateSuggestionsChanged;
    notifyActorTaskStateChanged;
    requestViewChange;
    notifyPageMetadataChanged;
    notifyDefaultTabContextPermissionStateChanged;
    requestToShowCredentialSelectionDialog;
    requestToShowUserConfirmationDialog;
    notifyAdditionalContext;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.notifyPanelWillOpen =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WebClient_NotifyPanelWillOpen_ParamsSpec.$, WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$, this.notifyPanelWillOpen.createReceiverHandler(true /* expectsResponse */), false);
        this.notifyPanelWasClosed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WebClient_NotifyPanelWasClosed_ParamsSpec.$, WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$, this.notifyPanelWasClosed.createReceiverHandler(true /* expectsResponse */), false);
        this.notifyPanelStateChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WebClient_NotifyPanelStateChange_ParamsSpec.$, null, this.notifyPanelStateChange.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyPanelActiveChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, WebClient_NotifyPanelActiveChange_ParamsSpec.$, null, this.notifyPanelActiveChange.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyPanelCanAttachChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, WebClient_NotifyPanelCanAttachChange_ParamsSpec.$, null, this.notifyPanelCanAttachChange.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyMicrophonePermissionStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$, null, this.notifyMicrophonePermissionStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyLocationPermissionStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$, null, this.notifyLocationPermissionStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyTabContextPermissionStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$, null, this.notifyTabContextPermissionStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyOsLocationPermissionStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$, null, this.notifyOsLocationPermissionStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyFocusedTabChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, WebClient_NotifyFocusedTabChanged_ParamsSpec.$, null, this.notifyFocusedTabChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyManualResizeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, WebClient_NotifyManualResizeChanged_ParamsSpec.$, null, this.notifyManualResizeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyOsHotkeyStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$, null, this.notifyOsHotkeyStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyBrowserIsOpenChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$, null, this.notifyBrowserIsOpenChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyBrowserIsActiveChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, WebClient_NotifyBrowserIsActiveChanged_ParamsSpec.$, null, this.notifyBrowserIsActiveChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyActiveBrowserChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, WebClient_NotifyActiveBrowserChanged_ParamsSpec.$, null, this.notifyActiveBrowserChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyClosedCaptioningSettingChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$, null, this.notifyClosedCaptioningSettingChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyPinnedTabsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, WebClient_NotifyPinnedTabsChanged_ParamsSpec.$, null, this.notifyPinnedTabsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyPinnedTabDataChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$, null, this.notifyPinnedTabDataChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyZeroStateSuggestionsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$, null, this.notifyZeroStateSuggestionsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyActorTaskStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, WebClient_NotifyActorTaskStateChanged_ParamsSpec.$, null, this.notifyActorTaskStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.requestViewChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, WebClient_RequestViewChange_ParamsSpec.$, null, this.requestViewChange.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyPageMetadataChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, WebClient_NotifyPageMetadataChanged_ParamsSpec.$, null, this.notifyPageMetadataChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyDefaultTabContextPermissionStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$, null, this.notifyDefaultTabContextPermissionStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.requestToShowCredentialSelectionDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$, WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$, this.requestToShowCredentialSelectionDialog.createReceiverHandler(true /* expectsResponse */), false);
        this.requestToShowUserConfirmationDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$, WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$, this.requestToShowUserConfirmationDialog.createReceiverHandler(true /* expectsResponse */), false);
        this.notifyAdditionalContext =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, WebClient_NotifyAdditionalContext_ParamsSpec.$, null, this.notifyAdditionalContext.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const UserProfileInfoSpec = { $: {} };
export const ActiveBrowserInfoSpec = { $: {} };
export const WebClientInitialStateSpec = { $: {} };
export const GetTabContextOptionsSpec = { $: {} };
export const GetPinCandidatesOptionsSpec = { $: {} };
export const ScrollToParamsSpec = { $: {} };
export const ScrollToTextSelectorSpec = { $: {} };
export const ScrollToTextFragmentSelectorSpec = { $: {} };
export const ScrollToNodeSelectorSpec = { $: {} };
export const SuggestionContentSpec = { $: {} };
export const ZeroStateSuggestionsSpec = { $: {} };
export const ZeroStateSuggestionsV2Spec = { $: {} };
export const ZeroStateSuggestionsOptionsSpec = { $: {} };
export const PinCandidateSpec = { $: {} };
export const ConversationInfoSpec = { $: {} };
export const PanelOpeningDataSpec = { $: {} };
export const PanelStateSpec = { $: {} };
export const OnResponseStoppedDetailsSpec = { $: {} };
export const OpenPanelInfoSpec = { $: {} };
export const ContextDataSpec = { $: {} };
export const AdditionalContextSpec = { $: {} };
export const TabContextSpec = { $: {} };
export const WebPageDataSpec = { $: {} };
export const DocumentDataSpec = { $: {} };
export const PdfDocumentDataSpec = { $: {} };
export const TabDataSpec = { $: {} };
export const NoFocusedTabDataSpec = { $: {} };
export const AnnotatedPageDataSpec = { $: {} };
export const ImageOriginAnnotationsSpec = { $: {} };
export const JournalSpec = { $: {} };
export const ScreenshotSpec = { $: {} };
export const OpenSettingsOptionsSpec = { $: {} };
export const ViewChangeRequestActuationSpec = { $: {} };
export const ViewChangeRequestConversationSpec = { $: {} };
export const ViewChangeRequestSpec = { $: {} };
export const ViewChangedNotificationSpec = { $: {} };
export const Page_IntentToShow_ParamsSpec = { $: {} };
export const Page_SetProfileReadyState_ParamsSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_CreateWebClient_ParamsSpec = { $: {} };
export const PageHandler_PrepareForClient_ParamsSpec = { $: {} };
export const PageHandler_PrepareForClient_ResponseParamsSpec = { $: {} };
export const PageHandler_WebviewCommitted_ParamsSpec = { $: {} };
export const PageHandler_ClosePanel_ParamsSpec = { $: {} };
export const PageHandler_ClosePanel_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec = { $: {} };
export const PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec = { $: {} };
export const PageHandler_SignInAndClosePanel_ParamsSpec = { $: {} };
export const PageHandler_ResizeWidget_ParamsSpec = { $: {} };
export const PageHandler_ResizeWidget_ResponseParamsSpec = { $: {} };
export const PageHandler_EnableDragResize_ParamsSpec = { $: {} };
export const PageHandler_WebUiStateChanged_ParamsSpec = { $: {} };
export const PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec = { $: {} };
export const WebClientHandler_WebClientCreated_ParamsSpec = { $: {} };
export const WebClientHandler_WebClientCreated_ResponseParamsSpec = { $: {} };
export const WebClientHandler_WebClientInitialized_ParamsSpec = { $: {} };
export const WebClientHandler_WebClientInitializeFailed_ParamsSpec = { $: {} };
export const WebClientHandler_CreateTab_ParamsSpec = { $: {} };
export const WebClientHandler_CreateTab_ResponseParamsSpec = { $: {} };
export const WebClientHandler_OpenGlicSettingsPage_ParamsSpec = { $: {} };
export const WebClientHandler_ClosePanel_ParamsSpec = { $: {} };
export const WebClientHandler_ClosePanelAndShutdown_ParamsSpec = { $: {} };
export const WebClientHandler_AttachPanel_ParamsSpec = { $: {} };
export const WebClientHandler_DetachPanel_ParamsSpec = { $: {} };
export const WebClientHandler_ShowProfilePicker_ParamsSpec = { $: {} };
export const WebClientHandler_GetModelQualityClientId_ParamsSpec = { $: {} };
export const WebClientHandler_GetModelQualityClientId_ResponseParamsSpec = { $: {} };
export const WebClientHandler_GetContextFromFocusedTab_ParamsSpec = { $: {} };
export const WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec = { $: {} };
export const WebClientHandler_GetContextFromTab_ParamsSpec = { $: {} };
export const WebClientHandler_GetContextFromTab_ResponseParamsSpec = { $: {} };
export const WebClientHandler_GetContextForActorFromTab_ParamsSpec = { $: {} };
export const WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec = { $: {} };
export const WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec = { $: {} };
export const WebClientHandler_PinTabs_ParamsSpec = { $: {} };
export const WebClientHandler_PinTabs_ResponseParamsSpec = { $: {} };
export const WebClientHandler_UnpinTabs_ParamsSpec = { $: {} };
export const WebClientHandler_UnpinTabs_ResponseParamsSpec = { $: {} };
export const WebClientHandler_UnpinAllTabs_ParamsSpec = { $: {} };
export const WebClientHandler_SubscribeToPinCandidates_ParamsSpec = { $: {} };
export const WebClientHandler_CreateTask_ParamsSpec = { $: {} };
export const WebClientHandler_CreateTask_ResponseParamsSpec = { $: {} };
export const WebClientHandler_PerformActions_ParamsSpec = { $: {} };
export const WebClientHandler_PerformActions_ResponseParamsSpec = { $: {} };
export const WebClientHandler_StopActorTask_ParamsSpec = { $: {} };
export const WebClientHandler_PauseActorTask_ParamsSpec = { $: {} };
export const WebClientHandler_ResumeActorTask_ParamsSpec = { $: {} };
export const WebClientHandler_ResumeActorTask_ResponseParamsSpec = { $: {} };
export const WebClientHandler_ResizeWidget_ParamsSpec = { $: {} };
export const WebClientHandler_ResizeWidget_ResponseParamsSpec = { $: {} };
export const WebClientHandler_CaptureScreenshot_ParamsSpec = { $: {} };
export const WebClientHandler_CaptureScreenshot_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetAudioDucking_ParamsSpec = { $: {} };
export const WebClientHandler_SetAudioDucking_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetPanelDraggableAreas_ParamsSpec = { $: {} };
export const WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetMinimumPanelSize_ParamsSpec = { $: {} };
export const WebClientHandler_SetMicrophonePermissionState_ParamsSpec = { $: {} };
export const WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetLocationPermissionState_ParamsSpec = { $: {} };
export const WebClientHandler_SetLocationPermissionState_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetTabContextPermissionState_ParamsSpec = { $: {} };
export const WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetClosedCaptioningSetting_ParamsSpec = { $: {} };
export const WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec = { $: {} };
export const WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec = { $: {} };
export const WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec = { $: {} };
export const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec = { $: {} };
export const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SetContextAccessIndicator_ParamsSpec = { $: {} };
export const WebClientHandler_GetUserProfileInfo_ParamsSpec = { $: {} };
export const WebClientHandler_GetUserProfileInfo_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SyncCookies_ParamsSpec = { $: {} };
export const WebClientHandler_SyncCookies_ResponseParamsSpec = { $: {} };
export const WebClientHandler_LogBeginAsyncEvent_ParamsSpec = { $: {} };
export const WebClientHandler_LogEndAsyncEvent_ParamsSpec = { $: {} };
export const WebClientHandler_LogInstantEvent_ParamsSpec = { $: {} };
export const WebClientHandler_JournalClear_ParamsSpec = { $: {} };
export const WebClientHandler_JournalSnapshot_ParamsSpec = { $: {} };
export const WebClientHandler_JournalSnapshot_ResponseParamsSpec = { $: {} };
export const WebClientHandler_JournalStart_ParamsSpec = { $: {} };
export const WebClientHandler_JournalStop_ParamsSpec = { $: {} };
export const WebClientHandler_JournalRecordFeedback_ParamsSpec = { $: {} };
export const WebClientHandler_OnUserInputSubmitted_ParamsSpec = { $: {} };
export const WebClientHandler_OnContextUploadStarted_ParamsSpec = { $: {} };
export const WebClientHandler_OnContextUploadCompleted_ParamsSpec = { $: {} };
export const WebClientHandler_OnReaction_ParamsSpec = { $: {} };
export const WebClientHandler_OnResponseStarted_ParamsSpec = { $: {} };
export const WebClientHandler_OnResponseStopped_ParamsSpec = { $: {} };
export const WebClientHandler_OnSessionTerminated_ParamsSpec = { $: {} };
export const WebClientHandler_OnTurnCompleted_ParamsSpec = { $: {} };
export const WebClientHandler_OnModelChanged_ParamsSpec = { $: {} };
export const WebClientHandler_OnResponseRated_ParamsSpec = { $: {} };
export const WebClientHandler_OnClosedCaptionsShown_ParamsSpec = { $: {} };
export const WebClientHandler_ScrollTo_ParamsSpec = { $: {} };
export const WebClientHandler_ScrollTo_ResponseParamsSpec = { $: {} };
export const WebClientHandler_DropScrollToHighlight_ParamsSpec = { $: {} };
export const WebClientHandler_SetSyntheticExperimentState_ParamsSpec = { $: {} };
export const WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec = { $: {} };
export const WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec = { $: {} };
export const WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec = { $: {} };
export const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec = { $: {} };
export const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec = { $: {} };
export const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec = { $: {} };
export const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec = { $: {} };
export const WebClientHandler_MaybeRefreshUserStatus_ParamsSpec = { $: {} };
export const WebClientHandler_IsDebuggerAttached_ParamsSpec = { $: {} };
export const WebClientHandler_IsDebuggerAttached_ResponseParamsSpec = { $: {} };
export const WebClientHandler_OnViewChanged_ParamsSpec = { $: {} };
export const WebClientHandler_SubscribeToPageMetadata_ParamsSpec = { $: {} };
export const WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec = { $: {} };
export const WebClientHandler_SwitchConversation_ParamsSpec = { $: {} };
export const WebClientHandler_SwitchConversation_ResponseParamsSpec = { $: {} };
export const WebClientHandler_RegisterConversation_ParamsSpec = { $: {} };
export const WebClientHandler_RegisterConversation_ResponseParamsSpec = { $: {} };
export const WebClient_NotifyPanelWillOpen_ParamsSpec = { $: {} };
export const WebClient_NotifyPanelWillOpen_ResponseParamsSpec = { $: {} };
export const WebClient_NotifyPanelWasClosed_ParamsSpec = { $: {} };
export const WebClient_NotifyPanelWasClosed_ResponseParamsSpec = { $: {} };
export const WebClient_NotifyPanelStateChange_ParamsSpec = { $: {} };
export const WebClient_NotifyPanelActiveChange_ParamsSpec = { $: {} };
export const WebClient_NotifyPanelCanAttachChange_ParamsSpec = { $: {} };
export const WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyLocationPermissionStateChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyFocusedTabChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyManualResizeChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyOsHotkeyStateChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyBrowserIsOpenChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyBrowserIsActiveChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyActiveBrowserChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyPinnedTabsChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyPinnedTabDataChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyActorTaskStateChanged_ParamsSpec = { $: {} };
export const WebClient_RequestViewChange_ParamsSpec = { $: {} };
export const WebClient_NotifyPageMetadataChanged_ParamsSpec = { $: {} };
export const WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec = { $: {} };
export const WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec = { $: {} };
export const WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec = { $: {} };
export const WebClient_RequestToShowUserConfirmationDialog_ParamsSpec = { $: {} };
export const WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec = { $: {} };
export const WebClient_NotifyAdditionalContext_ParamsSpec = { $: {} };
export const GetContextResultSpec = { $: {} };
export const CaptureScreenshotResultSpec = { $: {} };
export const ScrollToSelectorSpec = { $: {} };
export const AdditionalContextPartSpec = { $: {} };
export const FocusedTabDataSpec = { $: {} };
export const ViewChangeRequestDetailsSpec = { $: {} };
export const WebClientHandler_CreateTask_ResponseParam_ResultSpec = { $: {} };
export const WebClientHandler_PerformActions_ResponseParam_ResultSpec = { $: {} };
mojo.internal.Struct(UserProfileInfoSpec.$, 'UserProfileInfo', [
    mojo.internal.StructField('avatarIcon', 0, 0, skia_mojom_BitmapN32Spec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('localProfileName', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('email', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('givenName', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isManaged', 40, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(ActiveBrowserInfoSpec.$, 'ActiveBrowserInfo', [
    mojo.internal.StructField('windowId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('usingThisProfile', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientInitialStateSpec.$, 'WebClientInitialState', [
    mojo.internal.StructField('panelState', 0, 0, PanelStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('focusedTabData', 8, 0, FocusedTabDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('microphonePermissionEnabled', 24, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locationPermissionEnabled', 24, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabContextPermissionEnabled', 24, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('osLocationPermissionEnabled', 24, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hotkey', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('chromeVersion', 40, 0, mojoBase_mojom_VersionSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('canAttach', 24, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('panelIsActive', 24, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('browserIsOpen', 24, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('browserIsActive', 24, 7, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('activeBrowserInfo', 48, 0, ActiveBrowserInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('alwaysDetachedMode', 25, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableZeroStateSuggestions', 25, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableActInFocusedTab', 25, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableScrollTo', 25, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableDefaultTabContextSettingFeature', 25, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('defaultTabContextSettingEnabled', 25, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableClosedCaptioningFeature', 25, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('closedCaptioningSettingEnabled', 25, 7, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableMaybeRefreshUserStatus', 26, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableMultiTab', 26, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableGetContextActor', 26, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hostCapabilities', 56, 0, mojo.internal.Array(HostCapabilitySpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableGetPageMetadata', 26, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableApiActivationGating', 26, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 72],]);
mojo.internal.Struct(GetTabContextOptionsSpec.$, 'GetTabContextOptions', [
    mojo.internal.StructField('includeInnerText', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('innerTextBytesLimit', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('includeViewportScreenshot', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('includeAnnotatedPageContent', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxMetaTags', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('includePdf', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pdfSizeLimit', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('annotatedPageContentMode', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(GetPinCandidatesOptionsSpec.$, 'GetPinCandidatesOptions', [
    mojo.internal.StructField('maxCandidates', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('query', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ScrollToParamsSpec.$, 'ScrollToParams', [
    mojo.internal.StructField('selector', 0, 0, ScrollToSelectorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('highlight', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('documentId', 24, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 32, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(ScrollToTextSelectorSpec.$, 'ScrollToTextSelector', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('search_range_start_node_id_$flag', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "search_range_start_node_id_$value",
        originalFieldName: "searchRangeStartNodeId",
    }, undefined),
    mojo.internal.StructField('search_range_start_node_id_$value', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "searchRangeStartNodeId",
    }, undefined),
], [[0, 24],]);
mojo.internal.Struct(ScrollToTextFragmentSelectorSpec.$, 'ScrollToTextFragmentSelector', [
    mojo.internal.StructField('textStart', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('textEnd', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('search_range_start_node_id_$flag', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "search_range_start_node_id_$value",
        originalFieldName: "searchRangeStartNodeId",
    }, undefined),
    mojo.internal.StructField('search_range_start_node_id_$value', 20, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "searchRangeStartNodeId",
    }, undefined),
], [[0, 32],]);
mojo.internal.Struct(ScrollToNodeSelectorSpec.$, 'ScrollToNodeSelector', [
    mojo.internal.StructField('nodeId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SuggestionContentSpec.$, 'SuggestionContent', [
    mojo.internal.StructField('suggestion', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ZeroStateSuggestionsSpec.$, 'ZeroStateSuggestions', [
    mojo.internal.StructField('suggestions', 0, 0, mojo.internal.Array(SuggestionContentSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabId', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabUrl', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ZeroStateSuggestionsV2Spec.$, 'ZeroStateSuggestionsV2', [
    mojo.internal.StructField('suggestions', 0, 0, mojo.internal.Array(SuggestionContentSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isPending', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ZeroStateSuggestionsOptionsSpec.$, 'ZeroStateSuggestionsOptions', [
    mojo.internal.StructField('isFirstRun', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportedTools', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PinCandidateSpec.$, 'PinCandidate', [
    mojo.internal.StructField('tabData', 0, 0, TabDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConversationInfoSpec.$, 'ConversationInfo', [
    mojo.internal.StructField('conversationId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('conversationTitle', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PanelOpeningDataSpec.$, 'PanelOpeningData', [
    mojo.internal.StructField('panelState', 0, 0, PanelStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('invocationSource', 8, 0, InvocationSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('conversationId', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
export const PanelState_KindSpec = { $: mojo.internal.Enum() };
export var PanelState_Kind;
(function (PanelState_Kind) {
    PanelState_Kind[PanelState_Kind["MIN_VALUE"] = 0] = "MIN_VALUE";
    PanelState_Kind[PanelState_Kind["MAX_VALUE"] = 2] = "MAX_VALUE";
    PanelState_Kind[PanelState_Kind["kHidden"] = 0] = "kHidden";
    PanelState_Kind[PanelState_Kind["kDetached"] = 1] = "kDetached";
    PanelState_Kind[PanelState_Kind["kAttached"] = 2] = "kAttached";
})(PanelState_Kind || (PanelState_Kind = {}));
mojo.internal.Struct(PanelStateSpec.$, 'PanelState', [
    mojo.internal.StructField('kind', 0, 0, PanelState_KindSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('window_id_$flag', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "window_id_$value",
        originalFieldName: "windowId",
    }, undefined),
    mojo.internal.StructField('window_id_$value', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "windowId",
    }, undefined),
], [[0, 24],]);
mojo.internal.Struct(OnResponseStoppedDetailsSpec.$, 'OnResponseStoppedDetails', [
    mojo.internal.StructField('cause', 0, 0, ResponseStopCauseSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OpenPanelInfoSpec.$, 'OpenPanelInfo', [
    mojo.internal.StructField('webClientMode', 0, 0, WebClientModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('panelSize', 8, 0, gfx_mojom_SizeSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resizeDuration', 16, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('canUserResize', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ContextDataSpec.$, 'ContextData', [
    mojo.internal.StructField('mimeType', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('data', 8, 0, mojoBase_mojom_BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(AdditionalContextSpec.$, 'AdditionalContext', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tab_id_$flag', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "tab_id_$value",
        originalFieldName: "tabId",
    }, undefined),
    mojo.internal.StructField('tab_id_$value', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "tabId",
    }, undefined),
    mojo.internal.StructField('origin', 16, 0, url_mojom_OriginSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('frameUrl', 24, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('parts', 32, 0, mojo.internal.Array(AdditionalContextPartSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(TabContextSpec.$, 'TabContext', [
    mojo.internal.StructField('tabData', 0, 0, TabDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('webPageData', 8, 0, WebPageDataSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('viewportScreenshot', 16, 0, ScreenshotSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pdfDocumentData', 24, 0, PdfDocumentDataSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('annotatedPageData', 32, 0, AnnotatedPageDataSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(WebPageDataSpec.$, 'WebPageData', [
    mojo.internal.StructField('mainDocument', 0, 0, DocumentDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DocumentDataSpec.$, 'DocumentData', [
    mojo.internal.StructField('origin', 0, 0, url_mojom_OriginSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('innerText', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('innerTextTruncated', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PdfDocumentDataSpec.$, 'PdfDocumentData', [
    mojo.internal.StructField('origin', 0, 0, url_mojom_OriginSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pdfData', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sizeLimitExceeded', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(TabDataSpec.$, 'TabData', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('windowId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('favicon', 24, 0, skia_mojom_BitmapN32Spec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('faviconUrl', 32, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('documentMimeType', 40, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('is_observable_$flag', 48, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_observable_$value",
        originalFieldName: "isObservable",
    }, undefined),
    mojo.internal.StructField('is_observable_$value', 48, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isObservable",
    }, undefined),
    mojo.internal.StructField('is_media_active_$flag', 48, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_media_active_$value",
        originalFieldName: "isMediaActive",
    }, undefined),
    mojo.internal.StructField('is_media_active_$value', 48, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isMediaActive",
    }, undefined),
    mojo.internal.StructField('is_tab_content_captured_$flag', 48, 4, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_tab_content_captured_$value",
        originalFieldName: "isTabContentCaptured",
    }, undefined),
    mojo.internal.StructField('is_tab_content_captured_$value', 48, 5, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isTabContentCaptured",
    }, undefined),
], [[0, 64],]);
mojo.internal.Struct(NoFocusedTabDataSpec.$, 'NoFocusedTabData', [
    mojo.internal.StructField('activeTabData', 0, 0, TabDataSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('noFocusReason', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AnnotatedPageDataSpec.$, 'AnnotatedPageData', [
    mojo.internal.StructField('annotatedPageContent', 0, 0, mojoBase_mojom_ProtoWrapperSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('metadata', 8, 0, blink_mojom_PageMetadataSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ImageOriginAnnotationsSpec.$, 'ImageOriginAnnotations', [], [[0, 8],]);
mojo.internal.Struct(JournalSpec.$, 'Journal', [
    mojo.internal.StructField('data', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ScreenshotSpec.$, 'Screenshot', [
    mojo.internal.StructField('widthPixels', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('heightPixels', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('data', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mimeType', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('originAnnotations', 24, 0, ImageOriginAnnotationsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(OpenSettingsOptionsSpec.$, 'OpenSettingsOptions', [
    mojo.internal.StructField('highlightField', 0, 0, SettingsPageFieldSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ViewChangeRequestActuationSpec.$, 'ViewChangeRequestActuation', [], [[0, 8],]);
mojo.internal.Struct(ViewChangeRequestConversationSpec.$, 'ViewChangeRequestConversation', [], [[0, 8],]);
mojo.internal.Struct(ViewChangeRequestSpec.$, 'ViewChangeRequest', [
    mojo.internal.StructField('details', 0, 0, ViewChangeRequestDetailsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ViewChangedNotificationSpec.$, 'ViewChangedNotification', [
    mojo.internal.StructField('currentView', 0, 0, CurrentViewSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_IntentToShow_ParamsSpec.$, 'Page_IntentToShow_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_SetProfileReadyState_ParamsSpec.$, 'Page_SetProfileReadyState_Params', [
    mojo.internal.StructField('readyState', 0, 0, ProfileReadyStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('receiver', 0, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('page', 4, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_CreateWebClient_ParamsSpec.$, 'PageHandler_CreateWebClient_Params', [
    mojo.internal.StructField('webClientReceiver', 0, 0, mojo.internal.InterfaceRequest(WebClientHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_PrepareForClient_ParamsSpec.$, 'PageHandler_PrepareForClient_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_PrepareForClient_ResponseParamsSpec.$, 'PageHandler_PrepareForClient_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, PrepareForClientResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_WebviewCommitted_ParamsSpec.$, 'PageHandler_WebviewCommitted_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ClosePanel_ParamsSpec.$, 'PageHandler_ClosePanel_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ClosePanel_ResponseParamsSpec.$, 'PageHandler_ClosePanel_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$, 'PageHandler_OpenProfilePickerAndClosePanel_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$, 'PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_SignInAndClosePanel_ParamsSpec.$, 'PageHandler_SignInAndClosePanel_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ResizeWidget_ParamsSpec.$, 'PageHandler_ResizeWidget_Params', [
    mojo.internal.StructField('size', 0, 0, gfx_mojom_SizeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duration', 8, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ResizeWidget_ResponseParamsSpec.$, 'PageHandler_ResizeWidget_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_EnableDragResize_ParamsSpec.$, 'PageHandler_EnableDragResize_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_WebUiStateChanged_ParamsSpec.$, 'PageHandler_WebUiStateChanged_Params', [
    mojo.internal.StructField('newState', 0, 0, WebUiStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$, 'PinCandidatesObserver_OnPinCandidatesChanged_Params', [
    mojo.internal.StructField('candidates', 0, 0, mojo.internal.Array(PinCandidateSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_WebClientCreated_ParamsSpec.$, 'WebClientHandler_WebClientCreated_Params', [
    mojo.internal.StructField('webClient', 0, 0, mojo.internal.InterfaceProxy(WebClientRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_WebClientCreated_ResponseParamsSpec.$, 'WebClientHandler_WebClientCreated_ResponseParams', [
    mojo.internal.StructField('initialState', 0, 0, WebClientInitialStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_WebClientInitialized_ParamsSpec.$, 'WebClientHandler_WebClientInitialized_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_WebClientInitializeFailed_ParamsSpec.$, 'WebClientHandler_WebClientInitializeFailed_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_CreateTab_ParamsSpec.$, 'WebClientHandler_CreateTab_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('openInBackground', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('window_id_$flag', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "window_id_$value",
        originalFieldName: "windowId",
    }, undefined),
    mojo.internal.StructField('window_id_$value', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "windowId",
    }, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_CreateTab_ResponseParamsSpec.$, 'WebClientHandler_CreateTab_ResponseParams', [
    mojo.internal.StructField('tabData', 0, 0, TabDataSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$, 'WebClientHandler_OpenGlicSettingsPage_Params', [
    mojo.internal.StructField('options', 0, 0, OpenSettingsOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_ClosePanel_ParamsSpec.$, 'WebClientHandler_ClosePanel_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$, 'WebClientHandler_ClosePanelAndShutdown_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_AttachPanel_ParamsSpec.$, 'WebClientHandler_AttachPanel_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_DetachPanel_ParamsSpec.$, 'WebClientHandler_DetachPanel_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_ShowProfilePicker_ParamsSpec.$, 'WebClientHandler_ShowProfilePicker_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_GetModelQualityClientId_ParamsSpec.$, 'WebClientHandler_GetModelQualityClientId_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$, 'WebClientHandler_GetModelQualityClientId_ResponseParams', [
    mojo.internal.StructField('modelQualityClientId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$, 'WebClientHandler_GetContextFromFocusedTab_Params', [
    mojo.internal.StructField('options', 0, 0, GetTabContextOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$, 'WebClientHandler_GetContextFromFocusedTab_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GetContextResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_GetContextFromTab_ParamsSpec.$, 'WebClientHandler_GetContextFromTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('options', 8, 0, GetTabContextOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_GetContextFromTab_ResponseParamsSpec.$, 'WebClientHandler_GetContextFromTab_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GetContextResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_GetContextForActorFromTab_ParamsSpec.$, 'WebClientHandler_GetContextForActorFromTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('options', 8, 0, GetTabContextOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$, 'WebClientHandler_GetContextForActorFromTab_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GetContextResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$, 'WebClientHandler_SetMaximumNumberOfPinnedTabs_Params', [
    mojo.internal.StructField('requestedMax', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$, 'WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams', [
    mojo.internal.StructField('effectiveMax', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_PinTabs_ParamsSpec.$, 'WebClientHandler_PinTabs_Params', [
    mojo.internal.StructField('tabIds', 0, 0, mojo.internal.Array(mojo.internal.Int32, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_PinTabs_ResponseParamsSpec.$, 'WebClientHandler_PinTabs_ResponseParams', [
    mojo.internal.StructField('pinnedAll', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_UnpinTabs_ParamsSpec.$, 'WebClientHandler_UnpinTabs_Params', [
    mojo.internal.StructField('tabIds', 0, 0, mojo.internal.Array(mojo.internal.Int32, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_UnpinTabs_ResponseParamsSpec.$, 'WebClientHandler_UnpinTabs_ResponseParams', [
    mojo.internal.StructField('unpinnedAll', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_UnpinAllTabs_ParamsSpec.$, 'WebClientHandler_UnpinAllTabs_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$, 'WebClientHandler_SubscribeToPinCandidates_Params', [
    mojo.internal.StructField('options', 0, 0, GetPinCandidatesOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('observer', 8, 0, mojo.internal.InterfaceProxy(PinCandidatesObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_CreateTask_ParamsSpec.$, 'WebClientHandler_CreateTask_Params', [
    mojo.internal.StructField('taskOptions', 0, 0, actor_webui_mojom_TaskOptionsSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_CreateTask_ResponseParamsSpec.$, 'WebClientHandler_CreateTask_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, WebClientHandler_CreateTask_ResponseParam_ResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_PerformActions_ParamsSpec.$, 'WebClientHandler_PerformActions_Params', [
    mojo.internal.StructField('actionsProto', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_PerformActions_ResponseParamsSpec.$, 'WebClientHandler_PerformActions_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, WebClientHandler_PerformActions_ResponseParam_ResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_StopActorTask_ParamsSpec.$, 'WebClientHandler_StopActorTask_Params', [
    mojo.internal.StructField('taskId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('stopReason', 4, 0, ActorTaskStopReasonSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_PauseActorTask_ParamsSpec.$, 'WebClientHandler_PauseActorTask_Params', [
    mojo.internal.StructField('taskId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pauseReason', 4, 0, ActorTaskPauseReasonSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_ResumeActorTask_ParamsSpec.$, 'WebClientHandler_ResumeActorTask_Params', [
    mojo.internal.StructField('taskId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contextOptions', 8, 0, GetTabContextOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_ResumeActorTask_ResponseParamsSpec.$, 'WebClientHandler_ResumeActorTask_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GetContextResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_ResizeWidget_ParamsSpec.$, 'WebClientHandler_ResizeWidget_Params', [
    mojo.internal.StructField('size', 0, 0, gfx_mojom_SizeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duration', 8, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_ResizeWidget_ResponseParamsSpec.$, 'WebClientHandler_ResizeWidget_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_CaptureScreenshot_ParamsSpec.$, 'WebClientHandler_CaptureScreenshot_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$, 'WebClientHandler_CaptureScreenshot_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, CaptureScreenshotResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_SetAudioDucking_ParamsSpec.$, 'WebClientHandler_SetAudioDucking_Params', [
    mojo.internal.StructField('enable', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetAudioDucking_ResponseParamsSpec.$, 'WebClientHandler_SetAudioDucking_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$, 'WebClientHandler_SetPanelDraggableAreas_Params', [
    mojo.internal.StructField('draggableAreas', 0, 0, mojo.internal.Array(gfx_mojom_RectSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$, 'WebClientHandler_SetPanelDraggableAreas_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_SetMinimumPanelSize_ParamsSpec.$, 'WebClientHandler_SetMinimumPanelSize_Params', [
    mojo.internal.StructField('size', 0, 0, gfx_mojom_SizeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$, 'WebClientHandler_SetMicrophonePermissionState_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$, 'WebClientHandler_SetMicrophonePermissionState_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_SetLocationPermissionState_ParamsSpec.$, 'WebClientHandler_SetLocationPermissionState_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$, 'WebClientHandler_SetLocationPermissionState_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_SetTabContextPermissionState_ParamsSpec.$, 'WebClientHandler_SetTabContextPermissionState_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$, 'WebClientHandler_SetTabContextPermissionState_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$, 'WebClientHandler_SetClosedCaptioningSetting_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$, 'WebClientHandler_SetClosedCaptioningSetting_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$, 'WebClientHandler_ShouldAllowMediaPermissionRequest_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$, 'WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams', [
    mojo.internal.StructField('isAllowed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$, 'WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$, 'WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams', [
    mojo.internal.StructField('isAllowed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SetContextAccessIndicator_ParamsSpec.$, 'WebClientHandler_SetContextAccessIndicator_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_GetUserProfileInfo_ParamsSpec.$, 'WebClientHandler_GetUserProfileInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$, 'WebClientHandler_GetUserProfileInfo_ResponseParams', [
    mojo.internal.StructField('profileInfo', 0, 0, UserProfileInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SyncCookies_ParamsSpec.$, 'WebClientHandler_SyncCookies_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_SyncCookies_ResponseParamsSpec.$, 'WebClientHandler_SyncCookies_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$, 'WebClientHandler_LogBeginAsyncEvent_Params', [
    mojo.internal.StructField('eventAsyncId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('taskId', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('event', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('details', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(WebClientHandler_LogEndAsyncEvent_ParamsSpec.$, 'WebClientHandler_LogEndAsyncEvent_Params', [
    mojo.internal.StructField('eventAsyncId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('details', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_LogInstantEvent_ParamsSpec.$, 'WebClientHandler_LogInstantEvent_Params', [
    mojo.internal.StructField('taskId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('event', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('details', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(WebClientHandler_JournalClear_ParamsSpec.$, 'WebClientHandler_JournalClear_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_JournalSnapshot_ParamsSpec.$, 'WebClientHandler_JournalSnapshot_Params', [
    mojo.internal.StructField('clearJournal', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_JournalSnapshot_ResponseParamsSpec.$, 'WebClientHandler_JournalSnapshot_ResponseParams', [
    mojo.internal.StructField('journal', 0, 0, JournalSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_JournalStart_ParamsSpec.$, 'WebClientHandler_JournalStart_Params', [
    mojo.internal.StructField('maxBytes', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('captureScreenshots', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_JournalStop_ParamsSpec.$, 'WebClientHandler_JournalStop_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_JournalRecordFeedback_ParamsSpec.$, 'WebClientHandler_JournalRecordFeedback_Params', [
    mojo.internal.StructField('positive', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('reason', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_OnUserInputSubmitted_ParamsSpec.$, 'WebClientHandler_OnUserInputSubmitted_Params', [
    mojo.internal.StructField('mode', 0, 0, WebClientModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_OnContextUploadStarted_ParamsSpec.$, 'WebClientHandler_OnContextUploadStarted_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_OnContextUploadCompleted_ParamsSpec.$, 'WebClientHandler_OnContextUploadCompleted_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_OnReaction_ParamsSpec.$, 'WebClientHandler_OnReaction_Params', [
    mojo.internal.StructField('reactionType', 0, 0, MetricUserInputReactionTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_OnResponseStarted_ParamsSpec.$, 'WebClientHandler_OnResponseStarted_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_OnResponseStopped_ParamsSpec.$, 'WebClientHandler_OnResponseStopped_Params', [
    mojo.internal.StructField('details', 0, 0, OnResponseStoppedDetailsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_OnSessionTerminated_ParamsSpec.$, 'WebClientHandler_OnSessionTerminated_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_OnTurnCompleted_ParamsSpec.$, 'WebClientHandler_OnTurnCompleted_Params', [
    mojo.internal.StructField('model', 0, 0, WebClientModelSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duration', 8, 0, mojoBase_mojom_TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_OnModelChanged_ParamsSpec.$, 'WebClientHandler_OnModelChanged_Params', [
    mojo.internal.StructField('model', 0, 0, WebClientModelSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_OnResponseRated_ParamsSpec.$, 'WebClientHandler_OnResponseRated_Params', [
    mojo.internal.StructField('positive', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$, 'WebClientHandler_OnClosedCaptionsShown_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_ScrollTo_ParamsSpec.$, 'WebClientHandler_ScrollTo_Params', [
    mojo.internal.StructField('params', 0, 0, ScrollToParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_ScrollTo_ResponseParamsSpec.$, 'WebClientHandler_ScrollTo_ResponseParams', [
    mojo.internal.StructField('error_reason_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "error_reason_$value",
        originalFieldName: "errorReason",
    }, undefined),
    mojo.internal.StructField('error_reason_$value', 4, 0, ScrollToErrorReasonSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "errorReason",
    }, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_DropScrollToHighlight_ParamsSpec.$, 'WebClientHandler_DropScrollToHighlight_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$, 'WebClientHandler_SetSyntheticExperimentState_Params', [
    mojo.internal.StructField('trialName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('groupName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$, 'WebClientHandler_OpenOsPermissionSettingsMenu_Params', [
    mojo.internal.StructField('type', 0, 0, contentSettings_mojom_ContentSettingsTypeSpec.$, -1, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$, 'WebClientHandler_GetOsMicrophonePermissionStatus_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$, 'WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$, 'WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params', [
    mojo.internal.StructField('isLive', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('options', 8, 0, ZeroStateSuggestionsOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$, 'WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams', [
    mojo.internal.StructField('zeroStateSuggestions', 0, 0, ZeroStateSuggestionsV2Spec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$, 'WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params', [
    mojo.internal.StructField('is_first_run_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_first_run_$value",
        originalFieldName: "isFirstRun",
    }, undefined),
    mojo.internal.StructField('is_first_run_$value', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isFirstRun",
    }, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$, 'WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams', [
    mojo.internal.StructField('suggestions', 0, 0, ZeroStateSuggestionsSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$, 'WebClientHandler_MaybeRefreshUserStatus_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_IsDebuggerAttached_ParamsSpec.$, 'WebClientHandler_IsDebuggerAttached_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$, 'WebClientHandler_IsDebuggerAttached_ResponseParams', [
    mojo.internal.StructField('isAttachedToWebview', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_OnViewChanged_ParamsSpec.$, 'WebClientHandler_OnViewChanged_Params', [
    mojo.internal.StructField('notification', 0, 0, ViewChangedNotificationSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$, 'WebClientHandler_SubscribeToPageMetadata_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('names', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$, 'WebClientHandler_SubscribeToPageMetadata_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SwitchConversation_ParamsSpec.$, 'WebClientHandler_SwitchConversation_Params', [
    mojo.internal.StructField('info', 0, 0, ConversationInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_SwitchConversation_ResponseParamsSpec.$, 'WebClientHandler_SwitchConversation_ResponseParams', [
    mojo.internal.StructField('error_reason_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "error_reason_$value",
        originalFieldName: "errorReason",
    }, undefined),
    mojo.internal.StructField('error_reason_$value', 4, 0, SwitchConversationErrorReasonSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "errorReason",
    }, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_RegisterConversation_ParamsSpec.$, 'WebClientHandler_RegisterConversation_Params', [
    mojo.internal.StructField('info', 0, 0, ConversationInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClientHandler_RegisterConversation_ResponseParamsSpec.$, 'WebClientHandler_RegisterConversation_ResponseParams', [
    mojo.internal.StructField('error_reason_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "error_reason_$value",
        originalFieldName: "errorReason",
    }, undefined),
    mojo.internal.StructField('error_reason_$value', 4, 0, RegisterConversationErrorReasonSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "errorReason",
    }, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPanelWillOpen_ParamsSpec.$, 'WebClient_NotifyPanelWillOpen_Params', [
    mojo.internal.StructField('panelOpeningData', 0, 0, PanelOpeningDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$, 'WebClient_NotifyPanelWillOpen_ResponseParams', [
    mojo.internal.StructField('openPanelInfo', 0, 0, OpenPanelInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPanelWasClosed_ParamsSpec.$, 'WebClient_NotifyPanelWasClosed_Params', [], [[0, 8],]);
mojo.internal.Struct(WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$, 'WebClient_NotifyPanelWasClosed_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(WebClient_NotifyPanelStateChange_ParamsSpec.$, 'WebClient_NotifyPanelStateChange_Params', [
    mojo.internal.StructField('panelState', 0, 0, PanelStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPanelActiveChange_ParamsSpec.$, 'WebClient_NotifyPanelActiveChange_Params', [
    mojo.internal.StructField('panelActive', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPanelCanAttachChange_ParamsSpec.$, 'WebClient_NotifyPanelCanAttachChange_Params', [
    mojo.internal.StructField('canAttach', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$, 'WebClient_NotifyMicrophonePermissionStateChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$, 'WebClient_NotifyLocationPermissionStateChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$, 'WebClient_NotifyTabContextPermissionStateChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$, 'WebClient_NotifyOsLocationPermissionStateChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyFocusedTabChanged_ParamsSpec.$, 'WebClient_NotifyFocusedTabChanged_Params', [
    mojo.internal.StructField('focusedTabData', 0, 0, FocusedTabDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClient_NotifyManualResizeChanged_ParamsSpec.$, 'WebClient_NotifyManualResizeChanged_Params', [
    mojo.internal.StructField('resizing', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$, 'WebClient_NotifyOsHotkeyStateChanged_Params', [
    mojo.internal.StructField('hotkey', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$, 'WebClient_NotifyBrowserIsOpenChanged_Params', [
    mojo.internal.StructField('browserIsOpen', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyBrowserIsActiveChanged_ParamsSpec.$, 'WebClient_NotifyBrowserIsActiveChanged_Params', [
    mojo.internal.StructField('browserActive', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyActiveBrowserChanged_ParamsSpec.$, 'WebClient_NotifyActiveBrowserChanged_Params', [
    mojo.internal.StructField('activeBrowserInfo', 0, 0, ActiveBrowserInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$, 'WebClient_NotifyClosedCaptioningSettingChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPinnedTabsChanged_ParamsSpec.$, 'WebClient_NotifyPinnedTabsChanged_Params', [
    mojo.internal.StructField('tabData', 0, 0, mojo.internal.Array(TabDataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$, 'WebClient_NotifyPinnedTabDataChanged_Params', [
    mojo.internal.StructField('tabData', 0, 0, TabDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$, 'WebClient_NotifyZeroStateSuggestionsChanged_Params', [
    mojo.internal.StructField('suggestions', 0, 0, ZeroStateSuggestionsV2Spec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('options', 8, 0, ZeroStateSuggestionsOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClient_NotifyActorTaskStateChanged_ParamsSpec.$, 'WebClient_NotifyActorTaskStateChanged_Params', [
    mojo.internal.StructField('taskId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('state', 4, 0, ActorTaskStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_RequestViewChange_ParamsSpec.$, 'WebClient_RequestViewChange_Params', [
    mojo.internal.StructField('request', 0, 0, ViewChangeRequestSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyPageMetadataChanged_ParamsSpec.$, 'WebClient_NotifyPageMetadataChanged_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('metadata', 8, 0, blink_mojom_PageMetadataSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$, 'WebClient_NotifyDefaultTabContextPermissionStateChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$, 'WebClient_RequestToShowCredentialSelectionDialog_Params', [
    mojo.internal.StructField('request', 0, 0, actor_webui_mojom_SelectCredentialDialogRequestSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$, 'WebClient_RequestToShowCredentialSelectionDialog_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, actor_webui_mojom_SelectCredentialDialogResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$, 'WebClient_RequestToShowUserConfirmationDialog_Params', [
    mojo.internal.StructField('request', 0, 0, actor_webui_mojom_UserConfirmationDialogRequestSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$, 'WebClient_RequestToShowUserConfirmationDialog_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, actor_webui_mojom_UserConfirmationDialogResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebClient_NotifyAdditionalContext_ParamsSpec.$, 'WebClient_NotifyAdditionalContext_Params', [
    mojo.internal.StructField('context', 0, 0, AdditionalContextSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(GetContextResultSpec.$, 'GetContextResult', {
    'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'tabContext': {
        'ordinal': 1,
        'type': TabContextSpec.$,
    },
});
export var GetContextResultFieldTags;
(function (GetContextResultFieldTags) {
    GetContextResultFieldTags[GetContextResultFieldTags["ERROR_REASON"] = 0] = "ERROR_REASON";
    GetContextResultFieldTags[GetContextResultFieldTags["TAB_CONTEXT"] = 1] = "TAB_CONTEXT";
})(GetContextResultFieldTags || (GetContextResultFieldTags = {}));
export function whichGetContextResult(u) {
    if (u.errorReason !== null && u.errorReason !== undefined) {
        return GetContextResultFieldTags.ERROR_REASON;
    }
    if (u.tabContext !== null && u.tabContext !== undefined) {
        return GetContextResultFieldTags.TAB_CONTEXT;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(CaptureScreenshotResultSpec.$, 'CaptureScreenshotResult', {
    'errorReason': {
        'ordinal': 0,
        'type': CaptureScreenshotErrorReasonSpec.$,
    },
    'screenshot': {
        'ordinal': 1,
        'type': ScreenshotSpec.$,
    },
});
export var CaptureScreenshotResultFieldTags;
(function (CaptureScreenshotResultFieldTags) {
    CaptureScreenshotResultFieldTags[CaptureScreenshotResultFieldTags["ERROR_REASON"] = 0] = "ERROR_REASON";
    CaptureScreenshotResultFieldTags[CaptureScreenshotResultFieldTags["SCREENSHOT"] = 1] = "SCREENSHOT";
})(CaptureScreenshotResultFieldTags || (CaptureScreenshotResultFieldTags = {}));
export function whichCaptureScreenshotResult(u) {
    if (u.errorReason !== null && u.errorReason !== undefined) {
        return CaptureScreenshotResultFieldTags.ERROR_REASON;
    }
    if (u.screenshot !== null && u.screenshot !== undefined) {
        return CaptureScreenshotResultFieldTags.SCREENSHOT;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(ScrollToSelectorSpec.$, 'ScrollToSelector', {
    'exactTextSelector': {
        'ordinal': 0,
        'type': ScrollToTextSelectorSpec.$,
    },
    'textFragmentSelector': {
        'ordinal': 1,
        'type': ScrollToTextFragmentSelectorSpec.$,
    },
    'nodeSelector': {
        'ordinal': 2,
        'type': ScrollToNodeSelectorSpec.$,
    },
});
export var ScrollToSelectorFieldTags;
(function (ScrollToSelectorFieldTags) {
    ScrollToSelectorFieldTags[ScrollToSelectorFieldTags["EXACT_TEXT_SELECTOR"] = 0] = "EXACT_TEXT_SELECTOR";
    ScrollToSelectorFieldTags[ScrollToSelectorFieldTags["TEXT_FRAGMENT_SELECTOR"] = 1] = "TEXT_FRAGMENT_SELECTOR";
    ScrollToSelectorFieldTags[ScrollToSelectorFieldTags["NODE_SELECTOR"] = 2] = "NODE_SELECTOR";
})(ScrollToSelectorFieldTags || (ScrollToSelectorFieldTags = {}));
export function whichScrollToSelector(u) {
    if (u.exactTextSelector !== null && u.exactTextSelector !== undefined) {
        return ScrollToSelectorFieldTags.EXACT_TEXT_SELECTOR;
    }
    if (u.textFragmentSelector !== null && u.textFragmentSelector !== undefined) {
        return ScrollToSelectorFieldTags.TEXT_FRAGMENT_SELECTOR;
    }
    if (u.nodeSelector !== null && u.nodeSelector !== undefined) {
        return ScrollToSelectorFieldTags.NODE_SELECTOR;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(AdditionalContextPartSpec.$, 'AdditionalContextPart', {
    'data': {
        'ordinal': 0,
        'type': ContextDataSpec.$,
    },
    'screenshot': {
        'ordinal': 1,
        'type': ScreenshotSpec.$,
    },
    'webPageData': {
        'ordinal': 2,
        'type': WebPageDataSpec.$,
    },
    'annotatedPageData': {
        'ordinal': 3,
        'type': AnnotatedPageDataSpec.$,
    },
    'pdfDocumentData': {
        'ordinal': 4,
        'type': PdfDocumentDataSpec.$,
    },
});
export var AdditionalContextPartFieldTags;
(function (AdditionalContextPartFieldTags) {
    AdditionalContextPartFieldTags[AdditionalContextPartFieldTags["DATA"] = 0] = "DATA";
    AdditionalContextPartFieldTags[AdditionalContextPartFieldTags["SCREENSHOT"] = 1] = "SCREENSHOT";
    AdditionalContextPartFieldTags[AdditionalContextPartFieldTags["WEB_PAGE_DATA"] = 2] = "WEB_PAGE_DATA";
    AdditionalContextPartFieldTags[AdditionalContextPartFieldTags["ANNOTATED_PAGE_DATA"] = 3] = "ANNOTATED_PAGE_DATA";
    AdditionalContextPartFieldTags[AdditionalContextPartFieldTags["PDF_DOCUMENT_DATA"] = 4] = "PDF_DOCUMENT_DATA";
})(AdditionalContextPartFieldTags || (AdditionalContextPartFieldTags = {}));
export function whichAdditionalContextPart(u) {
    if (u.data !== null && u.data !== undefined) {
        return AdditionalContextPartFieldTags.DATA;
    }
    if (u.screenshot !== null && u.screenshot !== undefined) {
        return AdditionalContextPartFieldTags.SCREENSHOT;
    }
    if (u.webPageData !== null && u.webPageData !== undefined) {
        return AdditionalContextPartFieldTags.WEB_PAGE_DATA;
    }
    if (u.annotatedPageData !== null && u.annotatedPageData !== undefined) {
        return AdditionalContextPartFieldTags.ANNOTATED_PAGE_DATA;
    }
    if (u.pdfDocumentData !== null && u.pdfDocumentData !== undefined) {
        return AdditionalContextPartFieldTags.PDF_DOCUMENT_DATA;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(FocusedTabDataSpec.$, 'FocusedTabData', {
    'focusedTab': {
        'ordinal': 0,
        'type': TabDataSpec.$,
    },
    'noFocusedTabData': {
        'ordinal': 1,
        'type': NoFocusedTabDataSpec.$,
    },
});
export var FocusedTabDataFieldTags;
(function (FocusedTabDataFieldTags) {
    FocusedTabDataFieldTags[FocusedTabDataFieldTags["FOCUSED_TAB"] = 0] = "FOCUSED_TAB";
    FocusedTabDataFieldTags[FocusedTabDataFieldTags["NO_FOCUSED_TAB_DATA"] = 1] = "NO_FOCUSED_TAB_DATA";
})(FocusedTabDataFieldTags || (FocusedTabDataFieldTags = {}));
export function whichFocusedTabData(u) {
    if (u.focusedTab !== null && u.focusedTab !== undefined) {
        return FocusedTabDataFieldTags.FOCUSED_TAB;
    }
    if (u.noFocusedTabData !== null && u.noFocusedTabData !== undefined) {
        return FocusedTabDataFieldTags.NO_FOCUSED_TAB_DATA;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(ViewChangeRequestDetailsSpec.$, 'ViewChangeRequestDetails', {
    'actuation': {
        'ordinal': 0,
        'type': ViewChangeRequestActuationSpec.$,
    },
    'conversation': {
        'ordinal': 1,
        'type': ViewChangeRequestConversationSpec.$,
    },
});
export var ViewChangeRequestDetailsFieldTags;
(function (ViewChangeRequestDetailsFieldTags) {
    ViewChangeRequestDetailsFieldTags[ViewChangeRequestDetailsFieldTags["ACTUATION"] = 0] = "ACTUATION";
    ViewChangeRequestDetailsFieldTags[ViewChangeRequestDetailsFieldTags["CONVERSATION"] = 1] = "CONVERSATION";
})(ViewChangeRequestDetailsFieldTags || (ViewChangeRequestDetailsFieldTags = {}));
export function whichViewChangeRequestDetails(u) {
    if (u.actuation !== null && u.actuation !== undefined) {
        return ViewChangeRequestDetailsFieldTags.ACTUATION;
    }
    if (u.conversation !== null && u.conversation !== undefined) {
        return ViewChangeRequestDetailsFieldTags.CONVERSATION;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(WebClientHandler_CreateTask_ResponseParam_ResultSpec.$, 'WebClientHandler_CreateTask_ResponseParam_Result', {
    'success': {
        'ordinal': 0,
        'type': mojo.internal.Int32,
    },
    'failure': {
        'ordinal': 1,
        'type': CreateTaskErrorReasonSpec.$,
    },
});
export var WebClientHandler_CreateTask_ResponseParam_ResultFieldTags;
(function (WebClientHandler_CreateTask_ResponseParam_ResultFieldTags) {
    WebClientHandler_CreateTask_ResponseParam_ResultFieldTags[WebClientHandler_CreateTask_ResponseParam_ResultFieldTags["SUCCESS"] = 0] = "SUCCESS";
    WebClientHandler_CreateTask_ResponseParam_ResultFieldTags[WebClientHandler_CreateTask_ResponseParam_ResultFieldTags["FAILURE"] = 1] = "FAILURE";
})(WebClientHandler_CreateTask_ResponseParam_ResultFieldTags || (WebClientHandler_CreateTask_ResponseParam_ResultFieldTags = {}));
export function whichWebClientHandler_CreateTask_ResponseParam_Result(u) {
    if (u.success !== null && u.success !== undefined) {
        return WebClientHandler_CreateTask_ResponseParam_ResultFieldTags.SUCCESS;
    }
    if (u.failure !== null && u.failure !== undefined) {
        return WebClientHandler_CreateTask_ResponseParam_ResultFieldTags.FAILURE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(WebClientHandler_PerformActions_ResponseParam_ResultSpec.$, 'WebClientHandler_PerformActions_ResponseParam_Result', {
    'success': {
        'ordinal': 0,
        'type': mojoBase_mojom_ProtoWrapperSpec.$,
    },
    'failure': {
        'ordinal': 1,
        'type': PerformActionsErrorReasonSpec.$,
    },
});
export var WebClientHandler_PerformActions_ResponseParam_ResultFieldTags;
(function (WebClientHandler_PerformActions_ResponseParam_ResultFieldTags) {
    WebClientHandler_PerformActions_ResponseParam_ResultFieldTags[WebClientHandler_PerformActions_ResponseParam_ResultFieldTags["SUCCESS"] = 0] = "SUCCESS";
    WebClientHandler_PerformActions_ResponseParam_ResultFieldTags[WebClientHandler_PerformActions_ResponseParam_ResultFieldTags["FAILURE"] = 1] = "FAILURE";
})(WebClientHandler_PerformActions_ResponseParam_ResultFieldTags || (WebClientHandler_PerformActions_ResponseParam_ResultFieldTags = {}));
export function whichWebClientHandler_PerformActions_ResponseParam_Result(u) {
    if (u.success !== null && u.success !== undefined) {
        return WebClientHandler_PerformActions_ResponseParam_ResultFieldTags.SUCCESS;
    }
    if (u.failure !== null && u.failure !== undefined) {
        return WebClientHandler_PerformActions_ResponseParam_ResultFieldTags.FAILURE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
