import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { BitmapN32 as skia_mojom_BitmapN32 } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import { Origin as url_mojom_Origin } from '//resources/mojo/url/mojom/origin.mojom-webui.js';
export declare const UserGrantedPermissionDurationSpec: {
    $: mojo.internal.MojomType;
};
export declare enum UserGrantedPermissionDuration {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kOneTime = 0,
    kAlwaysAllow = 1
}
export declare const SelectCredentialDialogErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SelectCredentialDialogErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 0,
    kDialogPromiseNoSubscriber = 0
}
export declare const UserConfirmationDialogErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum UserConfirmationDialogErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kDialogPromiseNoSubscriber = 0,
    kPreemptedByNewRequest = 1
}
export declare const TaskOptionsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CredentialSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectCredentialDialogRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectCredentialDialogResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogPayloadSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogResultSpec: {
    $: mojo.internal.MojomType;
};
export interface TaskOptionsMojoType {
    title: (string | null);
}
export type TaskOptions = TaskOptionsMojoType;
export interface CredentialMojoType {
    id: number;
    username: string;
    sourceSiteOrApp: string;
}
export type Credential = CredentialMojoType;
export interface SelectCredentialDialogRequestMojoType {
    taskId: number;
    showDialog: boolean;
    credentials: Credential[];
    icons: {
        [key: string]: skia_mojom_BitmapN32;
    };
}
export type SelectCredentialDialogRequest = SelectCredentialDialogRequestMojoType;
export interface SelectCredentialDialogResponseMojoType {
    taskId: number;
    errorReason: (SelectCredentialDialogErrorReason | null);
    permissionDuration: (UserGrantedPermissionDuration | null);
    selectedCredentialId: (number | null);
}
export type SelectCredentialDialogResponse = SelectCredentialDialogResponseMojoType;
export interface UserConfirmationDialogRequestMojoType {
    payload: UserConfirmationDialogPayload;
}
export type UserConfirmationDialogRequest = UserConfirmationDialogRequestMojoType;
export interface UserConfirmationDialogResponseMojoType {
    result: UserConfirmationDialogResult;
}
export type UserConfirmationDialogResponse = UserConfirmationDialogResponseMojoType;
export interface UserConfirmationDialogPayload {
    navigationOrigin?: url_mojom_Origin;
    downloadId?: number;
}
export declare enum UserConfirmationDialogPayloadFieldTags {
    NAVIGATION_ORIGIN = 0,
    DOWNLOAD_ID = 1
}
export declare function whichUserConfirmationDialogPayload(u: UserConfirmationDialogPayload): UserConfirmationDialogPayloadFieldTags;
export interface UserConfirmationDialogResult {
    permissionGranted?: boolean;
    errorReason?: UserConfirmationDialogErrorReason;
}
export declare enum UserConfirmationDialogResultFieldTags {
    PERMISSION_GRANTED = 0,
    ERROR_REASON = 1
}
export declare function whichUserConfirmationDialogResult(u: UserConfirmationDialogResult): UserConfirmationDialogResultFieldTags;
