// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assertNotReached}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{AlphaType}from"//resources/mojo/skia/public/mojom/image_info.mojom-webui.js";import{ContentSettingsType}from"../content_settings_types.mojom-webui.js";import{CurrentView as CurrentViewMojo,PinCandidatesObserverReceiver,ResponseStopCause as ResponseStopCauseMojo,SettingsPageField as SettingsPageFieldMojo,WebClientHandlerRemote,WebClientMode,WebClientReceiver}from"../glic.mojom-webui.js";import{CaptureScreenshotErrorReason,ClientView,CreateTaskErrorReason,DEFAULT_INNER_TEXT_BYTES_LIMIT,DEFAULT_PDF_SIZE_LIMIT,PerformActionsErrorReason,ResponseStopCause,ScrollToErrorReason}from"../glic_api/glic_api.js";import{ObservableValue}from"../observable.js";import{OneShotTimer}from"../timer.js";import{replaceProperties}from"./conversions.js";import{newSenderId,PostMessageRequestReceiver,PostMessageRequestSender,ResponseExtras}from"./post_message_transport.js";import{ErrorWithReasonImpl,exceptionFromTransferable,HOST_REQUEST_TYPES,ImageAlphaType,ImageColorType,requestTypeToHistogramSuffix}from"./request_types.js";export var WebClientState;(function(WebClientState){WebClientState[WebClientState["UNINITIALIZED"]=0]="UNINITIALIZED";WebClientState[WebClientState["RESPONSIVE"]=1]="RESPONSIVE";WebClientState[WebClientState["UNRESPONSIVE"]=2]="UNRESPONSIVE";WebClientState[WebClientState["ERROR"]=3]="ERROR"})(WebClientState||(WebClientState={}));var PanelOpenState;(function(PanelOpenState){PanelOpenState[PanelOpenState["OPEN"]=0]="OPEN";PanelOpenState[PanelOpenState["CLOSED"]=1]="CLOSED"})(PanelOpenState||(PanelOpenState={}));export var DetailedWebClientState;(function(DetailedWebClientState){DetailedWebClientState[DetailedWebClientState["BOOTSTRAP_PENDING"]=0]="BOOTSTRAP_PENDING";DetailedWebClientState[DetailedWebClientState["WEB_CLIENT_NOT_CREATED"]=1]="WEB_CLIENT_NOT_CREATED";DetailedWebClientState[DetailedWebClientState["WEB_CLIENT_INITIALIZE_FAILED"]=2]="WEB_CLIENT_INITIALIZE_FAILED";DetailedWebClientState[DetailedWebClientState["WEB_CLIENT_NOT_INITIALIZED"]=3]="WEB_CLIENT_NOT_INITIALIZED";DetailedWebClientState[DetailedWebClientState["TEMPORARY_UNRESPONSIVE"]=4]="TEMPORARY_UNRESPONSIVE";DetailedWebClientState[DetailedWebClientState["PERMANENT_UNRESPONSIVE"]=5]="PERMANENT_UNRESPONSIVE";DetailedWebClientState[DetailedWebClientState["RESPONSIVE"]=6]="RESPONSIVE";DetailedWebClientState[DetailedWebClientState["RESPONSIVE_INACTIVE"]=7]="RESPONSIVE_INACTIVE";DetailedWebClientState[DetailedWebClientState["UNRESPONSIVE_INACTIVE"]=8]="UNRESPONSIVE_INACTIVE";DetailedWebClientState[DetailedWebClientState["MOJO_PIPE_CLOSED_UNEXPECTEDLY"]=9]="MOJO_PIPE_CLOSED_UNEXPECTEDLY";DetailedWebClientState[DetailedWebClientState["MAX_VALUE"]=9]="MAX_VALUE"})(DetailedWebClientState||(DetailedWebClientState={}));const BACKGROUND_RESPONSES={glicBrowserCreateTab:{returns:{}},glicBrowserShowProfilePicker:{throws:true},glicBrowserGetContextFromFocusedTab:{throws:true},glicBrowserGetContextFromTab:{throws:true},glicBrowserCaptureScreenshot:{throws:true},glicBrowserScrollTo:{does:()=>{throw new ErrorWithReasonImpl("scrollTo",ScrollToErrorReason.NOT_SUPPORTED)}},glicBrowserOpenOsPermissionSettingsMenu:{throws:true},glicBrowserPinTabs:{returns:{pinnedAll:false}},glicBrowserUnpinAllTabs:{returns:undefined},glicBrowserSubscribeToPinCandidates:{returns:undefined},glicBrowserGetZeroStateSuggestionsForFocusedTab:{returns:{}},glicBrowserGetZeroStateSuggestionsAndSubscribe:{returns:{}}};class WebClientImpl{host;embedder;sender;constructor(host,embedder){this.host=host;this.embedder=embedder;this.sender=this.host.sender}async notifyPanelWillOpen(panelOpeningData){this.host.setWaitingOnPanelWillOpen(true);let result;try{result=await this.sender.requestWithResponse("glicWebClientNotifyPanelWillOpen",{panelOpeningData:panelOpeningDataToClient(panelOpeningData)})}finally{this.host.setWaitingOnPanelWillOpen(false);this.host.panelOpenStateChanged(PanelOpenState.OPEN)}this.embedder.webClientReady();const openPanelInfoMojo={webClientMode:result.openPanelInfo?.startingMode??WebClientMode.kUnknown,panelSize:null,resizeDuration:timeDeltaFromClient(result.openPanelInfo?.resizeParams?.options?.durationMs),canUserResize:result.openPanelInfo?.canUserResize??true};if(result.openPanelInfo?.resizeParams){const size={width:result.openPanelInfo?.resizeParams?.width,height:result.openPanelInfo?.resizeParams?.height};this.embedder.onGuestResizeRequest(size);openPanelInfoMojo.panelSize=size}return{openPanelInfo:openPanelInfoMojo}}notifyPanelWasClosed(){this.host.panelOpenStateChanged(PanelOpenState.CLOSED);return this.sender.requestWithResponse("glicWebClientNotifyPanelWasClosed",undefined)}notifyPanelStateChange(panelState){this.sender.requestNoResponse("glicWebClientPanelStateChanged",{panelState:panelStateToClient(panelState)})}notifyPanelCanAttachChange(canAttach){this.sender.requestNoResponse("glicWebClientCanAttachStateChanged",{canAttach:canAttach})}notifyMicrophonePermissionStateChanged(enabled){this.sender.requestNoResponse("glicWebClientNotifyMicrophonePermissionStateChanged",{enabled:enabled})}notifyLocationPermissionStateChanged(enabled){this.sender.requestNoResponse("glicWebClientNotifyLocationPermissionStateChanged",{enabled:enabled})}notifyTabContextPermissionStateChanged(enabled){this.sender.requestNoResponse("glicWebClientNotifyTabContextPermissionStateChanged",{enabled:enabled})}notifyOsLocationPermissionStateChanged(enabled){this.sender.requestNoResponse("glicWebClientNotifyOsLocationPermissionStateChanged",{enabled:enabled})}notifyClosedCaptioningSettingChanged(enabled){this.sender.requestNoResponse("glicWebClientNotifyClosedCaptioningSettingChanged",{enabled:enabled})}notifyDefaultTabContextPermissionStateChanged(enabled){this.sender.requestNoResponse("glicWebClientNotifyDefaultTabContextPermissionStateChanged",{enabled:enabled})}notifyFocusedTabChanged(focusedTabData){const extras=new ResponseExtras;this.sender.sendLatestWhenActive("glicWebClientNotifyFocusedTabChanged",{focusedTabDataPrivate:focusedTabDataToClient(focusedTabData,extras)},extras.transfers)}notifyPanelActiveChange(panelActive){this.sender.requestNoResponse("glicWebClientNotifyPanelActiveChanged",{panelActive:panelActive});this.host.panelIsActive=panelActive;this.host.updateSenderActive()}notifyManualResizeChanged(resizing){this.sender.requestNoResponse("glicWebClientNotifyManualResizeChanged",{resizing:resizing})}notifyBrowserIsOpenChanged(browserIsOpen){this.sender.requestNoResponse("glicWebClientBrowserIsOpenChanged",{browserIsOpen:browserIsOpen})}notifyBrowserIsActiveChanged(browserIsActive){this.host.setBrowserIsActive(browserIsActive)}notifyOsHotkeyStateChanged(hotkey){this.sender.requestNoResponse("glicWebClientNotifyOsHotkeyStateChanged",{hotkey:hotkey})}notifyPinnedTabsChanged(tabData){const extras=new ResponseExtras;this.sender.sendLatestWhenActive("glicWebClientNotifyPinnedTabsChanged",{tabData:tabData.map((x=>tabDataToClient(x,extras)))},extras.transfers)}notifyPinnedTabDataChanged(tabData){const extras=new ResponseExtras;this.sender.sendLatestWhenActive("glicWebClientNotifyPinnedTabDataChanged",{tabData:tabDataToClient(tabData,extras)},extras.transfers,`${tabData.tabId}`)}notifyZeroStateSuggestionsChanged(suggestions,options){this.sender.sendLatestWhenActive("glicWebClientZeroStateSuggestionsChanged",{suggestions:suggestions,options:options})}notifyActorTaskStateChanged(taskId,state){const clientState=state;this.sender.requestNoResponse("glicWebClientNotifyActorTaskStateChanged",{taskId:taskId,state:clientState})}notifyActiveBrowserChanged(activeBrowserInfo){this.sender.requestNoResponse("glicWebClientNotifyActiveBrowserChanged",{activeBrowserInfo:activeBrowserInfoToClient(activeBrowserInfo)})}requestViewChange(requestMojo){let request;if(requestMojo.details.actuation){request={desiredView:ClientView.ACTUATION}}else if(requestMojo.details.conversation){request={desiredView:ClientView.CONVERSATION}}if(!request){return}this.sender.requestNoResponse("glicWebClientRequestViewChange",{request:request})}notifyPageMetadataChanged(tabId,metadata){this.sender.sendLatestWhenActive("glicWebClientPageMetadataChanged",{tabId:tabIdToClient(tabId),pageMetadata:pageMetadataToClient(metadata)},undefined,`${tabId}`)}async requestToShowCredentialSelectionDialog(request){const clientResponse=await this.sender.requestWithResponse("glicWebClientRequestToShowDialog",{request:selectCredentialDialogRequestToClient(request)});return{response:selectCredentialDialogResponseToMojo(clientResponse.response)}}async requestToShowUserConfirmationDialog(request){const clientResponse=await this.sender.requestWithResponse("glicWebClientRequestToShowConfirmationDialog",{request:userConfirmationDialogRequestToClient(request)});return{response:userConfirmationDialogResponseToMojo(clientResponse.response)}}notifyAdditionalContext(context){const extras=new ResponseExtras;const clientParts=context.parts.map((p=>{const part={};if(p.data){part.data=contextDataToClient(p.data,extras)}else if(p.screenshot){part.screenshot=screenshotToClient(p.screenshot,extras)}else if(p.webPageData){part.webPageData=webPageDataToClient(p.webPageData)}else if(p.annotatedPageData){part.annotatedPageData=annotatedPageDataToClient(p.annotatedPageData,extras)}else if(p.pdfDocumentData){part.pdf=pdfDocumentDataToClient(p.pdfDocumentData,extras)}return part}));const clientContext={name:optionalToClient(context.name),tabId:tabIdToClient(context.tabId),origin:originToClient(context.origin),frameUrl:urlToClient(context.frameUrl),parts:clientParts};this.sender.sendWhenActive("glicWebClientNotifyAdditionalContext",{context:clientContext},extras.transfers)}}class PinCandidatesObserverImpl{sender;handler;options;observationId;receiver;constructor(sender,handler,options,observationId){this.sender=sender;this.handler=handler;this.options=options;this.observationId=observationId;this.connectToSource()}disconnectFromSource(){if(!this.receiver){return}this.receiver.$.close();this.receiver=undefined}connectToSource(){if(this.receiver){return}this.receiver=new PinCandidatesObserverReceiver(this);this.handler.subscribeToPinCandidates(getPinCandidatesOptionsFromClient(this.options),this.receiver.$.bindNewPipeAndPassRemote())}onPinCandidatesChanged(candidates){const extras=new ResponseExtras;this.sender.sendLatestWhenActive("glicWebClientPinCandidatesChanged",{candidates:candidates.map((c=>({tabData:tabDataToClient(c.tabData,extras)}))),observationId:this.observationId},extras.transfers)}}class HostMessageHandler{handler;sender;embedder;host;receiver;constructor(handler,sender,embedder,host){this.handler=handler;this.sender=sender;this.embedder=embedder;this.host=host}destroy(){if(this.receiver){this.receiver.$.close();this.receiver=undefined}}async glicBrowserWebClientCreated(_request,extras){if(this.receiver){throw new Error("web client already created")}this.host.detailedWebClientState=DetailedWebClientState.WEB_CLIENT_NOT_INITIALIZED;const webClientImpl=new WebClientImpl(this.host,this.embedder);this.receiver=new WebClientReceiver(webClientImpl);const{initialState:initialState}=await this.handler.webClientCreated(this.receiver.$.bindNewPipeAndPassRemote());this.host.setInitialState(initialState);const chromeVersion=initialState.chromeVersion.components;const hostCapabilities=initialState.hostCapabilities;this.host.setBrowserIsActive(initialState.browserIsActive);if(initialState.enableApiActivationGating&&!initialState.panelIsActive){const actualFocus=initialState.focusedTabData;initialState.focusedTabData={noFocusedTabData:{activeTabData:null,noFocusReason:"glic not active"}};webClientImpl.notifyFocusedTabChanged(actualFocus)}return{initialState:replaceProperties(initialState,{panelState:panelStateToClient(initialState.panelState),focusedTabData:focusedTabDataToClient(initialState.focusedTabData,extras),chromeVersion:{major:chromeVersion[0]||0,minor:chromeVersion[1]||0,build:chromeVersion[2]||0,patch:chromeVersion[3]||0},loggingEnabled:loadTimeData.getBoolean("loggingEnabled"),hostCapabilities:hostCapabilitiesToClient(hostCapabilities),activeBrowserInfo:activeBrowserInfoToClient(initialState.activeBrowserInfo)})}}glicBrowserWebClientInitialized(request){if(request.exception){console.warn(exceptionFromTransferable(request.exception))}if(request.success){this.handler.webClientInitialized();this.host.webClientInitialized()}else{this.handler.webClientInitializeFailed();this.host.webClientInitializeFailed()}}async glicBrowserCreateTab(request){const response=await this.handler.createTab(urlFromClient(request.url),request.options.openInBackground!==undefined?request.options.openInBackground:false,optionalWindowIdFromClient(request.options.windowId));const tabData=response.tabData;if(tabData){return{tabData:{tabId:tabIdToClient(tabData.tabId),windowId:windowIdToClient(tabData.windowId),url:urlToClient(tabData.url),title:optionalToClient(tabData.title)}}}return{}}glicBrowserOpenGlicSettingsPage(request){const optionsMojo={highlightField:SettingsPageFieldMojo.kNone};if(request.options?.highlightField){optionsMojo.highlightField=request.options?.highlightField}this.handler.openGlicSettingsPage(optionsMojo)}glicBrowserClosePanel(){return this.handler.closePanel()}glicBrowserClosePanelAndShutdown(){this.handler.closePanelAndShutdown()}glicBrowserAttachPanel(){this.handler.attachPanel()}glicBrowserDetachPanel(){this.handler.detachPanel()}glicBrowserShowProfilePicker(){this.handler.showProfilePicker()}glicBrowserGetModelQualityClientId(){return this.handler.getModelQualityClientId()}async glicBrowserSwitchConversation(request){const{errorReason:errorReason}=await this.handler.switchConversation(request.info??null);if(errorReason!==null){throw new ErrorWithReasonImpl("switchConversation",errorReason.valueOf())}return{}}async glicBrowserRegisterConversation(request){const{errorReason:errorReason}=await this.handler.registerConversation(request.info);if(errorReason!==null){throw new ErrorWithReasonImpl("registerConversation",errorReason.valueOf())}return{}}async glicBrowserGetContextFromFocusedTab(request,extras){const{result:{errorReason:errorReason,tabContext:tabContext}}=await this.handler.getContextFromFocusedTab(tabContextOptionsFromClient(request.options));if(!tabContext){throw new Error(`tabContext failed: ${errorReason}`)}const tabContextResult=tabContextToClient(tabContext,extras);return{tabContextResult:tabContextResult}}async glicBrowserGetContextFromTab(request,extras){const{result:{errorReason:errorReason,tabContext:tabContext}}=await this.handler.getContextFromTab(tabIdFromClient(request.tabId),tabContextOptionsFromClient(request.options));if(!tabContext){throw new Error(`tabContext failed: ${errorReason}`)}const tabContextResult=tabContextToClient(tabContext,extras);return{tabContextResult:tabContextResult}}async glicBrowserGetContextForActorFromTab(request,extras){const{result:{errorReason:errorReason,tabContext:tabContext}}=await this.handler.getContextForActorFromTab(tabIdFromClient(request.tabId),tabContextOptionsFromClient(request.options));if(!tabContext){throw new Error(`tabContext failed: ${errorReason}`)}const tabContextResult=tabContextToClient(tabContext,extras);return{tabContextResult:tabContextResult}}async glicBrowserSetMaximumNumberOfPinnedTabs(request){const requestedMax=request.requestedMax>=0?request.requestedMax:0;const{effectiveMax:effectiveMax}=await this.handler.setMaximumNumberOfPinnedTabs(requestedMax);return{effectiveMax:effectiveMax}}async glicBrowserCreateTask(request){try{const taskId=await this.handler.createTask(taskOptionsToMojo(request.taskOptions));return{taskId:taskId}}catch(errorReason){throw new ErrorWithReasonImpl("createTask",errorReason??CreateTaskErrorReason.UNKNOWN)}}async glicBrowserPerformActions(request){try{const resultProto=await this.handler.performActions(byteArrayFromClient(request.actions));const buffer=getArrayBufferFromBigBuffer(resultProto.smuggled);if(!buffer){throw PerformActionsErrorReason.UNKNOWN}return{actionsResult:buffer}}catch(errorReason){throw new ErrorWithReasonImpl("performActions",errorReason??PerformActionsErrorReason.UNKNOWN)}}glicBrowserStopActorTask(request){const actorTaskStopReason=request.stopReason;this.handler.stopActorTask(request.taskId,actorTaskStopReason)}glicBrowserPauseActorTask(request){const actorTaskPauseReason=request.pauseReason;this.handler.pauseActorTask(request.taskId,actorTaskPauseReason)}async glicBrowserResumeActorTask(request,extras){const{result:{errorReason:errorReason,tabContext:tabContext}}=await this.handler.resumeActorTask(request.taskId,tabContextOptionsFromClient(request.tabContextOptions));if(!tabContext){throw new Error(`resumeActorTask failed: ${errorReason}`)}return{tabContextResult:tabContextToClient(tabContext,extras)}}async glicBrowserResizeWindow(request){this.embedder.onGuestResizeRequest(request.size);return await this.handler.resizeWidget(request.size,timeDeltaFromClient(request.options?.durationMs))}glicBrowserEnableDragResize(request){return this.embedder.enableDragResize(request.enabled)}async glicBrowserCaptureScreenshot(_request,extras){const{result:{screenshot:screenshot,errorReason:errorReason}}=await this.handler.captureScreenshot();if(!screenshot){throw new ErrorWithReasonImpl("captureScreenshot",errorReason??CaptureScreenshotErrorReason.UNKNOWN)}const screenshotArray=new Uint8Array(screenshot.data);extras.addTransfer(screenshotArray.buffer);return{screenshot:{widthPixels:screenshot.widthPixels,heightPixels:screenshot.heightPixels,data:screenshotArray.buffer,mimeType:screenshot.mimeType,originAnnotations:{}}}}glicBrowserSetWindowDraggableAreas(request){return this.handler.setPanelDraggableAreas(request.areas)}glicBrowserSetMinimumWidgetSize(request){return this.handler.setMinimumPanelSize(request.size)}glicBrowserSetMicrophonePermissionState(request){return this.handler.setMicrophonePermissionState(request.enabled)}glicBrowserSetLocationPermissionState(request){return this.handler.setLocationPermissionState(request.enabled)}glicBrowserSetTabContextPermissionState(request){return this.handler.setTabContextPermissionState(request.enabled)}glicBrowserSetClosedCaptioningSetting(request){return this.handler.setClosedCaptioningSetting(request.enabled)}async glicBrowserGetUserProfileInfo(_request,extras){const{profileInfo:mojoProfileInfo}=await this.handler.getUserProfileInfo();if(!mojoProfileInfo){return{}}let avatarIcon;if(mojoProfileInfo.avatarIcon){avatarIcon=bitmapN32ToRGBAImage(mojoProfileInfo.avatarIcon);if(avatarIcon){extras.addTransfer(avatarIcon.dataRGBA)}}return{profileInfo:replaceProperties(mojoProfileInfo,{avatarIcon:avatarIcon})}}glicBrowserRefreshSignInCookies(){return this.handler.syncCookies()}glicBrowserSetContextAccessIndicator(request){this.handler.setContextAccessIndicator(request.show)}glicBrowserSetAudioDucking(request){this.handler.setAudioDucking(request.enabled)}glicBrowserOnUserInputSubmitted(request){this.handler.onUserInputSubmitted(request.mode)}glicBrowserOnContextUploadStarted(){this.handler.onContextUploadStarted()}glicBrowserOnContextUploadCompleted(){this.handler.onContextUploadCompleted()}glicBrowserOnReaction(request){this.handler.onReaction(request.reactionType)}glicBrowserOnResponseStarted(){this.handler.onResponseStarted()}glicBrowserOnResponseStopped(request){const cause=request.details?.cause;let causeMojo=ResponseStopCauseMojo.kUnknown;if(cause!==undefined){switch(cause){case ResponseStopCause.USER:causeMojo=ResponseStopCauseMojo.kUser;break;case ResponseStopCause.OTHER:causeMojo=ResponseStopCauseMojo.kOther;break;default:assertNotReached()}}this.handler.onResponseStopped({cause:causeMojo})}glicBrowserOnSessionTerminated(){this.handler.onSessionTerminated()}glicBrowserOnTurnCompleted(request){this.handler.onTurnCompleted(request.model,timeDeltaFromClient(request.duration))}glicBrowserOnModelChanged(request){this.handler.onModelChanged(request.model)}glicBrowserLogBeginAsyncEvent(request){this.handler.logBeginAsyncEvent(BigInt(request.asyncEventId),request.taskId,request.event,request.details)}glicBrowserLogEndAsyncEvent(request){this.handler.logEndAsyncEvent(BigInt(request.asyncEventId),request.details)}glicBrowserLogInstantEvent(request){this.handler.logInstantEvent(request.taskId,request.event,request.details)}glicBrowserJournalClear(){this.handler.journalClear()}async glicBrowserJournalSnapshot(request,extras){const result=await this.handler.journalSnapshot(request.clear);const journalArray=new Uint8Array(result.journal.data);extras.addTransfer(journalArray.buffer);return{journal:{data:journalArray.buffer}}}glicBrowserJournalStart(request){this.handler.journalStart(BigInt(request.maxBytes),request.captureScreenshots)}glicBrowserJournalStop(){this.handler.journalStop()}glicBrowserJournalRecordFeedback(request){this.handler.journalRecordFeedback(request.positive,request.reason)}glicBrowserOnResponseRated(request){this.handler.onResponseRated(request.positive)}glicBrowserOnClosedCaptionsShown(){this.handler.onClosedCaptionsShown()}async glicBrowserScrollTo(request){const{params:params}=request;function getMojoSelector(){const{selector:selector}=params;if(selector.exactText!==undefined){if(selector.exactText.searchRangeStartNodeId!==undefined&&params.documentId===undefined){throw new ErrorWithReasonImpl("scrollTo",ScrollToErrorReason.NOT_SUPPORTED,"searchRangeStartNodeId without documentId")}return{exactTextSelector:{text:selector.exactText.text,searchRangeStartNodeId:selector.exactText.searchRangeStartNodeId??null}}}if(selector.textFragment!==undefined){if(selector.textFragment.searchRangeStartNodeId!==undefined&&params.documentId===undefined){throw new ErrorWithReasonImpl("scrollTo",ScrollToErrorReason.NOT_SUPPORTED,"searchRangeStartNodeId without documentId")}return{textFragmentSelector:{textStart:selector.textFragment.textStart,textEnd:selector.textFragment.textEnd,searchRangeStartNodeId:selector.textFragment.searchRangeStartNodeId??null}}}if(selector.node!==undefined){if(params.documentId===undefined){throw new ErrorWithReasonImpl("scrollTo",ScrollToErrorReason.NOT_SUPPORTED,"nodeId without documentId")}return{nodeSelector:{nodeId:selector.node.nodeId}}}throw new ErrorWithReasonImpl("scrollTo",ScrollToErrorReason.NOT_SUPPORTED)}const mojoParams={highlight:params.highlight===undefined?true:params.highlight,selector:getMojoSelector(),documentId:params.documentId??null,url:params.url?urlFromClient(params.url):null};const{errorReason:errorReason}=await this.handler.scrollTo(mojoParams);if(errorReason!==null){throw new ErrorWithReasonImpl("scrollTo",errorReason)}return{}}glicBrowserSetSyntheticExperimentState(request){return this.handler.setSyntheticExperimentState(request.trialName,request.groupName)}glicBrowserOpenOsPermissionSettingsMenu(request){switch(request.permission){case"media":return this.handler.openOsPermissionSettingsMenu(ContentSettingsType.MEDIASTREAM_MIC);case"geolocation":return this.handler.openOsPermissionSettingsMenu(ContentSettingsType.GEOLOCATION)}return Promise.resolve()}glicBrowserGetOsMicrophonePermissionStatus(){return this.handler.getOsMicrophonePermissionStatus()}glicBrowserPinTabs(request){return this.handler.pinTabs(request.tabIds.map((x=>tabIdFromClient(x))))}glicBrowserUnpinTabs(request){return this.handler.unpinTabs(request.tabIds.map((x=>tabIdFromClient(x))))}glicBrowserUnpinAllTabs(){this.handler.unpinAllTabs()}glicBrowserSubscribeToPinCandidates(request){this.host.pinCandidatesObserver?.disconnectFromSource();this.host.pinCandidatesObserver=new PinCandidatesObserverImpl(this.sender,this.handler,request.options,request.observationId)}glicBrowserUnsubscribeFromPinCandidates(request){if(!this.host.pinCandidatesObserver){return}if(this.host.pinCandidatesObserver.observationId===request.observationId){this.host.pinCandidatesObserver.disconnectFromSource();this.host.pinCandidatesObserver=undefined}}async glicBrowserGetZeroStateSuggestionsForFocusedTab(request){const zeroStateResult=await this.handler.getZeroStateSuggestionsForFocusedTab(optionalFromClient(request.isFirstRun));const zeroStateData=zeroStateResult.suggestions;if(!zeroStateData){return{}}else{return{suggestions:{tabId:tabIdToClient(zeroStateData.tabId),url:urlToClient(zeroStateData.tabUrl),suggestions:zeroStateData.suggestions}}}}async glicBrowserGetZeroStateSuggestionsAndSubscribe(request){const zeroStateResult=await this.handler.getZeroStateSuggestionsAndSubscribe(request.hasActiveSubscription,{isFirstRun:request.options.isFirstRun??false,supportedTools:request.options.supportedTools??[]});const zeroStateData=zeroStateResult.zeroStateSuggestions;if(!zeroStateData){return{}}else{return{suggestions:zeroStateData}}}glicBrowserDropScrollToHighlight(){this.handler.dropScrollToHighlight()}glicBrowserMaybeRefreshUserStatus(){this.handler.maybeRefreshUserStatus()}glicBrowserOnViewChanged(request){const{currentView:currentView}=request.notification;switch(currentView){case ClientView.ACTUATION:this.handler.onViewChanged({currentView:CurrentViewMojo.kActuation});break;case ClientView.CONVERSATION:this.handler.onViewChanged({currentView:CurrentViewMojo.kConversation});break;default:const _exhaustive=currentView;throw new Error(`glicBrowserOnViewChanged: invalid currentView: ${_exhaustive}`)}}glicBrowserSubscribeToPageMetadata(request){return this.handler.subscribeToPageMetadata(tabIdFromClient(request.tabId),request.names)}}export class GlicApiHost{browserProxy;windowProxy;embeddedOrigin;senderId=newSenderId();messageHandler;postMessageReceiver;sender;enableApiActivationGating=true;panelIsActive=false;handler;bootstrapPingIntervalId;webClientErrorTimer;webClientState=ObservableValue.withValue(WebClientState.UNINITIALIZED);waitingOnPanelWillOpenValue=false;clientActiveObs=ObservableValue.withValue(false);panelOpenState=PanelOpenState.CLOSED;browserIsActive=true;hasShownDebuggerAttachedWarning=false;detailedWebClientState=DetailedWebClientState.BOOTSTRAP_PENDING;pinCandidatesObserver;constructor(browserProxy,windowProxy,embeddedOrigin,embedder){this.browserProxy=browserProxy;this.windowProxy=windowProxy;this.embeddedOrigin=embeddedOrigin;this.postMessageReceiver=new PostMessageRequestReceiver(embeddedOrigin,this.senderId,windowProxy,this,"glic_api_host");this.postMessageReceiver.setLoggingEnabled(loadTimeData.getBoolean("loggingEnabled"));const ungatedSender=new PostMessageRequestSender(windowProxy,embeddedOrigin,this.senderId,"glic_api_host");ungatedSender.setLoggingEnabled(loadTimeData.getBoolean("loggingEnabled"));this.sender=new GatedSender(ungatedSender);this.handler=new WebClientHandlerRemote;this.handler.onConnectionError.addListener((()=>{if(this.webClientState.getCurrentValue()!==WebClientState.ERROR){console.warn(`Mojo connection error in glic host`);this.detailedWebClientState=DetailedWebClientState.MOJO_PIPE_CLOSED_UNEXPECTEDLY;this.webClientState.assignAndSignal(WebClientState.ERROR)}}));this.handler.$.close();this.browserProxy.handler.createWebClient(this.handler.$.bindNewPipeAndPassReceiver());this.messageHandler=new HostMessageHandler(this.handler,this.sender,embedder,this);this.webClientErrorTimer=new OneShotTimer(loadTimeData.getInteger("clientUnresponsiveUiMaxTimeMs"));this.bootstrapPingIntervalId=window.setInterval(this.bootstrapPing.bind(this),50);this.bootstrapPing()}destroy(){this.webClientState=ObservableValue.withValue(WebClientState.ERROR);window.clearInterval(this.bootstrapPingIntervalId);this.webClientErrorTimer.reset();this.postMessageReceiver.destroy();this.messageHandler.destroy();this.sender.destroy();this.pinCandidatesObserver?.disconnectFromSource()}setInitialState(initialState){this.enableApiActivationGating=initialState.enableApiActivationGating;this.panelIsActive=initialState.panelIsActive;this.updateSenderActive()}updateSenderActive(){this.sender.setGating(this.shouldGateRequests())}shouldGateRequests(){return!this.panelIsActive&&this.enableApiActivationGating}contentLoaded(){this.bootstrapPing();this.stopBootstrapPing()}waitingOnPanelWillOpen(){return this.waitingOnPanelWillOpenValue}setWaitingOnPanelWillOpen(value){this.waitingOnPanelWillOpenValue=value}panelOpenStateChanged(state){this.panelOpenState=state;this.clientActiveObs.assignAndSignal(this.isClientActive());if(state===PanelOpenState.CLOSED){this.pinCandidatesObserver?.disconnectFromSource()}else{this.pinCandidatesObserver?.connectToSource()}}setBrowserIsActive(browserIsActive){this.browserIsActive=browserIsActive;this.clientActiveObs.assignAndSignal(this.isClientActive())}isClientActive(){return this.panelOpenState===PanelOpenState.OPEN&&this.webClientState.getCurrentValue()!==WebClientState.ERROR&&this.browserIsActive}webClientInitialized(){this.detailedWebClientState=DetailedWebClientState.RESPONSIVE;this.setWebClientState(WebClientState.RESPONSIVE);this.responsiveCheckLoop()}webClientInitializeFailed(){console.warn("GlicApiHost: web client initialize failed");this.detailedWebClientState=DetailedWebClientState.WEB_CLIENT_INITIALIZE_FAILED;this.setWebClientState(WebClientState.ERROR)}setWebClientState(state){this.webClientState.assignAndSignal(state)}getWebClientState(){return this.webClientState}getDetailedWebClientState(){return this.detailedWebClientState}bootstrapPing(){if(this.bootstrapPingIntervalId===undefined){return}this.windowProxy.postMessage({type:"glic-bootstrap",glicApiSource:loadTimeData.getString("glicGuestAPISource")},this.embeddedOrigin)}stopBootstrapPing(){if(this.bootstrapPingIntervalId!==undefined){window.clearInterval(this.bootstrapPingIntervalId);this.bootstrapPingIntervalId=undefined}}async responsiveCheckLoop(){if(!loadTimeData.getBoolean("isClientResponsivenessCheckEnabled")){return}const timeoutMs=loadTimeData.getInteger("clientResponsivenessCheckTimeoutMs")*(loadTimeData.getBoolean("devMode")?1e3:1);const checkIntervalMs=loadTimeData.getInteger("clientResponsivenessCheckIntervalMs");while(this.webClientState.getCurrentValue()!==WebClientState.ERROR){if(!this.isClientActive()){if(this.webClientState.getCurrentValue()===WebClientState.UNRESPONSIVE){this.detailedWebClientState=DetailedWebClientState.UNRESPONSIVE_INACTIVE;this.setWebClientState(WebClientState.RESPONSIVE);this.webClientErrorTimer.reset()}else{this.detailedWebClientState=DetailedWebClientState.RESPONSIVE_INACTIVE}await this.clientActiveObs.waitUntil((active=>active))}let gotResponse=false;const responsePromise=this.sender.requestWithResponse("glicWebClientCheckResponsive",undefined).then((()=>{gotResponse=true}));const responseTimeout=sleep(timeoutMs);await Promise.race([responsePromise,responseTimeout]);if(this.webClientState.getCurrentValue()===WebClientState.ERROR){return}if(gotResponse){this.webClientErrorTimer.reset();this.setWebClientState(WebClientState.RESPONSIVE);this.detailedWebClientState=DetailedWebClientState.RESPONSIVE;await sleep(checkIntervalMs);continue}if(this.webClientState.getCurrentValue()===WebClientState.RESPONSIVE){const ignoreUnresponsiveClient=await this.shouldAllowUnresponsiveClient();if(!ignoreUnresponsiveClient){console.warn("GlicApiHost: web client is unresponsive");this.detailedWebClientState=DetailedWebClientState.TEMPORARY_UNRESPONSIVE;this.setWebClientState(WebClientState.UNRESPONSIVE);this.startWebClientErrorTimer()}}await responsePromise}}async shouldAllowUnresponsiveClient(){if(loadTimeData.getBoolean("clientResponsivenessCheckIgnoreWhenDebuggerAttached")){const isDebuggerAttached=await this.handler.isDebuggerAttached().then((result=>result.isAttachedToWebview)).catch((()=>false));if(isDebuggerAttached){if(!this.hasShownDebuggerAttachedWarning){console.warn("GlicApiHost: ignoring unresponsive client because "+"a debugger (likely DevTools) is attached");this.hasShownDebuggerAttachedWarning=true}return true}}return false}startWebClientErrorTimer(){this.webClientErrorTimer.start((()=>{console.warn("GlicApiHost: web client is permanently unresponsive");this.detailedWebClientState=DetailedWebClientState.PERMANENT_UNRESPONSIVE;this.setWebClientState(WebClientState.ERROR)}))}async openLinkInNewTab(url){await this.handler.createTab(urlFromClient(url),false,null)}async shouldAllowMediaPermissionRequest(){return(await this.handler.shouldAllowMediaPermissionRequest()).isAllowed}async shouldAllowGeolocationPermissionRequest(){return(await this.handler.shouldAllowGeolocationPermissionRequest()).isAllowed}async handleRawRequest(type,payload,extras){const handlerFunction=this.messageHandler[type];if(typeof handlerFunction!=="function"){console.warn(`GlicApiHost: Unknown message type ${type}`);return}if(this.detailedWebClientState===DetailedWebClientState.BOOTSTRAP_PENDING){this.detailedWebClientState=DetailedWebClientState.WEB_CLIENT_NOT_CREATED}this.stopBootstrapPing();let response;if(this.shouldGateRequests()&&Object.hasOwn(BACKGROUND_RESPONSES,type)){const backgroundResponse=BACKGROUND_RESPONSES[type];if(Object.hasOwn(backgroundResponse,"throws")){const friendlyName=type.replaceAll(/^glicBrowser|^glicWebClient/g,"");throw new Error(`${friendlyName} not allowed while backgrounded`)}if(Object.hasOwn(backgroundResponse,"does")){response=await backgroundResponse.does()}else{response=backgroundResponse.returns}}else{response=await handlerFunction.call(this.messageHandler,payload,extras)}if(!response){return}return{payload:response}}onRequestReceived(type){this.reportRequestCountEvent(type,GlicRequestEvent.REQUEST_RECEIVED);if(document.visibilityState==="hidden"){this.reportRequestCountEvent(type,GlicRequestEvent.REQUEST_RECEIVED_WHILE_HIDDEN)}}onRequestHandlerException(type){this.reportRequestCountEvent(type,GlicRequestEvent.REQUEST_HANDLER_EXCEPTION)}onRequestCompleted(type){this.reportRequestCountEvent(type,GlicRequestEvent.RESPONSE_SENT)}reportRequestCountEvent(requestType,event){const histogramSuffix=requestTypeToHistogramSuffix(requestType);if(histogramSuffix===undefined){return}const requestTypeNumber=HOST_REQUEST_TYPES[histogramSuffix];if(!requestTypeNumber){console.warn(`reportRequestCountEvent: invalid requestType ${histogramSuffix}`);return}chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.${histogramSuffix}`,event,GlicRequestEvent.MAX_VALUE+1);switch(event){case GlicRequestEvent.REQUEST_HANDLER_EXCEPTION:chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.Error`,requestTypeNumber,HOST_REQUEST_TYPES.MAX_VALUE+1);break;case GlicRequestEvent.REQUEST_RECEIVED_WHILE_HIDDEN:chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.Hidden`,requestTypeNumber,HOST_REQUEST_TYPES.MAX_VALUE+1);break;case GlicRequestEvent.REQUEST_RECEIVED:chrome.metricsPrivate.recordEnumerationValue(`Glic.Api.RequestCounts.Received`,requestTypeNumber,HOST_REQUEST_TYPES.MAX_VALUE+1);break;default:break}}}export class GatedSender{sender;sequenceNumber=0;messageQueue=[];keyedMessages=new Map;shouldGateRequests=true;constructor(sender){this.sender=sender}getRawSender(){return this.sender}destroy(){this.sender.destroy()}setGating(shouldGateRequests){if(this.shouldGateRequests===shouldGateRequests){return}this.shouldGateRequests=shouldGateRequests;if(this.shouldGateRequests){return}const messages=this.messageQueue;this.messageQueue=[];messages.push(...this.keyedMessages.values());this.keyedMessages.clear();messages.sort(((a,b)=>a.order-b.order));messages.forEach((message=>{this.sender.requestNoResponse(message.requestType,message.payload,message.transfer)}))}sendWhenActive(requestType,request,transfer=[]){if(!this.shouldGateRequests){this.sender.requestNoResponse(requestType,request,transfer)}else{this.messageQueue.push({order:this.sequenceNumber++,requestType:requestType,payload:request,transfer:transfer})}}sendIfActiveOrDrop(requestType,request,transfer=[]){if(!this.shouldGateRequests){this.sender.requestNoResponse(requestType,request,transfer)}}sendLatestWhenActive(requestType,request,transfer=[],additionalKey){if(!this.shouldGateRequests){this.sender.requestNoResponse(requestType,request,transfer)}else{let key=requestType;if(additionalKey){key+=","+additionalKey}this.keyedMessages.set(key,{order:this.sequenceNumber++,requestType:requestType,payload:request,transfer:transfer})}}requestNoResponse(requestType,request,transfer=[]){this.sender.requestNoResponse(requestType,request,transfer)}requestWithResponse(requestType,request,transfer=[]){return this.sender.requestWithResponse(requestType,request,transfer)}}var GlicRequestEvent;(function(GlicRequestEvent){GlicRequestEvent[GlicRequestEvent["REQUEST_RECEIVED"]=0]="REQUEST_RECEIVED";GlicRequestEvent[GlicRequestEvent["RESPONSE_SENT"]=1]="RESPONSE_SENT";GlicRequestEvent[GlicRequestEvent["REQUEST_HANDLER_EXCEPTION"]=2]="REQUEST_HANDLER_EXCEPTION";GlicRequestEvent[GlicRequestEvent["REQUEST_RECEIVED_WHILE_HIDDEN"]=3]="REQUEST_RECEIVED_WHILE_HIDDEN";GlicRequestEvent[GlicRequestEvent["MAX_VALUE"]=3]="MAX_VALUE"})(GlicRequestEvent||(GlicRequestEvent={}));function sleep(ms){return new Promise((resolve=>setTimeout(resolve,ms)))}function windowIdToClient(windowId){return`${windowId}`}function windowIdFromClient(windowId){return parseInt(windowId)}function tabIdToClient(tabId){if(tabId===null){return undefined}return`${tabId}`}function tabIdFromClient(tabId){const parsed=parseInt(tabId);if(Number.isNaN(parsed)){return 0}return parsed}function optionalWindowIdToClient(windowId){if(windowId===null){return undefined}return windowIdToClient(windowId)}function optionalWindowIdFromClient(windowId){if(windowId===undefined){return null}return windowIdFromClient(windowId)}function screenshotToClient(screenshot,extras){if(!screenshot){return undefined}const screenshotArray=new Uint8Array(screenshot.data);const buffer=screenshotArray.buffer;extras.addTransfer(buffer);return{widthPixels:screenshot.widthPixels,heightPixels:screenshot.heightPixels,data:buffer,mimeType:screenshot.mimeType,originAnnotations:{}}}function contextDataToClient(data,extras){const buffer=getArrayBufferFromBigBuffer(data.data);if(!buffer){return undefined}extras.addTransfer(buffer);return{mimeType:data.mimeType,data:buffer}}function webPageDataToClient(webPageData){if(!webPageData){return undefined}return{mainDocument:{origin:originToClient(webPageData.mainDocument.origin),innerText:webPageData.mainDocument.innerText,innerTextTruncated:webPageData.mainDocument.innerTextTruncated}}}function pdfDocumentDataToClient(pdfDocumentData,extras){if(!pdfDocumentData){return undefined}const pdfData=pdfDocumentData.pdfData?new Uint8Array(pdfDocumentData.pdfData).buffer:undefined;if(pdfData){extras.addTransfer(pdfData)}return{origin:originToClient(pdfDocumentData.origin),pdfSizeLimitExceeded:pdfDocumentData.sizeLimitExceeded,pdfData:pdfData}}function annotatedPageDataToClient(annotatedPageData,extras){if(!annotatedPageData){return undefined}const annotatedPageContent=annotatedPageData.annotatedPageContent?getArrayBufferFromBigBuffer(annotatedPageData.annotatedPageContent.smuggled):undefined;if(annotatedPageContent){extras.addTransfer(annotatedPageContent)}let metadata=undefined;if(annotatedPageData.metadata){metadata={frameMetadata:annotatedPageData.metadata.frameMetadata.map((m=>replaceProperties(m,{url:urlToClient(m.url)})))}}return{annotatedPageContent:annotatedPageContent,metadata:metadata}}function optionalToClient(value){if(value===null){return undefined}return value}function optionalFromClient(value){if(value===undefined){return null}return value}function urlToClient(url){if(url===null){return undefined}return url.url}function urlFromClient(url){return{url:url}}function originToClient(origin){if(!origin){return undefined}if(!origin.scheme){return""}const originBase=`${origin.scheme}://${origin.host}`;if(origin.port){return`${originBase}:${origin.port}`}return originBase}function tabDataToClient(tabData,extras){if(!tabData){return undefined}let favicon=undefined;if(tabData.favicon){favicon=bitmapN32ToRGBAImage(tabData.favicon);if(favicon){extras.addTransfer(favicon.dataRGBA)}}const isObservable=optionalToClient(tabData.isObservable);const isMediaActive=optionalToClient(tabData.isMediaActive);const isTabContentCaptured=optionalToClient(tabData.isTabContentCaptured);return{tabId:tabIdToClient(tabData.tabId),windowId:windowIdToClient(tabData.windowId),url:urlToClient(tabData.url),title:optionalToClient(tabData.title),favicon:favicon,faviconUrl:urlToClient(tabData.faviconUrl),documentMimeType:tabData.documentMimeType,isObservable:isObservable,isMediaActive:isMediaActive,isTabContentCaptured:isTabContentCaptured}}function focusedTabDataToClient(focusedTabData,extras){if(focusedTabData.focusedTab){return{hasFocus:{tabData:tabDataToClient(focusedTabData.focusedTab,extras)}}}if(focusedTabData.noFocusedTabData){return{hasNoFocus:{tabFocusCandidateData:tabDataToClient(focusedTabData.noFocusedTabData.activeTabData,extras),noFocusReason:focusedTabData.noFocusedTabData.noFocusReason}}}console.error("Invalid FocusedTabDataMojo");return{}}function getArrayBufferFromBigBuffer(bigBuffer){if(bigBuffer.bytes!==undefined){return new Uint8Array(bigBuffer.bytes).buffer}return bigBuffer.sharedMemory?.bufferHandle.mapBuffer(0,bigBuffer.sharedMemory.size).buffer}function bitmapN32ToRGBAImage(bitmap){const bytes=getArrayBufferFromBigBuffer(bitmap.pixelData);if(!bytes){return undefined}const colorType=ImageColorType.BGRA;return{width:bitmap.imageInfo.width,height:bitmap.imageInfo.height,dataRGBA:bytes,alphaType:bitmap.imageInfo.alphaType===AlphaType.PREMUL?ImageAlphaType.PREMUL:ImageAlphaType.UNPREMUL,colorType:colorType}}function panelOpeningDataToClient(panelOpeningData){return{panelState:panelStateToClient(panelOpeningData.panelState),invocationSource:panelOpeningData.invocationSource,conversationId:optionalToClient(panelOpeningData.conversationId)}}function panelStateToClient(panelState){return{kind:panelState.kind,windowId:optionalWindowIdToClient(panelState.windowId)}}function pageMetadataToClient(metadata){if(!metadata){return null}return{frameMetadata:metadata.frameMetadata.map((m=>replaceProperties(m,{url:urlToClient(m.url)})))}}function timeDeltaFromClient(durationMs=0){if(!Number.isFinite(durationMs)){throw new Error("Invalid duration value: "+durationMs)}return{microseconds:BigInt(Math.floor(durationMs*1e3))}}function tabContextToClient(tabContext,extras){const tabData=tabDataToClient(tabContext.tabData,extras);const webPageData=webPageDataToClient(tabContext.webPageData);const viewportScreenshot=screenshotToClient(tabContext.viewportScreenshot,extras);const pdfDocumentData=pdfDocumentDataToClient(tabContext.pdfDocumentData,extras);const annotatedPageData=annotatedPageDataToClient(tabContext.annotatedPageData,extras);return{tabData:tabData,webPageData:webPageData,viewportScreenshot:viewportScreenshot,pdfDocumentData:pdfDocumentData,annotatedPageData:annotatedPageData}}function tabContextOptionsFromClient(options){return{includeInnerText:options.innerText??false,innerTextBytesLimit:options.innerTextBytesLimit??DEFAULT_INNER_TEXT_BYTES_LIMIT,includeViewportScreenshot:options.viewportScreenshot??false,includePdf:options.pdfData??false,includeAnnotatedPageContent:options.annotatedPageContent??false,maxMetaTags:options.maxMetaTags??0,pdfSizeLimit:options.pdfSizeLimit===undefined?DEFAULT_PDF_SIZE_LIMIT:Math.min(Number.MAX_SAFE_INTEGER,options.pdfSizeLimit),annotatedPageContentMode:options.annotatedPageContentMode===undefined?0:options.annotatedPageContentMode}}function activeBrowserInfoToClient(info){if(!info){return undefined}return replaceProperties(info,{windowId:windowIdToClient(info.windowId)})}function getPinCandidatesOptionsFromClient(options){return{maxCandidates:options.maxCandidates,query:options.query??null}}function byteArrayFromClient(buffer){const byteArray=new Uint8Array(buffer);return Array.from(byteArray)}function hostCapabilitiesToClient(capabilities){return capabilities.map((capability=>capability))}function selectCredentialDialogResponseToMojo(response){return response.errorReason?{taskId:response.taskId,errorReason:response.errorReason,permissionDuration:null,selectedCredentialId:null}:{...response,errorReason:null,permissionDuration:optionalFromClient(response.permissionDuration),selectedCredentialId:response.selectedCredentialId??null}}function selectCredentialDialogRequestToClient(request){const icons=new Map;if(request.icons){for(const[siteOrApp,value]of Object.entries(request.icons)){const rgbaImage=bitmapN32ToRGBAImage(value);if(rgbaImage){icons.set(siteOrApp,rgbaImage)}}}return{...request,icons:icons}}function userConfirmationDialogRequestToClient(request){return{navigationOrigin:request.payload.navigationOrigin?originToClient(request.payload.navigationOrigin):undefined,downloadId:typeof request.payload.downloadId==="number"?request.payload.downloadId:undefined}}function userConfirmationDialogResponseToMojo(response){if(response.errorReason){return{result:{errorReason:response.errorReason}}}return{result:{permissionGranted:response.permissionGranted}}}function taskOptionsToMojo(taskOptions){if(taskOptions){return{title:taskOptions.title??null}}return null}