// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ResponseStopCause;(function(ResponseStopCause){ResponseStopCause[ResponseStopCause["USER"]=0]="USER";ResponseStopCause[ResponseStopCause["OTHER"]=1]="OTHER"})(ResponseStopCause||(ResponseStopCause={}));var PanelStateKind;(function(PanelStateKind){PanelStateKind[PanelStateKind["HIDDEN"]=0]="HIDDEN";PanelStateKind[PanelStateKind["FLOATING"]=1]="FLOATING";PanelStateKind[PanelStateKind["DETACHED"]=1]="DETACHED";PanelStateKind[PanelStateKind["DOCKED"]=2]="DOCKED";PanelStateKind[PanelStateKind["ATTACHED"]=2]="ATTACHED"})(PanelStateKind||(PanelStateKind={}));var WebClientInitializeErrorReason;(function(WebClientInitializeErrorReason){WebClientInitializeErrorReason[WebClientInitializeErrorReason["UNKNOWN"]=0]="UNKNOWN"})(WebClientInitializeErrorReason||(WebClientInitializeErrorReason={}));var ActInFocusedTabErrorReason;(function(ActInFocusedTabErrorReason){ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["UNKNOWN"]=0]="UNKNOWN";ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["GET_CONTEXT_FAILED"]=1]="GET_CONTEXT_FAILED";ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["INVALID_ACTION_PROTO"]=2]="INVALID_ACTION_PROTO";ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["TARGET_NOT_FOUND"]=3]="TARGET_NOT_FOUND";ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["FAILED_TO_START_TASK"]=4]="FAILED_TO_START_TASK"})(ActInFocusedTabErrorReason||(ActInFocusedTabErrorReason={}));var ClientView;(function(ClientView){ClientView["ACTUATION"]="actuation";ClientView["CONVERSATION"]="conversation"})(ClientView||(ClientView={}));var UserGrantedPermissionDuration;(function(UserGrantedPermissionDuration){UserGrantedPermissionDuration[UserGrantedPermissionDuration["ONE_TIME"]=0]="ONE_TIME";UserGrantedPermissionDuration[UserGrantedPermissionDuration["ALWAYS_ALLOW"]=1]="ALWAYS_ALLOW"})(UserGrantedPermissionDuration||(UserGrantedPermissionDuration={}));var MetricUserInputReactionType;(function(MetricUserInputReactionType){MetricUserInputReactionType[MetricUserInputReactionType["UNKNOWN"]=0]="UNKNOWN";MetricUserInputReactionType[MetricUserInputReactionType["CANNED"]=1]="CANNED";MetricUserInputReactionType[MetricUserInputReactionType["MODEL"]=2]="MODEL"})(MetricUserInputReactionType||(MetricUserInputReactionType={}));var PerformActionsErrorReason;(function(PerformActionsErrorReason){PerformActionsErrorReason[PerformActionsErrorReason["UNKNOWN"]=0]="UNKNOWN";PerformActionsErrorReason[PerformActionsErrorReason["INVALID_ACTION_PROTO"]=1]="INVALID_ACTION_PROTO"})(PerformActionsErrorReason||(PerformActionsErrorReason={}));var CreateTaskErrorReason;(function(CreateTaskErrorReason){CreateTaskErrorReason[CreateTaskErrorReason["UNKNOWN"]=0]="UNKNOWN";CreateTaskErrorReason[CreateTaskErrorReason["TASK_SYSTEM_UNAVAILABLE"]=1]="TASK_SYSTEM_UNAVAILABLE"})(CreateTaskErrorReason||(CreateTaskErrorReason={}));var ActorTaskState;(function(ActorTaskState){ActorTaskState[ActorTaskState["UNKNOWN"]=0]="UNKNOWN";ActorTaskState[ActorTaskState["IDLE"]=1]="IDLE";ActorTaskState[ActorTaskState["ACTING"]=2]="ACTING";ActorTaskState[ActorTaskState["PAUSED"]=3]="PAUSED";ActorTaskState[ActorTaskState["STOPPED"]=4]="STOPPED"})(ActorTaskState||(ActorTaskState={}));var ActorTaskPauseReason;(function(ActorTaskPauseReason){ActorTaskPauseReason[ActorTaskPauseReason["PAUSED_BY_MODEL"]=0]="PAUSED_BY_MODEL";ActorTaskPauseReason[ActorTaskPauseReason["PAUSED_BY_USER"]=1]="PAUSED_BY_USER"})(ActorTaskPauseReason||(ActorTaskPauseReason={}));var ActorTaskStopReason;(function(ActorTaskStopReason){ActorTaskStopReason[ActorTaskStopReason["TASK_COMPLETE"]=0]="TASK_COMPLETE";ActorTaskStopReason[ActorTaskStopReason["STOPPED_BY_USER"]=1]="STOPPED_BY_USER"})(ActorTaskStopReason||(ActorTaskStopReason={}));var CaptureScreenshotErrorReason;(function(CaptureScreenshotErrorReason){CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["UNKNOWN"]=0]="UNKNOWN";CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["SCREEN_CAPTURE_REQUEST_THROTTLED"]=1]="SCREEN_CAPTURE_REQUEST_THROTTLED";CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["USER_CANCELLED_SCREEN_PICKER_DIALOG"]=2]="USER_CANCELLED_SCREEN_PICKER_DIALOG"})(CaptureScreenshotErrorReason||(CaptureScreenshotErrorReason={}));var ScrollToErrorReason;(function(ScrollToErrorReason){ScrollToErrorReason[ScrollToErrorReason["NOT_SUPPORTED"]=0]="NOT_SUPPORTED";ScrollToErrorReason[ScrollToErrorReason["NEWER_SCROLL_TO_CALL"]=1]="NEWER_SCROLL_TO_CALL";ScrollToErrorReason[ScrollToErrorReason["NO_FOCUSED_TAB"]=2]="NO_FOCUSED_TAB";ScrollToErrorReason[ScrollToErrorReason["NO_MATCH_FOUND"]=3]="NO_MATCH_FOUND";ScrollToErrorReason[ScrollToErrorReason["FOCUSED_TAB_CHANGED_OR_NAVIGATED"]=4]="FOCUSED_TAB_CHANGED_OR_NAVIGATED";ScrollToErrorReason[ScrollToErrorReason["NO_MATCHING_DOCUMENT"]=5]="NO_MATCHING_DOCUMENT";ScrollToErrorReason[ScrollToErrorReason["SEARCH_RANGE_INVALID"]=6]="SEARCH_RANGE_INVALID";ScrollToErrorReason[ScrollToErrorReason["TAB_CONTEXT_PERMISSION_DISABLED"]=7]="TAB_CONTEXT_PERMISSION_DISABLED";ScrollToErrorReason[ScrollToErrorReason["DROPPED_BY_WEB_CLIENT"]=8]="DROPPED_BY_WEB_CLIENT"})(ScrollToErrorReason||(ScrollToErrorReason={}));var SwitchConversationErrorReason;(function(SwitchConversationErrorReason){SwitchConversationErrorReason[SwitchConversationErrorReason["UNKNOWN"]=0]="UNKNOWN"})(SwitchConversationErrorReason||(SwitchConversationErrorReason={}));var RegisterConversationErrorReason;(function(RegisterConversationErrorReason){RegisterConversationErrorReason[RegisterConversationErrorReason["UNKNOWN"]=0]="UNKNOWN";RegisterConversationErrorReason[RegisterConversationErrorReason["INSTANCE_ALREADY_HAS_CONVERSATION_ID"]=1]="INSTANCE_ALREADY_HAS_CONVERSATION_ID"})(RegisterConversationErrorReason||(RegisterConversationErrorReason={}));var InvocationSource;(function(InvocationSource){InvocationSource[InvocationSource["OS_BUTTON"]=0]="OS_BUTTON";InvocationSource[InvocationSource["OS_BUTTON_MENU"]=1]="OS_BUTTON_MENU";InvocationSource[InvocationSource["OS_HOTKEY"]=2]="OS_HOTKEY";InvocationSource[InvocationSource["TOP_CHROME_BUTTON"]=3]="TOP_CHROME_BUTTON";InvocationSource[InvocationSource["FRE"]=4]="FRE";InvocationSource[InvocationSource["PROFILE_PICKER"]=5]="PROFILE_PICKER";InvocationSource[InvocationSource["NUDGE"]=6]="NUDGE";InvocationSource[InvocationSource["THREE_DOTS_MENU"]=7]="THREE_DOTS_MENU";InvocationSource[InvocationSource["UNSUPPORTED"]=8]="UNSUPPORTED";InvocationSource[InvocationSource["WHATS_NEW"]=9]="WHATS_NEW";InvocationSource[InvocationSource["AFTER_SIGN_IN"]=10]="AFTER_SIGN_IN";InvocationSource[InvocationSource["SHARED_TAB"]=11]="SHARED_TAB";InvocationSource[InvocationSource["ACTOR_TASK_ICON"]=12]="ACTOR_TASK_ICON";InvocationSource[InvocationSource["SHARED_IMAGE"]=13]="SHARED_IMAGE"})(InvocationSource||(InvocationSource={}));var WebClientMode;(function(WebClientMode){WebClientMode[WebClientMode["TEXT"]=0]="TEXT";WebClientMode[WebClientMode["AUDIO"]=1]="AUDIO"})(WebClientMode||(WebClientMode={}));var WebClientModel;(function(WebClientModel){WebClientModel[WebClientModel["DEFAULT"]=0]="DEFAULT";WebClientModel[WebClientModel["ACTOR"]=1]="ACTOR"})(WebClientModel||(WebClientModel={}));var SettingsPageField;(function(SettingsPageField){SettingsPageField[SettingsPageField["OS_HOTKEY"]=1]="OS_HOTKEY";SettingsPageField[SettingsPageField["OS_ENTRYPOINT_TOGGLE"]=2]="OS_ENTRYPOINT_TOGGLE"})(SettingsPageField||(SettingsPageField={}));var HostCapability;(function(HostCapability){HostCapability[HostCapability["SCROLL_TO_PDF"]=0]="SCROLL_TO_PDF";HostCapability[HostCapability["RESET_SIZE_AND_LOCATION_ON_OPEN"]=1]="RESET_SIZE_AND_LOCATION_ON_OPEN";HostCapability[HostCapability["GET_MODEL_QUALITY_CLIENT_ID"]=2]="GET_MODEL_QUALITY_CLIENT_ID";HostCapability[HostCapability["MULTI_INSTANCE"]=3]="MULTI_INSTANCE"})(HostCapability||(HostCapability={}));class ObservableSubscription{observer;onUnsubscribe;constructor(observer,onUnsubscribe){this.observer=observer;this.onUnsubscribe=onUnsubscribe}unsubscribe(){this.onUnsubscribe(this)}}class ObservableBase{subscribers=new Set;state_="active";errorValue;next(value){switch(this.state_){case"active":break;case"complete":case"error":throw new Error("Observable is not active")}this.subscribers.forEach((sub=>{if(this.subscribers.has(sub)){try{sub.observer.next?.(value)}catch(e){console.warn(e)}}}))}error(e){switch(this.state_){case"active":this.state_="error";this.errorValue=e;break;case"complete":case"error":throw new Error("Observable is not active")}let loggedWarning=false;const hadSubscribers=this.hasActiveSubscription();this.subscribers.forEach((sub=>{if(this.subscribers.has(sub)){if(sub.observer.error){try{sub.observer.error(e)}catch(e){console.warn(e)}}else{if(!loggedWarning){console.warn("unhandled error: ",e);loggedWarning=true}}}}));this.subscribers.clear();if(hadSubscribers){this.activeSubscriptionChanged(false)}}complete(){switch(this.state_){case"active":this.state_="complete";break;case"complete":case"error":throw new Error("Observable is not active")}const hadSubscribers=this.hasActiveSubscription();this.subscribers.forEach((sub=>{if(this.subscribers.has(sub)){try{sub.observer.complete?.()}catch(e){console.warn(e)}}}));this.subscribers.clear();if(hadSubscribers){this.activeSubscriptionChanged(false)}}isStopped(){return this.state_!=="active"}subscribe(changeOrObserver){if(typeof changeOrObserver==="function"){return this.subscribeObserver({next:value=>{changeOrObserver(value)}})}else{return this.subscribeObserver(changeOrObserver)}}subscribeObserver(observer){switch(this.state_){case"active":break;case"complete":observer.complete?.();return{unsubscribe:()=>{}};case"error":observer.error?.(this.errorValue);return{unsubscribe:()=>{}}}const newSub=new ObservableSubscription(observer,this.onUnsubscribe.bind(this));if(this.subscribers.size===0){this.activeSubscriptionChanged(true)}this.subscribers.add(newSub);this.subscriberAdded(newSub);return newSub}onUnsubscribe(sub){if(!this.subscribers){return}if(this.subscribers.size===0){return}this.subscribers.delete(sub);if(this.subscribers.size===0){this.activeSubscriptionChanged(false)}}subscriberAdded(_sub){}activeSubscriptionChanged(_hasActiveSubscription){}hasActiveSubscription(){return this.subscribers.size>0}}class Subject extends ObservableBase{next(value){super.next(value)}}class ObservableValue extends Subject{isSet;value;hasActiveSubscriptionCallback;constructor(isSet,value,hasActiveSubscriptionCallback){super();this.isSet=isSet;this.value=value;this.hasActiveSubscriptionCallback=hasActiveSubscriptionCallback}static withValue(value,hasActiveSubscriptionCallback){return new ObservableValue(true,value,hasActiveSubscriptionCallback)}static withNoValue(hasActiveSubscriptionCallback){return new ObservableValue(false,undefined,hasActiveSubscriptionCallback)}assignAndSignal(v,force=false){if(this.isStopped()){throw new Error("ObservableValue is not active")}const send=!this.isSet||this.value!==v||force;this.isSet=true;this.value=v;if(!send){return}super.next(v)}getCurrentValue(){return this.value}async waitUntil(criteria){const{promise:promise,resolve:resolve,reject:reject}=Promise.withResolvers();const sub=this.subscribe({next(newValue){if(criteria(newValue)){resolve(newValue)}},error:reject,complete(){reject(new Error("Observable completed"))}});let resultValue;try{resultValue=await promise}finally{sub.unsubscribe()}return resultValue}subscriberAdded(sub){if(this.isSet){sub.observer.next?.(this.value)}}activeSubscriptionChanged(hasActiveSubscription){super.activeSubscriptionChanged(hasActiveSubscription);this.hasActiveSubscriptionCallback?.(hasActiveSubscription)}}function replaceProperties(original,replacements){return Object.assign(Object.assign({},original),replacements)}(()=>{const result={WebClientCreated:1,WebClientInitialized:2,CreateTab:3,OpenGlicSettingsPage:4,ClosePanel:5,ClosePanelAndShutdown:6,ShowProfilePicker:7,GetModelQualityClientId:8,GetContextFromFocusedTab:9,GetContextFromTab:10,GetContextForActorFromTab:11,SetMaximumNumberOfPinnedTabs:12,StopActorTask:13,PauseActorTask:14,ResumeActorTask:15,CaptureScreenshot:16,ResizeWindow:17,EnableDragResize:18,SetWindowDraggableAreas:19,SetMinimumWidgetSize:20,SetMicrophonePermissionState:21,SetLocationPermissionState:22,SetTabContextPermissionState:23,SetContextAccessIndicator:24,GetUserProfileInfo:25,RefreshSignInCookies:26,AttachPanel:27,DetachPanel:28,SetAudioDucking:29,LogBeginAsyncEvent:30,LogEndAsyncEvent:31,LogInstantEvent:32,JournalClear:33,JournalSnapshot:34,JournalStart:35,JournalStop:36,JournalRecordFeedback:37,OnUserInputSubmitted:38,OnResponseRated:39,OnResponseStarted:40,OnResponseStopped:41,OnSessionTerminated:42,OnTurnCompleted:43,OnModelChanged:44,ScrollTo:45,SetSyntheticExperimentState:46,OpenOsPermissionSettingsMenu:47,GetOsMicrophonePermissionStatus:48,PinTabs:49,UnpinTabs:50,UnpinAllTabs:51,SubscribeToPinCandidates:52,UnsubscribeFromPinCandidates:53,GetZeroStateSuggestionsForFocusedTab:54,GetZeroStateSuggestionsAndSubscribe:55,SetClosedCaptioningSetting:56,DropScrollToHighlight:57,MaybeRefreshUserStatus:58,OnClosedCaptionsShown:59,CreateTask:60,PerformActions:61,OnViewChanged:62,SubscribeToPageMetadata:63,SwitchConversation:64,RegisterConversation:65,OnReaction:66,OnContextUploadCompleted:67,OnContextUploadStarted:68};return{...result,MAX_VALUE:Math.max(...Object.values(result))}})();var ImageAlphaType;(function(ImageAlphaType){ImageAlphaType[ImageAlphaType["UNPREMUL"]=0]="UNPREMUL";ImageAlphaType[ImageAlphaType["PREMUL"]=1]="PREMUL"})(ImageAlphaType||(ImageAlphaType={}));var ImageColorType;(function(ImageColorType){ImageColorType[ImageColorType["BGRA"]=0]="BGRA"})(ImageColorType||(ImageColorType={}));var SelectCredentialDialogErrorReason;(function(SelectCredentialDialogErrorReason){SelectCredentialDialogErrorReason[SelectCredentialDialogErrorReason["DIALOG_PROMISE_NO_SUBSCRIBER"]=0]="DIALOG_PROMISE_NO_SUBSCRIBER"})(SelectCredentialDialogErrorReason||(SelectCredentialDialogErrorReason={}));var UserConfirmationDialogErrorReason;(function(UserConfirmationDialogErrorReason){UserConfirmationDialogErrorReason[UserConfirmationDialogErrorReason["DIALOG_PROMISE_NO_SUBSCRIBER"]=0]="DIALOG_PROMISE_NO_SUBSCRIBER";UserConfirmationDialogErrorReason[UserConfirmationDialogErrorReason["PREEMPTED_BY_NEW_REQUEST"]=1]="PREEMPTED_BY_NEW_REQUEST"})(UserConfirmationDialogErrorReason||(UserConfirmationDialogErrorReason={}));function exceptionFromTransferable(e){if(e.exceptionReason!==undefined){const withReason=e.exception;withReason.reason=e.exceptionReason.reason;withReason.reasonType=e.exceptionReason.reasonType}return e.exception}function newTransferableException(e){let exceptionReason=undefined;const maybeWithReason=e;if(maybeWithReason.reasonType!==undefined&&maybeWithReason.reason!==undefined){exceptionReason={reason:maybeWithReason.reason,reasonType:maybeWithReason.reasonType}}return{exception:e,exceptionReason:exceptionReason}}function newSenderId(){const array=new Uint8Array(8);crypto.getRandomValues(array);return Array.from(array).map((n=>n.toString(16))).join("")}class ResponseExtras{transfers=[];addTransfer(...transfers){this.transfers.push(...transfers)}}class MessageLogger{prefix;loggingEnabled=false;loggingPrefix;constructor(senderId,prefix){this.prefix=prefix;this.loggingPrefix=`${prefix}(${senderId.substring(0,6)})`}setLoggingEnabled(v){this.loggingEnabled=v}shouldLogMessage(requestType){return this.loggingEnabled&&requestType!=="glicWebClientCheckResponsive"}maybeLogMessage(requestType,message,payload){if(!this.shouldLogMessage(requestType)){return}console.info(`${this.loggingPrefix} [${requestType}] ${message}: ${toDebugJson(payload)}`,payload)}}class PostMessageRequestSender extends MessageLogger{messageSender;remoteOrigin;senderId;requestId=1;responseHandlers=new Map;onDestroy;constructor(messageSender,remoteOrigin,senderId,logPrefix){super(senderId,logPrefix);this.messageSender=messageSender;this.remoteOrigin=remoteOrigin;this.senderId=senderId;const handler=this.onMessage.bind(this);window.addEventListener("message",handler);this.onDestroy=()=>{window.removeEventListener("message",handler)}}destroy(){this.onDestroy()}onMessage(event){if(event.origin!==this.remoteOrigin||event.data.senderId!==this.senderId||event.data.type===undefined||event.data.responseId===undefined){return}const response=event.data;const handler=this.responseHandlers.get(response.responseId);if(!handler){return}this.responseHandlers.delete(response.responseId);handler(response)}requestWithResponse(requestType,request,transfer=[]){const{promise:promise,resolve:resolve,reject:reject}=Promise.withResolvers();const requestId=this.requestId++;this.responseHandlers.set(requestId,(response=>{if(response.exception!==undefined){this.maybeLogMessage(requestType,"received with exception",response.exception);reject(exceptionFromTransferable(response.exception))}else{this.maybeLogMessage(requestType,"received",response.responsePayload);resolve(response.responsePayload)}}));this.maybeLogMessage(requestType,"sending",request);const message={senderId:this.senderId,glicRequest:true,requestId:requestId,type:requestType,requestPayload:request};this.messageSender.postMessage(message,this.remoteOrigin,transfer);return promise}requestNoResponse(requestType,request,transfer=[]){const message={senderId:this.senderId,glicRequest:true,requestId:undefined,type:requestType,requestPayload:request};this.maybeLogMessage(requestType,"sending",request);this.messageSender.postMessage(message,this.remoteOrigin,transfer)}}class PostMessageRequestReceiver extends MessageLogger{embeddedOrigin;postMessageSender;handler;onDestroy;constructor(embeddedOrigin,senderId,postMessageSender,handler,logPrefix){super(senderId,logPrefix);this.embeddedOrigin=embeddedOrigin;this.postMessageSender=postMessageSender;this.handler=handler;const handlerFunction=this.onMessage.bind(this);window.addEventListener("message",handlerFunction);this.onDestroy=()=>{window.removeEventListener("message",handlerFunction)}}destroy(){this.onDestroy()}async onMessage(event){if(event.origin!==this.embeddedOrigin||!event.source||!event.data.glicRequest){return}const requestMessage=event.data;const{requestId:requestId,type:type,requestPayload:requestPayload,senderId:senderId}=requestMessage;let response;let exception;const extras=new ResponseExtras;this.handler.onRequestReceived(type);this.maybeLogMessage(type,"processing request",requestPayload);try{response=await this.handler.handleRawRequest(type,requestPayload,extras)}catch(error){this.handler.onRequestHandlerException(type);console.warn("Unexpected error",error);if(error instanceof Error){exception=newTransferableException(error)}else{exception=newTransferableException(new Error(`Unexpected error: ${error}`))}}if(!exception){this.handler.onRequestCompleted(type)}if(!requestId){return}this.maybeLogMessage(type,"sending response",response?.payload);const responseMessage={type:type,responseId:requestId,responsePayload:response?.payload,senderId:senderId};if(exception){responseMessage.exception=exception}this.postMessageSender.postMessage(responseMessage,this.embeddedOrigin,extras.transfers)}}function toDebugJson(v){return JSON.stringify(v,((_key,value)=>{if(typeof value==="bigint"){return value.toString()}return value}))}class GlicHostRegistryImpl{windowProxy;host;constructor(windowProxy){this.windowProxy=windowProxy}async registerWebClient(webClient){this.host=new GlicBrowserHostImpl(webClient,this.windowProxy);await this.host.webClientCreated();let success=false;let exception;try{await webClient.initialize(this.host);success=true}catch(e){console.warn(e);if(e instanceof Error){exception=newTransferableException(e)}}if(this.host){this.host.webClientInitialized(success,exception)}}}class WebClientMessageHandler{webClient;host;cachedPinnedTabs=undefined;constructor(webClient,host){this.webClient=webClient;this.host=host}async glicWebClientNotifyPanelWillOpen(payload){let openPanelInfo;try{const mergedArgument=Object.assign({},payload.panelOpeningData,payload.panelOpeningData.panelState);const result=await(this.webClient.notifyPanelWillOpen?.(mergedArgument));if(result){openPanelInfo=result}}catch(e){console.warn(e)}return{openPanelInfo:openPanelInfo}}async glicWebClientNotifyPanelWasClosed(){try{await(this.webClient.notifyPanelWasClosed?.())}catch(e){console.warn(e)}}glicWebClientPanelStateChanged(payload){this.host.getPanelState?.().assignAndSignal(payload.panelState)}glicWebClientRequestViewChange(payload){this.host.viewChangeRequestsSubject.next(payload.request)}glicWebClientZeroStateSuggestionsChanged(payload){this.host.currentZeroStateObserver?.assignAndSignal(payload.suggestions)}glicWebClientCanAttachStateChanged(payload){this.host.canAttachPanelValue.assignAndSignal(payload.canAttach)}glicWebClientNotifyMicrophonePermissionStateChanged(payload){this.host.getMicrophonePermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyLocationPermissionStateChanged(payload){this.host.getLocationPermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyTabContextPermissionStateChanged(payload){this.host.getTabContextPermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyDefaultTabContextPermissionStateChanged(payload){this.host.defaultTabContextPermission.assignAndSignal(payload.enabled)}glicWebClientNotifyOsLocationPermissionStateChanged(payload){this.host.getOsLocationPermissionState().assignAndSignal(payload.enabled)}glicWebClientNotifyClosedCaptioningSettingChanged(payload){this.host.closedCaptioningState.assignAndSignal(payload.enabled)}glicWebClientNotifyFocusedTabChanged(payload){const focusedTabData=convertFocusedTabDataFromPrivate(payload.focusedTabDataPrivate);this.host.getFocusedTabStateV2().assignAndSignal(focusedTabData)}glicWebClientNotifyPanelActiveChanged(payload){this.host.panelActiveValue.assignAndSignal(payload.panelActive)}async glicWebClientCheckResponsive(){return this.webClient.checkResponsive?.()}glicWebClientNotifyManualResizeChanged(payload){this.host.isManuallyResizing().assignAndSignal(payload.resizing)}glicWebClientBrowserIsOpenChanged(payload){this.host.isBrowserOpenValue.assignAndSignal(payload.browserIsOpen)}glicWebClientNotifyOsHotkeyStateChanged(payload){this.host.getOsHotkeyState().assignAndSignal(payload)}glicWebClientPinCandidatesChanged(payload){this.host.pinCandidates?.processUpdate(payload.candidates,payload.observationId)}glicWebClientNotifyPinnedTabsChanged(payload){this.cachedPinnedTabs=payload.tabData.map((x=>convertTabDataFromPrivate(x)));this.host.pinnedTabs?.assignAndSignal(this.cachedPinnedTabs)}glicWebClientNotifyPinnedTabDataChanged(payload){if(!this.cachedPinnedTabs){return}const tabData=convertTabDataFromPrivate(payload.tabData);this.cachedPinnedTabs=this.cachedPinnedTabs.map((cachedTab=>{if(cachedTab.tabId===tabData.tabId){return tabData}return cachedTab}));this.host.pinnedTabs.assignAndSignal(this.cachedPinnedTabs)}glicWebClientNotifyActorTaskStateChanged(payload){this.host.setActorTaskState(payload.taskId,payload.state)}glicWebClientPageMetadataChanged(payload){const observable=this.host.pageMetadataObservers.get(payload.tabId);if(!observable){return}if(payload.pageMetadata){observable.assignAndSignal(payload.pageMetadata)}else{if(!observable.isStopped()){observable.complete()}this.host.pageMetadataObservers.delete(payload.tabId)}}glicWebClientNotifyActiveBrowserChanged(payload){this.host.activeBrowserInfo.assignAndSignal(payload.activeBrowserInfo)}async glicWebClientRequestToShowDialog(payload){const request=payload.request;return new Promise((resolve=>{if(!this.host.selectCredentialDialogRequestSubject.hasActiveSubscription()){window.console.warn("GlicWebClient: no subscriber for selectCredentialDialogRequest()!");resolve({response:{taskId:request.taskId,errorReason:SelectCredentialDialogErrorReason.DIALOG_PROMISE_NO_SUBSCRIBER}});return}const iconsGetter=new Map;for(const[id,image]of payload.request.icons.entries()){let promise;iconsGetter.set(id,(()=>{if(!promise){promise=rgbaImageToBlob(image)}return promise}))}const credentials=request.credentials.map((credential=>{const getIcon=iconsGetter.get(credential.sourceSiteOrApp);if(getIcon){return{...credential,getIcon:getIcon}}return credential}));const requestWithCallback={...request,credentials:credentials,onDialogClosed:resolve};this.host.selectCredentialDialogRequestSubject.next(requestWithCallback)}))}glicWebClientRequestToShowConfirmationDialog(payload){return new Promise((resolve=>{if(!this.host.userConfirmationDialogRequestSubject.hasActiveSubscription()){window.console.warn("GlicWebClient: no subscriber for "+"userConfirmationDialogRequest()!");resolve({response:{permissionGranted:false,errorReason:UserConfirmationDialogErrorReason.DIALOG_PROMISE_NO_SUBSCRIBER}});return}const requestWithCallback={...payload.request,onDialogClosed:resolve};this.host.userConfirmationDialogRequestSubject.next(requestWithCallback)}))}glicWebClientNotifyAdditionalContext(payload){const context=payload.context;const parts=context.parts.map((p=>{const annotatedPageData=p.annotatedPageData&&convertAnnotatedPageDataFromPrivate(p.annotatedPageData);const pdf=p.pdf&&convertPdfDocumentDataFromPrivate(p.pdf);const data=p.data&&new Blob([p.data.data],{type:p.data.mimeType});return{...p,data:data,annotatedPageData:annotatedPageData,pdf:pdf}}));this.host.additionalContextSubject.next({name:context.name,tabId:context.tabId,origin:context.origin,frameUrl:context.frameUrl,parts:parts})}}class GlicBrowserHostImpl{webClient;hostId=newSenderId();sender;receiver;handlerFunctionNames=new Set;webClientMessageHandler;chromeVersion;panelState=ObservableValue.withNoValue();canAttachPanelValue=ObservableValue.withNoValue();focusedTabStateV2=ObservableValue.withNoValue();activeBrowserInfo=ObservableValue.withNoValue();permissionStateMicrophone=ObservableValue.withNoValue();permissionStateLocation=ObservableValue.withNoValue();permissionStateTabContext=ObservableValue.withNoValue();defaultTabContextPermission=ObservableValue.withNoValue();permissionStateOsLocation=ObservableValue.withNoValue();closedCaptioningState=ObservableValue.withNoValue();osHotkeyState=ObservableValue.withNoValue();panelActiveValue=ObservableValue.withNoValue();isBrowserOpenValue=ObservableValue.withNoValue();journalHost;metrics;manuallyResizing=ObservableValue.withValue(false);pinnedTabs=ObservableValue.withNoValue();pinCandidates;idGenerator=new IdGenerator;currentZeroStateSuggestionOptions={isFirstRun:false,supportedTools:[]};currentZeroStateObserver=ObservableValue.withNoValue();hostCapabilities=new Set;actorTaskState=new Map;viewChangeRequestsSubject=new Subject;additionalContextSubject=new Subject;pageMetadataObservers=new Map;selectCredentialDialogRequestSubject=new Subject;userConfirmationDialogRequestSubject=new Subject;constructor(webClient,windowProxy){this.webClient=webClient;this.sender=new PostMessageRequestSender(windowProxy,"chrome://glic",this.hostId,"glic_api_client");this.receiver=new PostMessageRequestReceiver("chrome://glic",this.hostId,windowProxy,this,"glic_api_client");this.webClientMessageHandler=new WebClientMessageHandler(this.webClient,this);this.journalHost=new GlicBrowserHostJournalImpl(this.sender);this.metrics=new GlicBrowserHostMetricsImpl(this.sender);for(const name of Object.getOwnPropertyNames(WebClientMessageHandler.prototype)){if(name!=="constructor"){this.handlerFunctionNames.add(name)}}}destroy(){this.receiver.destroy()}async webClientCreated(){const response=await this.sender.requestWithResponse("glicBrowserWebClientCreated",undefined);const state=response.initialState;this.receiver.setLoggingEnabled(state.loggingEnabled);this.sender.setLoggingEnabled(state.loggingEnabled);this.panelState.assignAndSignal(state.panelState);const focusedTabData=convertFocusedTabDataFromPrivate(state.focusedTabData);this.focusedTabStateV2.assignAndSignal(focusedTabData);this.permissionStateMicrophone.assignAndSignal(state.microphonePermissionEnabled);this.permissionStateLocation.assignAndSignal(state.locationPermissionEnabled);this.permissionStateTabContext.assignAndSignal(state.tabContextPermissionEnabled);this.defaultTabContextPermission.assignAndSignal(state.defaultTabContextSettingEnabled);this.permissionStateOsLocation.assignAndSignal(state.osLocationPermissionEnabled);this.canAttachPanelValue.assignAndSignal(state.canAttach);this.chromeVersion=state.chromeVersion;this.panelActiveValue.assignAndSignal(state.panelIsActive);this.isBrowserOpenValue.assignAndSignal(state.browserIsOpen);this.osHotkeyState.assignAndSignal({hotkey:state.hotkey});this.closedCaptioningState.assignAndSignal(state.closedCaptioningSettingEnabled);this.activeBrowserInfo.assignAndSignal(state.activeBrowserInfo);for(const capability of state.hostCapabilities){this.hostCapabilities.add(capability)}if(!this.hostCapabilities.has(HostCapability.GET_MODEL_QUALITY_CLIENT_ID)){this.getModelQualityClientId=undefined}if(!state.enableScrollTo){this.scrollTo=undefined;this.dropScrollToHighlight=undefined}if(!state.enableActInFocusedTab){this.createTask=undefined;this.performActions=undefined;this.stopActorTask=undefined;this.pauseActorTask=undefined;this.resumeActorTask=undefined}if(state.alwaysDetachedMode){this.attachPanel=undefined;this.detachPanel=undefined;this.canAttachPanel=undefined;this.getPanelState=undefined}if(!state.enableZeroStateSuggestions){this.getZeroStateSuggestionsForFocusedTab=undefined;this.getZeroStateSuggestions=undefined}if(!state.enableDefaultTabContextSettingFeature){this.getDefaultTabContextPermissionState=undefined}if(!state.enableClosedCaptioningFeature){this.getClosedCaptioningSetting=undefined;this.setClosedCaptioningSetting=undefined;this.metrics.onClosedCaptionsShown=undefined}if(!state.enableMaybeRefreshUserStatus){this.maybeRefreshUserStatus=undefined}if(!state.enableMultiTab){this.getContextFromTab=undefined;this.getPinnedTabs=undefined;this.getPinCandidates=undefined;this.pinTabs=undefined;this.setMaximumNumberOfPinnedTabs=undefined;this.unpinTabs=undefined;this.unpinAllTabs=undefined}if(!state.enableGetContextActor){this.getContextForActorFromTab=undefined}if(!state.enableGetPageMetadata){this.getPageMetadata=undefined}}webClientInitialized(success,exception){this.sender.requestNoResponse("glicBrowserWebClientInitialized",{success:success,exception:exception})}async handleRawRequest(type,payload,extras){if(!this.handlerFunctionNames.has(type)){return}const handlerFunction=this.webClientMessageHandler[type];const response=await handlerFunction.call(this.webClientMessageHandler,payload,extras);if(!response){return}return{payload:response}}setActorTaskState(taskId,state){this.getActorTaskState(taskId).assignAndSignal(state);if(state===ActorTaskState.STOPPED){this.actorTaskState.delete(taskId)}}onRequestReceived(_type){}onRequestHandlerException(_type){}onRequestCompleted(_type){}getChromeVersion(){return Promise.resolve(this.chromeVersion)}async createTab(url,options){const result=await this.sender.requestWithResponse("glicBrowserCreateTab",{url:url,options:options});if(!result.tabData){throw new Error("createTab: failed")}return convertTabDataFromPrivate(result.tabData)}openGlicSettingsPage(options){this.sender.requestNoResponse("glicBrowserOpenGlicSettingsPage",{options:options})}closePanel(){return this.sender.requestWithResponse("glicBrowserClosePanel",undefined)}closePanelAndShutdown(){this.sender.requestNoResponse("glicBrowserClosePanelAndShutdown",undefined)}attachPanel(){this.sender.requestNoResponse("glicBrowserAttachPanel",undefined)}detachPanel(){this.sender.requestNoResponse("glicBrowserDetachPanel",undefined)}showProfilePicker(){this.sender.requestNoResponse("glicBrowserShowProfilePicker",undefined)}async getModelQualityClientId(){const result=await this.sender.requestWithResponse("glicBrowserGetModelQualityClientId",undefined);return result.modelQualityClientId}async switchConversation(info){if(info&&!info.conversationId){throw new Error("conversationId cannot be empty.")}await this.sender.requestWithResponse("glicBrowserSwitchConversation",{info:info})}async registerConversation(info){await this.sender.requestWithResponse("glicBrowserRegisterConversation",{info:info})}async getContextFromFocusedTab(options){const context=await this.sender.requestWithResponse("glicBrowserGetContextFromFocusedTab",{options:options});return convertTabContextResultFromPrivate(context.tabContextResult)}async setMaximumNumberOfPinnedTabs(requestedMax){const result=await this.sender.requestWithResponse("glicBrowserSetMaximumNumberOfPinnedTabs",{requestedMax:requestedMax});return result.effectiveMax}async getContextFromTab(tabId,options){const result=await this.sender.requestWithResponse("glicBrowserGetContextFromTab",{tabId:tabId,options:options});return convertTabContextResultFromPrivate(result.tabContextResult)}async getContextForActorFromTab(tabId,options){const result=await this.sender.requestWithResponse("glicBrowserGetContextForActorFromTab",{tabId:tabId,options:options});return convertTabContextResultFromPrivate(result.tabContextResult)}async createTask(taskOptions){const result=await this.sender.requestWithResponse("glicBrowserCreateTask",{taskOptions:taskOptions});return result.taskId}async performActions(actions){const result=await this.sender.requestWithResponse("glicBrowserPerformActions",{actions:actions});return result.actionsResult}stopActorTask(taskId,stopReason){this.sender.requestNoResponse("glicBrowserStopActorTask",{taskId:taskId??0,stopReason:stopReason??ActorTaskStopReason.TASK_COMPLETE})}pauseActorTask(taskId,pauseReason){this.sender.requestNoResponse("glicBrowserPauseActorTask",{taskId:taskId,pauseReason:pauseReason??ActorTaskPauseReason.PAUSED_BY_MODEL})}async resumeActorTask(taskId,tabContextOptions){const response=await this.sender.requestWithResponse("glicBrowserResumeActorTask",{taskId:taskId,tabContextOptions:tabContextOptions});return convertTabContextResultFromPrivate(response.tabContextResult)}getActorTaskState(taskId){const stateObs=this.actorTaskState.get(taskId);if(stateObs){return stateObs}const newObs=ObservableValue.withNoValue();this.actorTaskState.set(taskId,newObs);return newObs}async resizeWindow(width,height,options){return this.sender.requestWithResponse("glicBrowserResizeWindow",{size:{width:width,height:height},options:options})}enableDragResize(enabled){return this.sender.requestWithResponse("glicBrowserEnableDragResize",{enabled:enabled})}async captureScreenshot(){const screenshotResult=await this.sender.requestWithResponse("glicBrowserCaptureScreenshot",undefined);return screenshotResult.screenshot}setWindowDraggableAreas(areas){return this.sender.requestWithResponse("glicBrowserSetWindowDraggableAreas",{areas:areas})}setMinimumWidgetSize(width,height){return this.sender.requestWithResponse("glicBrowserSetMinimumWidgetSize",{size:{width:width,height:height}})}getPanelState(){return this.panelState}panelActive(){return this.panelActiveValue}canAttachPanel(){return this.canAttachPanelValue}isBrowserOpen(){return this.isBrowserOpenValue}activeBrowser(){return this.activeBrowserInfo}getFocusedTabStateV2(){return this.focusedTabStateV2}getMicrophonePermissionState(){return this.permissionStateMicrophone}getLocationPermissionState(){return this.permissionStateLocation}getTabContextPermissionState(){return this.permissionStateTabContext}getDefaultTabContextPermissionState(){return this.defaultTabContextPermission}getOsLocationPermissionState(){return this.permissionStateOsLocation}getClosedCaptioningSetting(){return this.closedCaptioningState}setMicrophonePermissionState(enabled){return this.sender.requestWithResponse("glicBrowserSetMicrophonePermissionState",{enabled:enabled})}setLocationPermissionState(enabled){return this.sender.requestWithResponse("glicBrowserSetLocationPermissionState",{enabled:enabled})}setTabContextPermissionState(enabled){return this.sender.requestWithResponse("glicBrowserSetTabContextPermissionState",{enabled:enabled})}setClosedCaptioningSetting(enabled){return this.sender.requestWithResponse("glicBrowserSetClosedCaptioningSetting",{enabled:enabled})}setContextAccessIndicator(show){this.sender.requestWithResponse("glicBrowserSetContextAccessIndicator",{show:show})}async getUserProfileInfo(){const{profileInfo:profileInfo}=await this.sender.requestWithResponse("glicBrowserGetUserProfileInfo",undefined);if(!profileInfo){throw new Error("getUserProfileInfo failed")}const{avatarIcon:avatarIcon}=profileInfo;return replaceProperties(profileInfo,{avatarIcon:async()=>avatarIcon&&rgbaImageToBlob(avatarIcon)})}async refreshSignInCookies(){const result=await this.sender.requestWithResponse("glicBrowserRefreshSignInCookies",undefined);if(!result.success){throw Error("refreshSignInCookies failed")}}setAudioDucking(enabled){this.sender.requestNoResponse("glicBrowserSetAudioDucking",{enabled:enabled})}getJournalHost(){return this.journalHost}getMetrics(){return this.metrics}scrollTo(params){return this.sender.requestWithResponse("glicBrowserScrollTo",{params:params})}setSyntheticExperimentState(trialName,groupName){this.sender.requestNoResponse("glicBrowserSetSyntheticExperimentState",{trialName:trialName,groupName:groupName})}openOsPermissionSettingsMenu(permission){this.sender.requestNoResponse("glicBrowserOpenOsPermissionSettingsMenu",{permission:permission})}async getOsMicrophonePermissionStatus(){return(await this.sender.requestWithResponse("glicBrowserGetOsMicrophonePermissionStatus",undefined)).enabled}isManuallyResizing(){return this.manuallyResizing}getOsHotkeyState(){return this.osHotkeyState}getPinnedTabs(){return this.pinnedTabs}async pinTabs(tabIds){return(await this.sender.requestWithResponse("glicBrowserPinTabs",{tabIds:tabIds})).pinnedAll}async unpinTabs(tabIds){return(await this.sender.requestWithResponse("glicBrowserUnpinTabs",{tabIds:tabIds})).unpinnedAll}unpinAllTabs(){this.sender.requestNoResponse("glicBrowserUnpinAllTabs",undefined)}getPinCandidates(options){this.pinCandidates?.setObsolete();return this.pinCandidates=new PinCandidatesObservable(this.idGenerator.next(),this.sender,options)}async getZeroStateSuggestionsForFocusedTab(isFirstRun){const zeroStateResult=await this.sender.requestWithResponse("glicBrowserGetZeroStateSuggestionsForFocusedTab",{isFirstRun:isFirstRun});if(!zeroStateResult.suggestions){return{suggestions:[],tabId:"",url:""}}return zeroStateResult.suggestions}async zeroStateActiveSubscriptionStateChanged(options,hasActiveSubscription){if(options!==this.currentZeroStateSuggestionOptions){return}const zeroStateResult=await this.sender.requestWithResponse("glicBrowserGetZeroStateSuggestionsAndSubscribe",{hasActiveSubscription:hasActiveSubscription,options:options});if(zeroStateResult.suggestions){this.currentZeroStateObserver?.assignAndSignal(zeroStateResult.suggestions)}}getZeroStateSuggestions(options){options=options??{isFirstRun:false,supportedTools:[]};this.currentZeroStateSuggestionOptions=options;this.currentZeroStateObserver=ObservableValue.withNoValue(this.zeroStateActiveSubscriptionStateChanged.bind(this,options));return this.currentZeroStateObserver}dropScrollToHighlight(){this.sender.requestNoResponse("glicBrowserDropScrollToHighlight",undefined)}maybeRefreshUserStatus(){this.sender.requestNoResponse("glicBrowserMaybeRefreshUserStatus",undefined)}getAdditionalContext(){return this.additionalContextSubject}getHostCapabilities(){return this.hostCapabilities}getViewChangeRequests(){return this.viewChangeRequestsSubject}onViewChanged(notification){this.sender.requestNoResponse("glicBrowserOnViewChanged",{notification:notification})}getPageMetadata(tabId,names){if(this.pageMetadataObservers.has(tabId)){return this.pageMetadataObservers.get(tabId)}if(names.length===0){throw Error("names must not be empty")}const observableValue=ObservableValue.withNoValue((async isActive=>{const{success:success}=await this.sender.requestWithResponse("glicBrowserSubscribeToPageMetadata",{tabId:tabId,names:isActive?names:[]});if(!success){if(!observableValue.isStopped()){observableValue.complete()}this.pageMetadataObservers.delete(tabId)}}));this.pageMetadataObservers.set(tabId,observableValue);return observableValue}selectCredentialDialogRequestHandler(){return this.selectCredentialDialogRequestSubject}selectUserConfirmationDialogRequestHandler(){return this.userConfirmationDialogRequestSubject}}class GlicBrowserHostJournalImpl{sender;constructor(sender){this.sender=sender}beginAsyncEvent(asyncEventId,taskId,event,details){this.sender.requestNoResponse("glicBrowserLogBeginAsyncEvent",{asyncEventId:asyncEventId,taskId:taskId,event:event,details:details})}clear(){this.sender.requestNoResponse("glicBrowserJournalClear",undefined)}endAsyncEvent(asyncEventId,details){this.sender.requestNoResponse("glicBrowserLogEndAsyncEvent",{asyncEventId:asyncEventId,details:details})}instantEvent(taskId,event,details){this.sender.requestNoResponse("glicBrowserLogInstantEvent",{taskId:taskId,event:event,details:details})}async snapshot(clear){const snapshotResult=await this.sender.requestWithResponse("glicBrowserJournalSnapshot",{clear:clear});return snapshotResult.journal}start(maxBytes,captureScreenshots){this.sender.requestNoResponse("glicBrowserJournalStart",{maxBytes:maxBytes,captureScreenshots:captureScreenshots})}stop(){this.sender.requestNoResponse("glicBrowserJournalStop",undefined)}recordFeedback(positive,reason){this.sender.requestNoResponse("glicBrowserJournalRecordFeedback",{positive:positive,reason:reason})}}class GlicBrowserHostMetricsImpl{sender;constructor(sender){this.sender=sender}onUserInputSubmitted(mode){this.sender.requestNoResponse("glicBrowserOnUserInputSubmitted",{mode:mode})}onReaction(reactionType){this.sender.requestNoResponse("glicBrowserOnReaction",{reactionType:reactionType})}onContextUploadStarted(){this.sender.requestNoResponse("glicBrowserOnContextUploadStarted",undefined)}onContextUploadCompleted(){this.sender.requestNoResponse("glicBrowserOnContextUploadCompleted",undefined)}onResponseStarted(){this.sender.requestNoResponse("glicBrowserOnResponseStarted",undefined)}onResponseStopped(details){this.sender.requestNoResponse("glicBrowserOnResponseStopped",{details:details})}onSessionTerminated(){this.sender.requestNoResponse("glicBrowserOnSessionTerminated",undefined)}onResponseRated(positive){this.sender.requestNoResponse("glicBrowserOnResponseRated",{positive:positive})}onClosedCaptionsShown(){this.sender.requestNoResponse("glicBrowserOnClosedCaptionsShown",undefined)}onTurnCompleted(model,duration){this.sender.requestNoResponse("glicBrowserOnTurnCompleted",{model:model,duration:duration})}onModelChanged(model){this.sender.requestNoResponse("glicBrowserOnModelChanged",{model:model})}}class IdGenerator{nextId=1;next(){return this.nextId++}}class PinCandidatesObservable extends ObservableValue{observationId;sender;options;isObsolete=false;constructor(observationId,sender,options){super(false);this.observationId=observationId;this.sender=sender;this.options=options}activeSubscriptionChanged(hasActiveSubscription){super.activeSubscriptionChanged(hasActiveSubscription);if(this.isObsolete){console.warn(`getPinCandidates() observable is in use while obsolete.`);return}if(hasActiveSubscription){this.sender.requestNoResponse("glicBrowserSubscribeToPinCandidates",{options:this.options,observationId:this.observationId})}else{this.sender.requestNoResponse("glicBrowserUnsubscribeFromPinCandidates",{observationId:this.observationId})}}processUpdate(candidates,observationId){if(this.observationId!==observationId){return}this.assignAndSignal(candidates.map((c=>({tabData:convertTabDataFromPrivate(c.tabData)}))))}setObsolete(){if(this.hasActiveSubscription()){console.warn(`getPinCandidates() observable was made obsolete with subscribers.`)}this.isObsolete=true}}async function rgbaImageToBlob(image){const canvas=document.createElement("canvas");canvas.width=image.width;canvas.height=image.height;const ctx=canvas.getContext("2d");if(!ctx){throw Error("getContext error")}if(image.colorType!==ImageColorType.BGRA){throw Error("unsupported colorType")}const pixelData=new Uint8ClampedArray(image.dataRGBA);if(image.alphaType===ImageAlphaType.PREMUL){for(let i=0;i+3<pixelData.length;i+=4){const alphaInt=pixelData[i+3];if(alphaInt===0){continue}const alpha=alphaInt/255;const[B,G,R]=[pixelData[i],pixelData[i+1],pixelData[i+2]];pixelData[i]=R/alpha;pixelData[i+1]=G/alpha;pixelData[i+2]=B/alpha}}else{for(let i=0;i+3<pixelData.length;i+=4){const[B,R]=[pixelData[i],pixelData[i+2]];pixelData[i]=R;pixelData[i+2]=B}}ctx.putImageData(new ImageData(pixelData,image.width,image.height),0,0);return new Promise((resolve=>{canvas.toBlob((result=>{if(!result){throw Error("toBlob failed")}resolve(result)}))}))}function convertTabDataFromPrivate(data){if(!data){return undefined}let faviconResult;const dataFavicon=data.favicon;async function getFavicon(){if(dataFavicon&&!faviconResult){faviconResult=rgbaImageToBlob(dataFavicon);return faviconResult}return faviconResult}const favicon=dataFavicon&&getFavicon;return replaceProperties(data,{favicon:favicon})}function convertFocusedTabDataFromPrivate(data){const result={};if(data.hasFocus){result.hasFocus=replaceProperties(data.hasFocus,{tabData:convertTabDataFromPrivate(data.hasFocus.tabData)})}if(data.hasNoFocus){result.hasNoFocus=replaceProperties(data.hasNoFocus,{tabFocusCandidateData:convertTabDataFromPrivate(data.hasNoFocus.tabFocusCandidateData)})}return result}function streamFromBuffer(buffer){return new ReadableStream({start(controller){controller.enqueue(buffer);controller.close()}})}function convertPdfDocumentDataFromPrivate(data){const pdfData=data.pdfData&&streamFromBuffer(new Uint8Array(data.pdfData));return replaceProperties(data,{pdfData:pdfData})}function convertAnnotatedPageDataFromPrivate(data){const annotatedPageContent=data.annotatedPageContent&&streamFromBuffer(new Uint8Array(data.annotatedPageContent));return replaceProperties(data,{annotatedPageContent:annotatedPageContent})}function convertTabContextResultFromPrivate(data){const tabData=convertTabDataFromPrivate(data.tabData);const pdfDocumentData=data.pdfDocumentData&&convertPdfDocumentDataFromPrivate(data.pdfDocumentData);const annotatedPageData=data.annotatedPageData&&convertAnnotatedPageDataFromPrivate(data.annotatedPageData);return replaceProperties(data,{tabData:tabData,pdfDocumentData:pdfDocumentData,annotatedPageData:annotatedPageData})}window.internalAutoGlicBoot=windowProxy=>new GlicHostRegistryImpl(windowProxy);