// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const INTERNAL_REQUEST_MESSAGE="internal-request-message";const INTERNAL_REPLY_MESSAGE="internal-reply-message";class Channel{constructor(){this.port_=null;this.messageCallbacks_={};this.nextInternalRequestId_=0;this.internalRequestCallbacks_={}}init(port){this.port_=port;this.port_.onMessage.addListener(this.onMessage_.bind(this))}connect(name){this.port_=chrome.runtime.connect({name:name});this.port_.onMessage.addListener(this.onMessage_.bind(this))}registerMessage(name,callback){this.messageCallbacks_[name]=callback}send(msg){this.port_.postMessage(msg)}sendWithCallback(msg,callback){const requestId=this.nextInternalRequestId_++;this.internalRequestCallbacks_[requestId]=callback;this.send({name:INTERNAL_REQUEST_MESSAGE,requestId:requestId,payload:msg})}invokeMessageCallbacks_(msg){const name=msg.name;if(this.messageCallbacks_[name]){return this.messageCallbacks_[name](msg)}console.error("Error: Unexpected message, name="+name);return null}onMessage_(msg){const name=msg.name;if(name===INTERNAL_REQUEST_MESSAGE){const payload=msg.payload;const result=this.invokeMessageCallbacks_(payload);this.send({name:INTERNAL_REPLY_MESSAGE,requestId:msg.requestId,result:result})}else if(name===INTERNAL_REPLY_MESSAGE){const callback=this.internalRequestCallbacks_[msg.requestId];delete this.internalRequestCallbacks_[msg.requestId];if(callback){callback(msg.result)}}else{this.invokeMessageCallbacks_(msg)}}}const ALLOWED_ORIGINS=["chrome://oobe","chrome://chrome-signin","chrome://password-change","chrome://lock-reauth"];const PORT_MESSAGE="post-message-port-message";const CHANNEL_INIT_MESSAGE="post-message-channel-init";const CHANNEL_CONNECT_MESSAGE="post-message-channel-connect";function isTopLevelWindow(){return window===window.top}class EventTarget{constructor(){this.listeners_=[]}addListener(listener){this.listeners_.push(listener)}dispatch(e){for(let i=0;i<this.listeners_.length;++i){this.listeners_[i].call(undefined,e)}}}class PostMessagePort{constructor(channelId,name){this.channelId=channelId;this.name=name;this.targetWindow=null;this.targetOrigin="";this.deferredMessages_=[];this.onMessage=new EventTarget}setTarget(targetWindow,targetOrigin){this.targetWindow=targetWindow;this.targetOrigin=targetOrigin;for(let i=0;i<this.deferredMessages_.length;++i){this.postMessage(this.deferredMessages_[i])}this.deferredMessages_=[]}postMessage(msg){if(!this.targetWindow){this.deferredMessages_.push(msg);return}this.targetWindow.postMessage({type:PORT_MESSAGE,channelId:this.channelId,payload:msg},this.targetOrigin)}handleWindowMessage(e){this.onMessage.dispatch(e.data.payload)}}class ChannelManager{constructor(){this.upperWindow=isTopLevelWindow()?null:window.parent;this.upperOrigin=isTopLevelWindow()?"":"*";this.channels_={};this.deferredUpperWindowMessages_=[];this.deferredUpperWindowPorts_=[];this.isDaemon=false;this.onConnect=new EventTarget;window.addEventListener("message",this.onMessage_.bind(this))}createChannelId_(){return(new Date).getTime()}postToUpperWindow(data){if(this.upperWindow==null){this.deferredUpperWindowMessages_.push(data);return}this.upperWindow.postMessage(data,this.upperOrigin)}createPort(channelId,channelName,opt_targetWindow,opt_targetOrigin){const port=new PostMessagePort(channelId,channelName);if(opt_targetWindow){port.setTarget(opt_targetWindow,opt_targetOrigin)}this.channels_[channelId]=port;return port}getProxyPortForwardHandler_(proxyPort){return function(msg){proxyPort.postMessage(msg)}}createProxyPort(channelId,channelName,targetWindow,targetOrigin){const port=this.createPort(channelId,channelName,targetWindow,targetOrigin);port.onMessage.addListener(this.getProxyPortForwardHandler_(port));return port}connectToDaemon(name){if(this.isDaemon){console.error("Error: Connecting from the daemon page is not supported.");return null}const port=this.createPort(this.createChannelId_(),name);if(this.upperWindow){port.setTarget(this.upperWindow,this.upperOrigin)}else{this.deferredUpperWindowPorts_.push(port)}this.postToUpperWindow({type:CHANNEL_CONNECT_MESSAGE,channelId:port.channelId,channelName:port.name});return port}dispatchMessageToPort_(e){const channelId=e.data.channelId;const port=this.channels_[channelId];if(!port){console.error("Error: Unable to dispatch message. Unknown channel.");return}port.handleWindowMessage(e)}onMessage_(e){if(typeof e.data!=="object"||!e.data.hasOwnProperty("type")){return}if(e.data.type===PORT_MESSAGE){if(this.isDaemon||this.upperWindow&&e.source===this.upperWindow){this.dispatchMessageToPort_(e)}else{this.postToUpperWindow(e.data)}}else if(e.data.type===CHANNEL_CONNECT_MESSAGE){const channelId=e.data.channelId;const channelName=e.data.channelName;if(this.isDaemon){const port=this.createPort(channelId,channelName,e.source,e.origin);this.onConnect.dispatch(port)}else{this.createProxyPort(channelId,channelName,e.source,e.origin);this.postToUpperWindow(e.data)}}else if(e.data.type===CHANNEL_INIT_MESSAGE){if(ALLOWED_ORIGINS.indexOf(e.origin)===-1){return}this.upperWindow=e.source;this.upperOrigin=e.origin;for(let i=0;i<this.deferredUpperWindowMessages_.length;++i){this.upperWindow.postMessage(this.deferredUpperWindowMessages_[i],this.upperOrigin)}this.deferredUpperWindowMessages_=[];for(let i=0;i<this.deferredUpperWindowPorts_.length;++i){this.deferredUpperWindowPorts_[i].setTarget(this.upperWindow,this.upperOrigin)}this.deferredUpperWindowPorts_=[]}}}class PostMessageChannel extends Channel{static channelManager(){if(!PostMessageChannel._channelManager){PostMessageChannel._channelManager=new ChannelManager}return PostMessageChannel._channelManager}isTopLevel(){return isTopLevelWindow()}connect(name){this.port_=PostMessageChannel.channelManager().connectToDaemon(name);this.port_.onMessage.addListener(this.onMessage_.bind(this))}static init(webViewContentWindow){webViewContentWindow.postMessage({type:CHANNEL_INIT_MESSAGE},"*")}static runAsDaemon(callback){PostMessageChannel.channelManager().isDaemon=true;const onConnect=function(port){callback(port)};PostMessageChannel.channelManager().onConnect.addListener(onConnect)}}const WebviewScrollShadowsHelper=function(){function WebviewScrollShadowsHelper(){}WebviewScrollShadowsHelper.prototype={init(channel){this.channel_=channel;window.addEventListener("scroll",this.sendScrollInfo_.bind(this));window.addEventListener("resize",this.sendScrollInfo_.bind(this));this.boundAttachResizeObserver_=this.attachResizeObserver_.bind(this);window.addEventListener("load",this.boundAttachResizeObserver_);this.resizeObserver=new ResizeObserver((()=>{this.sendScrollInfo_()}))},attachResizeObserver_(event){this.resizeObserver.observe(document.body);window.removeEventListener(event.type,this.boundAttachResizeObserver_)},sendScrollInfo_(event){this.channel_.send({name:"scrollInfo",scrollTop:window.scrollY,scrollHeight:document.body.scrollHeight})}};return WebviewScrollShadowsHelper}();const WebviewScrollShadowsHelperConstructor=function(){return new WebviewScrollShadowsHelper};(function(){function APICallForwarder(){}APICallForwarder.prototype={channel_:null,init(channel){this.channel_=channel;this.channel_.registerMessage("apiResponse",this.onAPIResponse_.bind(this));window.addEventListener("message",this.onMessage_.bind(this))},onMessage_(event){if(event.source!==window||typeof event.data!=="object"||!event.data.hasOwnProperty("type")||event.data.type!=="gaia_saml_api"){return}this.channel_.send({name:"apiCall",call:event.data.call})},onAPIResponse_(msg){window.postMessage({type:"gaia_saml_api_reply",response:msg.response},"/")}};function PasswordInputScraper(){}PasswordInputScraper.prototype={pageURL_:null,channel_:null,passwordFields_:null,passwordValues_:null,passwordFieldsObserver:null,init(channel,pageURL,docRoot){this.pageURL_=pageURL;this.channel_=channel;this.passwordFields_=[];this.passwordValues_=[];this.findAndTrackChildren(docRoot);this.passwordFieldsObserver=new MutationObserver(function(mutations){mutations.forEach(function(mutation){Array.prototype.forEach.call(mutation.addedNodes,function(addedNode){if(addedNode.nodeType!==Node.ELEMENT_NODE){return}if(addedNode.matches("input[type=password]")){this.trackPasswordField(addedNode)}else{this.findAndTrackChildren(addedNode)}}.bind(this))}.bind(this))}.bind(this));this.passwordFieldsObserver.observe(docRoot,{subtree:true,childList:true})},findAndTrackChildren(element){Array.prototype.forEach.call(element.querySelectorAll("input[type=password]"),function(field){this.trackPasswordField(field)}.bind(this))},trackPasswordField(passwordField){const existing=this.passwordFields_.filter((function(element){return element===passwordField}));if(existing.length!==0){return}const index=this.passwordFields_.length;const fieldId=passwordField.id||passwordField.name||"";passwordField.addEventListener("input",this.onPasswordChanged_.bind(this,index,fieldId));this.passwordFields_.push(passwordField);this.passwordValues_.push(passwordField.value)},maybeSendUpdatedPassword(index,fieldId){const newValue=this.passwordFields_[index].value;if(newValue===this.passwordValues_[index]){return}this.passwordValues_[index]=newValue;const passwordId=this.pageURL_.split("#")[0].split("?")[0]+"|"+index+"|"+fieldId;this.channel_.send({name:"updatePassword",id:passwordId,password:newValue})},onPasswordChanged_(index,fieldId){this.maybeSendUpdatedPassword(index,fieldId)}};function onGetSAMLFlag(channel,isSAMLPage){if(!isSAMLPage){return}const pageURL=window.location.href;channel.send({name:"pageLoaded",url:pageURL});const initPasswordScraper=function(){const passwordScraper=new PasswordInputScraper;passwordScraper.init(channel,pageURL,document.documentElement)};if(document.readyState==="loading"){window.addEventListener("readystatechange",(function listener(event){if(document.readyState==="loading"){return}initPasswordScraper();window.removeEventListener(event.type,listener,true)}),true)}else{initPasswordScraper()}}const channel=new PostMessageChannel;channel.connect("injected");channel.sendWithCallback({name:"getSAMLFlag"},onGetSAMLFlag.bind(undefined,channel));const apiCallForwarder=new APICallForwarder;apiCallForwarder.init(channel);if(window.top===window.self){const scrollHelper=WebviewScrollShadowsHelperConstructor();scrollHelper.init(channel)}})();