// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{SHAREKIT_SDK_VERSION}from"./dummy_data_sharing_sdk.js";import"/strings.m.js";import{ColorChangeUpdater}from"//resources/cr_components/color_change_listener/colors_css_updater.js";import{assert}from"chrome-untrusted://resources/js/assert.js";import{CustomElement}from"chrome-untrusted://resources/js/custom_element.js";import{loadTimeData}from"chrome-untrusted://resources/js/load_time_data.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{GroupAction,GroupActionProgress}from"./data_sharing.mojom-webui.js";import{getTemplate}from"./data_sharing_app.html.js";var UrlQueryParams;(function(UrlQueryParams){UrlQueryParams["FLOW"]="flow";UrlQueryParams["GROUP_ID"]="group_id";UrlQueryParams["TOKEN_SECRET"]="token_secret";UrlQueryParams["TAB_GROUP_ID"]="tab_group_id";UrlQueryParams["TAB_GROUP_TITLE"]="tab_group_title";UrlQueryParams["IS_DISABLED_FOR_POLICY"]="is_disabled_for_policy"})(UrlQueryParams||(UrlQueryParams={}));var FlowValues;(function(FlowValues){FlowValues["SHARE"]="share";FlowValues["JOIN"]="join";FlowValues["MANAGE"]="manage";FlowValues["DELETE"]="delete";FlowValues["LEAVE"]="leave";FlowValues["CLOSE"]="close"})(FlowValues||(FlowValues={}));var DataSharingIntentType;(function(DataSharingIntentType){DataSharingIntentType[DataSharingIntentType["UNKNOWN"]=0]="UNKNOWN";DataSharingIntentType[DataSharingIntentType["STOP_SHARING"]=1]="STOP_SHARING";DataSharingIntentType[DataSharingIntentType["LEAVE_GROUP"]=2]="LEAVE_GROUP";DataSharingIntentType[DataSharingIntentType["REMOVE_ACCESS"]=3]="REMOVE_ACCESS";DataSharingIntentType[DataSharingIntentType["UPDATE_ACCESS"]=4]="UPDATE_ACCESS";DataSharingIntentType[DataSharingIntentType["BLOCK_USER"]=5]="BLOCK_USER";DataSharingIntentType[DataSharingIntentType["REMOVE_USER"]=6]="REMOVE_USER";DataSharingIntentType[DataSharingIntentType["REMOVE_ACCESS_TOKEN"]=7]="REMOVE_ACCESS_TOKEN";DataSharingIntentType[DataSharingIntentType["ADD_ACCESS_TOKEN"]=8]="ADD_ACCESS_TOKEN";DataSharingIntentType[DataSharingIntentType["COPY_LINK"]=9]="COPY_LINK";DataSharingIntentType[DataSharingIntentType["BLOCK_AND_LEAVE"]=10]="BLOCK_AND_LEAVE";DataSharingIntentType[DataSharingIntentType["OPEN_GROUP_DETAILS"]=11]="OPEN_GROUP_DETAILS";DataSharingIntentType[DataSharingIntentType["OPEN_LEARN_MORE_URL"]=12]="OPEN_LEARN_MORE_URL";DataSharingIntentType[DataSharingIntentType["ACCEPT_JOIN_AND_OPEN"]=13]="ACCEPT_JOIN_AND_OPEN";DataSharingIntentType[DataSharingIntentType["ABANDON_JOIN"]=14]="ABANDON_JOIN"})(DataSharingIntentType||(DataSharingIntentType={}));var ProgressType;(function(ProgressType){ProgressType["UNKNOWN"]="Unknown";ProgressType["STARTED"]="Started";ProgressType["FAILED"]="Failed";ProgressType["SUCCEEDED"]="Succeeded"})(ProgressType||(ProgressType={}));function toMojomGroupAction(intent){switch(intent){case 16:return GroupAction.kDeleteGroup;case 2:return GroupAction.kLeaveGroup;case 13:return GroupAction.kJoinGroup;case 1:return GroupAction.kStopSharing;default:return GroupAction.kUnknown}}function toMojomGroupActionProgress(progress){switch(progress){case 1:return GroupActionProgress.kStarted;case 3:return GroupActionProgress.kSuccess;case 2:return GroupActionProgress.kFailed;default:return GroupActionProgress.kUnknown}}function getGroupOwnerName(params){for(const member of params.group.members){if(member.role==="owner"){return member.name}}return""}function getGroupOwnerEmail(params){for(const member of params.group.members){if(member.role==="owner"){return member.email}}return""}function getTabGroupName(){const currentUrl=urlForTesting?urlForTesting:window.location.href;const params=new URL(currentUrl).searchParams;return params.get(UrlQueryParams.TAB_GROUP_TITLE)||""}export function createTranslationMap(){return{static:{[0]:loadTimeData.getString("cancel"),[1]:loadTimeData.getString("cancel"),[2]:loadTimeData.getString("close"),[4]:loadTimeData.getString("back"),[3]:loadTimeData.getString("loading"),[6]:loadTimeData.getString("somethingWrong"),[7]:loadTimeData.getString("somethingWrongBody"),[8]:loadTimeData.getString("somethingWrongBody"),[9]:loadTimeData.getString("somethingWrongBody"),[10]:loadTimeData.getString("moreOptions"),[11]:loadTimeData.getString("moreOptionsDescription"),[14]:loadTimeData.getString("copyLink"),[16]:loadTimeData.getString("copyLinkSuccess"),[17]:loadTimeData.getString("copyLinkFailed"),[18]:loadTimeData.getString("previewDialogConfirm"),[21]:loadTimeData.getString("tabsInGroup"),[22]:loadTimeData.getString("linkJoinToggle"),[23]:loadTimeData.getString("manageShareWisely"),[24]:loadTimeData.getString("blockLeaveDialogTitle"),[25]:loadTimeData.getString("blockLeaveDialogConfrim"),[26]:loadTimeData.getString("blockLeaveLearnMore"),[27]:loadTimeData.getString("gotIt"),[28]:loadTimeData.getString("joinWarning"),[29]:loadTimeData.getString("ownerStopSharingDialogTitle"),[30]:loadTimeData.getString("manageStopSharingOption"),[31]:loadTimeData.getString("block"),[32]:loadTimeData.getString("leaveGroup"),[33]:loadTimeData.getString("leaveGroupConfirm"),[34]:loadTimeData.getString("leaveDialogTitle"),[35]:loadTimeData.getString("remove"),[36]:loadTimeData.getString("you"),[37]:loadTimeData.getString("owner"),[12]:loadTimeData.getString("shareGroupBody"),[13]:loadTimeData.getString("copyInviteLink"),[19]:loadTimeData.getString("learnMoreJoinFlow"),[15]:loadTimeData.getString("learnMoreSharedTabGroup"),[20]:loadTimeData.getString("tabGroupDetailsTitle"),[38]:loadTimeData.getString("peopleWithAccess"),[39]:loadTimeData.getString("peopleWithAccessSubtitleManageFlow"),[5]:loadTimeData.getString("errorDialogContent"),[40]:loadTimeData.getString("groupFull"),[41]:loadTimeData.getString("groupFullBody"),[44]:loadTimeData.getString("activityLog"),[42]:loadTimeData.getString("ownerCannotShare"),[45]:loadTimeData.getString("deleteLastDialogHeader"),[46]:loadTimeData.getString("keepGroup"),[47]:loadTimeData.getString("deleteGroup"),[48]:loadTimeData.getString("deleteFlowHeader"),[49]:loadTimeData.getString("delete"),[43]:loadTimeData.getString("sharingDisabledDescription")},dynamic:{[1]:params=>loadTimeData.getStringF("shareGroupShareAs",params.loggedInUser.name),[4]:params=>loadTimeData.getStringF("joinGroupJoinAs",params.loggedInUser.name),[5]:params=>loadTimeData.getStringF(params.group.members.length<=1?"memberCountSingular":"memberCountPlural",params.group.members.length),[6]:params=>loadTimeData.getStringF(params.payload.mediaCount<=1?"tabCountSingular":"tabCountPlural",params.payload.mediaCount),[7]:params=>loadTimeData.getStringF("getGroupPreviewAriaLabel",params.group.name)+" "+loadTimeData.getStringF(params.group.members.length<=1?"memberCountSingular":"memberCountPlural",params.group.members.length)+" "+loadTimeData.getStringF(params.payload.mediaCount<=1?"tabCountSingular":"tabCountPlural",params.payload.mediaCount),[9]:()=>loadTimeData.getStringF("ownerStopSharingDialogBody",getTabGroupName()),[10]:params=>loadTimeData.getStringF("ownerRemoveMemberDialogTitle",params.displayedUser.name),[11]:params=>loadTimeData.getStringF("ownerRemoveMemberDialogBody",params.displayedUser.name,params.displayedUser.email,getTabGroupName()),[12]:()=>loadTimeData.getStringF("leaveDialogBody",getTabGroupName()),[13]:params=>loadTimeData.getStringF("blockDialogTitle",params.displayedUser.name),[14]:params=>loadTimeData.getStringF("blockDialogBody",params.displayedUser.name,params.displayedUser.email,getTabGroupName()),[15]:params=>loadTimeData.getStringF("blockLeaveDialogBody",getTabGroupName(),params.displayedUser.name,params.displayedUser.email),[0]:()=>loadTimeData.getStringF("shareGroupTitle",getTabGroupName()),[2]:params=>{const otherMemberCount=params.group.members.length-1;return loadTimeData.getStringF(otherMemberCount<=0?"previewDialogTitleZero":otherMemberCount===1?"previewDialogTitleSingular":"previewDialogTitlePlural",getGroupOwnerName(params),otherMemberCount)},[3]:params=>loadTimeData.getStringF("previewDialogBody",getGroupOwnerName(params),getGroupOwnerEmail(params)),[8]:()=>loadTimeData.getStringF("manageGroupTitle",getTabGroupName()),[16]:params=>{if(params.loggedInUser.role==="owner"){return loadTimeData.getStringF("ownerDeleteLastTimeBody")}else{return loadTimeData.getStringF("memberDeleteLastTimeBody")}},[17]:params=>{if(params.loggedInUser.role==="owner"){return loadTimeData.getStringF("ownerDeleteLastTimeBody2",getTabGroupName())}else{return""}},[18]:()=>loadTimeData.getStringF("deleteFlowDescriptionContent",getTabGroupName())}}}const learnMoreUrlMap={[0]:()=>loadTimeData.getStringF("dataSharingUrl"),[1]:()=>loadTimeData.getStringF("learnMoreSharedTabGroupPageUrl"),[2]:()=>loadTimeData.getStringF("learnMoreSharedTabGroupPageUrl"),[3]:()=>loadTimeData.getStringF("learnMoreSharedTabGroupPageUrl"),[4]:()=>loadTimeData.getStringF("learnAboutBlockedAccountsUrl")};export class DataSharingApp extends CustomElement{initialized_=false;dataSharingSdk_=window.data_sharing_sdk.buildDataSharingSdk();browserProxy_=BrowserProxyImpl.getInstance();translationMap_=createTranslationMap();abandonJoin_=false;successfullyJoined_=false;tabGroupId_=null;convertedToSharedTabGroup=false;static get is(){return"data-sharing-app"}static get template(){return getTemplate()}constructor(){super();console.info("ShareKit SDK version: "+SHAREKIT_SDK_VERSION);this.dataSharingSdk_.updateClearcut({enabled:loadTimeData.getBoolean("metricsReportingEnabled")});this.browserProxy_.callbackRouter.onAccessTokenFetched.addListener((accessToken=>{this.dataSharingSdk_.setOauthAccessToken({accessToken:accessToken});if(!this.initialized_){this.processUrl();this.browserProxy_.showUi();this.initialized_=true}}))}connectedCallback(){ColorChangeUpdater.forDocument().start()}onEvent(event){const intentMetricName="DataSharing.Intent."+this.getProgressType(event.progress);chrome.metricsPrivate.recordEnumerationValue(intentMetricName,this.getDataSharingIntentType(event.intentType),Object.keys(DataSharingIntentType).length);if(event.intentType===14){this.abandonJoin_=true}if(event.intentType===1){assert(this.tabGroupId_);if(event.progress===1){this.browserProxy_.aboutToUnShareTabGroup(this.tabGroupId_)}else if(event.progress===3){this.browserProxy_.onTabGroupUnShareComplete(this.tabGroupId_)}}this.browserProxy_.onGroupAction(toMojomGroupAction(event.intentType),toMojomGroupActionProgress(event.progress))}setSuccessfullyJoinedForTesting(){this.successfullyJoined_=true}getProgressType(progress){switch(progress){case 1:return ProgressType.STARTED;case 2:return ProgressType.FAILED;case 3:return ProgressType.SUCCEEDED;default:break}return ProgressType.UNKNOWN}getDataSharingIntentType(intent){switch(intent){case 1:return DataSharingIntentType.STOP_SHARING;case 2:return DataSharingIntentType.LEAVE_GROUP;case 3:return DataSharingIntentType.REMOVE_ACCESS;case 4:return DataSharingIntentType.UPDATE_ACCESS;case 5:return DataSharingIntentType.BLOCK_USER;case 6:return DataSharingIntentType.REMOVE_USER;case 7:return DataSharingIntentType.REMOVE_ACCESS_TOKEN;case 8:return DataSharingIntentType.ADD_ACCESS_TOKEN;case 9:return DataSharingIntentType.COPY_LINK;case 10:return DataSharingIntentType.BLOCK_AND_LEAVE;case 11:return DataSharingIntentType.OPEN_GROUP_DETAILS;case 12:return DataSharingIntentType.OPEN_LEARN_MORE_URL;case 13:return DataSharingIntentType.ACCEPT_JOIN_AND_OPEN;case 14:return DataSharingIntentType.ABANDON_JOIN;default:break}return DataSharingIntentType.UNKNOWN}processUrl(){const currentUrl=urlForTesting?urlForTesting:window.location.href;const params=new URL(currentUrl).searchParams;const flow=params.get(UrlQueryParams.FLOW);const groupId=params.get(UrlQueryParams.GROUP_ID);const tokenSecret=params.get(UrlQueryParams.TOKEN_SECRET);const tabGroupId=params.get(UrlQueryParams.TAB_GROUP_ID);const parent=this.getRequiredElement("#dialog-container");const isSharingDisabled=params.get(UrlQueryParams.IS_DISABLED_FOR_POLICY)==="true";this.tabGroupId_=tabGroupId;if(flow===FlowValues.SHARE){parent.classList.add("invite")}else{parent.classList.remove("invite")}switch(flow){case FlowValues.SHARE:document.title=loadTimeData.getStringF("shareGroupTitle",getTabGroupName());break;case FlowValues.MANAGE:document.title=loadTimeData.getStringF("manageGroupTitle",getTabGroupName());break;case FlowValues.JOIN:document.title=loadTimeData.getStringF("previewA11yName");break;default:break}switch(flow){case FlowValues.SHARE:this.dataSharingSdk_.runInviteFlow({parent:parent,translatedMessages:this.translationMap_,getShareLink:async params=>{if(!this.convertedToSharedTabGroup){const url=await this.browserProxy_.makeTabGroupShared(tabGroupId,params.groupId,params.tokenSecret);if(url===undefined){this.browserProxy_.closeUi(2);return""}else{this.convertedToSharedTabGroup=true;return url}}else{return this.browserProxy_.getShareLink(params.groupId,params.tokenSecret)}},groupName:"",learnMoreUrlMap:learnMoreUrlMap,logger:this}).then((res=>{this.browserProxy_.closeUi(res.status)}));break;case FlowValues.JOIN:this.dataSharingSdk_.runJoinFlow({parent:parent,groupId:groupId,translatedMessages:this.translationMap_,tokenSecret:tokenSecret,learnMoreUrlMap:learnMoreUrlMap,onJoinSuccessful:()=>{this.successfullyJoined_=true;this.browserProxy_.handler.openTabGroup(groupId);return new Promise((()=>{}))},fetchPreviewData:()=>this.browserProxy_.getTabGroupPreview(groupId,tokenSecret),logger:this}).then((res=>{if(this.successfullyJoined_){return}if(this.abandonJoin_){this.browserProxy_.closeUi(res.status)}else{this.browserProxy_.closeUi(2)}}));break;case FlowValues.MANAGE:case FlowValues.LEAVE:this.dataSharingSdk_.runManageFlow({parent:parent,translatedMessages:this.translationMap_,groupId:groupId,getShareLink:params=>this.browserProxy_.getShareLink(params.groupId,params.tokenSecret),learnMoreUrlMap:learnMoreUrlMap,activityLogCallback:()=>{window.open(loadTimeData.getStringF("activityLogsUrl"),"_blank")},logger:this,showLeaveDialogAtStartup:flow===FlowValues.LEAVE,isSharingDisabled:isSharingDisabled}).then((res=>{this.browserProxy_.closeUi(res.status)}));break;case FlowValues.DELETE:this.dataSharingSdk_.runDeleteFlow({parent:parent,groupId:groupId,translatedMessages:this.translationMap_,logger:this}).then((res=>{this.browserProxy_.closeUi(res.status)}));break;case FlowValues.CLOSE:this.dataSharingSdk_.runCloseFlow({parent:parent,groupId:groupId,translatedMessages:this.translationMap_,logger:this}).then((res=>{this.browserProxy_.closeUi(res.status)}));break;default:break}}static setUrlForTesting(url){urlForTesting=url}}let urlForTesting=null;customElements.define(DataSharingApp.is,DataSharingApp);