// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{assert}from"chrome://resources/js/assert.js";import{addWebUiListener,sendWithPromise}from"chrome://resources/js/cr.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{isChromeOS}from"chrome://resources/js/platform.js";import{getRequiredElement}from"chrome://resources/js/util.js";import{render}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getHtml}from"./component.html.js";let currentComponentsData=null;function renderTemplate(componentsData){render(getHtml(componentsData),getRequiredElement("component-placeholder"))}function requestComponentsData(){sendWithPromise("requestComponentsData").then(returnComponentsData)}function returnComponentsData(componentsData){const bodyContainer=getRequiredElement("body-container");const body=document.body;bodyContainer.style.visibility="hidden";body.className="";currentComponentsData=componentsData.components;renderTemplate(componentsData);const links=document.body.querySelectorAll(".button-check-update");for(const link of links){link.onclick=function(e){handleCheckUpdate(link);e.preventDefault()}}if(isChromeOS&&loadTimeData.getBoolean("isGuest")){document.body.querySelectorAll("[guest-disabled]").forEach((function(element){element.disabled=true}))}bodyContainer.style.visibility="visible";body.className="show-tmi-mode-initial"}function onComponentEvent(event){if(!event.id){return}const id=event.id;assert(currentComponentsData);const filteredComponents=currentComponentsData.filter((function(entry){return entry.id===id}));if(filteredComponents.length===0){return}const component=filteredComponents[0];assert(component);const status=event.event;getRequiredElement("status-"+id).textContent=status;component.status=status;if(event.version){const version=event.version;getRequiredElement("version-"+id).textContent=version;component.version=version}}function handleCheckUpdate(node){getRequiredElement("status-"+String(node.id)).textContent=loadTimeData.getString("checkingLabel");chrome.send("checkUpdate",[String(node.id)])}document.addEventListener("DOMContentLoaded",(function(){addWebUiListener("component-event",onComponentEvent);requestComponentsData()}));