import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ProductSpecificationsSet as commerce_shared_mojom_ProductSpecificationsSet } from './shared.mojom-webui.js';
import { Uuid as mojoBase_mojom_Uuid } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export declare const DisclosureVersionSpec: {
    $: mojo.internal.MojomType;
};
export declare enum DisclosureVersion {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kUnknown = 0,
    kV1 = 1
}
export declare const ShowSetDispositionSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ShowSetDisposition {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kInNewTabs = 0,
    kInNewWindow = 1
}
export type ProductSpecificationsHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerPendingReceiver>;
export declare class ProductSpecificationsHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<ProductSpecificationsHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerPendingReceiver>;
    constructor(handle: MojoHandle | ProductSpecificationsHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface ProductSpecificationsHandlerInterface {
    setAcceptedDisclosureVersion(version: DisclosureVersion): void;
    maybeShowDisclosure(urls: url_mojom_Url[], name: string, setId: string): Promise<{
        disclosureShown: boolean;
    }>;
    declineDisclosure(): void;
    showSyncSetupFlow(): void;
    getPageTitleFromHistory(url: url_mojom_Url): Promise<{
        title: string;
    }>;
    showProductSpecificationsSetForUuid(uuid: mojoBase_mojom_Uuid, inNewTab: boolean): void;
    showProductSpecificationsSetsForUuids(uuids: mojoBase_mojom_Uuid[], disposition: ShowSetDisposition): void;
    showComparePage(inNewTab: boolean): void;
    getComparisonTableUrlForUuid(uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url;
    }>;
}
export declare class ProductSpecificationsHandlerRemote implements ProductSpecificationsHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ProductSpecificationsHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | ProductSpecificationsHandlerPendingReceiverEndpoint);
    setAcceptedDisclosureVersion(version: DisclosureVersion): void;
    maybeShowDisclosure(urls: url_mojom_Url[], name: string, setId: string): Promise<{
        disclosureShown: boolean;
    }>;
    declineDisclosure(): void;
    showSyncSetupFlow(): void;
    getPageTitleFromHistory(url: url_mojom_Url): Promise<{
        title: string;
    }>;
    showProductSpecificationsSetForUuid(uuid: mojoBase_mojom_Uuid, inNewTab: boolean): void;
    showProductSpecificationsSetsForUuids(uuids: mojoBase_mojom_Uuid[], disposition: ShowSetDisposition): void;
    showComparePage(inNewTab: boolean): void;
    getComparisonTableUrlForUuid(uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url;
    }>;
}
/**
 * An object which receives request messages for the ProductSpecificationsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class ProductSpecificationsHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ProductSpecificationsHandlerRemote, ProductSpecificationsHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: ProductSpecificationsHandlerInterface);
}
export declare class ProductSpecificationsHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): ProductSpecificationsHandlerRemote;
}
/**
 * An object which receives request messages for the ProductSpecificationsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class ProductSpecificationsHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ProductSpecificationsHandlerRemote, ProductSpecificationsHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    setAcceptedDisclosureVersion: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    maybeShowDisclosure: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    declineDisclosure: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showSyncSetupFlow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getPageTitleFromHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showProductSpecificationsSetForUuid: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showProductSpecificationsSetsForUuids: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showComparePage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getComparisonTableUrlForUuid: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PagePendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
export declare class PagePendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<Page> {
    handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
    constructor(handle: MojoHandle | PagePendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageInterface {
    onProductSpecificationsSetAdded(set: commerce_shared_mojom_ProductSpecificationsSet): void;
    onProductSpecificationsSetUpdated(set: commerce_shared_mojom_ProductSpecificationsSet): void;
    onProductSpecificationsSetRemoved(uuid: mojoBase_mojom_Uuid): void;
    onSyncStateChanged(): void;
}
export declare class PageRemote implements PageInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PagePendingReceiverEndpoint);
    onProductSpecificationsSetAdded(set: commerce_shared_mojom_ProductSpecificationsSet): void;
    onProductSpecificationsSetUpdated(set: commerce_shared_mojom_ProductSpecificationsSet): void;
    onProductSpecificationsSetRemoved(uuid: mojoBase_mojom_Uuid): void;
    onSyncStateChanged(): void;
}
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageInterface);
}
export declare class Page {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageRemote;
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    onProductSpecificationsSetAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onProductSpecificationsSetUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onProductSpecificationsSetRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onSyncStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type ProductSpecificationsHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerFactoryPendingReceiver>;
export declare class ProductSpecificationsHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<ProductSpecificationsHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | ProductSpecificationsHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface ProductSpecificationsHandlerFactoryInterface {
    createProductSpecificationsHandler(page: PageRemote, handler: ProductSpecificationsHandlerPendingReceiver): void;
}
export declare class ProductSpecificationsHandlerFactoryRemote implements ProductSpecificationsHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ProductSpecificationsHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | ProductSpecificationsHandlerFactoryPendingReceiverEndpoint);
    createProductSpecificationsHandler(page: PageRemote, handler: ProductSpecificationsHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the ProductSpecificationsHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class ProductSpecificationsHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ProductSpecificationsHandlerFactoryRemote, ProductSpecificationsHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: ProductSpecificationsHandlerFactoryInterface);
}
export declare class ProductSpecificationsHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): ProductSpecificationsHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the ProductSpecificationsHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class ProductSpecificationsHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ProductSpecificationsHandlerFactoryRemote, ProductSpecificationsHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createProductSpecificationsHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_MaybeShowDisclosure_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_DeclineDisclosure_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_ShowComparePage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnProductSpecificationsSetAdded_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnProductSpecificationsSetUpdated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnProductSpecificationsSetRemoved_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnSyncStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsMojoType {
    version: DisclosureVersion;
}
export type ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params = ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsMojoType;
export interface ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType {
    urls: url_mojom_Url[];
    name: string;
    setId: string;
}
export type ProductSpecificationsHandler_MaybeShowDisclosure_Params = ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType;
export interface ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsMojoType {
    disclosureShown: boolean;
}
export type ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams = ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsMojoType;
export interface ProductSpecificationsHandler_DeclineDisclosure_ParamsMojoType {
}
export type ProductSpecificationsHandler_DeclineDisclosure_Params = ProductSpecificationsHandler_DeclineDisclosure_ParamsMojoType;
export interface ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsMojoType {
}
export type ProductSpecificationsHandler_ShowSyncSetupFlow_Params = ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsMojoType;
export interface ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsMojoType {
    url: url_mojom_Url;
}
export type ProductSpecificationsHandler_GetPageTitleFromHistory_Params = ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsMojoType;
export interface ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsMojoType {
    title: string;
}
export type ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams = ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsMojoType;
export interface ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
    inNewTab: boolean;
}
export type ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params = ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsMojoType;
export interface ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsMojoType {
    uuids: mojoBase_mojom_Uuid[];
    disposition: ShowSetDisposition;
}
export type ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params = ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsMojoType;
export interface ProductSpecificationsHandler_ShowComparePage_ParamsMojoType {
    inNewTab: boolean;
}
export type ProductSpecificationsHandler_ShowComparePage_Params = ProductSpecificationsHandler_ShowComparePage_ParamsMojoType;
export interface ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
}
export type ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params = ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsMojoType;
export interface ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsMojoType {
    url: url_mojom_Url;
}
export type ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams = ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsMojoType;
export interface Page_OnProductSpecificationsSetAdded_ParamsMojoType {
    set: commerce_shared_mojom_ProductSpecificationsSet;
}
export type Page_OnProductSpecificationsSetAdded_Params = Page_OnProductSpecificationsSetAdded_ParamsMojoType;
export interface Page_OnProductSpecificationsSetUpdated_ParamsMojoType {
    set: commerce_shared_mojom_ProductSpecificationsSet;
}
export type Page_OnProductSpecificationsSetUpdated_Params = Page_OnProductSpecificationsSetUpdated_ParamsMojoType;
export interface Page_OnProductSpecificationsSetRemoved_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
}
export type Page_OnProductSpecificationsSetRemoved_Params = Page_OnProductSpecificationsSetRemoved_ParamsMojoType;
export interface Page_OnSyncStateChanged_ParamsMojoType {
}
export type Page_OnSyncStateChanged_Params = Page_OnSyncStateChanged_ParamsMojoType;
export interface ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsMojoType {
    page: PageRemote;
    handler: ProductSpecificationsHandlerPendingReceiver;
}
export type ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params = ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsMojoType;
