// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import './product_selection_menu.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './product_selector.css.js';
import { getHtml } from './product_selector.html.js';
import { getAbbreviatedUrl } from './utils.js';
export class ProductSelectorElement extends CrLitElement {
    static get is() {
        return 'product-selector';
    }
    static get styles() {
        return getCss();
    }
    static get properties() {
        return {
            selectedItem: { type: Object },
            excludedUrls: { type: Array },
        };
    }
    #selectedItem_accessor_storage = null;
    get selectedItem() { return this.#selectedItem_accessor_storage; }
    set selectedItem(value) { this.#selectedItem_accessor_storage = value; }
    #excludedUrls_accessor_storage = [];
    get excludedUrls() { return this.#excludedUrls_accessor_storage; }
    set excludedUrls(value) { this.#excludedUrls_accessor_storage = value; }
    render() {
        return getHtml.bind(this)();
    }
    closeMenu() {
        this.$.productSelectionMenu.close();
    }
    showMenu_() {
        this.$.productSelectionMenu.showAt(this.$.currentProductContainer);
        this.$.currentProductContainer.classList.add('showing-menu');
    }
    onCloseMenu_() {
        this.$.currentProductContainer.classList.remove('showing-menu');
    }
    onCurrentProductContainerKeyDown_(e) {
        if (e.key === ' ' || e.key === 'Enter') {
            e.preventDefault();
            e.stopPropagation();
            this.showMenu_();
        }
    }
    getUrl_(item) {
        return getAbbreviatedUrl(item.url);
    }
    getSelectedUrl_() {
        return this.selectedItem?.url ?? '';
    }
}
customElements.define(ProductSelectorElement.is, ProductSelectorElement);
