/**
 * @fileoverview The 'crs-section' component is the Chrome Root Store
 * section of the Certificate Management V2 UI.
 */
import './certificate_list.js';
import './certificate_manager_style.css.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_page_host_style.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { CertificateListElement } from './certificate_list.js';
import { CertificateSource } from './certificate_manager.mojom-webui.js';
export interface CrsSectionElement {
    $: {
        crsCerts: CertificateListElement;
    };
}
export declare class CrsSectionElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        crsLearnMoreUrl_: {
            type: StringConstructor;
            value: () => string;
        };
        certificateSourceEnum_: {
            type: ObjectConstructor;
            value: typeof CertificateSource;
        };
    };
    private crsLearnMoreUrl_;
}
declare global {
    interface HTMLElementTagNameMap {
        'crs-section': CrsSectionElement;
    }
}
