/**
 * @fileoverview The 'certificate-manager' component is a newer way for
 * showing and managing TLS certificates. This is tied to the Chrome Root Store
 * and Chrome Cert Management Enterprise policies launch.
 */
import '/strings.m.js';
import './certificate_list.js';
import './certificate_confirmation_dialog.js';
import './certificate_info_dialog.js';
import './certificate_password_dialog.js';
import './certificate_subpage.js';
import './certificate_manager_icons.html.js';
import './certificate_manager_style.css.js';
import './crs_section.js';
import './local_certs_section.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_toast/cr_toast.js';
import '//resources/cr_elements/cr_toolbar/cr_toolbar.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_link_row/cr_link_row.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/cr_elements/cr_page_selector/cr_page_selector.js';
import '//resources/cr_elements/cr_menu_selector/cr_menu_selector.js';
import '//resources/cr_elements/cr_nav_menu_item_style.css.js';
import '//resources/cr_elements/cr_page_host_style.css.js';
import type { CrPageSelectorElement } from '//resources/cr_elements/cr_page_selector/cr_page_selector.js';
import type { CrToastElement } from '//resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { CertificateListElement } from './certificate_list.js';
import { CertificateSource } from './certificate_manager.mojom-webui.js';
import type { CertificateSubpageElement, SubpageCertificateList } from './certificate_subpage.js';
import type { CrsSectionElement } from './crs_section.js';
import type { LocalCertsSectionElement } from './local_certs_section.js';
import type { Route } from './navigation.js';
import { Page } from './navigation.js';
declare const CertificateManagerElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/cr_container_shadow_mixin.js").CrContainerShadowMixinInterface) & (new (...args: any[]) => import("./navigation.js").RouteObserverMixinInterface);
export interface CertificateManagerElement {
    $: {
        toolbar: HTMLElement;
        main: CrPageSelectorElement;
        platformClientCerts: CertificateListElement;
        provisionedClientCerts: CertificateListElement;
        toast: CrToastElement;
        viewOsImportedClientCerts: HTMLElement;
        manageOsImportedClientCerts: HTMLElement;
        localMenuItem: HTMLElement;
        clientMenuItem: HTMLElement;
        crsMenuItem: HTMLElement;
        localCertSection: LocalCertsSectionElement;
        clientCertSection: HTMLElement;
        crsCertSection: CrsSectionElement;
        adminCertsSection: CertificateSubpageElement;
        userCertsSection: CertificateSubpageElement;
        platformCertsSection: CertificateSubpageElement;
        platformClientCertsSection: CertificateSubpageElement;
    };
}
export declare class CertificateManagerElement extends CertificateManagerElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        selectedPage_: StringConstructor;
        enterpriseSubpageLists_: {
            type: {
                (arrayLength: number): SubpageCertificateList[];
                (...items: SubpageCertificateList[]): SubpageCertificateList[];
                new (arrayLength: number): SubpageCertificateList[];
                new (...items: SubpageCertificateList[]): SubpageCertificateList[];
                isArray(arg: any): arg is any[];
                readonly prototype: any[];
                from<T>(arrayLike: ArrayLike<T>): T[];
                from<T, U>(arrayLike: ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                from<T>(iterable: Iterable<T> | ArrayLike<T>): T[];
                from<T, U>(iterable: Iterable<T> | ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                of<T>(...items: T[]): T[];
                readonly [Symbol.species]: ArrayConstructor;
            };
            value: () => SubpageCertificateList[];
        };
        platformSubpageLists_: {
            type: {
                (arrayLength: number): SubpageCertificateList[];
                (...items: SubpageCertificateList[]): SubpageCertificateList[];
                new (arrayLength: number): SubpageCertificateList[];
                new (...items: SubpageCertificateList[]): SubpageCertificateList[];
                isArray(arg: any): arg is any[];
                readonly prototype: any[];
                from<T>(arrayLike: ArrayLike<T>): T[];
                from<T, U>(arrayLike: ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                from<T>(iterable: Iterable<T> | ArrayLike<T>): T[];
                from<T, U>(iterable: Iterable<T> | ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                of<T>(...items: T[]): T[];
                readonly [Symbol.species]: ArrayConstructor;
            };
            value: () => SubpageCertificateList[];
        };
        clientPlatformSubpageLists_: {
            type: {
                (arrayLength: number): SubpageCertificateList[];
                (...items: SubpageCertificateList[]): SubpageCertificateList[];
                new (arrayLength: number): SubpageCertificateList[];
                new (...items: SubpageCertificateList[]): SubpageCertificateList[];
                isArray(arg: any): arg is any[];
                readonly prototype: any[];
                from<T>(arrayLike: ArrayLike<T>): T[];
                from<T, U>(arrayLike: ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                from<T>(iterable: Iterable<T> | ArrayLike<T>): T[];
                from<T, U>(iterable: Iterable<T> | ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                of<T>(...items: T[]): T[];
                readonly [Symbol.species]: ArrayConstructor;
            };
            computed: string;
        };
        userSubpageLists_: {
            type: {
                (arrayLength: number): SubpageCertificateList[];
                (...items: SubpageCertificateList[]): SubpageCertificateList[];
                new (arrayLength: number): SubpageCertificateList[];
                new (...items: SubpageCertificateList[]): SubpageCertificateList[];
                isArray(arg: any): arg is any[];
                readonly prototype: any[];
                from<T>(arrayLike: ArrayLike<T>): T[];
                from<T, U>(arrayLike: ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                from<T>(iterable: Iterable<T> | ArrayLike<T>): T[];
                from<T, U>(iterable: Iterable<T> | ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
                of<T>(...items: T[]): T[];
                readonly [Symbol.species]: ArrayConstructor;
            };
            value: () => SubpageCertificateList[];
        };
        toastMessage_: StringConstructor;
        showInfoDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        infoDialogTitle_: StringConstructor;
        infoDialogMessage_: StringConstructor;
        showPasswordDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        confirmationDialogTitle_: StringConstructor;
        confirmationDialogMessage_: StringConstructor;
        showConfirmationDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showSearch_: {
            type: BooleanConstructor;
            value: boolean;
        };
        certificateSourceEnum_: {
            type: ObjectConstructor;
            value: typeof CertificateSource;
        };
        pageEnum_: {
            type: ObjectConstructor;
            value: typeof Page;
        };
        numPlatformClientCertsString_: StringConstructor;
    };
    private selectedPage_;
    private userSubpageLists_;
    private toastMessage_;
    private showInfoDialog_;
    private infoDialogTitle_;
    private infoDialogMessage_;
    private showPasswordDialog_;
    private passwordEntryResolver_;
    private showConfirmationDialog_;
    private showSearch_;
    private confirmationDialogTitle_;
    private confirmationDialogMessage_;
    private confirmationDialogResolver_;
    private enterpriseSubpageLists_;
    private platformSubpageLists_;
    private clientPlatformSubpageLists_;
    private numPlatformClientCertsString_;
    ready(): void;
    private onTriggerReload_;
    private getClientCertCount_;
    private onAskForImportPassword_;
    private onPasswordDialogClose_;
    private onAskForConfirmation_;
    private onConfirmationDialogClose_;
    private onHashCopied_;
    protected onMenuItemClick_(e: MouseEvent): void;
    currentRouteChanged(route: Route, oldRoute: Route): Promise<void>;
    private onMenuItemActivate_;
    private getSelectedTopLevelHref_;
    private generateHrefForPage_;
    private onClientPlatformCertsLinkRowClick_;
    private onImportResult_;
    private onDeleteResult_;
    private onInfoDialogClose_;
    private computeClientPlatformSubpageLists_;
    private onManageCertsExternal_;
}
declare global {
    interface HTMLElementTagNameMap {
        'certificate-manager': CertificateManagerElement;
    }
}
export {};
