/**
 * @fileoverview The 'certificate-list' component shows a list of
 * certificates with a header, an expander, and optionally an "export all"
 * button.
 *
 * This component is used in the new Certificate Management UI in
 * ./certificate_manager.ts.
 */
import '/strings.m.js';
import './certificate_entry.js';
import './certificate_manager_style.css.js';
import '//resources/cr_elements/cr_expand_button/cr_expand_button.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import type { CrCollapseElement } from '//resources/cr_elements/cr_collapse/cr_collapse.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { CertificateSource } from './certificate_manager.mojom-webui.js';
declare const CertificateListElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export interface CertificateListElement {
    $: {
        certs: CrCollapseElement;
        exportCerts: HTMLElement;
        importCert: HTMLElement;
        importAndBindCert: HTMLElement;
        noCertsRow: HTMLElement;
        listHeader: HTMLElement;
        expandButton: HTMLElement;
    };
}
export declare class CertificateListElement extends CertificateListElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        certSource: NumberConstructor;
        headerText: StringConstructor;
        showImport: {
            type: BooleanConstructor;
            value: boolean;
        };
        showImportAndBind: {
            type: BooleanConstructor;
            value: boolean;
        };
        noCollapse: {
            type: BooleanConstructor;
            value: boolean;
        };
        hideExport: {
            type: BooleanConstructor;
            value: boolean;
        };
        hideIfEmpty: {
            type: BooleanConstructor;
            value: boolean;
        };
        hideHeader: {
            type: BooleanConstructor;
            value: boolean;
        };
        certMetadataEditable: {
            type: BooleanConstructor;
            value: boolean;
        };
        inSubpage: {
            type: BooleanConstructor;
            value: boolean;
        };
        expanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        certificates_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        hideEverything_: {
            type: BooleanConstructor;
            computed: string;
        };
        hasCerts_: {
            type: BooleanConstructor;
            computed: string;
        };
    };
    certSource: CertificateSource;
    headerText: string;
    certMetadataEditable: boolean;
    showImport: boolean;
    showImportAndBind: boolean;
    hideExport: boolean;
    hideHeader: boolean;
    inSubpage: boolean;
    noCollapse: boolean;
    hideIfEmpty: boolean;
    private expanded_;
    private hideEverything_;
    private certificates_;
    private hasCerts_;
    ready(): void;
    private onRefreshRequested_;
    private refreshCertificates;
    private onExportCertsClick_;
    private onImportCertClick_;
    private onImportAndBindCertClick_;
    private handleImportResult;
    private onDeleteResult_;
    private computeHasCerts_;
    private computeHideEverything_;
    private hideCollapseButton_;
    private hideExportButton_;
}
declare global {
    interface HTMLElementTagNameMap {
        'certificate-list': CertificateListElement;
    }
}
export {};
