import type { IncognitoAvailability } from './constants.js';
export interface BatchUploadPromoData {
    canShow: boolean;
    promoSubtitle: string;
}
export interface BrowserProxy {
    getIncognitoAvailability(): Promise<IncognitoAvailability>;
    getCanEditBookmarks(): Promise<boolean>;
    getCanUploadBookmarkToAccountStorage(id: string): Promise<boolean>;
    recordInHistogram(histogram: string, bucket: number, maxBucket: number): void;
    onSingleBookmarkUploadClicked(bookmarkId: string): void;
    getBatchUploadPromoInfo(): Promise<BatchUploadPromoData>;
    onBatchUploadPromoClicked(): void;
    onBatchUploadPromoDismissed(): void;
}
export declare class BrowserProxyImpl implements BrowserProxy {
    getIncognitoAvailability(): Promise<any>;
    getCanEditBookmarks(): Promise<any>;
    getCanUploadBookmarkToAccountStorage(id: string): Promise<any>;
    recordInHistogram(histogram: string, bucket: number, maxBucket: number): void;
    onSingleBookmarkUploadClicked(bookmarkId: string): void;
    getBatchUploadPromoInfo(): Promise<any>;
    onBatchUploadPromoClicked(): void;
    onBatchUploadPromoDismissed(): void;
    static getInstance(): BrowserProxy;
    static setInstance(obj: BrowserProxy): void;
}
