/**
 * A side menu that lists the currently navigable pages.
 */
export class Sidebar extends PageManagerObserver {
    /** @param {!Element} sidebarDiv The div corresponding to the sidebar. */
    constructor(sidebarDiv: Element);
    /** @private {!Element} */
    private sidebarDiv_;
    /** @private {!Element} */
    private sidebarContent_;
    /** @private {!Element} */
    private sidebarList_;
    /** @private {!Element} */
    private overlayDiv_;
    /**
     * Adds a new list item to the sidebar using the given |item|.
     * @param {!SidebarItem} item
     */
    addItem(item: SidebarItem): void;
    /**
     * Closes the sidebar. Only applies to layouts with window width <= 600px.
     */
    close(): void;
    /**
     * Opens the sidebar. Only applies to layouts with window width <= 600px.
     */
    open(): void;
    /**
     * Removes a sidebar item where |pageName| matches the item's pageName.
     * @param {string} pageName
     */
    removeItem(pageName: string): void;
    /**
     * Called when a page is navigated to.
     * @override
     * @param {string} path The path of the page being visited.
     */
    override updateHistory(path: string): void;
    /**
     * Switches the page based on which sidebar list button was clicked.
     * @param {!Event} event
     * @private
     */
    private onItemClick_;
}
import { PageManagerObserver } from './page_manager.js';
type SidebarItem = {
    pageName: string;
    text: string;
};
/** @typedef {{pageName: string, text: string}} */
declare let SidebarItem: any;
export {};
