/**
 * Format in a user readable way service UUIDs.
 * Note: UUID type is defined in uuid.mojom-webui.ts, however, pure types
 * are elided by the TS compiler at runtime, so we don't import it here since
 * this file is in JavaScript. The import can be restored when this file is
 * migrated to TypeScript.
 * @param ?Array<UUID> uuids
 * @return {string}
 */
export function formatServiceUuids(serviceUuids: any): string;
/**
 * Format in a user readable way device manufacturer data map. Keys are
 * Bluetooth company identifiers (unsigned short), values are bytes.
 * @param {Map<string, array<number>>} manufacturerDataMap
 * @return {string}
 */
export function formatManufacturerDataMap(manufacturerDataMap: Map<string, array<number>>): string;
