/**
 * Page that displays all of the details of a device. This page is generated
 * and managed dynamically in bluetooth_internals. The page contains two
 * sections: Status and Services. The Status section displays information from
 * the DeviceInfo object and the Services section contains a ServiceList
 * compononent that lists all of the active services on the device.
 */
export class DeviceDetailsPage extends Page {
    /**
     * @param {string} id
     * @param {!DeviceInfo} deviceInfo
     */
    constructor(id: string, deviceInfo: DeviceInfo);
    /** @type {!DeviceInfo} */
    deviceInfo: DeviceInfo;
    /** @type {?Array<ServiceInfo>} */
    services: Array<ServiceInfo> | null;
    /** @private {?DeviceRemote} */
    private device_;
    /** @private {!ObjectFieldSetElement} */
    private deviceFieldSet_;
    /** @private {!ServiceList} */
    private serviceList_;
    /** @private {!ConnectionStatus} */
    private status_;
    /** @private {?Element} */
    private connectBtn_;
    /** Creates a connection to the Bluetooth device. */
    connect(): void;
    /** Disconnects the page from the Bluetooth device. */
    disconnect(): void;
    /** Redraws the contents of the page with the current |deviceInfo|. */
    redraw(): void;
    /**
     * Sets the page's device info and forces a redraw.
     * @param {!DeviceInfo} info
     */
    setDeviceInfo(info: DeviceInfo): void;
    /**
     * Fires an 'infochanged' event with the current |deviceInfo|
     * @private
     */
    private fireDeviceInfoChanged_;
    /**
     * Updates the current connection status. Caches the latest status, updates
     * the connection button message, and fires a 'connectionchanged' event when
     * finished.
     * @param {!ConnectionStatus} status
     * @private
     */
    private updateConnectionStatus_;
}
import { Page } from './page.js';
