// device/bluetooth/public/mojom/device.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UUIDSpec as bluetooth_mojom_UUIDSpec } from './uuid.mojom-webui.js';
export const PropertySpec = { $: mojo.internal.Enum() };
export var Property;
(function (Property) {
    Property[Property["MIN_VALUE"] = 0] = "MIN_VALUE";
    Property[Property["MAX_VALUE"] = 8192] = "MAX_VALUE";
    Property[Property["NONE"] = 0] = "NONE";
    Property[Property["BROADCAST"] = 1] = "BROADCAST";
    Property[Property["READ"] = 2] = "READ";
    Property[Property["WRITE_WITHOUT_RESPONSE"] = 4] = "WRITE_WITHOUT_RESPONSE";
    Property[Property["WRITE"] = 8] = "WRITE";
    Property[Property["NOTIFY"] = 16] = "NOTIFY";
    Property[Property["INDICATE"] = 32] = "INDICATE";
    Property[Property["AUTHENTICATED_SIGNED_WRITES"] = 64] = "AUTHENTICATED_SIGNED_WRITES";
    Property[Property["EXTENDED_PROPERTIES"] = 128] = "EXTENDED_PROPERTIES";
    Property[Property["RELIABLE_WRITE"] = 256] = "RELIABLE_WRITE";
    Property[Property["WRITABLE_AUXILIARIES"] = 512] = "WRITABLE_AUXILIARIES";
    Property[Property["READ_ENCRYPTED"] = 1024] = "READ_ENCRYPTED";
    Property[Property["WRITE_ENCRYPTED"] = 2048] = "WRITE_ENCRYPTED";
    Property[Property["READ_ENCRYPTED_AUTHENTICATED"] = 4096] = "READ_ENCRYPTED_AUTHENTICATED";
    Property[Property["WRITE_ENCRYPTED_AUTHENTICATED"] = 8192] = "WRITE_ENCRYPTED_AUTHENTICATED";
})(Property || (Property = {}));
export const GattResultSpec = { $: mojo.internal.Enum() };
export var GattResult;
(function (GattResult) {
    GattResult[GattResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    GattResult[GattResult["MAX_VALUE"] = 11] = "MAX_VALUE";
    GattResult[GattResult["SUCCESS"] = 0] = "SUCCESS";
    GattResult[GattResult["UNKNOWN"] = 1] = "UNKNOWN";
    GattResult[GattResult["FAILED"] = 2] = "FAILED";
    GattResult[GattResult["IN_PROGRESS"] = 3] = "IN_PROGRESS";
    GattResult[GattResult["INVALID_LENGTH"] = 4] = "INVALID_LENGTH";
    GattResult[GattResult["NOT_PERMITTED"] = 5] = "NOT_PERMITTED";
    GattResult[GattResult["NOT_AUTHORIZED"] = 6] = "NOT_AUTHORIZED";
    GattResult[GattResult["NOT_PAIRED"] = 7] = "NOT_PAIRED";
    GattResult[GattResult["NOT_SUPPORTED"] = 8] = "NOT_SUPPORTED";
    GattResult[GattResult["SERVICE_NOT_FOUND"] = 9] = "SERVICE_NOT_FOUND";
    GattResult[GattResult["CHARACTERISTIC_NOT_FOUND"] = 10] = "CHARACTERISTIC_NOT_FOUND";
    GattResult[GattResult["DESCRIPTOR_NOT_FOUND"] = 11] = "DESCRIPTOR_NOT_FOUND";
})(GattResult || (GattResult = {}));
export class DevicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.Device', scope);
    }
}
export class DeviceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DevicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    disconnect() {
        this.proxy.sendMessage(0, Device_Disconnect_ParamsSpec.$, null, [], false);
    }
    getInfo() {
        return this.proxy.sendMessage(1, Device_GetInfo_ParamsSpec.$, Device_GetInfo_ResponseParamsSpec.$, [], false);
    }
    getServices() {
        return this.proxy.sendMessage(2, Device_GetServices_ParamsSpec.$, Device_GetServices_ResponseParamsSpec.$, [], false);
    }
    getCharacteristics(serviceId) {
        return this.proxy.sendMessage(3, Device_GetCharacteristics_ParamsSpec.$, Device_GetCharacteristics_ResponseParamsSpec.$, [
            serviceId
        ], false);
    }
    readValueForCharacteristic(serviceId, characteristicId) {
        return this.proxy.sendMessage(4, Device_ReadValueForCharacteristic_ParamsSpec.$, Device_ReadValueForCharacteristic_ResponseParamsSpec.$, [
            serviceId,
            characteristicId
        ], false);
    }
    writeValueForCharacteristic(serviceId, characteristicId, value) {
        return this.proxy.sendMessage(5, Device_WriteValueForCharacteristic_ParamsSpec.$, Device_WriteValueForCharacteristic_ResponseParamsSpec.$, [
            serviceId,
            characteristicId,
            value
        ], false);
    }
    getDescriptors(serviceId, characteristicId) {
        return this.proxy.sendMessage(6, Device_GetDescriptors_ParamsSpec.$, Device_GetDescriptors_ResponseParamsSpec.$, [
            serviceId,
            characteristicId
        ], false);
    }
    readValueForDescriptor(serviceId, characteristicId, descriptorId) {
        return this.proxy.sendMessage(7, Device_ReadValueForDescriptor_ParamsSpec.$, Device_ReadValueForDescriptor_ResponseParamsSpec.$, [
            serviceId,
            characteristicId,
            descriptorId
        ], false);
    }
    writeValueForDescriptor(serviceId, characteristicId, descriptorId, value) {
        return this.proxy.sendMessage(8, Device_WriteValueForDescriptor_ParamsSpec.$, Device_WriteValueForDescriptor_ResponseParamsSpec.$, [
            serviceId,
            characteristicId,
            descriptorId,
            value
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Device
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DeviceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DeviceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Device_Disconnect_ParamsSpec.$, null, impl.disconnect.bind(impl), false);
        this.helper_internal_.registerHandler(1, Device_GetInfo_ParamsSpec.$, Device_GetInfo_ResponseParamsSpec.$, impl.getInfo.bind(impl), false);
        this.helper_internal_.registerHandler(2, Device_GetServices_ParamsSpec.$, Device_GetServices_ResponseParamsSpec.$, impl.getServices.bind(impl), false);
        this.helper_internal_.registerHandler(3, Device_GetCharacteristics_ParamsSpec.$, Device_GetCharacteristics_ResponseParamsSpec.$, impl.getCharacteristics.bind(impl), false);
        this.helper_internal_.registerHandler(4, Device_ReadValueForCharacteristic_ParamsSpec.$, Device_ReadValueForCharacteristic_ResponseParamsSpec.$, impl.readValueForCharacteristic.bind(impl), false);
        this.helper_internal_.registerHandler(5, Device_WriteValueForCharacteristic_ParamsSpec.$, Device_WriteValueForCharacteristic_ResponseParamsSpec.$, impl.writeValueForCharacteristic.bind(impl), false);
        this.helper_internal_.registerHandler(6, Device_GetDescriptors_ParamsSpec.$, Device_GetDescriptors_ResponseParamsSpec.$, impl.getDescriptors.bind(impl), false);
        this.helper_internal_.registerHandler(7, Device_ReadValueForDescriptor_ParamsSpec.$, Device_ReadValueForDescriptor_ResponseParamsSpec.$, impl.readValueForDescriptor.bind(impl), false);
        this.helper_internal_.registerHandler(8, Device_WriteValueForDescriptor_ParamsSpec.$, Device_WriteValueForDescriptor_ResponseParamsSpec.$, impl.writeValueForDescriptor.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Device {
    static get $interfaceName() {
        return "bluetooth.mojom.Device";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DeviceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Device
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DeviceCallbackRouter {
    helper_internal_;
    $;
    router_;
    disconnect;
    getInfo;
    getServices;
    getCharacteristics;
    readValueForCharacteristic;
    writeValueForCharacteristic;
    getDescriptors;
    readValueForDescriptor;
    writeValueForDescriptor;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DeviceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.disconnect =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Device_Disconnect_ParamsSpec.$, null, this.disconnect.createReceiverHandler(false /* expectsResponse */), false);
        this.getInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Device_GetInfo_ParamsSpec.$, Device_GetInfo_ResponseParamsSpec.$, this.getInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Device_GetServices_ParamsSpec.$, Device_GetServices_ResponseParamsSpec.$, this.getServices.createReceiverHandler(true /* expectsResponse */), false);
        this.getCharacteristics =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Device_GetCharacteristics_ParamsSpec.$, Device_GetCharacteristics_ResponseParamsSpec.$, this.getCharacteristics.createReceiverHandler(true /* expectsResponse */), false);
        this.readValueForCharacteristic =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Device_ReadValueForCharacteristic_ParamsSpec.$, Device_ReadValueForCharacteristic_ResponseParamsSpec.$, this.readValueForCharacteristic.createReceiverHandler(true /* expectsResponse */), false);
        this.writeValueForCharacteristic =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Device_WriteValueForCharacteristic_ParamsSpec.$, Device_WriteValueForCharacteristic_ResponseParamsSpec.$, this.writeValueForCharacteristic.createReceiverHandler(true /* expectsResponse */), false);
        this.getDescriptors =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Device_GetDescriptors_ParamsSpec.$, Device_GetDescriptors_ResponseParamsSpec.$, this.getDescriptors.createReceiverHandler(true /* expectsResponse */), false);
        this.readValueForDescriptor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Device_ReadValueForDescriptor_ParamsSpec.$, Device_ReadValueForDescriptor_ResponseParamsSpec.$, this.readValueForDescriptor.createReceiverHandler(true /* expectsResponse */), false);
        this.writeValueForDescriptor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Device_WriteValueForDescriptor_ParamsSpec.$, Device_WriteValueForDescriptor_ResponseParamsSpec.$, this.writeValueForDescriptor.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const RSSIWrapperSpec = { $: {} };
export const DeviceInfoSpec = { $: {} };
export const ServiceInfoSpec = { $: {} };
export const CharacteristicInfoSpec = { $: {} };
export const DescriptorInfoSpec = { $: {} };
export const Device_Disconnect_ParamsSpec = { $: {} };
export const Device_GetInfo_ParamsSpec = { $: {} };
export const Device_GetInfo_ResponseParamsSpec = { $: {} };
export const Device_GetServices_ParamsSpec = { $: {} };
export const Device_GetServices_ResponseParamsSpec = { $: {} };
export const Device_GetCharacteristics_ParamsSpec = { $: {} };
export const Device_GetCharacteristics_ResponseParamsSpec = { $: {} };
export const Device_ReadValueForCharacteristic_ParamsSpec = { $: {} };
export const Device_ReadValueForCharacteristic_ResponseParamsSpec = { $: {} };
export const Device_WriteValueForCharacteristic_ParamsSpec = { $: {} };
export const Device_WriteValueForCharacteristic_ResponseParamsSpec = { $: {} };
export const Device_GetDescriptors_ParamsSpec = { $: {} };
export const Device_GetDescriptors_ResponseParamsSpec = { $: {} };
export const Device_ReadValueForDescriptor_ParamsSpec = { $: {} };
export const Device_ReadValueForDescriptor_ResponseParamsSpec = { $: {} };
export const Device_WriteValueForDescriptor_ParamsSpec = { $: {} };
export const Device_WriteValueForDescriptor_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(RSSIWrapperSpec.$, 'RSSIWrapper', [
    mojo.internal.StructField('value', 0, 0, mojo.internal.Int8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DeviceInfoSpec.$, 'DeviceInfo', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('nameForDisplay', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('address', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isGattConnected', 24, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rssi', 32, 0, RSSIWrapperSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('serviceUuids', 40, 0, mojo.internal.Array(bluetooth_mojom_UUIDSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('manufacturerDataMap', 48, 0, mojo.internal.Map(mojo.internal.Uint16, mojo.internal.Array(mojo.internal.Uint8, false), false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('serviceDataMap', 56, 0, mojo.internal.Map(bluetooth_mojom_UUIDSpec.$, mojo.internal.Array(mojo.internal.Uint8, false), false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 72],]);
mojo.internal.Struct(ServiceInfoSpec.$, 'ServiceInfo', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('uuid', 8, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isPrimary', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(CharacteristicInfoSpec.$, 'CharacteristicInfo', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('uuid', 8, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('properties', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permissions', 20, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastKnownValue', 24, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(DescriptorInfoSpec.$, 'DescriptorInfo', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('uuid', 8, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastKnownValue', 16, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Device_Disconnect_ParamsSpec.$, 'Device_Disconnect_Params', [], [[0, 8],]);
mojo.internal.Struct(Device_GetInfo_ParamsSpec.$, 'Device_GetInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(Device_GetInfo_ResponseParamsSpec.$, 'Device_GetInfo_ResponseParams', [
    mojo.internal.StructField('info', 0, 0, DeviceInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Device_GetServices_ParamsSpec.$, 'Device_GetServices_Params', [], [[0, 8],]);
mojo.internal.Struct(Device_GetServices_ResponseParamsSpec.$, 'Device_GetServices_ResponseParams', [
    mojo.internal.StructField('services', 0, 0, mojo.internal.Array(ServiceInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Device_GetCharacteristics_ParamsSpec.$, 'Device_GetCharacteristics_Params', [
    mojo.internal.StructField('serviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Device_GetCharacteristics_ResponseParamsSpec.$, 'Device_GetCharacteristics_ResponseParams', [
    mojo.internal.StructField('characteristics', 0, 0, mojo.internal.Array(CharacteristicInfoSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Device_ReadValueForCharacteristic_ParamsSpec.$, 'Device_ReadValueForCharacteristic_Params', [
    mojo.internal.StructField('serviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('characteristicId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Device_ReadValueForCharacteristic_ResponseParamsSpec.$, 'Device_ReadValueForCharacteristic_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GattResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Device_WriteValueForCharacteristic_ParamsSpec.$, 'Device_WriteValueForCharacteristic_Params', [
    mojo.internal.StructField('serviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('characteristicId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 16, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Device_WriteValueForCharacteristic_ResponseParamsSpec.$, 'Device_WriteValueForCharacteristic_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GattResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Device_GetDescriptors_ParamsSpec.$, 'Device_GetDescriptors_Params', [
    mojo.internal.StructField('serviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('characteristicId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Device_GetDescriptors_ResponseParamsSpec.$, 'Device_GetDescriptors_ResponseParams', [
    mojo.internal.StructField('descriptors', 0, 0, mojo.internal.Array(DescriptorInfoSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Device_ReadValueForDescriptor_ParamsSpec.$, 'Device_ReadValueForDescriptor_Params', [
    mojo.internal.StructField('serviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('characteristicId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptorId', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Device_ReadValueForDescriptor_ResponseParamsSpec.$, 'Device_ReadValueForDescriptor_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GattResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Device_WriteValueForDescriptor_ParamsSpec.$, 'Device_WriteValueForDescriptor_Params', [
    mojo.internal.StructField('serviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('characteristicId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptorId', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 24, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(Device_WriteValueForDescriptor_ResponseParamsSpec.$, 'Device_WriteValueForDescriptor_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, GattResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
