/**
 * Initializes an AdapterBroker if one doesn't exist.
 * @param {!BluetoothInternalsHandlerRemote=}
 *     opt_bluetoothInternalsHandler
 * @return {!Promise<!AdapterBroker>} resolves with
 *     AdapterBroker, rejects if Bluetooth is not supported.
 */
export function getAdapterBroker(opt_bluetoothInternalsHandler?: BluetoothInternalsHandlerRemote | undefined): Promise<AdapterBroker>;
/**
 * Enum of adapter property names. Used for adapterchanged events.
 */
export type AdapterProperty = string;
export namespace AdapterProperty {
    let DISCOVERABLE: string;
    let DISCOVERING: string;
    let POWERED: string;
    let PRESENT: string;
}
/**
 * The proxy class of an adapter and router of adapter events.
 * Exposes an EventTarget interface that allows other object to subscribe to
 * to specific AdapterObserver events.
 * Provides remote access to Adapter functions. Converts parameters to Mojo
 * handles and back when necessary.
 *
 * @implements {AdapterObserverInterface}
 */
export class AdapterBroker extends EventTarget implements AdapterObserverInterface {
    /** @param {!AdapterRemote} adapter */
    constructor(adapter: AdapterRemote);
    adapterObserverReceiver_: AdapterObserverReceiver;
    adapter_: AdapterRemote;
    presentChanged(present: any): void;
    poweredChanged(powered: any): void;
    discoverableChanged(discoverable: any): void;
    discoveringChanged(discovering: any): void;
    deviceAdded(device: any): void;
    deviceChanged(device: any): void;
    deviceRemoved(device: any): void;
    /**
     * Creates a GATT connection to the device with |address|.
     * @param {string} address
     * @return {!Promise<!Device>}
     */
    connectToDevice(address: string): Promise<Device>;
    /**
     * Gets an array of currently detectable devices from the Adapter service.
     * @return {Promise<{devices: Array<!DeviceInfo>}>}
     */
    getDevices(): Promise<{
        devices: Array<DeviceInfo>;
    }>;
    /**
     * Gets the current state of the Adapter.
     * @return {Promise<{info: AdapterInfo}>}
     */
    getInfo(): Promise<{
        info: AdapterInfo;
    }>;
    /**
     * Requests the adapter to start a new discovery session.
     * @return {!Promise<!DiscoverySessionRemote>}
     */
    startDiscoverySession(): Promise<DiscoverySessionRemote>;
}
import { BluetoothInternalsHandlerRemote } from './bluetooth_internals.mojom-webui.js';
import { AdapterObserverReceiver } from './adapter.mojom-webui.js';
import { AdapterRemote } from './adapter.mojom-webui.js';
import { Device } from './device.mojom-webui.js';
import { DiscoverySessionRemote } from './adapter.mojom-webui.js';
