// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{getRequiredElement}from"//resources/js/util.js";import{BrowserProxy}from"./browser_proxy.js";class ActorEventLog{table;template;spanIdCounter=0;activeSpans=[];spanState=new Map;indentationByTrack=new Map;constructor(){this.table=getRequiredElement("actor-events-table");this.template=getRequiredElement("actor-events-row")}getState(row){const rowSpanId=Number(row.dataset["spanId"]);return this.spanState.get(rowSpanId)}getParentIds(row){const state=this.getState(row);return state?state.parentIds:[]}isCollapsed(row){const state=this.getState(row);return state?state.collapsed:false}isAnyParentCollapsed(row){for(const parentId of this.getParentIds(row)){const parentState=this.spanState.get(parentId);if(parentState&&parentState.collapsed){return true}}return false}getIndentation(track){return this.indentationByTrack.get(track)||0}incrementIndentation(track){this.indentationByTrack.set(track,this.getIndentation(track)+1)}decrementIndentation(track){const newLevel=Math.max(0,this.getIndentation(track)-1);this.indentationByTrack.set(track,newLevel)}addEntry(entry){const{row:row,cells:cells}=this.createRow(entry);const typeCell=cells[3];const detailsCell=cells[4];if(entry.track==="FrontEnd"){typeCell.classList.add("frontend-track")}this.formatTypeCell(entry,row,typeCell);this.formatDetailsCell(entry,detailsCell);this.insertRow(row,entry.timestamp.getTime())}createRow(entry){const clone=this.template.content.cloneNode(true);const row=clone.children[0];row.dataset["timestamp"]=entry.timestamp.getTime().toString();row.dataset["taskId"]=entry.taskId.toString();row.dataset["type"]=entry.type.toString();row.dataset["track"]=entry.track.toString();const cells=clone.querySelectorAll("td");cells[0].textContent=entry.taskId===0?"":entry.taskId.toString();cells[1].textContent=entry.url;cells[2].textContent=entry.event;cells[5].textContent=new Date(entry.timestamp).toLocaleTimeString(undefined,{hour12:false,timeZoneName:"short"});return{row:row,cells:cells}}formatDetailsCell(entry,detailsCell){if(entry.event==="GlicPerformActions"&&entry.details.startsWith("proto=")){const protobytes=entry.details.substring("proto=".length);const link=document.createElement("a");link.textContent="Actions Proto";link.href=`https://protoshop.corp.google.com/embed?tabs=viewer,editor&type=chrome_intelligence_proto_features.Actions&protobytes=${protobytes}`;link.target="_blank";detailsCell.appendChild(link)}else if(entry.screenshot){const byteArray=new Uint8Array(entry.screenshot);const blob=new Blob([byteArray],{type:"image/jpeg"});const blobUrl=URL.createObjectURL(blob);const img=document.createElement("img");img.src=blobUrl;img.style.width="200px";img.style.height="100px";img.style.cursor="pointer";img.onclick=()=>{const newTab=window.open(blobUrl,"_blank");if(newTab){newTab.focus()}};detailsCell.appendChild(img)}else{detailsCell.textContent=entry.details}}formatTypeCell(entry,row,typeCell){const typeSpan=document.createElement("span");typeCell.classList.add("type-cell");const newSpanId=this.spanIdCounter++;row.dataset["spanId"]=newSpanId.toString();let indentLevel=0;let parentIds=[];if(entry.type==="Begin"){indentLevel=this.getIndentation(entry.track);parentIds=this.activeSpans.map((s=>s.id));typeCell.textContent=" ".repeat(indentLevel*2)+"+ ";typeCell.onclick=()=>this.toggleSpan(row);this.spanState.set(newSpanId,{collapsed:false,parentIds:parentIds});this.activeSpans.push({id:newSpanId,track:entry.track,event:entry.event});this.incrementIndentation(entry.track);typeSpan.className="type-b"}else if(entry.type==="End"){this.decrementIndentation(entry.track);indentLevel=this.getIndentation(entry.track);parentIds=this.activeSpans.map((s=>s.id));let endedSpanIndex=-1;for(let i=this.activeSpans.length-1;i>=0;i--){if(this.activeSpans[i].track===entry.track&&this.activeSpans[i].event.startsWith(entry.event)){endedSpanIndex=i;break}}if(endedSpanIndex>-1){this.activeSpans.splice(endedSpanIndex,1)}typeCell.textContent=" ".repeat(indentLevel*2)+"  ";this.spanState.set(newSpanId,{collapsed:false,parentIds:parentIds});typeSpan.className="type-e"}else{indentLevel=this.getIndentation(entry.track);parentIds=this.activeSpans.map((s=>s.id));typeCell.textContent=" ".repeat(indentLevel*2)+"  ";this.spanState.set(newSpanId,{collapsed:false,parentIds:parentIds})}typeSpan.textContent=entry.type;typeCell.appendChild(typeSpan);typeCell.classList.add("whitespace-pre")}insertRow(row,newTimestamp){const rows=this.table.rows;for(let i=rows.length-1;i>0;i--){const existingTimestamp=Number(rows[i].dataset["timestamp"]);if(newTimestamp>=existingTimestamp){rows[i].after(row);return}}rows[0].after(row)}toggleSpan(row){const toggledSpanId=Number(row.dataset["spanId"]);const state=this.spanState.get(toggledSpanId);if(!state){return}const toCollapse=!state.collapsed;state.collapsed=toCollapse;const typeCell=row.querySelector(".type-cell");const textNode=typeCell.childNodes[0];textNode.nodeValue=toCollapse?textNode.nodeValue.replace("+","-"):textNode.nodeValue.replace("-","+");for(let i=row.rowIndex+1;i<this.table.rows.length;i++){const childRow=this.table.rows[i];const parentSpans=this.getParentIds(childRow);if(!parentSpans.includes(toggledSpanId)){break}if(childRow.dataset["track"]!==row.dataset["track"]){continue}const isHidden=this.isAnyParentCollapsed(childRow);childRow.style.display=isHidden?"none":"";if(!isHidden&&!toCollapse){childRow.classList.add("newly-uncollapsed");setTimeout((()=>{childRow.classList.remove("newly-uncollapsed")}),2e3)}}}clearFilter(){getRequiredElement("task-id-filter").value="";const rows=Array.from(this.table.rows);for(let i=1;i<rows.length;i++){const row=rows[i];row.style.display=this.isAnyParentCollapsed(row)?"none":""}}filterByTaskId(){const taskId=getRequiredElement("task-id-filter").value.trim();if(!taskId){this.clearFilter();return}const rows=Array.from(this.table.rows);let firstIndex=-1;let lastIndex=-1;for(let i=1;i<rows.length;i++){if(rows[i].dataset["taskId"]===taskId){if(firstIndex===-1){firstIndex=i}lastIndex=i}}if(firstIndex===-1){for(let i=1;i<rows.length;i++){rows[i].style.display="none"}return}for(let i=1;i<rows.length;i++){const row=rows[i];const inRange=i>=firstIndex&&i<=lastIndex;if(!inRange){row.style.display="none"}else{row.style.display=this.isAnyParentCollapsed(row)?"none":""}}}}function startLogging(){BrowserProxy.getInstance().handler.startLogging();getRequiredElement("start-logging").style.display="none";getRequiredElement("stop-logging").style.display="inline-block"}function stopLogging(){BrowserProxy.getInstance().handler.stopLogging();getRequiredElement("start-logging").style.display="inline-block";getRequiredElement("stop-logging").style.display="none"}window.onload=function(){const proxy=BrowserProxy.getInstance();const log=new ActorEventLog;proxy.callbackRouter.journalEntryAdded.addListener((entry=>log.addEntry(entry)));getRequiredElement("start-logging").onclick=startLogging;getRequiredElement("stop-logging").onclick=stopLogging;getRequiredElement("filter-by-task-id").onclick=()=>log.filterByTaskId();getRequiredElement("clear-filter").onclick=()=>log.clearFilter()};