import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface PasscodeInputElement {
    $: {
        inputElement: HTMLInputElement;
        container: HTMLElement;
    };
}
export declare class PasscodeInputElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        ariaLabel: {
            type: StringConstructor;
            value: string;
        };
        charDisplayBoxes: ArrayConstructor;
        disabled: {
            type: BooleanConstructor;
            observer: string;
        };
        length: NumberConstructor;
        value: {
            type: StringConstructor;
            value: string;
            observer: string;
            notify: boolean;
            reflectToAttribute: boolean;
        };
    };
    ariaLabel: string;
    private charDisplayBoxes;
    disabled: boolean;
    length: number;
    value: string;
    focused: boolean;
    private afterFirstRender;
    private static readonly PASSCODE_INPUT_SIZE;
    private static readonly PASSCODE_BOX_SPACING;
    constructor();
    ready(): void;
    getCharBox(boxIndex: number): HTMLElement;
    getDisplayChar(charIndex: number): HTMLElement;
    focusInput(): void;
    private disabledChange;
    private valueChange;
    private makeActive;
    private renderSelection;
    private placeCursor;
    private removeCursor;
    private forEach;
    private handleOnFocus;
    private handleOnBlur;
    private handleOnInput;
    private displayChars;
    private afterPageLoaded;
}
declare global {
    interface HTMLElementTagNameMap {
        'c2c-passcode-input': PasscodeInputElement;
    }
}
