// chrome/browser/ui/webui/access_code_cast/access_code_cast.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  RouteRequestResultCodeSpec as mediaRouter_mojom_RouteRequestResultCodeSpec,
  RouteRequestResultCode as mediaRouter_mojom_RouteRequestResultCode
} from './route_request_result_code.mojom-webui.js';





export const AddSinkResultCodeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum AddSinkResultCode {

  MIN_VALUE = 0,
  MAX_VALUE = 14,
  UNKNOWN_ERROR = 0,
  OK = 1,
  AUTH_ERROR = 2,
  HTTP_RESPONSE_CODE_ERROR = 3,
  RESPONSE_MALFORMED = 4,
  EMPTY_RESPONSE = 5,
  INVALID_ACCESS_CODE = 6,
  ACCESS_CODE_NOT_FOUND = 7,
  TOO_MANY_REQUESTS = 8,
  SERVICE_NOT_PRESENT = 9,
  SERVER_ERROR = 10,
  SINK_CREATION_ERROR = 11,
  CHANNEL_OPEN_ERROR = 12,
  PROFILE_SYNC_ERROR = 13,
  INTERNAL_MEDIA_ROUTER_ERROR = 14,
}

export const CastDiscoveryMethodSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CastDiscoveryMethod {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  QR_CODE = 0,
  INPUT_ACCESS_CODE = 1,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'access_code_cast.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "access_code_cast.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'access_code_cast.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  addSink(accessCode: string, discoveryMethod: CastDiscoveryMethod): Promise<{
        resultCode: AddSinkResultCode, }>;
  castToSink(): Promise<{
        resultCode: mediaRouter_mojom_RouteRequestResultCode, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  addSink(
      accessCode: string,
      discoveryMethod: CastDiscoveryMethod): Promise<{
        resultCode: AddSinkResultCode, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_AddSink_ParamsSpec.$,
        PageHandler_AddSink_ResponseParamsSpec.$,
        [
          accessCode,
          discoveryMethod
        ],
        false);
  }

  castToSink(): Promise<{
        resultCode: mediaRouter_mojom_RouteRequestResultCode, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_CastToSink_ParamsSpec.$,
        PageHandler_CastToSink_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_AddSink_ParamsSpec.$,
        PageHandler_AddSink_ResponseParamsSpec.$,
        impl.addSink.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_CastToSink_ParamsSpec.$,
        PageHandler_CastToSink_ResponseParamsSpec.$,
        impl.castToSink.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "access_code_cast.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  addSink: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  castToSink: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.addSink =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_AddSink_ParamsSpec.$,
        PageHandler_AddSink_ResponseParamsSpec.$,
        this.addSink.createReceiverHandler(true /* expectsResponse */),
        false);
    this.castToSink =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_CastToSink_ParamsSpec.$,
        PageHandler_CastToSink_ResponseParamsSpec.$,
        this.castToSink.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'access_code_cast.mojom.Page',
        scope);
  }
}

export interface PageInterface {
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(_impl: PageInterface) {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "access_code_cast.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AddSink_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AddSink_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CastToSink_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CastToSink_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_AddSink_ParamsMojoType {
  accessCode: string;
  discoveryMethod: CastDiscoveryMethod;
}


export type PageHandler_AddSink_Params = PageHandler_AddSink_ParamsMojoType;
mojo.internal.Struct<PageHandler_AddSink_ParamsMojoType>(
    PageHandler_AddSink_ParamsSpec.$,
    'PageHandler_AddSink_Params',
    [
      mojo.internal.StructField<PageHandler_AddSink_ParamsMojoType, string>(
        'accessCode', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_AddSink_ParamsMojoType, CastDiscoveryMethod>(
        'discoveryMethod', 8,
        0,
        CastDiscoveryMethodSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_AddSink_ResponseParamsMojoType {
  resultCode: AddSinkResultCode;
}


export type PageHandler_AddSink_ResponseParams = PageHandler_AddSink_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_AddSink_ResponseParamsMojoType>(
    PageHandler_AddSink_ResponseParamsSpec.$,
    'PageHandler_AddSink_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_AddSink_ResponseParamsMojoType, AddSinkResultCode>(
        'resultCode', 0,
        0,
        AddSinkResultCodeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CastToSink_ParamsMojoType {
}


export type PageHandler_CastToSink_Params = PageHandler_CastToSink_ParamsMojoType;
mojo.internal.Struct<PageHandler_CastToSink_ParamsMojoType>(
    PageHandler_CastToSink_ParamsSpec.$,
    'PageHandler_CastToSink_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_CastToSink_ResponseParamsMojoType {
  resultCode: mediaRouter_mojom_RouteRequestResultCode;
}


export type PageHandler_CastToSink_ResponseParams = PageHandler_CastToSink_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_CastToSink_ResponseParamsMojoType>(
    PageHandler_CastToSink_ResponseParamsSpec.$,
    'PageHandler_CastToSink_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_CastToSink_ResponseParamsMojoType, mediaRouter_mojom_RouteRequestResultCode>(
        'resultCode', 0,
        0,
        mediaRouter_mojom_RouteRequestResultCodeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



