// chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_TAB_GROUPS_TAB_GROUPS_MOJOM_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_TAB_GROUPS_TAB_GROUPS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-forward.h"  // IWYU pragma: export
#include "components/tab_groups/public/mojom/tab_group_types.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ntp::tab_groups::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ntp.tab_groups.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateNewTabGroupMinVersion = 0,
    kGetTabGroupsMinVersion = 0,
    kOpenTabGroupMinVersion = 0,
    kDismissModuleMinVersion = 0,
    kRestoreModuleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateNewTabGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabGroups_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenTabGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DismissModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RestoreModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void CreateNewTabGroup() = 0;

  using GetTabGroupsCallback = base::OnceCallback<void(std::optional<std::vector<TabGroupPtr>>, bool)>;
  using GetTabGroupsMojoCallback = base::OnceCallback<void(std::optional<std::vector<TabGroupPtr>>, bool)>;

  virtual void GetTabGroups(GetTabGroupsCallback callback) = 0;

  virtual void OpenTabGroup(const std::string& id) = 0;

  virtual void DismissModule() = 0;

  virtual void RestoreModule() = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateNewTabGroup() final;
  
  void GetTabGroups(GetTabGroupsCallback callback) final;
  
  void OpenTabGroup(const std::string& id) final;
  
  void DismissModule() final;
  
  void RestoreModule() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  TabGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabGroup, T>::value>;
  using DataView = TabGroupDataView;
  using Data_ = internal::TabGroup_Data;

  template <typename... Args>
  static TabGroupPtr New(Args&&... args) {
    return TabGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabGroupPtr From(const U& u) {
    return mojo::TypeConverter<TabGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabGroup>::Convert(*this);
  }


  TabGroup();

  TabGroup(
      const std::string& id,
      const std::string& title,
      const std::string& update_time,
      const std::optional<std::string>& device_name,
      int32_t total_tab_count,
      ::tab_groups::TabGroupColorId color,
      std::vector<::GURL> favicon_urls,
      bool is_shared_tab_group);


  ~TabGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabGroupPtr>
  TabGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabGroup_UnserializedMessageContext<
            UserType, TabGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabGroup_UnserializedMessageContext<
            UserType, TabGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string title;
  
  std::string update_time;
  
  std::optional<std::string> device_name;
  
  int32_t total_tab_count;
  
  ::tab_groups::TabGroupColorId color;
  
  std::vector<::GURL> favicon_urls;
  
  bool is_shared_tab_group;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TabGroupPtr TabGroup::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(title),
      mojo::Clone(update_time),
      mojo::Clone(device_name),
      mojo::Clone(total_tab_count),
      mojo::Clone(color),
      mojo::Clone(favicon_urls),
      mojo::Clone(is_shared_tab_group)
  );
}

template <typename T, TabGroup::EnableIfSame<T>*>
bool TabGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->update_time, other_struct.update_time))
    return false;
  if (!mojo::Equals(this->device_name, other_struct.device_name))
    return false;
  if (!mojo::Equals(this->total_tab_count, other_struct.total_tab_count))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->favicon_urls, other_struct.favicon_urls))
    return false;
  if (!mojo::Equals(this->is_shared_tab_group, other_struct.is_shared_tab_group))
    return false;
  return true;
}

template <typename T, TabGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.update_time < rhs.update_time)
    return true;
  if (rhs.update_time < lhs.update_time)
    return false;
  if (lhs.device_name < rhs.device_name)
    return true;
  if (rhs.device_name < lhs.device_name)
    return false;
  if (lhs.total_tab_count < rhs.total_tab_count)
    return true;
  if (rhs.total_tab_count < lhs.total_tab_count)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.favicon_urls < rhs.favicon_urls)
    return true;
  if (rhs.favicon_urls < lhs.favicon_urls)
    return false;
  if (lhs.is_shared_tab_group < rhs.is_shared_tab_group)
    return true;
  if (rhs.is_shared_tab_group < lhs.is_shared_tab_group)
    return false;
  return false;
}


}  // ntp::tab_groups::mojom

namespace mojo {


template <>
struct  StructTraits<::ntp::tab_groups::mojom::TabGroup::DataView,
                                         ::ntp::tab_groups::mojom::TabGroupPtr> {
  static bool IsNull(const ::ntp::tab_groups::mojom::TabGroupPtr& input) { return !input; }
  static void SetToNull(::ntp::tab_groups::mojom::TabGroupPtr* output) { output->reset(); }

  static const decltype(::ntp::tab_groups::mojom::TabGroup::id)& id(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->id;
  }

  static const decltype(::ntp::tab_groups::mojom::TabGroup::title)& title(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->title;
  }

  static const decltype(::ntp::tab_groups::mojom::TabGroup::update_time)& update_time(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->update_time;
  }

  static const decltype(::ntp::tab_groups::mojom::TabGroup::device_name)& device_name(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->device_name;
  }

  static decltype(::ntp::tab_groups::mojom::TabGroup::total_tab_count) total_tab_count(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->total_tab_count;
  }

  static decltype(::ntp::tab_groups::mojom::TabGroup::color) color(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->color;
  }

  static const decltype(::ntp::tab_groups::mojom::TabGroup::favicon_urls)& favicon_urls(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->favicon_urls;
  }

  static decltype(::ntp::tab_groups::mojom::TabGroup::is_shared_tab_group) is_shared_tab_group(
      const ::ntp::tab_groups::mojom::TabGroupPtr& input) {
    return input->is_shared_tab_group;
  }

  static bool Read(::ntp::tab_groups::mojom::TabGroup::DataView input, ::ntp::tab_groups::mojom::TabGroupPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_TAB_GROUPS_TAB_GROUPS_MOJOM_H_