// chrome/browser/lens/core/mojom/polygon.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/lens/core/mojom/polygon.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/polygon.mojom-params-data.h"
namespace lens {
namespace mojom {

NOINLINE static const char* Polygon_VertexOrderingToStringHelper(Polygon_VertexOrdering value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Polygon_VertexOrdering::kUnspecified:
      return "kUnspecified";
    case Polygon_VertexOrdering::kClockwise:
      return "kClockwise";
    case Polygon_VertexOrdering::kCounterClockwise:
      return "kCounterClockwise";
    default:
      return nullptr;
  }
}

std::string Polygon_VertexOrderingToString(Polygon_VertexOrdering value) {
  const char *str = Polygon_VertexOrderingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Polygon_VertexOrdering value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Polygon_VertexOrdering value) {
  return os << Polygon_VertexOrderingToString(value);
}

NOINLINE static const char* Polygon_CoordinateTypeToStringHelper(Polygon_CoordinateType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Polygon_CoordinateType::kUnspecified:
      return "kUnspecified";
    case Polygon_CoordinateType::kNormalized:
      return "kNormalized";
    case Polygon_CoordinateType::kImage:
      return "kImage";
    default:
      return nullptr;
  }
}

std::string Polygon_CoordinateTypeToString(Polygon_CoordinateType value) {
  const char *str = Polygon_CoordinateTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Polygon_CoordinateType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Polygon_CoordinateType value) {
  return os << Polygon_CoordinateTypeToString(value);
}

namespace internal {


// static
bool Polygon_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Polygon_Data* object =
      static_cast<const Polygon_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->vertex, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& vertex_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->vertex, validation_context,
                                         &vertex_validate_params)) {
    return false;
  }


  if (!::lens::mojom::internal::Polygon_VertexOrdering_Data
        ::Validate(object->vertex_ordering, validation_context))
    return false;


  if (!::lens::mojom::internal::Polygon_CoordinateType_Data
        ::Validate(object->coordinate_type, validation_context))
    return false;

  return true;
}

Polygon_Data::Polygon_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Vertex_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Vertex_Data* object =
      static_cast<const Vertex_Data*>(data);

  return true;
}

Vertex_Data::Vertex_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace lens

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::Polygon_VertexOrdering>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::Polygon_VertexOrdering value) {
  return std::move(context).WriteString(::lens::mojom::Polygon_VertexOrderingToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::Polygon_CoordinateType>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::Polygon_CoordinateType value) {
  return std::move(context).WriteString(::lens::mojom::Polygon_CoordinateTypeToString(value));
}

} // namespace perfetto