// chrome/browser/lens/core/mojom/lens_side_panel.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-params-data.h"
namespace lens {
namespace mojom {

NOINLINE static const char* SidePanelResultStatusToStringHelper(SidePanelResultStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SidePanelResultStatus::kUnknown:
      return "kUnknown";
    case SidePanelResultStatus::kResultShown:
      return "kResultShown";
    case SidePanelResultStatus::kErrorPageShownOffline:
      return "kErrorPageShownOffline";
    case SidePanelResultStatus::kErrorPageShownStartQueryError:
      return "kErrorPageShownStartQueryError";
    case SidePanelResultStatus::kErrorPageShownProtected:
      return "kErrorPageShownProtected";
    default:
      return nullptr;
  }
}

std::string SidePanelResultStatusToString(SidePanelResultStatus value) {
  const char *str = SidePanelResultStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SidePanelResultStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SidePanelResultStatus value) {
  return os << SidePanelResultStatusToString(value);
}

namespace internal {


// static
bool LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data* object =
      static_cast<const LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data::LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data* object =
      static_cast<const LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data*>(data);

  return true;
}

LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data::LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data* object =
      static_cast<const LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data*>(data);

  return true;
}

LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data::LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data* object =
      static_cast<const LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data*>(data);

  return true;
}

LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data::LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPageHandler_OnScrollToMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandler_OnScrollToMessage_Params_Data* object =
      static_cast<const LensSidePanelPageHandler_OnScrollToMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_fragments, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_fragments_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->text_fragments, validation_context,
                                         &text_fragments_validate_params)) {
    return false;
  }

  return true;
}

LensSidePanelPageHandler_OnScrollToMessage_Params_Data::LensSidePanelPageHandler_OnScrollToMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPageHandler_RequestSendFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandler_RequestSendFeedback_Params_Data* object =
      static_cast<const LensSidePanelPageHandler_RequestSendFeedback_Params_Data*>(data);

  return true;
}

LensSidePanelPageHandler_RequestSendFeedback_Params_Data::LensSidePanelPageHandler_RequestSendFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPageHandler_OnAimMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandler_OnAimMessage_Params_Data* object =
      static_cast<const LensSidePanelPageHandler_OnAimMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

LensSidePanelPageHandler_OnAimMessage_Params_Data::LensSidePanelPageHandler_OnAimMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data* object =
      static_cast<const LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data*>(data);

  return true;
}

LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data::LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_LoadResultsInFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_LoadResultsInFrame_Params_Data* object =
      static_cast<const LensSidePanelPage_LoadResultsInFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->results_url, validation_context))
    return false;

  return true;
}

LensSidePanelPage_LoadResultsInFrame_Params_Data::LensSidePanelPage_LoadResultsInFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_SetIsLoadingResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_SetIsLoadingResults_Params_Data* object =
      static_cast<const LensSidePanelPage_SetIsLoadingResults_Params_Data*>(data);

  return true;
}

LensSidePanelPage_SetIsLoadingResults_Params_Data::LensSidePanelPage_SetIsLoadingResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_SetPageContentUploadProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_SetPageContentUploadProgress_Params_Data* object =
      static_cast<const LensSidePanelPage_SetPageContentUploadProgress_Params_Data*>(data);

  return true;
}

LensSidePanelPage_SetPageContentUploadProgress_Params_Data::LensSidePanelPage_SetPageContentUploadProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_SetBackArrowVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_SetBackArrowVisible_Params_Data* object =
      static_cast<const LensSidePanelPage_SetBackArrowVisible_Params_Data*>(data);

  return true;
}

LensSidePanelPage_SetBackArrowVisible_Params_Data::LensSidePanelPage_SetBackArrowVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_SetShowErrorPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_SetShowErrorPage_Params_Data* object =
      static_cast<const LensSidePanelPage_SetShowErrorPage_Params_Data*>(data);


  if (!::lens::mojom::internal::SidePanelResultStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

LensSidePanelPage_SetShowErrorPage_Params_Data::LensSidePanelPage_SetShowErrorPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_SuppressGhostLoader_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_SuppressGhostLoader_Params_Data* object =
      static_cast<const LensSidePanelPage_SuppressGhostLoader_Params_Data*>(data);

  return true;
}

LensSidePanelPage_SuppressGhostLoader_Params_Data::LensSidePanelPage_SuppressGhostLoader_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_PageContentTypeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_PageContentTypeChanged_Params_Data* object =
      static_cast<const LensSidePanelPage_PageContentTypeChanged_Params_Data*>(data);


  if (!::lens::mojom::internal::PageContentType_Data
        ::Validate(object->new_page_content_type, validation_context))
    return false;

  return true;
}

LensSidePanelPage_PageContentTypeChanged_Params_Data::LensSidePanelPage_PageContentTypeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_ShowToast_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_ShowToast_Params_Data* object =
      static_cast<const LensSidePanelPage_ShowToast_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

LensSidePanelPage_ShowToast_Params_Data::LensSidePanelPage_ShowToast_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_SendClientMessageToAim_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_SendClientMessageToAim_Params_Data* object =
      static_cast<const LensSidePanelPage_SendClientMessageToAim_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& serialized_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->serialized_message, validation_context,
                                         &serialized_message_validate_params)) {
    return false;
  }

  return true;
}

LensSidePanelPage_SendClientMessageToAim_Params_Data::LensSidePanelPage_SendClientMessageToAim_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_AimHandshakeReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_AimHandshakeReceived_Params_Data* object =
      static_cast<const LensSidePanelPage_AimHandshakeReceived_Params_Data*>(data);

  return true;
}

LensSidePanelPage_AimHandshakeReceived_Params_Data::LensSidePanelPage_AimHandshakeReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_AimResultsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_AimResultsChanged_Params_Data* object =
      static_cast<const LensSidePanelPage_AimResultsChanged_Params_Data*>(data);

  return true;
}

LensSidePanelPage_AimResultsChanged_Params_Data::LensSidePanelPage_AimResultsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_FocusResultsFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_FocusResultsFrame_Params_Data* object =
      static_cast<const LensSidePanelPage_FocusResultsFrame_Params_Data*>(data);

  return true;
}

LensSidePanelPage_FocusResultsFrame_Params_Data::LensSidePanelPage_FocusResultsFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensSidePanelPage_SetIsOverlayShowing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensSidePanelPage_SetIsOverlayShowing_Params_Data* object =
      static_cast<const LensSidePanelPage_SetIsOverlayShowing_Params_Data*>(data);

  return true;
}

LensSidePanelPage_SetIsOverlayShowing_Params_Data::LensSidePanelPage_SetIsOverlayShowing_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace lens

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::SidePanelResultStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::SidePanelResultStatus value) {
  return std::move(context).WriteString(::lens::mojom::SidePanelResultStatusToString(value));
}

} // namespace perfetto