// chrome/browser/lens/core/mojom/lens_ghost_loader.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/lens/core/mojom/lens_ghost_loader.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/lens_ghost_loader.mojom-params-data.h"
#include "chrome/browser/lens/core/mojom/lens_ghost_loader.mojom-shared-message-ids.h"

#include "chrome/browser/lens/core/mojom/lens_ghost_loader.mojom-import-headers.h"
#include "chrome/browser/lens/core/mojom/lens_ghost_loader.mojom-test-utils.h"


namespace lens::mojom {
// The declaration includes the definition on other builds.

LensGhostLoaderPageHandlerFactory::IPCStableHashFunction LensGhostLoaderPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensGhostLoaderPageHandlerFactory>(message.name())) {
    case messages::LensGhostLoaderPageHandlerFactory::kCreateGhostLoaderPage: {
      return &LensGhostLoaderPageHandlerFactory::CreateGhostLoaderPage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensGhostLoaderPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensGhostLoaderPageHandlerFactory>(message.name())) {
      case messages::LensGhostLoaderPageHandlerFactory::kCreateGhostLoaderPage:
            return "Receive lens::mojom::LensGhostLoaderPageHandlerFactory::CreateGhostLoaderPage";
    }
  } else {
    switch (static_cast<messages::LensGhostLoaderPageHandlerFactory>(message.name())) {
      case messages::LensGhostLoaderPageHandlerFactory::kCreateGhostLoaderPage:
            return "Receive reply lens::mojom::LensGhostLoaderPageHandlerFactory::CreateGhostLoaderPage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensGhostLoaderPageHandlerFactory::CreateGhostLoaderPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80b3ffce;  // IPCStableHash for lens::mojom::LensGhostLoaderPageHandlerFactory::CreateGhostLoaderPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LensGhostLoaderPageHandlerFactoryProxy::LensGhostLoaderPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensGhostLoaderPageHandlerFactoryProxy::CreateGhostLoaderPage(
    ::mojo::PendingRemote<LensGhostLoaderPage> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensGhostLoaderPageHandlerFactory::CreateGhostLoaderPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<LensGhostLoaderPage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensGhostLoaderPageHandlerFactory::kCreateGhostLoaderPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensGhostLoaderPageHandlerFactory_CreateGhostLoaderPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::lens::mojom::LensGhostLoaderPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in LensGhostLoaderPageHandlerFactory.CreateGhostLoaderPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensGhostLoaderPageHandlerFactory::Name_);
  message.set_method_name("CreateGhostLoaderPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LensGhostLoaderPageHandlerFactoryStubDispatch::Accept(
    LensGhostLoaderPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensGhostLoaderPageHandlerFactory>(message->header()->name)) {
    case messages::LensGhostLoaderPageHandlerFactory::kCreateGhostLoaderPage: {
      DCHECK(message->is_serialized());
      internal::LensGhostLoaderPageHandlerFactory_CreateGhostLoaderPage_Params_Data* params =
          reinterpret_cast<internal::LensGhostLoaderPageHandlerFactory_CreateGhostLoaderPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensGhostLoaderPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<LensGhostLoaderPage> p_page{};
      LensGhostLoaderPageHandlerFactory_CreateGhostLoaderPage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensGhostLoaderPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGhostLoaderPage(        
        std::move(p_page));
      return true;
    }
  }
  return false;
}

// static
bool LensGhostLoaderPageHandlerFactoryStubDispatch::AcceptWithResponder(
    LensGhostLoaderPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensGhostLoaderPageHandlerFactory>(message->header()->name)) {
    case messages::LensGhostLoaderPageHandlerFactory::kCreateGhostLoaderPage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensGhostLoaderPageHandlerFactoryValidationInfo[] = {
    { &internal::LensGhostLoaderPageHandlerFactory_CreateGhostLoaderPage_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensGhostLoaderPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensGhostLoaderPageHandlerFactory::Name_,
    kLensGhostLoaderPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

LensGhostLoaderPage::IPCStableHashFunction LensGhostLoaderPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensGhostLoaderPage>(message.name())) {
    case messages::LensGhostLoaderPage::kShowErrorState: {
      return &LensGhostLoaderPage::ShowErrorState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensGhostLoaderPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensGhostLoaderPage>(message.name())) {
      case messages::LensGhostLoaderPage::kShowErrorState:
            return "Receive lens::mojom::LensGhostLoaderPage::ShowErrorState";
    }
  } else {
    switch (static_cast<messages::LensGhostLoaderPage>(message.name())) {
      case messages::LensGhostLoaderPage::kShowErrorState:
            return "Receive reply lens::mojom::LensGhostLoaderPage::ShowErrorState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensGhostLoaderPage::ShowErrorState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb56cf1e7;  // IPCStableHash for lens::mojom::LensGhostLoaderPage::ShowErrorState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LensGhostLoaderPageProxy::LensGhostLoaderPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensGhostLoaderPageProxy::ShowErrorState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensGhostLoaderPage::ShowErrorState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensGhostLoaderPage::kShowErrorState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensGhostLoaderPage_ShowErrorState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensGhostLoaderPage::Name_);
  message.set_method_name("ShowErrorState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LensGhostLoaderPageStubDispatch::Accept(
    LensGhostLoaderPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensGhostLoaderPage>(message->header()->name)) {
    case messages::LensGhostLoaderPage::kShowErrorState: {
      DCHECK(message->is_serialized());
      internal::LensGhostLoaderPage_ShowErrorState_Params_Data* params =
          reinterpret_cast<internal::LensGhostLoaderPage_ShowErrorState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensGhostLoaderPage.0
      bool success = true;
      LensGhostLoaderPage_ShowErrorState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensGhostLoaderPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowErrorState(        );
      return true;
    }
  }
  return false;
}

// static
bool LensGhostLoaderPageStubDispatch::AcceptWithResponder(
    LensGhostLoaderPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensGhostLoaderPage>(message->header()->name)) {
    case messages::LensGhostLoaderPage::kShowErrorState: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensGhostLoaderPageValidationInfo[] = {
    { &internal::LensGhostLoaderPage_ShowErrorState_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensGhostLoaderPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensGhostLoaderPage::Name_,
    kLensGhostLoaderPageValidationInfo);
}



}  // lens::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace lens::mojom {


void LensGhostLoaderPageHandlerFactoryInterceptorForTesting::CreateGhostLoaderPage(::mojo::PendingRemote<LensGhostLoaderPage> page) {
  GetForwardingInterface()->CreateGhostLoaderPage(
    std::move(page)
    );
}
LensGhostLoaderPageHandlerFactoryAsyncWaiter::LensGhostLoaderPageHandlerFactoryAsyncWaiter(
    LensGhostLoaderPageHandlerFactory* proxy) : proxy_(proxy) {}

LensGhostLoaderPageHandlerFactoryAsyncWaiter::~LensGhostLoaderPageHandlerFactoryAsyncWaiter() = default;





void LensGhostLoaderPageInterceptorForTesting::ShowErrorState() {
  GetForwardingInterface()->ShowErrorState();
}
LensGhostLoaderPageAsyncWaiter::LensGhostLoaderPageAsyncWaiter(
    LensGhostLoaderPage* proxy) : proxy_(proxy) {}

LensGhostLoaderPageAsyncWaiter::~LensGhostLoaderPageAsyncWaiter() = default;







}  // lens::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif