// chrome/browser/lens/core/mojom/geometry.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/lens/core/mojom/geometry.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/geometry.mojom-params-data.h"
#include "chrome/browser/lens/core/mojom/geometry.mojom-shared-message-ids.h"

#include "chrome/browser/lens/core/mojom/geometry.mojom-import-headers.h"
#include "chrome/browser/lens/core/mojom/geometry.mojom-test-utils.h"


namespace lens::mojom {
CenterRotatedBox::CenterRotatedBox()
    : box(),
      rotation(),
      coordinate_type() {}

CenterRotatedBox::CenterRotatedBox(
    const ::gfx::RectF& box_in,
    float rotation_in,
    CenterRotatedBox::CoordinateType coordinate_type_in)
    : box(std::move(box_in)),
      rotation(std::move(rotation_in)),
      coordinate_type(std::move(coordinate_type_in)) {}

CenterRotatedBox::~CenterRotatedBox() = default;

void CenterRotatedBox::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "box"), this->box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation"), this->rotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coordinate_type"), this->coordinate_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CenterRotatedBox::CoordinateType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CenterRotatedBox::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Geometry::Geometry()
    : bounding_box(),
      segmentation_polygon() {}

Geometry::Geometry(
    CenterRotatedBoxPtr bounding_box_in,
    std::vector<::lens::mojom::PolygonPtr> segmentation_polygon_in)
    : bounding_box(std::move(bounding_box_in)),
      segmentation_polygon(std::move(segmentation_polygon_in)) {}

Geometry::~Geometry() = default;

void Geometry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounding_box"), this->bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CenterRotatedBoxPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segmentation_polygon"), this->segmentation_polygon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::lens::mojom::PolygonPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Geometry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // lens::mojom


namespace mojo {


// static
bool StructTraits<::lens::mojom::CenterRotatedBox::DataView, ::lens::mojom::CenterRotatedBoxPtr>::Read(
    ::lens::mojom::CenterRotatedBox::DataView input,
    ::lens::mojom::CenterRotatedBoxPtr* output) {
  bool success = true;
  ::lens::mojom::CenterRotatedBoxPtr result(::lens::mojom::CenterRotatedBox::New());
  
      if (success && !input.ReadBox(&result->box))
        success = false;
      if (success)
        result->rotation = input.rotation();
      if (success && !input.ReadCoordinateType(&result->coordinate_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::Geometry::DataView, ::lens::mojom::GeometryPtr>::Read(
    ::lens::mojom::Geometry::DataView input,
    ::lens::mojom::GeometryPtr* output) {
  bool success = true;
  ::lens::mojom::GeometryPtr result(::lens::mojom::Geometry::New());
  
      if (success && !input.ReadBoundingBox(&result->bounding_box))
        success = false;
      if (success && !input.ReadSegmentationPolygon(&result->segmentation_polygon))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace lens::mojom {




}  // lens::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif