// chrome/browser/lens/core/mojom/geometry.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/lens/core/mojom/geometry.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/polygon.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "chrome/browser/lens/core/mojom/geometry.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::CenterRotatedBoxDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::CenterRotatedBoxDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::CenterRotatedBox_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::box(input)) in_box = Traits::box(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->box)::BaseType> box_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_box,
        box_fragment);

      fragment->box.Set(
          box_fragment.is_null() ? nullptr : box_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->box.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null box in CenterRotatedBox struct");

      fragment->rotation = Traits::rotation(input);

      
      mojo::internal::Serialize<::lens::mojom::CenterRotatedBox_CoordinateType>(
        Traits::coordinate_type(input),
        &fragment->coordinate_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::GeometryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::GeometryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Geometry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::CenterRotatedBoxDataView, send_validation>(
        in_bounding_box,
        bounding_box_fragment);

      fragment->bounding_box.Set(
          bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounding_box.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounding_box in Geometry struct");

      decltype(Traits::segmentation_polygon(input)) in_segmentation_polygon = Traits::segmentation_polygon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->segmentation_polygon)::BaseType>
          segmentation_polygon_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& segmentation_polygon_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::PolygonDataView>, send_validation>(
        in_segmentation_polygon,
        segmentation_polygon_fragment,
        &segmentation_polygon_validate_params);

      fragment->segmentation_polygon.Set(
          segmentation_polygon_fragment.is_null() ? nullptr : segmentation_polygon_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->segmentation_polygon.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null segmentation_polygon in Geometry struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_SEND_VALIDATION_H_