// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/extensions/api/generated_api_registration.h"

#include "build/android_buildflags.h"
#include "build/build_config.h"

#include "chrome/browser/extensions/api/activity_log_private/activity_log_private_api.h"
#include "chrome/browser/extensions/api/bookmarks/bookmarks_api.h"
#include "chrome/browser/extensions/api/cookies/cookies_api.h"
#include "chrome/browser/extensions/api/context_menus/context_menus_api.h"
#include "chrome/browser/extensions/api/debugger/debugger_api.h"
#include "chrome/browser/extensions/api/developer_private/developer_private_functions.h"
#include "chrome/browser/extensions/api/enterprise_hardware_platform/enterprise_hardware_platform_api.h"
#include "chrome/browser/extensions/api/font_settings/font_settings_api.h"
#include "chrome/browser/extensions/api/gcm/gcm_api.h"
#include "chrome/browser/extensions/api/history/history_api.h"
#include "chrome/browser/extensions/api/identity/identity_api.h"
#include "chrome/browser/extensions/api/instance_id/instance_id_api.h"
#include "chrome/browser/extensions/api/notifications/notifications_api.h"
#include "chrome/browser/extensions/api/omnibox/omnibox_api.h"
#include "chrome/browser/extensions/api/page_capture/page_capture_api.h"
#include "chrome/browser/extensions/api/permissions/permissions_api.h"
#include "chrome/browser/extensions/api/processes/processes_api.h"
#include "chrome/browser/extensions/api/reading_list/reading_list_api.h"
#include "chrome/browser/extensions/api/search/search_api.h"
#include "chrome/browser/extensions/api/scripting/scripting_api.h"
#include "chrome/browser/extensions/api/tabs/tabs_api.h"
#include "chrome/browser/extensions/api/web_authentication_proxy/web_authentication_proxy_api.h"
#include "chrome/browser/extensions/api/web_navigation/web_navigation_api.h"
#include "chrome/browser/extensions/api/webrtc_audio_private/webrtc_audio_private_api.h"
#include "chrome/browser/extensions/api/webrtc_logging_private/webrtc_logging_private_api.h"
#include "chrome/browser/extensions/api/webstore_private/webstore_private_api.h"
#include "chrome/browser/extensions/api/tabs/tabs_api.h"
#include "chrome/browser/extensions/api/mdns/mdns_api.h"
#include "chrome/browser/extensions/api/experimental_actor/experimental_actor_api.h"
#include "chrome/browser/extensions/api/experimental_ai_data/experimental_ai_data_api.h"
#include "chrome/browser/extensions/api/autofill_private/autofill_private_api.h"
#if BUILDFLAG(IS_CHROMEOS)
#include "chrome/browser/ash/extensions/autotest_private/autotest_private_api.h"
#endif  // BUILDFLAG(IS_CHROMEOS)
#include "chrome/browser/extensions/api/bookmark_manager_private/bookmark_manager_private_api.h"
#include "chrome/browser/extensions/api/braille_display_private/braille_display_private_api.h"
#include "chrome/browser/extensions/api/web_view/chrome_web_view_internal_api.h"
#include "chrome/browser/extensions/api/command_line_private/command_line_private_api.h"
#include "chrome/browser/extensions/api/content_settings/content_settings_api.h"
#include "chrome/browser/extensions/api/desktop_capture/desktop_capture_api.h"
#if BUILDFLAG(IS_CHROMEOS)
#include "chrome/browser/extensions/api/crash_report_private/crash_report_private_api.h"
#endif  // BUILDFLAG(IS_CHROMEOS)
#include "chrome/browser/extensions/api/downloads/downloads_api.h"
#include "chrome/browser/extensions/api/downloads_internal/downloads_internal_api.h"
#include "chrome/browser/extensions/api/enterprise_reporting_private/enterprise_reporting_private_api.h"
#include "chrome/browser/extensions/api/image_writer_private/image_writer_private_api.h"
#include "chrome/browser/extensions/api/language_settings_private/language_settings_private_api.h"
#include "chrome/browser/extensions/api/passwords_private/passwords_private_api.h"
#include "chrome/browser/extensions/api/resources_private/resources_private_api.h"
#include "chrome/browser/extensions/api/safe_browsing_private/safe_browsing_private_api.h"
#include "chrome/browser/extensions/api/sessions/sessions_api.h"
#include "chrome/browser/extensions/api/settings_private/settings_private_api.h"
#include "chrome/browser/extensions/api/side_panel/side_panel_api.h"
#include "chrome/browser/extensions/api/system_private/system_private_api.h"
#include "chrome/browser/extensions/api/tab_capture/tab_capture_api.h"
#include "chrome/browser/extensions/api/tab_groups/tab_groups_api.h"
#include "chrome/browser/extensions/api/webrtc_desktop_capture_private/webrtc_desktop_capture_private_api.h"
#include "chrome/browser/extensions/api/pdf_viewer_private/pdf_viewer_private_api.h"
#include "chrome/browser/extensions/api/extension_action/extension_action_api.h"
#include "chrome/browser/extensions/api/browsing_data/browsing_data_api.h"
#include "chrome/browser/extensions/api/module/module.h"
#include "chrome/browser/extensions/api/top_sites/top_sites_api.h"
#include "chrome/browser/extensions/api/extension_action/extension_action_api.h"
#include "chrome/browser/extensions/api/idltest/idltest_api.h"
#include "chrome/browser/extensions/api/extension_action/extension_action_api.h"

#include "extensions/browser/extension_function_registry.h"

namespace extensions {
namespace api {

// static
void ChromeGeneratedFunctionRegistry::RegisterAll(ExtensionFunctionRegistry* registry) {
  constexpr ExtensionFunctionRegistry::FactoryEntry kEntries[] = {
    {
      &NewExtensionFunction<ActivityLogPrivateGetExtensionActivitiesFunction>,
      ActivityLogPrivateGetExtensionActivitiesFunction::static_function_name(),
      ActivityLogPrivateGetExtensionActivitiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActivityLogPrivateDeleteActivitiesFunction>,
      ActivityLogPrivateDeleteActivitiesFunction::static_function_name(),
      ActivityLogPrivateDeleteActivitiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActivityLogPrivateDeleteActivitiesByExtensionFunction>,
      ActivityLogPrivateDeleteActivitiesByExtensionFunction::static_function_name(),
      ActivityLogPrivateDeleteActivitiesByExtensionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActivityLogPrivateDeleteDatabaseFunction>,
      ActivityLogPrivateDeleteDatabaseFunction::static_function_name(),
      ActivityLogPrivateDeleteDatabaseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActivityLogPrivateDeleteUrlsFunction>,
      ActivityLogPrivateDeleteUrlsFunction::static_function_name(),
      ActivityLogPrivateDeleteUrlsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksGetFunction>,
      BookmarksGetFunction::static_function_name(),
      BookmarksGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksGetChildrenFunction>,
      BookmarksGetChildrenFunction::static_function_name(),
      BookmarksGetChildrenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksGetRecentFunction>,
      BookmarksGetRecentFunction::static_function_name(),
      BookmarksGetRecentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksGetTreeFunction>,
      BookmarksGetTreeFunction::static_function_name(),
      BookmarksGetTreeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksGetSubTreeFunction>,
      BookmarksGetSubTreeFunction::static_function_name(),
      BookmarksGetSubTreeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksSearchFunction>,
      BookmarksSearchFunction::static_function_name(),
      BookmarksSearchFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksCreateFunction>,
      BookmarksCreateFunction::static_function_name(),
      BookmarksCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksMoveFunction>,
      BookmarksMoveFunction::static_function_name(),
      BookmarksMoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksUpdateFunction>,
      BookmarksUpdateFunction::static_function_name(),
      BookmarksUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksRemoveFunction>,
      BookmarksRemoveFunction::static_function_name(),
      BookmarksRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarksRemoveTreeFunction>,
      BookmarksRemoveTreeFunction::static_function_name(),
      BookmarksRemoveTreeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CookiesGetFunction>,
      CookiesGetFunction::static_function_name(),
      CookiesGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CookiesGetAllFunction>,
      CookiesGetAllFunction::static_function_name(),
      CookiesGetAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CookiesSetFunction>,
      CookiesSetFunction::static_function_name(),
      CookiesSetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CookiesRemoveFunction>,
      CookiesRemoveFunction::static_function_name(),
      CookiesRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CookiesGetAllCookieStoresFunction>,
      CookiesGetAllCookieStoresFunction::static_function_name(),
      CookiesGetAllCookieStoresFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CookiesGetPartitionKeyFunction>,
      CookiesGetPartitionKeyFunction::static_function_name(),
      CookiesGetPartitionKeyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContextMenusCreateFunction>,
      ContextMenusCreateFunction::static_function_name(),
      ContextMenusCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContextMenusUpdateFunction>,
      ContextMenusUpdateFunction::static_function_name(),
      ContextMenusUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContextMenusRemoveFunction>,
      ContextMenusRemoveFunction::static_function_name(),
      ContextMenusRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContextMenusRemoveAllFunction>,
      ContextMenusRemoveAllFunction::static_function_name(),
      ContextMenusRemoveAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DebuggerAttachFunction>,
      DebuggerAttachFunction::static_function_name(),
      DebuggerAttachFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DebuggerDetachFunction>,
      DebuggerDetachFunction::static_function_name(),
      DebuggerDetachFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DebuggerSendCommandFunction>,
      DebuggerSendCommandFunction::static_function_name(),
      DebuggerSendCommandFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DebuggerGetTargetsFunction>,
      DebuggerGetTargetsFunction::static_function_name(),
      DebuggerGetTargetsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateAutoUpdateFunction>,
      DeveloperPrivateAutoUpdateFunction::static_function_name(),
      DeveloperPrivateAutoUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateGetExtensionsInfoFunction>,
      DeveloperPrivateGetExtensionsInfoFunction::static_function_name(),
      DeveloperPrivateGetExtensionsInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateGetExtensionInfoFunction>,
      DeveloperPrivateGetExtensionInfoFunction::static_function_name(),
      DeveloperPrivateGetExtensionInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateGetExtensionSizeFunction>,
      DeveloperPrivateGetExtensionSizeFunction::static_function_name(),
      DeveloperPrivateGetExtensionSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateGetProfileConfigurationFunction>,
      DeveloperPrivateGetProfileConfigurationFunction::static_function_name(),
      DeveloperPrivateGetProfileConfigurationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateUpdateProfileConfigurationFunction>,
      DeveloperPrivateUpdateProfileConfigurationFunction::static_function_name(),
      DeveloperPrivateUpdateProfileConfigurationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateReloadFunction>,
      DeveloperPrivateReloadFunction::static_function_name(),
      DeveloperPrivateReloadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateUpdateExtensionConfigurationFunction>,
      DeveloperPrivateUpdateExtensionConfigurationFunction::static_function_name(),
      DeveloperPrivateUpdateExtensionConfigurationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateLoadUnpackedFunction>,
      DeveloperPrivateLoadUnpackedFunction::static_function_name(),
      DeveloperPrivateLoadUnpackedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateInstallDroppedFileFunction>,
      DeveloperPrivateInstallDroppedFileFunction::static_function_name(),
      DeveloperPrivateInstallDroppedFileFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateNotifyDragInstallInProgressFunction>,
      DeveloperPrivateNotifyDragInstallInProgressFunction::static_function_name(),
      DeveloperPrivateNotifyDragInstallInProgressFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateLoadDirectoryFunction>,
      DeveloperPrivateLoadDirectoryFunction::static_function_name(),
      DeveloperPrivateLoadDirectoryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateChoosePathFunction>,
      DeveloperPrivateChoosePathFunction::static_function_name(),
      DeveloperPrivateChoosePathFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivatePackDirectoryFunction>,
      DeveloperPrivatePackDirectoryFunction::static_function_name(),
      DeveloperPrivatePackDirectoryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateRequestFileSourceFunction>,
      DeveloperPrivateRequestFileSourceFunction::static_function_name(),
      DeveloperPrivateRequestFileSourceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateOpenDevToolsFunction>,
      DeveloperPrivateOpenDevToolsFunction::static_function_name(),
      DeveloperPrivateOpenDevToolsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateDeleteExtensionErrorsFunction>,
      DeveloperPrivateDeleteExtensionErrorsFunction::static_function_name(),
      DeveloperPrivateDeleteExtensionErrorsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateRepairExtensionFunction>,
      DeveloperPrivateRepairExtensionFunction::static_function_name(),
      DeveloperPrivateRepairExtensionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateShowOptionsFunction>,
      DeveloperPrivateShowOptionsFunction::static_function_name(),
      DeveloperPrivateShowOptionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateShowPathFunction>,
      DeveloperPrivateShowPathFunction::static_function_name(),
      DeveloperPrivateShowPathFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateSetShortcutHandlingSuspendedFunction>,
      DeveloperPrivateSetShortcutHandlingSuspendedFunction::static_function_name(),
      DeveloperPrivateSetShortcutHandlingSuspendedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateUpdateExtensionCommandFunction>,
      DeveloperPrivateUpdateExtensionCommandFunction::static_function_name(),
      DeveloperPrivateUpdateExtensionCommandFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateAddHostPermissionFunction>,
      DeveloperPrivateAddHostPermissionFunction::static_function_name(),
      DeveloperPrivateAddHostPermissionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateRemoveHostPermissionFunction>,
      DeveloperPrivateRemoveHostPermissionFunction::static_function_name(),
      DeveloperPrivateRemoveHostPermissionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateGetUserSiteSettingsFunction>,
      DeveloperPrivateGetUserSiteSettingsFunction::static_function_name(),
      DeveloperPrivateGetUserSiteSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateAddUserSpecifiedSitesFunction>,
      DeveloperPrivateAddUserSpecifiedSitesFunction::static_function_name(),
      DeveloperPrivateAddUserSpecifiedSitesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateRemoveUserSpecifiedSitesFunction>,
      DeveloperPrivateRemoveUserSpecifiedSitesFunction::static_function_name(),
      DeveloperPrivateRemoveUserSpecifiedSitesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateGetUserAndExtensionSitesByEtldFunction>,
      DeveloperPrivateGetUserAndExtensionSitesByEtldFunction::static_function_name(),
      DeveloperPrivateGetUserAndExtensionSitesByEtldFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateGetMatchingExtensionsForSiteFunction>,
      DeveloperPrivateGetMatchingExtensionsForSiteFunction::static_function_name(),
      DeveloperPrivateGetMatchingExtensionsForSiteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateUpdateSiteAccessFunction>,
      DeveloperPrivateUpdateSiteAccessFunction::static_function_name(),
      DeveloperPrivateUpdateSiteAccessFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateRemoveMultipleExtensionsFunction>,
      DeveloperPrivateRemoveMultipleExtensionsFunction::static_function_name(),
      DeveloperPrivateRemoveMultipleExtensionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateDismissSafetyHubExtensionsMenuNotificationFunction>,
      DeveloperPrivateDismissSafetyHubExtensionsMenuNotificationFunction::static_function_name(),
      DeveloperPrivateDismissSafetyHubExtensionsMenuNotificationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateDismissMv2DeprecationNoticeForExtensionFunction>,
      DeveloperPrivateDismissMv2DeprecationNoticeForExtensionFunction::static_function_name(),
      DeveloperPrivateDismissMv2DeprecationNoticeForExtensionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeveloperPrivateUploadExtensionToAccountFunction>,
      DeveloperPrivateUploadExtensionToAccountFunction::static_function_name(),
      DeveloperPrivateUploadExtensionToAccountFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_DESKTOP_ANDROID)
    {
      &NewExtensionFunction<DeveloperPrivateShowSiteSettingsFunction>,
      DeveloperPrivateShowSiteSettingsFunction::static_function_name(),
      DeveloperPrivateShowSiteSettingsFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_DESKTOP_ANDROID)
    {
      &NewExtensionFunction<EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction>,
      EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction::static_function_name(),
      EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsClearFontFunction>,
      FontSettingsClearFontFunction::static_function_name(),
      FontSettingsClearFontFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsGetFontFunction>,
      FontSettingsGetFontFunction::static_function_name(),
      FontSettingsGetFontFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsSetFontFunction>,
      FontSettingsSetFontFunction::static_function_name(),
      FontSettingsSetFontFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsGetFontListFunction>,
      FontSettingsGetFontListFunction::static_function_name(),
      FontSettingsGetFontListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsClearDefaultFontSizeFunction>,
      FontSettingsClearDefaultFontSizeFunction::static_function_name(),
      FontSettingsClearDefaultFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsGetDefaultFontSizeFunction>,
      FontSettingsGetDefaultFontSizeFunction::static_function_name(),
      FontSettingsGetDefaultFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsSetDefaultFontSizeFunction>,
      FontSettingsSetDefaultFontSizeFunction::static_function_name(),
      FontSettingsSetDefaultFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsClearDefaultFixedFontSizeFunction>,
      FontSettingsClearDefaultFixedFontSizeFunction::static_function_name(),
      FontSettingsClearDefaultFixedFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsGetDefaultFixedFontSizeFunction>,
      FontSettingsGetDefaultFixedFontSizeFunction::static_function_name(),
      FontSettingsGetDefaultFixedFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsSetDefaultFixedFontSizeFunction>,
      FontSettingsSetDefaultFixedFontSizeFunction::static_function_name(),
      FontSettingsSetDefaultFixedFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsClearMinimumFontSizeFunction>,
      FontSettingsClearMinimumFontSizeFunction::static_function_name(),
      FontSettingsClearMinimumFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsGetMinimumFontSizeFunction>,
      FontSettingsGetMinimumFontSizeFunction::static_function_name(),
      FontSettingsGetMinimumFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FontSettingsSetMinimumFontSizeFunction>,
      FontSettingsSetMinimumFontSizeFunction::static_function_name(),
      FontSettingsSetMinimumFontSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<GcmRegisterFunction>,
      GcmRegisterFunction::static_function_name(),
      GcmRegisterFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<GcmUnregisterFunction>,
      GcmUnregisterFunction::static_function_name(),
      GcmUnregisterFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<GcmSendFunction>,
      GcmSendFunction::static_function_name(),
      GcmSendFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HistorySearchFunction>,
      HistorySearchFunction::static_function_name(),
      HistorySearchFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HistoryGetVisitsFunction>,
      HistoryGetVisitsFunction::static_function_name(),
      HistoryGetVisitsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HistoryAddUrlFunction>,
      HistoryAddUrlFunction::static_function_name(),
      HistoryAddUrlFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HistoryDeleteUrlFunction>,
      HistoryDeleteUrlFunction::static_function_name(),
      HistoryDeleteUrlFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HistoryDeleteRangeFunction>,
      HistoryDeleteRangeFunction::static_function_name(),
      HistoryDeleteRangeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HistoryDeleteAllFunction>,
      HistoryDeleteAllFunction::static_function_name(),
      HistoryDeleteAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdentityGetAccountsFunction>,
      IdentityGetAccountsFunction::static_function_name(),
      IdentityGetAccountsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdentityGetAuthTokenFunction>,
      IdentityGetAuthTokenFunction::static_function_name(),
      IdentityGetAuthTokenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdentityGetProfileUserInfoFunction>,
      IdentityGetProfileUserInfoFunction::static_function_name(),
      IdentityGetProfileUserInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdentityRemoveCachedAuthTokenFunction>,
      IdentityRemoveCachedAuthTokenFunction::static_function_name(),
      IdentityRemoveCachedAuthTokenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdentityClearAllCachedAuthTokensFunction>,
      IdentityClearAllCachedAuthTokensFunction::static_function_name(),
      IdentityClearAllCachedAuthTokensFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdentityLaunchWebAuthFlowFunction>,
      IdentityLaunchWebAuthFlowFunction::static_function_name(),
      IdentityLaunchWebAuthFlowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<InstanceIDGetIDFunction>,
      InstanceIDGetIDFunction::static_function_name(),
      InstanceIDGetIDFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<InstanceIDGetCreationTimeFunction>,
      InstanceIDGetCreationTimeFunction::static_function_name(),
      InstanceIDGetCreationTimeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<InstanceIDGetTokenFunction>,
      InstanceIDGetTokenFunction::static_function_name(),
      InstanceIDGetTokenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<InstanceIDDeleteTokenFunction>,
      InstanceIDDeleteTokenFunction::static_function_name(),
      InstanceIDDeleteTokenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<InstanceIDDeleteIDFunction>,
      InstanceIDDeleteIDFunction::static_function_name(),
      InstanceIDDeleteIDFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NotificationsCreateFunction>,
      NotificationsCreateFunction::static_function_name(),
      NotificationsCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NotificationsUpdateFunction>,
      NotificationsUpdateFunction::static_function_name(),
      NotificationsUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NotificationsClearFunction>,
      NotificationsClearFunction::static_function_name(),
      NotificationsClearFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NotificationsGetAllFunction>,
      NotificationsGetAllFunction::static_function_name(),
      NotificationsGetAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NotificationsGetPermissionLevelFunction>,
      NotificationsGetPermissionLevelFunction::static_function_name(),
      NotificationsGetPermissionLevelFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<OmniboxSendSuggestionsFunction>,
      OmniboxSendSuggestionsFunction::static_function_name(),
      OmniboxSendSuggestionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<OmniboxSetDefaultSuggestionFunction>,
      OmniboxSetDefaultSuggestionFunction::static_function_name(),
      OmniboxSetDefaultSuggestionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageCaptureSaveAsMHTMLFunction>,
      PageCaptureSaveAsMHTMLFunction::static_function_name(),
      PageCaptureSaveAsMHTMLFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PermissionsGetAllFunction>,
      PermissionsGetAllFunction::static_function_name(),
      PermissionsGetAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PermissionsContainsFunction>,
      PermissionsContainsFunction::static_function_name(),
      PermissionsContainsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PermissionsRequestFunction>,
      PermissionsRequestFunction::static_function_name(),
      PermissionsRequestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PermissionsRemoveFunction>,
      PermissionsRemoveFunction::static_function_name(),
      PermissionsRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PermissionsAddHostAccessRequestFunction>,
      PermissionsAddHostAccessRequestFunction::static_function_name(),
      PermissionsAddHostAccessRequestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PermissionsRemoveHostAccessRequestFunction>,
      PermissionsRemoveHostAccessRequestFunction::static_function_name(),
      PermissionsRemoveHostAccessRequestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ProcessesGetProcessIdForTabFunction>,
      ProcessesGetProcessIdForTabFunction::static_function_name(),
      ProcessesGetProcessIdForTabFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ProcessesTerminateFunction>,
      ProcessesTerminateFunction::static_function_name(),
      ProcessesTerminateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ProcessesGetProcessInfoFunction>,
      ProcessesGetProcessInfoFunction::static_function_name(),
      ProcessesGetProcessInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ReadingListAddEntryFunction>,
      ReadingListAddEntryFunction::static_function_name(),
      ReadingListAddEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ReadingListRemoveEntryFunction>,
      ReadingListRemoveEntryFunction::static_function_name(),
      ReadingListRemoveEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ReadingListUpdateEntryFunction>,
      ReadingListUpdateEntryFunction::static_function_name(),
      ReadingListUpdateEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ReadingListQueryFunction>,
      ReadingListQueryFunction::static_function_name(),
      ReadingListQueryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SearchQueryFunction>,
      SearchQueryFunction::static_function_name(),
      SearchQueryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ScriptingExecuteScriptFunction>,
      ScriptingExecuteScriptFunction::static_function_name(),
      ScriptingExecuteScriptFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ScriptingInsertCSSFunction>,
      ScriptingInsertCSSFunction::static_function_name(),
      ScriptingInsertCSSFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ScriptingRemoveCSSFunction>,
      ScriptingRemoveCSSFunction::static_function_name(),
      ScriptingRemoveCSSFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ScriptingRegisterContentScriptsFunction>,
      ScriptingRegisterContentScriptsFunction::static_function_name(),
      ScriptingRegisterContentScriptsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ScriptingGetRegisteredContentScriptsFunction>,
      ScriptingGetRegisteredContentScriptsFunction::static_function_name(),
      ScriptingGetRegisteredContentScriptsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ScriptingUnregisterContentScriptsFunction>,
      ScriptingUnregisterContentScriptsFunction::static_function_name(),
      ScriptingUnregisterContentScriptsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ScriptingUpdateContentScriptsFunction>,
      ScriptingUpdateContentScriptsFunction::static_function_name(),
      ScriptingUpdateContentScriptsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGetFunction>,
      TabsGetFunction::static_function_name(),
      TabsGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGetCurrentFunction>,
      TabsGetCurrentFunction::static_function_name(),
      TabsGetCurrentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGetSelectedFunction>,
      TabsGetSelectedFunction::static_function_name(),
      TabsGetSelectedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGetAllInWindowFunction>,
      TabsGetAllInWindowFunction::static_function_name(),
      TabsGetAllInWindowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsCreateFunction>,
      TabsCreateFunction::static_function_name(),
      TabsCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsDuplicateFunction>,
      TabsDuplicateFunction::static_function_name(),
      TabsDuplicateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsQueryFunction>,
      TabsQueryFunction::static_function_name(),
      TabsQueryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsHighlightFunction>,
      TabsHighlightFunction::static_function_name(),
      TabsHighlightFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsUpdateFunction>,
      TabsUpdateFunction::static_function_name(),
      TabsUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsMoveFunction>,
      TabsMoveFunction::static_function_name(),
      TabsMoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsReloadFunction>,
      TabsReloadFunction::static_function_name(),
      TabsReloadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsRemoveFunction>,
      TabsRemoveFunction::static_function_name(),
      TabsRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGroupFunction>,
      TabsGroupFunction::static_function_name(),
      TabsGroupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsUngroupFunction>,
      TabsUngroupFunction::static_function_name(),
      TabsUngroupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsDetectLanguageFunction>,
      TabsDetectLanguageFunction::static_function_name(),
      TabsDetectLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsCaptureVisibleTabFunction>,
      TabsCaptureVisibleTabFunction::static_function_name(),
      TabsCaptureVisibleTabFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsExecuteScriptFunction>,
      TabsExecuteScriptFunction::static_function_name(),
      TabsExecuteScriptFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsInsertCSSFunction>,
      TabsInsertCSSFunction::static_function_name(),
      TabsInsertCSSFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsRemoveCSSFunction>,
      TabsRemoveCSSFunction::static_function_name(),
      TabsRemoveCSSFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsSetZoomFunction>,
      TabsSetZoomFunction::static_function_name(),
      TabsSetZoomFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGetZoomFunction>,
      TabsGetZoomFunction::static_function_name(),
      TabsGetZoomFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsSetZoomSettingsFunction>,
      TabsSetZoomSettingsFunction::static_function_name(),
      TabsSetZoomSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGetZoomSettingsFunction>,
      TabsGetZoomSettingsFunction::static_function_name(),
      TabsGetZoomSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsDiscardFunction>,
      TabsDiscardFunction::static_function_name(),
      TabsDiscardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGoForwardFunction>,
      TabsGoForwardFunction::static_function_name(),
      TabsGoForwardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabsGoBackFunction>,
      TabsGoBackFunction::static_function_name(),
      TabsGoBackFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebAuthenticationProxyCompleteCreateRequestFunction>,
      WebAuthenticationProxyCompleteCreateRequestFunction::static_function_name(),
      WebAuthenticationProxyCompleteCreateRequestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebAuthenticationProxyCompleteGetRequestFunction>,
      WebAuthenticationProxyCompleteGetRequestFunction::static_function_name(),
      WebAuthenticationProxyCompleteGetRequestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebAuthenticationProxyCompleteIsUvpaaRequestFunction>,
      WebAuthenticationProxyCompleteIsUvpaaRequestFunction::static_function_name(),
      WebAuthenticationProxyCompleteIsUvpaaRequestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebAuthenticationProxyAttachFunction>,
      WebAuthenticationProxyAttachFunction::static_function_name(),
      WebAuthenticationProxyAttachFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebAuthenticationProxyDetachFunction>,
      WebAuthenticationProxyDetachFunction::static_function_name(),
      WebAuthenticationProxyDetachFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebNavigationGetFrameFunction>,
      WebNavigationGetFrameFunction::static_function_name(),
      WebNavigationGetFrameFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebNavigationGetAllFramesFunction>,
      WebNavigationGetAllFramesFunction::static_function_name(),
      WebNavigationGetAllFramesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcAudioPrivateGetSinksFunction>,
      WebrtcAudioPrivateGetSinksFunction::static_function_name(),
      WebrtcAudioPrivateGetSinksFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcAudioPrivateGetAssociatedSinkFunction>,
      WebrtcAudioPrivateGetAssociatedSinkFunction::static_function_name(),
      WebrtcAudioPrivateGetAssociatedSinkFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateSetMetaDataFunction>,
      WebrtcLoggingPrivateSetMetaDataFunction::static_function_name(),
      WebrtcLoggingPrivateSetMetaDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartFunction>,
      WebrtcLoggingPrivateStartFunction::static_function_name(),
      WebrtcLoggingPrivateStartFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateSetUploadOnRenderCloseFunction>,
      WebrtcLoggingPrivateSetUploadOnRenderCloseFunction::static_function_name(),
      WebrtcLoggingPrivateSetUploadOnRenderCloseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopFunction>,
      WebrtcLoggingPrivateStopFunction::static_function_name(),
      WebrtcLoggingPrivateStopFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStoreFunction>,
      WebrtcLoggingPrivateStoreFunction::static_function_name(),
      WebrtcLoggingPrivateStoreFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateUploadStoredFunction>,
      WebrtcLoggingPrivateUploadStoredFunction::static_function_name(),
      WebrtcLoggingPrivateUploadStoredFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateUploadFunction>,
      WebrtcLoggingPrivateUploadFunction::static_function_name(),
      WebrtcLoggingPrivateUploadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateDiscardFunction>,
      WebrtcLoggingPrivateDiscardFunction::static_function_name(),
      WebrtcLoggingPrivateDiscardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartRtpDumpFunction>,
      WebrtcLoggingPrivateStartRtpDumpFunction::static_function_name(),
      WebrtcLoggingPrivateStartRtpDumpFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopRtpDumpFunction>,
      WebrtcLoggingPrivateStopRtpDumpFunction::static_function_name(),
      WebrtcLoggingPrivateStopRtpDumpFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartAudioDebugRecordingsFunction>,
      WebrtcLoggingPrivateStartAudioDebugRecordingsFunction::static_function_name(),
      WebrtcLoggingPrivateStartAudioDebugRecordingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopAudioDebugRecordingsFunction>,
      WebrtcLoggingPrivateStopAudioDebugRecordingsFunction::static_function_name(),
      WebrtcLoggingPrivateStopAudioDebugRecordingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartEventLoggingFunction>,
      WebrtcLoggingPrivateStartEventLoggingFunction::static_function_name(),
      WebrtcLoggingPrivateStartEventLoggingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateGetLogsDirectoryFunction>,
      WebrtcLoggingPrivateGetLogsDirectoryFunction::static_function_name(),
      WebrtcLoggingPrivateGetLogsDirectoryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateBeginInstallWithManifest3Function>,
      WebstorePrivateBeginInstallWithManifest3Function::static_function_name(),
      WebstorePrivateBeginInstallWithManifest3Function::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateCompleteInstallFunction>,
      WebstorePrivateCompleteInstallFunction::static_function_name(),
      WebstorePrivateCompleteInstallFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateEnableAppLauncherFunction>,
      WebstorePrivateEnableAppLauncherFunction::static_function_name(),
      WebstorePrivateEnableAppLauncherFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetBrowserLoginFunction>,
      WebstorePrivateGetBrowserLoginFunction::static_function_name(),
      WebstorePrivateGetBrowserLoginFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetStoreLoginFunction>,
      WebstorePrivateGetStoreLoginFunction::static_function_name(),
      WebstorePrivateGetStoreLoginFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateSetStoreLoginFunction>,
      WebstorePrivateSetStoreLoginFunction::static_function_name(),
      WebstorePrivateSetStoreLoginFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetWebGLStatusFunction>,
      WebstorePrivateGetWebGLStatusFunction::static_function_name(),
      WebstorePrivateGetWebGLStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetIsLauncherEnabledFunction>,
      WebstorePrivateGetIsLauncherEnabledFunction::static_function_name(),
      WebstorePrivateGetIsLauncherEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateIsInIncognitoModeFunction>,
      WebstorePrivateIsInIncognitoModeFunction::static_function_name(),
      WebstorePrivateIsInIncognitoModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateIsPendingCustodianApprovalFunction>,
      WebstorePrivateIsPendingCustodianApprovalFunction::static_function_name(),
      WebstorePrivateIsPendingCustodianApprovalFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetReferrerChainFunction>,
      WebstorePrivateGetReferrerChainFunction::static_function_name(),
      WebstorePrivateGetReferrerChainFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetExtensionStatusFunction>,
      WebstorePrivateGetExtensionStatusFunction::static_function_name(),
      WebstorePrivateGetExtensionStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetFullChromeVersionFunction>,
      WebstorePrivateGetFullChromeVersionFunction::static_function_name(),
      WebstorePrivateGetFullChromeVersionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebstorePrivateGetMV2DeprecationStatusFunction>,
      WebstorePrivateGetMV2DeprecationStatusFunction::static_function_name(),
      WebstorePrivateGetMV2DeprecationStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WindowsGetFunction>,
      WindowsGetFunction::static_function_name(),
      WindowsGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WindowsGetCurrentFunction>,
      WindowsGetCurrentFunction::static_function_name(),
      WindowsGetCurrentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WindowsGetLastFocusedFunction>,
      WindowsGetLastFocusedFunction::static_function_name(),
      WindowsGetLastFocusedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WindowsGetAllFunction>,
      WindowsGetAllFunction::static_function_name(),
      WindowsGetAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WindowsCreateFunction>,
      WindowsCreateFunction::static_function_name(),
      WindowsCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WindowsUpdateFunction>,
      WindowsUpdateFunction::static_function_name(),
      WindowsUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WindowsRemoveFunction>,
      WindowsRemoveFunction::static_function_name(),
      WindowsRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MdnsForceDiscoveryFunction>,
      MdnsForceDiscoveryFunction::static_function_name(),
      MdnsForceDiscoveryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExperimentalActorStopTaskFunction>,
      ExperimentalActorStopTaskFunction::static_function_name(),
      ExperimentalActorStopTaskFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExperimentalActorCreateTaskFunction>,
      ExperimentalActorCreateTaskFunction::static_function_name(),
      ExperimentalActorCreateTaskFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExperimentalActorPerformActionsFunction>,
      ExperimentalActorPerformActionsFunction::static_function_name(),
      ExperimentalActorPerformActionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExperimentalActorRequestTabObservationFunction>,
      ExperimentalActorRequestTabObservationFunction::static_function_name(),
      ExperimentalActorRequestTabObservationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExperimentalAiDataGetAiDataFunction>,
      ExperimentalAiDataGetAiDataFunction::static_function_name(),
      ExperimentalAiDataGetAiDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExperimentalAiDataGetAiDataWithSpecifierFunction>,
      ExperimentalAiDataGetAiDataWithSpecifierFunction::static_function_name(),
      ExperimentalAiDataGetAiDataWithSpecifierFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetAccountInfoFunction>,
      AutofillPrivateGetAccountInfoFunction::static_function_name(),
      AutofillPrivateGetAccountInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateSaveAddressFunction>,
      AutofillPrivateSaveAddressFunction::static_function_name(),
      AutofillPrivateSaveAddressFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateRemoveAddressFunction>,
      AutofillPrivateRemoveAddressFunction::static_function_name(),
      AutofillPrivateRemoveAddressFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetCountryListFunction>,
      AutofillPrivateGetCountryListFunction::static_function_name(),
      AutofillPrivateGetCountryListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetAddressComponentsFunction>,
      AutofillPrivateGetAddressComponentsFunction::static_function_name(),
      AutofillPrivateGetAddressComponentsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetAddressListFunction>,
      AutofillPrivateGetAddressListFunction::static_function_name(),
      AutofillPrivateGetAddressListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateSaveCreditCardFunction>,
      AutofillPrivateSaveCreditCardFunction::static_function_name(),
      AutofillPrivateSaveCreditCardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateSaveIbanFunction>,
      AutofillPrivateSaveIbanFunction::static_function_name(),
      AutofillPrivateSaveIbanFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateRemovePaymentsEntityFunction>,
      AutofillPrivateRemovePaymentsEntityFunction::static_function_name(),
      AutofillPrivateRemovePaymentsEntityFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetCreditCardListFunction>,
      AutofillPrivateGetCreditCardListFunction::static_function_name(),
      AutofillPrivateGetCreditCardListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetIbanListFunction>,
      AutofillPrivateGetIbanListFunction::static_function_name(),
      AutofillPrivateGetIbanListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateIsValidIbanFunction>,
      AutofillPrivateIsValidIbanFunction::static_function_name(),
      AutofillPrivateIsValidIbanFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateLogServerCardLinkClickedFunction>,
      AutofillPrivateLogServerCardLinkClickedFunction::static_function_name(),
      AutofillPrivateLogServerCardLinkClickedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateLogServerIbanLinkClickedFunction>,
      AutofillPrivateLogServerIbanLinkClickedFunction::static_function_name(),
      AutofillPrivateLogServerIbanLinkClickedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateAddVirtualCardFunction>,
      AutofillPrivateAddVirtualCardFunction::static_function_name(),
      AutofillPrivateAddVirtualCardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateRemoveVirtualCardFunction>,
      AutofillPrivateRemoveVirtualCardFunction::static_function_name(),
      AutofillPrivateRemoveVirtualCardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetPayOverTimeIssuerListFunction>,
      AutofillPrivateGetPayOverTimeIssuerListFunction::static_function_name(),
      AutofillPrivateGetPayOverTimeIssuerListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateAuthenticateUserAndFlipMandatoryAuthToggleFunction>,
      AutofillPrivateAuthenticateUserAndFlipMandatoryAuthToggleFunction::static_function_name(),
      AutofillPrivateAuthenticateUserAndFlipMandatoryAuthToggleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetLocalCardFunction>,
      AutofillPrivateGetLocalCardFunction::static_function_name(),
      AutofillPrivateGetLocalCardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateCheckIfDeviceAuthAvailableFunction>,
      AutofillPrivateCheckIfDeviceAuthAvailableFunction::static_function_name(),
      AutofillPrivateCheckIfDeviceAuthAvailableFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateBulkDeleteAllCvcsFunction>,
      AutofillPrivateBulkDeleteAllCvcsFunction::static_function_name(),
      AutofillPrivateBulkDeleteAllCvcsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateSetAutofillSyncToggleEnabledFunction>,
      AutofillPrivateSetAutofillSyncToggleEnabledFunction::static_function_name(),
      AutofillPrivateSetAutofillSyncToggleEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateAddOrUpdateEntityInstanceFunction>,
      AutofillPrivateAddOrUpdateEntityInstanceFunction::static_function_name(),
      AutofillPrivateAddOrUpdateEntityInstanceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateRemoveEntityInstanceFunction>,
      AutofillPrivateRemoveEntityInstanceFunction::static_function_name(),
      AutofillPrivateRemoveEntityInstanceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateLoadEntityInstancesFunction>,
      AutofillPrivateLoadEntityInstancesFunction::static_function_name(),
      AutofillPrivateLoadEntityInstancesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetEntityInstanceByGuidFunction>,
      AutofillPrivateGetEntityInstanceByGuidFunction::static_function_name(),
      AutofillPrivateGetEntityInstanceByGuidFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetAllEntityTypesFunction>,
      AutofillPrivateGetAllEntityTypesFunction::static_function_name(),
      AutofillPrivateGetAllEntityTypesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetAllAttributeTypesForEntityTypeNameFunction>,
      AutofillPrivateGetAllAttributeTypesForEntityTypeNameFunction::static_function_name(),
      AutofillPrivateGetAllAttributeTypesForEntityTypeNameFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateGetAutofillAiOptInStatusFunction>,
      AutofillPrivateGetAutofillAiOptInStatusFunction::static_function_name(),
      AutofillPrivateGetAutofillAiOptInStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutofillPrivateSetAutofillAiOptInStatusFunction>,
      AutofillPrivateSetAutofillAiOptInStatusFunction::static_function_name(),
      AutofillPrivateSetAutofillAiOptInStatusFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<AutotestPrivateInitializeEventsFunction>,
      AutotestPrivateInitializeEventsFunction::static_function_name(),
      AutotestPrivateInitializeEventsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateLogoutFunction>,
      AutotestPrivateLogoutFunction::static_function_name(),
      AutotestPrivateLogoutFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRestartFunction>,
      AutotestPrivateRestartFunction::static_function_name(),
      AutotestPrivateRestartFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateShutdownFunction>,
      AutotestPrivateShutdownFunction::static_function_name(),
      AutotestPrivateShutdownFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateLoginStatusFunction>,
      AutotestPrivateLoginStatusFunction::static_function_name(),
      AutotestPrivateLoginStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateWaitForLoginAnimationEndFunction>,
      AutotestPrivateWaitForLoginAnimationEndFunction::static_function_name(),
      AutotestPrivateWaitForLoginAnimationEndFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateLockScreenFunction>,
      AutotestPrivateLockScreenFunction::static_function_name(),
      AutotestPrivateLockScreenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetExtensionsInfoFunction>,
      AutotestPrivateGetExtensionsInfoFunction::static_function_name(),
      AutotestPrivateGetExtensionsInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetAllEnterprisePoliciesFunction>,
      AutotestPrivateGetAllEnterprisePoliciesFunction::static_function_name(),
      AutotestPrivateGetAllEnterprisePoliciesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRefreshEnterprisePoliciesFunction>,
      AutotestPrivateRefreshEnterprisePoliciesFunction::static_function_name(),
      AutotestPrivateRefreshEnterprisePoliciesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRefreshRemoteCommandsFunction>,
      AutotestPrivateRefreshRemoteCommandsFunction::static_function_name(),
      AutotestPrivateRefreshRemoteCommandsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSimulateAsanMemoryBugFunction>,
      AutotestPrivateSimulateAsanMemoryBugFunction::static_function_name(),
      AutotestPrivateSimulateAsanMemoryBugFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetTouchpadSensitivityFunction>,
      AutotestPrivateSetTouchpadSensitivityFunction::static_function_name(),
      AutotestPrivateSetTouchpadSensitivityFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetTapToClickFunction>,
      AutotestPrivateSetTapToClickFunction::static_function_name(),
      AutotestPrivateSetTapToClickFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetThreeFingerClickFunction>,
      AutotestPrivateSetThreeFingerClickFunction::static_function_name(),
      AutotestPrivateSetThreeFingerClickFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetTapDraggingFunction>,
      AutotestPrivateSetTapDraggingFunction::static_function_name(),
      AutotestPrivateSetTapDraggingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetNaturalScrollFunction>,
      AutotestPrivateSetNaturalScrollFunction::static_function_name(),
      AutotestPrivateSetNaturalScrollFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetMouseSensitivityFunction>,
      AutotestPrivateSetMouseSensitivityFunction::static_function_name(),
      AutotestPrivateSetMouseSensitivityFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetPrimaryButtonRightFunction>,
      AutotestPrivateSetPrimaryButtonRightFunction::static_function_name(),
      AutotestPrivateSetPrimaryButtonRightFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetMouseReverseScrollFunction>,
      AutotestPrivateSetMouseReverseScrollFunction::static_function_name(),
      AutotestPrivateSetMouseReverseScrollFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetVisibleNotificationsFunction>,
      AutotestPrivateGetVisibleNotificationsFunction::static_function_name(),
      AutotestPrivateGetVisibleNotificationsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRemoveAllNotificationsFunction>,
      AutotestPrivateRemoveAllNotificationsFunction::static_function_name(),
      AutotestPrivateRemoveAllNotificationsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetArcStartTimeFunction>,
      AutotestPrivateGetArcStartTimeFunction::static_function_name(),
      AutotestPrivateGetArcStartTimeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetArcStateFunction>,
      AutotestPrivateGetArcStateFunction::static_function_name(),
      AutotestPrivateGetArcStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetPlayStoreStateFunction>,
      AutotestPrivateGetPlayStoreStateFunction::static_function_name(),
      AutotestPrivateGetPlayStoreStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetPrinterListFunction>,
      AutotestPrivateGetPrinterListFunction::static_function_name(),
      AutotestPrivateGetPrinterListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsAppShownFunction>,
      AutotestPrivateIsAppShownFunction::static_function_name(),
      AutotestPrivateIsAppShownFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsArcProvisionedFunction>,
      AutotestPrivateIsArcProvisionedFunction::static_function_name(),
      AutotestPrivateIsArcProvisionedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetArcAppFunction>,
      AutotestPrivateGetArcAppFunction::static_function_name(),
      AutotestPrivateGetArcAppFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetArcAppKillsFunction>,
      AutotestPrivateGetArcAppKillsFunction::static_function_name(),
      AutotestPrivateGetArcAppKillsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetArcPackageFunction>,
      AutotestPrivateGetArcPackageFunction::static_function_name(),
      AutotestPrivateGetArcPackageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateWaitForSystemWebAppsInstallFunction>,
      AutotestPrivateWaitForSystemWebAppsInstallFunction::static_function_name(),
      AutotestPrivateWaitForSystemWebAppsInstallFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetDefaultPinnedAppIdsFunction>,
      AutotestPrivateGetDefaultPinnedAppIdsFunction::static_function_name(),
      AutotestPrivateGetDefaultPinnedAppIdsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetRegisteredSystemWebAppsFunction>,
      AutotestPrivateGetRegisteredSystemWebAppsFunction::static_function_name(),
      AutotestPrivateGetRegisteredSystemWebAppsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsSystemWebAppOpenFunction>,
      AutotestPrivateIsSystemWebAppOpenFunction::static_function_name(),
      AutotestPrivateIsSystemWebAppOpenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateLaunchAppFunction>,
      AutotestPrivateLaunchAppFunction::static_function_name(),
      AutotestPrivateLaunchAppFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateLaunchSystemWebAppFunction>,
      AutotestPrivateLaunchSystemWebAppFunction::static_function_name(),
      AutotestPrivateLaunchSystemWebAppFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateLaunchFilesAppToPathFunction>,
      AutotestPrivateLaunchFilesAppToPathFunction::static_function_name(),
      AutotestPrivateLaunchFilesAppToPathFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateCloseAppFunction>,
      AutotestPrivateCloseAppFunction::static_function_name(),
      AutotestPrivateCloseAppFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateUpdatePrinterFunction>,
      AutotestPrivateUpdatePrinterFunction::static_function_name(),
      AutotestPrivateUpdatePrinterFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRemovePrinterFunction>,
      AutotestPrivateRemovePrinterFunction::static_function_name(),
      AutotestPrivateRemovePrinterFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetPlayStoreEnabledFunction>,
      AutotestPrivateSetPlayStoreEnabledFunction::static_function_name(),
      AutotestPrivateSetPlayStoreEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetClipboardTextDataFunction>,
      AutotestPrivateGetClipboardTextDataFunction::static_function_name(),
      AutotestPrivateGetClipboardTextDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetClipboardTextDataFunction>,
      AutotestPrivateSetClipboardTextDataFunction::static_function_name(),
      AutotestPrivateSetClipboardTextDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRunCrostiniInstallerFunction>,
      AutotestPrivateRunCrostiniInstallerFunction::static_function_name(),
      AutotestPrivateRunCrostiniInstallerFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRunCrostiniUninstallerFunction>,
      AutotestPrivateRunCrostiniUninstallerFunction::static_function_name(),
      AutotestPrivateRunCrostiniUninstallerFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetCrostiniEnabledFunction>,
      AutotestPrivateSetCrostiniEnabledFunction::static_function_name(),
      AutotestPrivateSetCrostiniEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateExportCrostiniFunction>,
      AutotestPrivateExportCrostiniFunction::static_function_name(),
      AutotestPrivateExportCrostiniFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateImportCrostiniFunction>,
      AutotestPrivateImportCrostiniFunction::static_function_name(),
      AutotestPrivateImportCrostiniFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateCouldAllowCrostiniFunction>,
      AutotestPrivateCouldAllowCrostiniFunction::static_function_name(),
      AutotestPrivateCouldAllowCrostiniFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetPluginVMPolicyFunction>,
      AutotestPrivateSetPluginVMPolicyFunction::static_function_name(),
      AutotestPrivateSetPluginVMPolicyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateShowPluginVMInstallerFunction>,
      AutotestPrivateShowPluginVMInstallerFunction::static_function_name(),
      AutotestPrivateShowPluginVMInstallerFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateInstallBorealisFunction>,
      AutotestPrivateInstallBorealisFunction::static_function_name(),
      AutotestPrivateInstallBorealisFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRegisterComponentFunction>,
      AutotestPrivateRegisterComponentFunction::static_function_name(),
      AutotestPrivateRegisterComponentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateTakeScreenshotFunction>,
      AutotestPrivateTakeScreenshotFunction::static_function_name(),
      AutotestPrivateTakeScreenshotFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateTakeScreenshotForDisplayFunction>,
      AutotestPrivateTakeScreenshotForDisplayFunction::static_function_name(),
      AutotestPrivateTakeScreenshotForDisplayFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateLoadSmartDimComponentFunction>,
      AutotestPrivateLoadSmartDimComponentFunction::static_function_name(),
      AutotestPrivateLoadSmartDimComponentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsArcPackageListInitialRefreshedFunction>,
      AutotestPrivateIsArcPackageListInitialRefreshedFunction::static_function_name(),
      AutotestPrivateIsArcPackageListInitialRefreshedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetAllowedPrefFunction>,
      AutotestPrivateSetAllowedPrefFunction::static_function_name(),
      AutotestPrivateSetAllowedPrefFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateClearAllowedPrefFunction>,
      AutotestPrivateClearAllowedPrefFunction::static_function_name(),
      AutotestPrivateClearAllowedPrefFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetWhitelistedPrefFunction>,
      AutotestPrivateSetWhitelistedPrefFunction::static_function_name(),
      AutotestPrivateSetWhitelistedPrefFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetCrostiniAppScaledFunction>,
      AutotestPrivateSetCrostiniAppScaledFunction::static_function_name(),
      AutotestPrivateSetCrostiniAppScaledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetPrimaryDisplayScaleFactorFunction>,
      AutotestPrivateGetPrimaryDisplayScaleFactorFunction::static_function_name(),
      AutotestPrivateGetPrimaryDisplayScaleFactorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsTabletModeEnabledFunction>,
      AutotestPrivateIsTabletModeEnabledFunction::static_function_name(),
      AutotestPrivateIsTabletModeEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetTabletModeEnabledFunction>,
      AutotestPrivateSetTabletModeEnabledFunction::static_function_name(),
      AutotestPrivateSetTabletModeEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetAllInstalledAppsFunction>,
      AutotestPrivateGetAllInstalledAppsFunction::static_function_name(),
      AutotestPrivateGetAllInstalledAppsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetShelfItemsFunction>,
      AutotestPrivateGetShelfItemsFunction::static_function_name(),
      AutotestPrivateGetShelfItemsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetLauncherSearchBoxStateFunction>,
      AutotestPrivateGetLauncherSearchBoxStateFunction::static_function_name(),
      AutotestPrivateGetLauncherSearchBoxStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetShelfAutoHideBehaviorFunction>,
      AutotestPrivateGetShelfAutoHideBehaviorFunction::static_function_name(),
      AutotestPrivateGetShelfAutoHideBehaviorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetShelfAutoHideBehaviorFunction>,
      AutotestPrivateSetShelfAutoHideBehaviorFunction::static_function_name(),
      AutotestPrivateSetShelfAutoHideBehaviorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetShelfAlignmentFunction>,
      AutotestPrivateGetShelfAlignmentFunction::static_function_name(),
      AutotestPrivateGetShelfAlignmentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetShelfAlignmentFunction>,
      AutotestPrivateSetShelfAlignmentFunction::static_function_name(),
      AutotestPrivateSetShelfAlignmentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivatePinShelfIconFunction>,
      AutotestPrivatePinShelfIconFunction::static_function_name(),
      AutotestPrivatePinShelfIconFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetShelfIconPinFunction>,
      AutotestPrivateSetShelfIconPinFunction::static_function_name(),
      AutotestPrivateSetShelfIconPinFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetOverviewModeStateFunction>,
      AutotestPrivateSetOverviewModeStateFunction::static_function_name(),
      AutotestPrivateSetOverviewModeStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateShowVirtualKeyboardIfEnabledFunction>,
      AutotestPrivateShowVirtualKeyboardIfEnabledFunction::static_function_name(),
      AutotestPrivateShowVirtualKeyboardIfEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSendArcOverlayColorFunction>,
      AutotestPrivateSendArcOverlayColorFunction::static_function_name(),
      AutotestPrivateSendArcOverlayColorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateArcAppTracingStartFunction>,
      AutotestPrivateArcAppTracingStartFunction::static_function_name(),
      AutotestPrivateArcAppTracingStartFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateArcAppTracingStopAndAnalyzeFunction>,
      AutotestPrivateArcAppTracingStopAndAnalyzeFunction::static_function_name(),
      AutotestPrivateArcAppTracingStopAndAnalyzeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSwapWindowsInSplitViewFunction>,
      AutotestPrivateSwapWindowsInSplitViewFunction::static_function_name(),
      AutotestPrivateSwapWindowsInSplitViewFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetArcAppWindowFocusFunction>,
      AutotestPrivateSetArcAppWindowFocusFunction::static_function_name(),
      AutotestPrivateSetArcAppWindowFocusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateWaitForDisplayRotationFunction>,
      AutotestPrivateWaitForDisplayRotationFunction::static_function_name(),
      AutotestPrivateWaitForDisplayRotationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetAppWindowListFunction>,
      AutotestPrivateGetAppWindowListFunction::static_function_name(),
      AutotestPrivateGetAppWindowListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetAppWindowStateFunction>,
      AutotestPrivateSetAppWindowStateFunction::static_function_name(),
      AutotestPrivateSetAppWindowStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateActivateAppWindowFunction>,
      AutotestPrivateActivateAppWindowFunction::static_function_name(),
      AutotestPrivateActivateAppWindowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateCloseAppWindowFunction>,
      AutotestPrivateCloseAppWindowFunction::static_function_name(),
      AutotestPrivateCloseAppWindowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateInstallPWAForCurrentURLFunction>,
      AutotestPrivateInstallPWAForCurrentURLFunction::static_function_name(),
      AutotestPrivateInstallPWAForCurrentURLFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateActivateAcceleratorFunction>,
      AutotestPrivateActivateAcceleratorFunction::static_function_name(),
      AutotestPrivateActivateAcceleratorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateWaitForLauncherStateFunction>,
      AutotestPrivateWaitForLauncherStateFunction::static_function_name(),
      AutotestPrivateWaitForLauncherStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateWaitForOverviewStateFunction>,
      AutotestPrivateWaitForOverviewStateFunction::static_function_name(),
      AutotestPrivateWaitForOverviewStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateCreateNewDeskFunction>,
      AutotestPrivateCreateNewDeskFunction::static_function_name(),
      AutotestPrivateCreateNewDeskFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateActivateDeskAtIndexFunction>,
      AutotestPrivateActivateDeskAtIndexFunction::static_function_name(),
      AutotestPrivateActivateDeskAtIndexFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRemoveActiveDeskFunction>,
      AutotestPrivateRemoveActiveDeskFunction::static_function_name(),
      AutotestPrivateRemoveActiveDeskFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateActivateAdjacentDesksToTargetIndexFunction>,
      AutotestPrivateActivateAdjacentDesksToTargetIndexFunction::static_function_name(),
      AutotestPrivateActivateAdjacentDesksToTargetIndexFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetDeskCountFunction>,
      AutotestPrivateGetDeskCountFunction::static_function_name(),
      AutotestPrivateGetDeskCountFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetDesksInfoFunction>,
      AutotestPrivateGetDesksInfoFunction::static_function_name(),
      AutotestPrivateGetDesksInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateMouseClickFunction>,
      AutotestPrivateMouseClickFunction::static_function_name(),
      AutotestPrivateMouseClickFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateMousePressFunction>,
      AutotestPrivateMousePressFunction::static_function_name(),
      AutotestPrivateMousePressFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateMouseReleaseFunction>,
      AutotestPrivateMouseReleaseFunction::static_function_name(),
      AutotestPrivateMouseReleaseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateMouseMoveFunction>,
      AutotestPrivateMouseMoveFunction::static_function_name(),
      AutotestPrivateMouseMoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetMetricsEnabledFunction>,
      AutotestPrivateSetMetricsEnabledFunction::static_function_name(),
      AutotestPrivateSetMetricsEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetArcTouchModeFunction>,
      AutotestPrivateSetArcTouchModeFunction::static_function_name(),
      AutotestPrivateSetArcTouchModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetScrollableShelfInfoForStateFunction>,
      AutotestPrivateGetScrollableShelfInfoForStateFunction::static_function_name(),
      AutotestPrivateGetScrollableShelfInfoForStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetShelfUIInfoForStateFunction>,
      AutotestPrivateGetShelfUIInfoForStateFunction::static_function_name(),
      AutotestPrivateGetShelfUIInfoForStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetWindowBoundsFunction>,
      AutotestPrivateSetWindowBoundsFunction::static_function_name(),
      AutotestPrivateSetWindowBoundsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStartSmoothnessTrackingFunction>,
      AutotestPrivateStartSmoothnessTrackingFunction::static_function_name(),
      AutotestPrivateStartSmoothnessTrackingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStopSmoothnessTrackingFunction>,
      AutotestPrivateStopSmoothnessTrackingFunction::static_function_name(),
      AutotestPrivateStopSmoothnessTrackingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateDisableSwitchAccessDialogFunction>,
      AutotestPrivateDisableSwitchAccessDialogFunction::static_function_name(),
      AutotestPrivateDisableSwitchAccessDialogFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateWaitForAmbientPhotoAnimationFunction>,
      AutotestPrivateWaitForAmbientPhotoAnimationFunction::static_function_name(),
      AutotestPrivateWaitForAmbientPhotoAnimationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateWaitForAmbientVideoFunction>,
      AutotestPrivateWaitForAmbientVideoFunction::static_function_name(),
      AutotestPrivateWaitForAmbientVideoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateDisableAutomationFunction>,
      AutotestPrivateDisableAutomationFunction::static_function_name(),
      AutotestPrivateDisableAutomationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStartThroughputTrackerDataCollectionFunction>,
      AutotestPrivateStartThroughputTrackerDataCollectionFunction::static_function_name(),
      AutotestPrivateStartThroughputTrackerDataCollectionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStopThroughputTrackerDataCollectionFunction>,
      AutotestPrivateStopThroughputTrackerDataCollectionFunction::static_function_name(),
      AutotestPrivateStopThroughputTrackerDataCollectionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetThroughputTrackerDataFunction>,
      AutotestPrivateGetThroughputTrackerDataFunction::static_function_name(),
      AutotestPrivateGetThroughputTrackerDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetDisplaySmoothnessFunction>,
      AutotestPrivateGetDisplaySmoothnessFunction::static_function_name(),
      AutotestPrivateGetDisplaySmoothnessFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateResetHoldingSpaceFunction>,
      AutotestPrivateResetHoldingSpaceFunction::static_function_name(),
      AutotestPrivateResetHoldingSpaceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStartLoginEventRecorderDataCollectionFunction>,
      AutotestPrivateStartLoginEventRecorderDataCollectionFunction::static_function_name(),
      AutotestPrivateStartLoginEventRecorderDataCollectionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetLoginEventRecorderLoginEventsFunction>,
      AutotestPrivateGetLoginEventRecorderLoginEventsFunction::static_function_name(),
      AutotestPrivateGetLoginEventRecorderLoginEventsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateAddLoginEventForTestingFunction>,
      AutotestPrivateAddLoginEventForTestingFunction::static_function_name(),
      AutotestPrivateAddLoginEventForTestingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateForceAutoThemeModeFunction>,
      AutotestPrivateForceAutoThemeModeFunction::static_function_name(),
      AutotestPrivateForceAutoThemeModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetAccessTokenFunction>,
      AutotestPrivateGetAccessTokenFunction::static_function_name(),
      AutotestPrivateGetAccessTokenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsInputMethodReadyForTestingFunction>,
      AutotestPrivateIsInputMethodReadyForTestingFunction::static_function_name(),
      AutotestPrivateIsInputMethodReadyForTestingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateMakeFuseboxTempDirFunction>,
      AutotestPrivateMakeFuseboxTempDirFunction::static_function_name(),
      AutotestPrivateMakeFuseboxTempDirFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRemoveFuseboxTempDirFunction>,
      AutotestPrivateRemoveFuseboxTempDirFunction::static_function_name(),
      AutotestPrivateRemoveFuseboxTempDirFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRemoveComponentExtensionFunction>,
      AutotestPrivateRemoveComponentExtensionFunction::static_function_name(),
      AutotestPrivateRemoveComponentExtensionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStartFrameCountingFunction>,
      AutotestPrivateStartFrameCountingFunction::static_function_name(),
      AutotestPrivateStartFrameCountingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStopFrameCountingFunction>,
      AutotestPrivateStopFrameCountingFunction::static_function_name(),
      AutotestPrivateStopFrameCountingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStartOverdrawTrackingFunction>,
      AutotestPrivateStartOverdrawTrackingFunction::static_function_name(),
      AutotestPrivateStartOverdrawTrackingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateStopOverdrawTrackingFunction>,
      AutotestPrivateStopOverdrawTrackingFunction::static_function_name(),
      AutotestPrivateStopOverdrawTrackingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateInstallBruschettaFunction>,
      AutotestPrivateInstallBruschettaFunction::static_function_name(),
      AutotestPrivateInstallBruschettaFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateRemoveBruschettaFunction>,
      AutotestPrivateRemoveBruschettaFunction::static_function_name(),
      AutotestPrivateRemoveBruschettaFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsFeatureEnabledFunction>,
      AutotestPrivateIsFeatureEnabledFunction::static_function_name(),
      AutotestPrivateIsFeatureEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetCurrentInputMethodDescriptorFunction>,
      AutotestPrivateGetCurrentInputMethodDescriptorFunction::static_function_name(),
      AutotestPrivateGetCurrentInputMethodDescriptorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateOverrideLobsterResponseForTestingFunction>,
      AutotestPrivateOverrideLobsterResponseForTestingFunction::static_function_name(),
      AutotestPrivateOverrideLobsterResponseForTestingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateOverrideOrcaResponseForTestingFunction>,
      AutotestPrivateOverrideOrcaResponseForTestingFunction::static_function_name(),
      AutotestPrivateOverrideOrcaResponseForTestingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateOverrideScannerResponsesForTestingFunction>,
      AutotestPrivateOverrideScannerResponsesForTestingFunction::static_function_name(),
      AutotestPrivateOverrideScannerResponsesForTestingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetArcInteractiveStateFunction>,
      AutotestPrivateSetArcInteractiveStateFunction::static_function_name(),
      AutotestPrivateSetArcInteractiveStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateIsFieldTrialActiveFunction>,
      AutotestPrivateIsFieldTrialActiveFunction::static_function_name(),
      AutotestPrivateIsFieldTrialActiveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetArcWakefulnessModeFunction>,
      AutotestPrivateGetArcWakefulnessModeFunction::static_function_name(),
      AutotestPrivateGetArcWakefulnessModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateSetDeviceLanguageFunction>,
      AutotestPrivateSetDeviceLanguageFunction::static_function_name(),
      AutotestPrivateSetDeviceLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutotestPrivateGetDeviceEventLogFunction>,
      AutotestPrivateGetDeviceEventLogFunction::static_function_name(),
      AutotestPrivateGetDeviceEventLogFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<BookmarkManagerPrivateCopyFunction>,
      BookmarkManagerPrivateCopyFunction::static_function_name(),
      BookmarkManagerPrivateCopyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateCutFunction>,
      BookmarkManagerPrivateCutFunction::static_function_name(),
      BookmarkManagerPrivateCutFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivatePasteFunction>,
      BookmarkManagerPrivatePasteFunction::static_function_name(),
      BookmarkManagerPrivatePasteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateCanPasteFunction>,
      BookmarkManagerPrivateCanPasteFunction::static_function_name(),
      BookmarkManagerPrivateCanPasteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateIsActiveTabInSplitFunction>,
      BookmarkManagerPrivateIsActiveTabInSplitFunction::static_function_name(),
      BookmarkManagerPrivateIsActiveTabInSplitFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateSortChildrenFunction>,
      BookmarkManagerPrivateSortChildrenFunction::static_function_name(),
      BookmarkManagerPrivateSortChildrenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateStartDragFunction>,
      BookmarkManagerPrivateStartDragFunction::static_function_name(),
      BookmarkManagerPrivateStartDragFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateDropFunction>,
      BookmarkManagerPrivateDropFunction::static_function_name(),
      BookmarkManagerPrivateDropFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateGetSubtreeFunction>,
      BookmarkManagerPrivateGetSubtreeFunction::static_function_name(),
      BookmarkManagerPrivateGetSubtreeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateRemoveTreesFunction>,
      BookmarkManagerPrivateRemoveTreesFunction::static_function_name(),
      BookmarkManagerPrivateRemoveTreesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateUndoFunction>,
      BookmarkManagerPrivateUndoFunction::static_function_name(),
      BookmarkManagerPrivateUndoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateRedoFunction>,
      BookmarkManagerPrivateRedoFunction::static_function_name(),
      BookmarkManagerPrivateRedoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateOpenInNewTabFunction>,
      BookmarkManagerPrivateOpenInNewTabFunction::static_function_name(),
      BookmarkManagerPrivateOpenInNewTabFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateOpenInNewWindowFunction>,
      BookmarkManagerPrivateOpenInNewWindowFunction::static_function_name(),
      BookmarkManagerPrivateOpenInNewWindowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateOpenInNewTabGroupFunction>,
      BookmarkManagerPrivateOpenInNewTabGroupFunction::static_function_name(),
      BookmarkManagerPrivateOpenInNewTabGroupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateImportFunction>,
      BookmarkManagerPrivateImportFunction::static_function_name(),
      BookmarkManagerPrivateImportFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BookmarkManagerPrivateExportFunction>,
      BookmarkManagerPrivateExportFunction::static_function_name(),
      BookmarkManagerPrivateExportFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrailleDisplayPrivateGetDisplayStateFunction>,
      BrailleDisplayPrivateGetDisplayStateFunction::static_function_name(),
      BrailleDisplayPrivateGetDisplayStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrailleDisplayPrivateWriteDotsFunction>,
      BrailleDisplayPrivateWriteDotsFunction::static_function_name(),
      BrailleDisplayPrivateWriteDotsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrailleDisplayPrivateUpdateBluetoothBrailleDisplayAddressFunction>,
      BrailleDisplayPrivateUpdateBluetoothBrailleDisplayAddressFunction::static_function_name(),
      BrailleDisplayPrivateUpdateBluetoothBrailleDisplayAddressFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ChromeWebViewInternalContextMenusCreateFunction>,
      ChromeWebViewInternalContextMenusCreateFunction::static_function_name(),
      ChromeWebViewInternalContextMenusCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ChromeWebViewInternalContextMenusUpdateFunction>,
      ChromeWebViewInternalContextMenusUpdateFunction::static_function_name(),
      ChromeWebViewInternalContextMenusUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ChromeWebViewInternalContextMenusRemoveFunction>,
      ChromeWebViewInternalContextMenusRemoveFunction::static_function_name(),
      ChromeWebViewInternalContextMenusRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ChromeWebViewInternalContextMenusRemoveAllFunction>,
      ChromeWebViewInternalContextMenusRemoveAllFunction::static_function_name(),
      ChromeWebViewInternalContextMenusRemoveAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ChromeWebViewInternalShowContextMenuFunction>,
      ChromeWebViewInternalShowContextMenuFunction::static_function_name(),
      ChromeWebViewInternalShowContextMenuFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CommandLinePrivateHasSwitchFunction>,
      CommandLinePrivateHasSwitchFunction::static_function_name(),
      CommandLinePrivateHasSwitchFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContentSettingsContentSettingClearFunction>,
      ContentSettingsContentSettingClearFunction::static_function_name(),
      ContentSettingsContentSettingClearFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContentSettingsContentSettingGetFunction>,
      ContentSettingsContentSettingGetFunction::static_function_name(),
      ContentSettingsContentSettingGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContentSettingsContentSettingSetFunction>,
      ContentSettingsContentSettingSetFunction::static_function_name(),
      ContentSettingsContentSettingSetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ContentSettingsContentSettingGetResourceIdentifiersFunction>,
      ContentSettingsContentSettingGetResourceIdentifiersFunction::static_function_name(),
      ContentSettingsContentSettingGetResourceIdentifiersFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DesktopCaptureChooseDesktopMediaFunction>,
      DesktopCaptureChooseDesktopMediaFunction::static_function_name(),
      DesktopCaptureChooseDesktopMediaFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DesktopCaptureCancelChooseDesktopMediaFunction>,
      DesktopCaptureCancelChooseDesktopMediaFunction::static_function_name(),
      DesktopCaptureCancelChooseDesktopMediaFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<CrashReportPrivateReportErrorFunction>,
      CrashReportPrivateReportErrorFunction::static_function_name(),
      CrashReportPrivateReportErrorFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<DownloadsDownloadFunction>,
      DownloadsDownloadFunction::static_function_name(),
      DownloadsDownloadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsSearchFunction>,
      DownloadsSearchFunction::static_function_name(),
      DownloadsSearchFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsPauseFunction>,
      DownloadsPauseFunction::static_function_name(),
      DownloadsPauseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsResumeFunction>,
      DownloadsResumeFunction::static_function_name(),
      DownloadsResumeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsCancelFunction>,
      DownloadsCancelFunction::static_function_name(),
      DownloadsCancelFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsGetFileIconFunction>,
      DownloadsGetFileIconFunction::static_function_name(),
      DownloadsGetFileIconFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsOpenFunction>,
      DownloadsOpenFunction::static_function_name(),
      DownloadsOpenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsShowFunction>,
      DownloadsShowFunction::static_function_name(),
      DownloadsShowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsShowDefaultFolderFunction>,
      DownloadsShowDefaultFolderFunction::static_function_name(),
      DownloadsShowDefaultFolderFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsEraseFunction>,
      DownloadsEraseFunction::static_function_name(),
      DownloadsEraseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsRemoveFileFunction>,
      DownloadsRemoveFileFunction::static_function_name(),
      DownloadsRemoveFileFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsAcceptDangerFunction>,
      DownloadsAcceptDangerFunction::static_function_name(),
      DownloadsAcceptDangerFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsSetShelfEnabledFunction>,
      DownloadsSetShelfEnabledFunction::static_function_name(),
      DownloadsSetShelfEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsSetUiOptionsFunction>,
      DownloadsSetUiOptionsFunction::static_function_name(),
      DownloadsSetUiOptionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DownloadsInternalDetermineFilenameFunction>,
      DownloadsInternalDetermineFilenameFunction::static_function_name(),
      DownloadsInternalDetermineFilenameFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetDeviceIdFunction>,
      EnterpriseReportingPrivateGetDeviceIdFunction::static_function_name(),
      EnterpriseReportingPrivateGetDeviceIdFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetPersistentSecretFunction>,
      EnterpriseReportingPrivateGetPersistentSecretFunction::static_function_name(),
      EnterpriseReportingPrivateGetPersistentSecretFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC)
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetDeviceDataFunction>,
      EnterpriseReportingPrivateGetDeviceDataFunction::static_function_name(),
      EnterpriseReportingPrivateGetDeviceDataFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateSetDeviceDataFunction>,
      EnterpriseReportingPrivateSetDeviceDataFunction::static_function_name(),
      EnterpriseReportingPrivateSetDeviceDataFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetDeviceInfoFunction>,
      EnterpriseReportingPrivateGetDeviceInfoFunction::static_function_name(),
      EnterpriseReportingPrivateGetDeviceInfoFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetContextInfoFunction>,
      EnterpriseReportingPrivateGetContextInfoFunction::static_function_name(),
      EnterpriseReportingPrivateGetContextInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetCertificateFunction>,
      EnterpriseReportingPrivateGetCertificateFunction::static_function_name(),
      EnterpriseReportingPrivateGetCertificateFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateEnqueueRecordFunction>,
      EnterpriseReportingPrivateEnqueueRecordFunction::static_function_name(),
      EnterpriseReportingPrivateEnqueueRecordFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetFileSystemInfoFunction>,
      EnterpriseReportingPrivateGetFileSystemInfoFunction::static_function_name(),
      EnterpriseReportingPrivateGetFileSystemInfoFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_LINUX)
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetSettingsFunction>,
      EnterpriseReportingPrivateGetSettingsFunction::static_function_name(),
      EnterpriseReportingPrivateGetSettingsFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC)
    #if BUILDFLAG(IS_WIN)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetAvInfoFunction>,
      EnterpriseReportingPrivateGetAvInfoFunction::static_function_name(),
      EnterpriseReportingPrivateGetAvInfoFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN)
    #if BUILDFLAG(IS_WIN)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateGetHotfixesFunction>,
      EnterpriseReportingPrivateGetHotfixesFunction::static_function_name(),
      EnterpriseReportingPrivateGetHotfixesFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN)
    {
      &NewExtensionFunction<EnterpriseReportingPrivateReportDataMaskingEventFunction>,
      EnterpriseReportingPrivateReportDataMaskingEventFunction::static_function_name(),
      EnterpriseReportingPrivateReportDataMaskingEventFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ImageWriterPrivateWriteFromUrlFunction>,
      ImageWriterPrivateWriteFromUrlFunction::static_function_name(),
      ImageWriterPrivateWriteFromUrlFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ImageWriterPrivateWriteFromFileFunction>,
      ImageWriterPrivateWriteFromFileFunction::static_function_name(),
      ImageWriterPrivateWriteFromFileFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ImageWriterPrivateCancelWriteFunction>,
      ImageWriterPrivateCancelWriteFunction::static_function_name(),
      ImageWriterPrivateCancelWriteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ImageWriterPrivateDestroyPartitionsFunction>,
      ImageWriterPrivateDestroyPartitionsFunction::static_function_name(),
      ImageWriterPrivateDestroyPartitionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ImageWriterPrivateListRemovableStorageDevicesFunction>,
      ImageWriterPrivateListRemovableStorageDevicesFunction::static_function_name(),
      ImageWriterPrivateListRemovableStorageDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateGetLanguageListFunction>,
      LanguageSettingsPrivateGetLanguageListFunction::static_function_name(),
      LanguageSettingsPrivateGetLanguageListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateEnableLanguageFunction>,
      LanguageSettingsPrivateEnableLanguageFunction::static_function_name(),
      LanguageSettingsPrivateEnableLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateDisableLanguageFunction>,
      LanguageSettingsPrivateDisableLanguageFunction::static_function_name(),
      LanguageSettingsPrivateDisableLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateSetEnableTranslationForLanguageFunction>,
      LanguageSettingsPrivateSetEnableTranslationForLanguageFunction::static_function_name(),
      LanguageSettingsPrivateSetEnableTranslationForLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateMoveLanguageFunction>,
      LanguageSettingsPrivateMoveLanguageFunction::static_function_name(),
      LanguageSettingsPrivateMoveLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateGetAlwaysTranslateLanguagesFunction>,
      LanguageSettingsPrivateGetAlwaysTranslateLanguagesFunction::static_function_name(),
      LanguageSettingsPrivateGetAlwaysTranslateLanguagesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateSetLanguageAlwaysTranslateStateFunction>,
      LanguageSettingsPrivateSetLanguageAlwaysTranslateStateFunction::static_function_name(),
      LanguageSettingsPrivateSetLanguageAlwaysTranslateStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateGetNeverTranslateLanguagesFunction>,
      LanguageSettingsPrivateGetNeverTranslateLanguagesFunction::static_function_name(),
      LanguageSettingsPrivateGetNeverTranslateLanguagesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateGetSpellcheckDictionaryStatusesFunction>,
      LanguageSettingsPrivateGetSpellcheckDictionaryStatusesFunction::static_function_name(),
      LanguageSettingsPrivateGetSpellcheckDictionaryStatusesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateGetSpellcheckWordsFunction>,
      LanguageSettingsPrivateGetSpellcheckWordsFunction::static_function_name(),
      LanguageSettingsPrivateGetSpellcheckWordsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateAddSpellcheckWordFunction>,
      LanguageSettingsPrivateAddSpellcheckWordFunction::static_function_name(),
      LanguageSettingsPrivateAddSpellcheckWordFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateRemoveSpellcheckWordFunction>,
      LanguageSettingsPrivateRemoveSpellcheckWordFunction::static_function_name(),
      LanguageSettingsPrivateRemoveSpellcheckWordFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateGetTranslateTargetLanguageFunction>,
      LanguageSettingsPrivateGetTranslateTargetLanguageFunction::static_function_name(),
      LanguageSettingsPrivateGetTranslateTargetLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateSetTranslateTargetLanguageFunction>,
      LanguageSettingsPrivateSetTranslateTargetLanguageFunction::static_function_name(),
      LanguageSettingsPrivateSetTranslateTargetLanguageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateGetInputMethodListsFunction>,
      LanguageSettingsPrivateGetInputMethodListsFunction::static_function_name(),
      LanguageSettingsPrivateGetInputMethodListsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateAddInputMethodFunction>,
      LanguageSettingsPrivateAddInputMethodFunction::static_function_name(),
      LanguageSettingsPrivateAddInputMethodFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateRemoveInputMethodFunction>,
      LanguageSettingsPrivateRemoveInputMethodFunction::static_function_name(),
      LanguageSettingsPrivateRemoveInputMethodFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<LanguageSettingsPrivateRetryDownloadDictionaryFunction>,
      LanguageSettingsPrivateRetryDownloadDictionaryFunction::static_function_name(),
      LanguageSettingsPrivateRetryDownloadDictionaryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateRecordPasswordsPageAccessInSettingsFunction>,
      PasswordsPrivateRecordPasswordsPageAccessInSettingsFunction::static_function_name(),
      PasswordsPrivateRecordPasswordsPageAccessInSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateChangeCredentialFunction>,
      PasswordsPrivateChangeCredentialFunction::static_function_name(),
      PasswordsPrivateChangeCredentialFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateRemoveCredentialFunction>,
      PasswordsPrivateRemoveCredentialFunction::static_function_name(),
      PasswordsPrivateRemoveCredentialFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateRemovePasswordExceptionFunction>,
      PasswordsPrivateRemovePasswordExceptionFunction::static_function_name(),
      PasswordsPrivateRemovePasswordExceptionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateUndoRemoveSavedPasswordOrExceptionFunction>,
      PasswordsPrivateUndoRemoveSavedPasswordOrExceptionFunction::static_function_name(),
      PasswordsPrivateUndoRemoveSavedPasswordOrExceptionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateRequestPlaintextPasswordFunction>,
      PasswordsPrivateRequestPlaintextPasswordFunction::static_function_name(),
      PasswordsPrivateRequestPlaintextPasswordFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateRequestCredentialsDetailsFunction>,
      PasswordsPrivateRequestCredentialsDetailsFunction::static_function_name(),
      PasswordsPrivateRequestCredentialsDetailsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateGetSavedPasswordListFunction>,
      PasswordsPrivateGetSavedPasswordListFunction::static_function_name(),
      PasswordsPrivateGetSavedPasswordListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateGetCredentialGroupsFunction>,
      PasswordsPrivateGetCredentialGroupsFunction::static_function_name(),
      PasswordsPrivateGetCredentialGroupsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateGetPasswordExceptionListFunction>,
      PasswordsPrivateGetPasswordExceptionListFunction::static_function_name(),
      PasswordsPrivateGetPasswordExceptionListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateMovePasswordsToAccountFunction>,
      PasswordsPrivateMovePasswordsToAccountFunction::static_function_name(),
      PasswordsPrivateMovePasswordsToAccountFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateFetchFamilyMembersFunction>,
      PasswordsPrivateFetchFamilyMembersFunction::static_function_name(),
      PasswordsPrivateFetchFamilyMembersFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateSharePasswordFunction>,
      PasswordsPrivateSharePasswordFunction::static_function_name(),
      PasswordsPrivateSharePasswordFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateImportPasswordsFunction>,
      PasswordsPrivateImportPasswordsFunction::static_function_name(),
      PasswordsPrivateImportPasswordsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateContinueImportFunction>,
      PasswordsPrivateContinueImportFunction::static_function_name(),
      PasswordsPrivateContinueImportFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateResetImporterFunction>,
      PasswordsPrivateResetImporterFunction::static_function_name(),
      PasswordsPrivateResetImporterFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateExportPasswordsFunction>,
      PasswordsPrivateExportPasswordsFunction::static_function_name(),
      PasswordsPrivateExportPasswordsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateRequestExportProgressStatusFunction>,
      PasswordsPrivateRequestExportProgressStatusFunction::static_function_name(),
      PasswordsPrivateRequestExportProgressStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateIsAccountStorageEnabledFunction>,
      PasswordsPrivateIsAccountStorageEnabledFunction::static_function_name(),
      PasswordsPrivateIsAccountStorageEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateSetAccountStorageEnabledFunction>,
      PasswordsPrivateSetAccountStorageEnabledFunction::static_function_name(),
      PasswordsPrivateSetAccountStorageEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateShouldShowAccountStorageSettingToggleFunction>,
      PasswordsPrivateShouldShowAccountStorageSettingToggleFunction::static_function_name(),
      PasswordsPrivateShouldShowAccountStorageSettingToggleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateGetInsecureCredentialsFunction>,
      PasswordsPrivateGetInsecureCredentialsFunction::static_function_name(),
      PasswordsPrivateGetInsecureCredentialsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateGetCredentialsWithReusedPasswordFunction>,
      PasswordsPrivateGetCredentialsWithReusedPasswordFunction::static_function_name(),
      PasswordsPrivateGetCredentialsWithReusedPasswordFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateMuteInsecureCredentialFunction>,
      PasswordsPrivateMuteInsecureCredentialFunction::static_function_name(),
      PasswordsPrivateMuteInsecureCredentialFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateUnmuteInsecureCredentialFunction>,
      PasswordsPrivateUnmuteInsecureCredentialFunction::static_function_name(),
      PasswordsPrivateUnmuteInsecureCredentialFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateStartPasswordCheckFunction>,
      PasswordsPrivateStartPasswordCheckFunction::static_function_name(),
      PasswordsPrivateStartPasswordCheckFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateGetPasswordCheckStatusFunction>,
      PasswordsPrivateGetPasswordCheckStatusFunction::static_function_name(),
      PasswordsPrivateGetPasswordCheckStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateGetUrlCollectionFunction>,
      PasswordsPrivateGetUrlCollectionFunction::static_function_name(),
      PasswordsPrivateGetUrlCollectionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateAddPasswordFunction>,
      PasswordsPrivateAddPasswordFunction::static_function_name(),
      PasswordsPrivateAddPasswordFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateExtendAuthValidityFunction>,
      PasswordsPrivateExtendAuthValidityFunction::static_function_name(),
      PasswordsPrivateExtendAuthValidityFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<PasswordsPrivateSwitchBiometricAuthBeforeFillingStateFunction>,
      PasswordsPrivateSwitchBiometricAuthBeforeFillingStateFunction::static_function_name(),
      PasswordsPrivateSwitchBiometricAuthBeforeFillingStateFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC) || BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<PasswordsPrivateShowAddShortcutDialogFunction>,
      PasswordsPrivateShowAddShortcutDialogFunction::static_function_name(),
      PasswordsPrivateShowAddShortcutDialogFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateShowExportedFileInShellFunction>,
      PasswordsPrivateShowExportedFileInShellFunction::static_function_name(),
      PasswordsPrivateShowExportedFileInShellFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateChangePasswordManagerPinFunction>,
      PasswordsPrivateChangePasswordManagerPinFunction::static_function_name(),
      PasswordsPrivateChangePasswordManagerPinFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateIsPasswordManagerPinAvailableFunction>,
      PasswordsPrivateIsPasswordManagerPinAvailableFunction::static_function_name(),
      PasswordsPrivateIsPasswordManagerPinAvailableFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateDisconnectCloudAuthenticatorFunction>,
      PasswordsPrivateDisconnectCloudAuthenticatorFunction::static_function_name(),
      PasswordsPrivateDisconnectCloudAuthenticatorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateIsConnectedToCloudAuthenticatorFunction>,
      PasswordsPrivateIsConnectedToCloudAuthenticatorFunction::static_function_name(),
      PasswordsPrivateIsConnectedToCloudAuthenticatorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PasswordsPrivateDeleteAllPasswordManagerDataFunction>,
      PasswordsPrivateDeleteAllPasswordManagerDataFunction::static_function_name(),
      PasswordsPrivateDeleteAllPasswordManagerDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ResourcesPrivateGetStringsFunction>,
      ResourcesPrivateGetStringsFunction::static_function_name(),
      ResourcesPrivateGetStringsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SafeBrowsingPrivateGetReferrerChainFunction>,
      SafeBrowsingPrivateGetReferrerChainFunction::static_function_name(),
      SafeBrowsingPrivateGetReferrerChainFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SessionsGetRecentlyClosedFunction>,
      SessionsGetRecentlyClosedFunction::static_function_name(),
      SessionsGetRecentlyClosedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SessionsGetDevicesFunction>,
      SessionsGetDevicesFunction::static_function_name(),
      SessionsGetDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SessionsRestoreFunction>,
      SessionsRestoreFunction::static_function_name(),
      SessionsRestoreFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SettingsPrivateSetPrefFunction>,
      SettingsPrivateSetPrefFunction::static_function_name(),
      SettingsPrivateSetPrefFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SettingsPrivateGetAllPrefsFunction>,
      SettingsPrivateGetAllPrefsFunction::static_function_name(),
      SettingsPrivateGetAllPrefsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SettingsPrivateGetPrefFunction>,
      SettingsPrivateGetPrefFunction::static_function_name(),
      SettingsPrivateGetPrefFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SettingsPrivateGetDefaultZoomFunction>,
      SettingsPrivateGetDefaultZoomFunction::static_function_name(),
      SettingsPrivateGetDefaultZoomFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SettingsPrivateSetDefaultZoomFunction>,
      SettingsPrivateSetDefaultZoomFunction::static_function_name(),
      SettingsPrivateSetDefaultZoomFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SidePanelSetOptionsFunction>,
      SidePanelSetOptionsFunction::static_function_name(),
      SidePanelSetOptionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SidePanelGetOptionsFunction>,
      SidePanelGetOptionsFunction::static_function_name(),
      SidePanelGetOptionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SidePanelSetPanelBehaviorFunction>,
      SidePanelSetPanelBehaviorFunction::static_function_name(),
      SidePanelSetPanelBehaviorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SidePanelGetPanelBehaviorFunction>,
      SidePanelGetPanelBehaviorFunction::static_function_name(),
      SidePanelGetPanelBehaviorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SidePanelOpenFunction>,
      SidePanelOpenFunction::static_function_name(),
      SidePanelOpenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SidePanelGetLayoutFunction>,
      SidePanelGetLayoutFunction::static_function_name(),
      SidePanelGetLayoutFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SidePanelCloseFunction>,
      SidePanelCloseFunction::static_function_name(),
      SidePanelCloseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemPrivateGetIncognitoModeAvailabilityFunction>,
      SystemPrivateGetIncognitoModeAvailabilityFunction::static_function_name(),
      SystemPrivateGetIncognitoModeAvailabilityFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemPrivateGetUpdateStatusFunction>,
      SystemPrivateGetUpdateStatusFunction::static_function_name(),
      SystemPrivateGetUpdateStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemPrivateGetApiKeyFunction>,
      SystemPrivateGetApiKeyFunction::static_function_name(),
      SystemPrivateGetApiKeyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabCaptureCaptureFunction>,
      TabCaptureCaptureFunction::static_function_name(),
      TabCaptureCaptureFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabCaptureGetCapturedTabsFunction>,
      TabCaptureGetCapturedTabsFunction::static_function_name(),
      TabCaptureGetCapturedTabsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabCaptureGetMediaStreamIdFunction>,
      TabCaptureGetMediaStreamIdFunction::static_function_name(),
      TabCaptureGetMediaStreamIdFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabGroupsGetFunction>,
      TabGroupsGetFunction::static_function_name(),
      TabGroupsGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabGroupsQueryFunction>,
      TabGroupsQueryFunction::static_function_name(),
      TabGroupsQueryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabGroupsUpdateFunction>,
      TabGroupsUpdateFunction::static_function_name(),
      TabGroupsUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TabGroupsMoveFunction>,
      TabGroupsMoveFunction::static_function_name(),
      TabGroupsMoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcDesktopCapturePrivateChooseDesktopMediaFunction>,
      WebrtcDesktopCapturePrivateChooseDesktopMediaFunction::static_function_name(),
      WebrtcDesktopCapturePrivateChooseDesktopMediaFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcDesktopCapturePrivateCancelChooseDesktopMediaFunction>,
      WebrtcDesktopCapturePrivateCancelChooseDesktopMediaFunction::static_function_name(),
      WebrtcDesktopCapturePrivateCancelChooseDesktopMediaFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PdfViewerPrivateGetStreamInfoFunction>,
      PdfViewerPrivateGetStreamInfoFunction::static_function_name(),
      PdfViewerPrivateGetStreamInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PdfViewerPrivateIsAllowedLocalFileAccessFunction>,
      PdfViewerPrivateIsAllowedLocalFileAccessFunction::static_function_name(),
      PdfViewerPrivateIsAllowedLocalFileAccessFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PdfViewerPrivateSaveToDriveFunction>,
      PdfViewerPrivateSaveToDriveFunction::static_function_name(),
      PdfViewerPrivateSaveToDriveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PdfViewerPrivateSetPdfDocumentTitleFunction>,
      PdfViewerPrivateSetPdfDocumentTitleFunction::static_function_name(),
      PdfViewerPrivateSetPdfDocumentTitleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PdfViewerPrivateSetPdfPluginAttributesFunction>,
      PdfViewerPrivateSetPdfPluginAttributesFunction::static_function_name(),
      PdfViewerPrivateSetPdfPluginAttributesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionSetTitleFunction>,
      ActionSetTitleFunction::static_function_name(),
      ActionSetTitleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionGetTitleFunction>,
      ActionGetTitleFunction::static_function_name(),
      ActionGetTitleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionSetIconFunction>,
      ActionSetIconFunction::static_function_name(),
      ActionSetIconFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionSetPopupFunction>,
      ActionSetPopupFunction::static_function_name(),
      ActionSetPopupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionGetPopupFunction>,
      ActionGetPopupFunction::static_function_name(),
      ActionGetPopupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionSetBadgeTextFunction>,
      ActionSetBadgeTextFunction::static_function_name(),
      ActionSetBadgeTextFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionGetBadgeTextFunction>,
      ActionGetBadgeTextFunction::static_function_name(),
      ActionGetBadgeTextFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionSetBadgeBackgroundColorFunction>,
      ActionSetBadgeBackgroundColorFunction::static_function_name(),
      ActionSetBadgeBackgroundColorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionGetBadgeBackgroundColorFunction>,
      ActionGetBadgeBackgroundColorFunction::static_function_name(),
      ActionGetBadgeBackgroundColorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionSetBadgeTextColorFunction>,
      ActionSetBadgeTextColorFunction::static_function_name(),
      ActionSetBadgeTextColorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionGetBadgeTextColorFunction>,
      ActionGetBadgeTextColorFunction::static_function_name(),
      ActionGetBadgeTextColorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionEnableFunction>,
      ActionEnableFunction::static_function_name(),
      ActionEnableFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionDisableFunction>,
      ActionDisableFunction::static_function_name(),
      ActionDisableFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionIsEnabledFunction>,
      ActionIsEnabledFunction::static_function_name(),
      ActionIsEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionGetUserSettingsFunction>,
      ActionGetUserSettingsFunction::static_function_name(),
      ActionGetUserSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ActionOpenPopupFunction>,
      ActionOpenPopupFunction::static_function_name(),
      ActionOpenPopupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataSettingsFunction>,
      BrowsingDataSettingsFunction::static_function_name(),
      BrowsingDataSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveFunction>,
      BrowsingDataRemoveFunction::static_function_name(),
      BrowsingDataRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveAppcacheFunction>,
      BrowsingDataRemoveAppcacheFunction::static_function_name(),
      BrowsingDataRemoveAppcacheFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveCacheFunction>,
      BrowsingDataRemoveCacheFunction::static_function_name(),
      BrowsingDataRemoveCacheFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveCacheStorageFunction>,
      BrowsingDataRemoveCacheStorageFunction::static_function_name(),
      BrowsingDataRemoveCacheStorageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveCookiesFunction>,
      BrowsingDataRemoveCookiesFunction::static_function_name(),
      BrowsingDataRemoveCookiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveDownloadsFunction>,
      BrowsingDataRemoveDownloadsFunction::static_function_name(),
      BrowsingDataRemoveDownloadsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveFileSystemsFunction>,
      BrowsingDataRemoveFileSystemsFunction::static_function_name(),
      BrowsingDataRemoveFileSystemsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveFormDataFunction>,
      BrowsingDataRemoveFormDataFunction::static_function_name(),
      BrowsingDataRemoveFormDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveHistoryFunction>,
      BrowsingDataRemoveHistoryFunction::static_function_name(),
      BrowsingDataRemoveHistoryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveIndexedDBFunction>,
      BrowsingDataRemoveIndexedDBFunction::static_function_name(),
      BrowsingDataRemoveIndexedDBFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveLocalStorageFunction>,
      BrowsingDataRemoveLocalStorageFunction::static_function_name(),
      BrowsingDataRemoveLocalStorageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemovePluginDataFunction>,
      BrowsingDataRemovePluginDataFunction::static_function_name(),
      BrowsingDataRemovePluginDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemovePasswordsFunction>,
      BrowsingDataRemovePasswordsFunction::static_function_name(),
      BrowsingDataRemovePasswordsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveServiceWorkersFunction>,
      BrowsingDataRemoveServiceWorkersFunction::static_function_name(),
      BrowsingDataRemoveServiceWorkersFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowsingDataRemoveWebSQLFunction>,
      BrowsingDataRemoveWebSQLFunction::static_function_name(),
      BrowsingDataRemoveWebSQLFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExtensionIsAllowedIncognitoAccessFunction>,
      ExtensionIsAllowedIncognitoAccessFunction::static_function_name(),
      ExtensionIsAllowedIncognitoAccessFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExtensionIsAllowedFileSchemeAccessFunction>,
      ExtensionIsAllowedFileSchemeAccessFunction::static_function_name(),
      ExtensionIsAllowedFileSchemeAccessFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ExtensionSetUpdateUrlDataFunction>,
      ExtensionSetUpdateUrlDataFunction::static_function_name(),
      ExtensionSetUpdateUrlDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TopSitesGetFunction>,
      TopSitesGetFunction::static_function_name(),
      TopSitesGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionSetTitleFunction>,
      BrowserActionSetTitleFunction::static_function_name(),
      BrowserActionSetTitleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionGetTitleFunction>,
      BrowserActionGetTitleFunction::static_function_name(),
      BrowserActionGetTitleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionSetIconFunction>,
      BrowserActionSetIconFunction::static_function_name(),
      BrowserActionSetIconFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionSetPopupFunction>,
      BrowserActionSetPopupFunction::static_function_name(),
      BrowserActionSetPopupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionGetPopupFunction>,
      BrowserActionGetPopupFunction::static_function_name(),
      BrowserActionGetPopupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionSetBadgeTextFunction>,
      BrowserActionSetBadgeTextFunction::static_function_name(),
      BrowserActionSetBadgeTextFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionGetBadgeTextFunction>,
      BrowserActionGetBadgeTextFunction::static_function_name(),
      BrowserActionGetBadgeTextFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionSetBadgeBackgroundColorFunction>,
      BrowserActionSetBadgeBackgroundColorFunction::static_function_name(),
      BrowserActionSetBadgeBackgroundColorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionGetBadgeBackgroundColorFunction>,
      BrowserActionGetBadgeBackgroundColorFunction::static_function_name(),
      BrowserActionGetBadgeBackgroundColorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionEnableFunction>,
      BrowserActionEnableFunction::static_function_name(),
      BrowserActionEnableFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionDisableFunction>,
      BrowserActionDisableFunction::static_function_name(),
      BrowserActionDisableFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<BrowserActionOpenPopupFunction>,
      BrowserActionOpenPopupFunction::static_function_name(),
      BrowserActionOpenPopupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdltestSendArrayBufferFunction>,
      IdltestSendArrayBufferFunction::static_function_name(),
      IdltestSendArrayBufferFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdltestSendArrayBufferViewFunction>,
      IdltestSendArrayBufferViewFunction::static_function_name(),
      IdltestSendArrayBufferViewFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdltestGetArrayBufferFunction>,
      IdltestGetArrayBufferFunction::static_function_name(),
      IdltestGetArrayBufferFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageActionShowFunction>,
      PageActionShowFunction::static_function_name(),
      PageActionShowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageActionHideFunction>,
      PageActionHideFunction::static_function_name(),
      PageActionHideFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageActionSetTitleFunction>,
      PageActionSetTitleFunction::static_function_name(),
      PageActionSetTitleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageActionGetTitleFunction>,
      PageActionGetTitleFunction::static_function_name(),
      PageActionGetTitleFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageActionSetIconFunction>,
      PageActionSetIconFunction::static_function_name(),
      PageActionSetIconFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageActionSetPopupFunction>,
      PageActionSetPopupFunction::static_function_name(),
      PageActionSetPopupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PageActionGetPopupFunction>,
      PageActionGetPopupFunction::static_function_name(),
      PageActionGetPopupFunction::static_histogram_value(),
    },
  };
  for (const auto& entry : kEntries) {
      registry->Register(entry);
  }
}

}  // namespace api
}  // namespace extensions
