// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Storage_h
#define protocol_Storage_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "chrome/browser/devtools/protocol/browser.h"

namespace protocol {
namespace Storage {
using SerializedStorageKey = String;
using InterestGroupAuctionId = String;
using InterestGroupAccessType = String;
using InterestGroupAuctionEventType = String;
using InterestGroupAuctionFetchType = String;
using SharedStorageAccessScope = String;
using SharedStorageAccessMethod = String;
class SharedStoragePrivateAggregationConfig;
class SharedStorageReportingMetadata;
class SharedStorageUrlWithMetadata;
class SharedStorageAccessParams;
using StorageBucketsDurability = String;
class StorageBucket;
class StorageBucketInfo;
using AttributionReportingSourceType = String;
using UnsignedInt64AsBase10 = String;
using UnsignedInt128AsBase16 = String;
using SignedInt64AsBase10 = String;
class AttributionReportingFilterDataEntry;
class AttributionReportingFilterConfig;
class AttributionReportingFilterPair;
class AttributionReportingAggregationKeysEntry;
class AttributionReportingEventReportWindows;
using AttributionReportingTriggerDataMatching = String;
class AttributionReportingAggregatableDebugReportingData;
class AttributionReportingAggregatableDebugReportingConfig;
class AttributionScopesData;
class AttributionReportingNamedBudgetDef;
class AttributionReportingSourceRegistration;
using AttributionReportingSourceRegistrationResult = String;
using AttributionReportingSourceRegistrationTimeConfig = String;
class AttributionReportingAggregatableValueDictEntry;
class AttributionReportingAggregatableValueEntry;
class AttributionReportingEventTriggerData;
class AttributionReportingAggregatableTriggerData;
class AttributionReportingAggregatableDedupKey;
class AttributionReportingNamedBudgetCandidate;
class AttributionReportingTriggerRegistration;
using AttributionReportingEventLevelResult = String;
using AttributionReportingAggregatableResult = String;
using AttributionReportingReportResult = String;
class RelatedWebsiteSet;

// ------------- Forward and enum declarations.

namespace InterestGroupAccessTypeEnum {
 extern const char Join[];
 extern const char Leave[];
 extern const char Update[];
 extern const char Loaded[];
 extern const char Bid[];
 extern const char Win[];
 extern const char AdditionalBid[];
 extern const char AdditionalBidWin[];
 extern const char TopLevelBid[];
 extern const char TopLevelAdditionalBid[];
 extern const char Clear[];
} // namespace InterestGroupAccessTypeEnum

namespace InterestGroupAuctionEventTypeEnum {
 extern const char Started[];
 extern const char ConfigResolved[];
} // namespace InterestGroupAuctionEventTypeEnum

namespace InterestGroupAuctionFetchTypeEnum {
 extern const char BidderJs[];
 extern const char BidderWasm[];
 extern const char SellerJs[];
 extern const char BidderTrustedSignals[];
 extern const char SellerTrustedSignals[];
} // namespace InterestGroupAuctionFetchTypeEnum

namespace SharedStorageAccessScopeEnum {
 extern const char Window[];
 extern const char SharedStorageWorklet[];
 extern const char ProtectedAudienceWorklet[];
 extern const char Header[];
} // namespace SharedStorageAccessScopeEnum

namespace SharedStorageAccessMethodEnum {
 extern const char AddModule[];
 extern const char CreateWorklet[];
 extern const char SelectURL[];
 extern const char Run[];
 extern const char BatchUpdate[];
 extern const char Set[];
 extern const char Append[];
 extern const char Delete[];
 extern const char Clear[];
 extern const char Get[];
 extern const char Keys[];
 extern const char Values[];
 extern const char Entries[];
 extern const char Length[];
 extern const char RemainingBudget[];
} // namespace SharedStorageAccessMethodEnum

namespace StorageBucketsDurabilityEnum {
 extern const char Relaxed[];
 extern const char Strict[];
} // namespace StorageBucketsDurabilityEnum

namespace AttributionReportingSourceTypeEnum {
 extern const char Navigation[];
 extern const char Event[];
} // namespace AttributionReportingSourceTypeEnum

namespace AttributionReportingTriggerDataMatchingEnum {
 extern const char Exact[];
 extern const char Modulus[];
} // namespace AttributionReportingTriggerDataMatchingEnum

namespace AttributionReportingSourceRegistrationResultEnum {
 extern const char Success[];
 extern const char InternalError[];
 extern const char InsufficientSourceCapacity[];
 extern const char InsufficientUniqueDestinationCapacity[];
 extern const char ExcessiveReportingOrigins[];
 extern const char ProhibitedByBrowserPolicy[];
 extern const char SuccessNoised[];
 extern const char DestinationReportingLimitReached[];
 extern const char DestinationGlobalLimitReached[];
 extern const char DestinationBothLimitsReached[];
 extern const char ReportingOriginsPerSiteLimitReached[];
 extern const char ExceedsMaxChannelCapacity[];
 extern const char ExceedsMaxScopesChannelCapacity[];
 extern const char ExceedsMaxTriggerStateCardinality[];
 extern const char ExceedsMaxEventStatesLimit[];
 extern const char DestinationPerDayReportingLimitReached[];
} // namespace AttributionReportingSourceRegistrationResultEnum

namespace AttributionReportingSourceRegistrationTimeConfigEnum {
 extern const char Include[];
 extern const char Exclude[];
} // namespace AttributionReportingSourceRegistrationTimeConfigEnum

namespace AttributionReportingEventLevelResultEnum {
 extern const char Success[];
 extern const char SuccessDroppedLowerPriority[];
 extern const char InternalError[];
 extern const char NoCapacityForAttributionDestination[];
 extern const char NoMatchingSources[];
 extern const char Deduplicated[];
 extern const char ExcessiveAttributions[];
 extern const char PriorityTooLow[];
 extern const char NeverAttributedSource[];
 extern const char ExcessiveReportingOrigins[];
 extern const char NoMatchingSourceFilterData[];
 extern const char ProhibitedByBrowserPolicy[];
 extern const char NoMatchingConfigurations[];
 extern const char ExcessiveReports[];
 extern const char FalselyAttributedSource[];
 extern const char ReportWindowPassed[];
 extern const char NotRegistered[];
 extern const char ReportWindowNotStarted[];
 extern const char NoMatchingTriggerData[];
} // namespace AttributionReportingEventLevelResultEnum

namespace AttributionReportingAggregatableResultEnum {
 extern const char Success[];
 extern const char InternalError[];
 extern const char NoCapacityForAttributionDestination[];
 extern const char NoMatchingSources[];
 extern const char ExcessiveAttributions[];
 extern const char ExcessiveReportingOrigins[];
 extern const char NoHistograms[];
 extern const char InsufficientBudget[];
 extern const char InsufficientNamedBudget[];
 extern const char NoMatchingSourceFilterData[];
 extern const char NotRegistered[];
 extern const char ProhibitedByBrowserPolicy[];
 extern const char Deduplicated[];
 extern const char ReportWindowPassed[];
 extern const char ExcessiveReports[];
} // namespace AttributionReportingAggregatableResultEnum

namespace AttributionReportingReportResultEnum {
 extern const char Sent[];
 extern const char Prohibited[];
 extern const char FailedToAssemble[];
 extern const char Expired[];
} // namespace AttributionReportingReportResultEnum

// ------------- Type and builder declarations.

class  SharedStoragePrivateAggregationConfig : public ::crdtp::ProtocolObject<SharedStoragePrivateAggregationConfig> {
public:
    ~SharedStoragePrivateAggregationConfig() override { }

    bool HasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String GetAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void SetAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }

    bool HasContextId() { return !!m_contextId; }
    String GetContextId(const String& defaultValue) const {
       return m_contextId.value_or(defaultValue);
    }
    const std::optional<String>& GetContextId() const {
       return m_contextId;
    }
    void SetContextId(const String& value) { m_contextId = value; }

    int GetFilteringIdMaxBytes() { return m_filteringIdMaxBytes; }
    void SetFilteringIdMaxBytes(int value) { m_filteringIdMaxBytes = value; }

    bool HasMaxContributions() { return !!m_maxContributions; }
    int GetMaxContributions(int defaultValue) const {
       return m_maxContributions.value_or(defaultValue);
    }
    const std::optional<int>& GetMaxContributions() const {
       return m_maxContributions;
    }
    void SetMaxContributions(int value) { m_maxContributions = value; }

    template<int STATE>
    class SharedStoragePrivateAggregationConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FilteringIdMaxBytesSet = 1 << 1,
            AllFieldsSet = (FilteringIdMaxBytesSet | 0)};


        SharedStoragePrivateAggregationConfigBuilder<STATE>& SetAggregationCoordinatorOrigin(const String& value)
        {
            m_result->SetAggregationCoordinatorOrigin(value);
            return *this;
        }

        SharedStoragePrivateAggregationConfigBuilder<STATE>& SetContextId(const String& value)
        {
            m_result->SetContextId(value);
            return *this;
        }

        SharedStoragePrivateAggregationConfigBuilder<STATE | FilteringIdMaxBytesSet>& SetFilteringIdMaxBytes(int value)
        {
            static_assert(!(STATE & FilteringIdMaxBytesSet), "property filteringIdMaxBytes should not be set yet");
            m_result->SetFilteringIdMaxBytes(value);
            return castState<FilteringIdMaxBytesSet>();
        }

        SharedStoragePrivateAggregationConfigBuilder<STATE>& SetMaxContributions(int value)
        {
            m_result->SetMaxContributions(value);
            return *this;
        }

        std::unique_ptr<SharedStoragePrivateAggregationConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStoragePrivateAggregationConfig;
        SharedStoragePrivateAggregationConfigBuilder() : m_result(new SharedStoragePrivateAggregationConfig()) { }

        template<int STEP> SharedStoragePrivateAggregationConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStoragePrivateAggregationConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> m_result;
    };

    static SharedStoragePrivateAggregationConfigBuilder<0> Create()
    {
        return SharedStoragePrivateAggregationConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStoragePrivateAggregationConfig()
    {
          m_filteringIdMaxBytes = 0;
    }

    std::optional<String> m_aggregationCoordinatorOrigin;
    std::optional<String> m_contextId;
    int m_filteringIdMaxBytes;
    std::optional<int> m_maxContributions;
};


class  SharedStorageReportingMetadata : public ::crdtp::ProtocolObject<SharedStorageReportingMetadata> {
public:
    ~SharedStorageReportingMetadata() override { }

    String GetEventType() { return m_eventType; }
    void SetEventType(const String& value) { m_eventType = value; }

    String GetReportingUrl() { return m_reportingUrl; }
    void SetReportingUrl(const String& value) { m_reportingUrl = value; }

    template<int STATE>
    class SharedStorageReportingMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            EventTypeSet = 1 << 1,
            ReportingUrlSet = 1 << 2,
            AllFieldsSet = (EventTypeSet | ReportingUrlSet | 0)};


        SharedStorageReportingMetadataBuilder<STATE | EventTypeSet>& SetEventType(const String& value)
        {
            static_assert(!(STATE & EventTypeSet), "property eventType should not be set yet");
            m_result->SetEventType(value);
            return castState<EventTypeSet>();
        }

        SharedStorageReportingMetadataBuilder<STATE | ReportingUrlSet>& SetReportingUrl(const String& value)
        {
            static_assert(!(STATE & ReportingUrlSet), "property reportingUrl should not be set yet");
            m_result->SetReportingUrl(value);
            return castState<ReportingUrlSet>();
        }

        std::unique_ptr<SharedStorageReportingMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageReportingMetadata;
        SharedStorageReportingMetadataBuilder() : m_result(new SharedStorageReportingMetadata()) { }

        template<int STEP> SharedStorageReportingMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageReportingMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageReportingMetadata> m_result;
    };

    static SharedStorageReportingMetadataBuilder<0> Create()
    {
        return SharedStorageReportingMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageReportingMetadata()
    {
    }

    String m_eventType;
    String m_reportingUrl;
};


class  SharedStorageUrlWithMetadata : public ::crdtp::ProtocolObject<SharedStorageUrlWithMetadata> {
public:
    ~SharedStorageUrlWithMetadata() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    protocol::Array<protocol::Storage::SharedStorageReportingMetadata>* GetReportingMetadata() { return m_reportingMetadata.get(); }
    void SetReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value) { m_reportingMetadata = std::move(value); }

    template<int STATE>
    class SharedStorageUrlWithMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            ReportingMetadataSet = 1 << 2,
            AllFieldsSet = (UrlSet | ReportingMetadataSet | 0)};


        SharedStorageUrlWithMetadataBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        SharedStorageUrlWithMetadataBuilder<STATE | ReportingMetadataSet>& SetReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value)
        {
            static_assert(!(STATE & ReportingMetadataSet), "property reportingMetadata should not be set yet");
            m_result->SetReportingMetadata(std::move(value));
            return castState<ReportingMetadataSet>();
        }

        std::unique_ptr<SharedStorageUrlWithMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageUrlWithMetadata;
        SharedStorageUrlWithMetadataBuilder() : m_result(new SharedStorageUrlWithMetadata()) { }

        template<int STEP> SharedStorageUrlWithMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageUrlWithMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageUrlWithMetadata> m_result;
    };

    static SharedStorageUrlWithMetadataBuilder<0> Create()
    {
        return SharedStorageUrlWithMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageUrlWithMetadata()
    {
    }

    String m_url;
    std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> m_reportingMetadata;
};


class  SharedStorageAccessParams : public ::crdtp::ProtocolObject<SharedStorageAccessParams> {
public:
    ~SharedStorageAccessParams() override { }

    bool HasScriptSourceUrl() { return !!m_scriptSourceUrl; }
    String GetScriptSourceUrl(const String& defaultValue) const {
       return m_scriptSourceUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetScriptSourceUrl() const {
       return m_scriptSourceUrl;
    }
    void SetScriptSourceUrl(const String& value) { m_scriptSourceUrl = value; }

    bool HasDataOrigin() { return !!m_dataOrigin; }
    String GetDataOrigin(const String& defaultValue) const {
       return m_dataOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetDataOrigin() const {
       return m_dataOrigin;
    }
    void SetDataOrigin(const String& value) { m_dataOrigin = value; }

    bool HasOperationName() { return !!m_operationName; }
    String GetOperationName(const String& defaultValue) const {
       return m_operationName.value_or(defaultValue);
    }
    const std::optional<String>& GetOperationName() const {
       return m_operationName;
    }
    void SetOperationName(const String& value) { m_operationName = value; }

    bool HasOperationId() { return !!m_operationId; }
    String GetOperationId(const String& defaultValue) const {
       return m_operationId.value_or(defaultValue);
    }
    const std::optional<String>& GetOperationId() const {
       return m_operationId;
    }
    void SetOperationId(const String& value) { m_operationId = value; }

    bool HasKeepAlive() { return !!m_keepAlive; }
    bool GetKeepAlive(bool defaultValue) const {
       return m_keepAlive.value_or(defaultValue);
    }
    const std::optional<bool>& GetKeepAlive() const {
       return m_keepAlive;
    }
    void SetKeepAlive(bool value) { m_keepAlive = value; }

    bool HasPrivateAggregationConfig() { return !!m_privateAggregationConfig; }
    protocol::Storage::SharedStoragePrivateAggregationConfig* GetPrivateAggregationConfig(protocol::Storage::SharedStoragePrivateAggregationConfig* defaultValue) {
       return m_privateAggregationConfig ? m_privateAggregationConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig>& GetPrivateAggregationConfig() const {
       return m_privateAggregationConfig;
    }
    void SetPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value) { m_privateAggregationConfig = std::move(value); }

    bool HasSerializedData() { return !!m_serializedData; }
    String GetSerializedData(const String& defaultValue) const {
       return m_serializedData.value_or(defaultValue);
    }
    const std::optional<String>& GetSerializedData() const {
       return m_serializedData;
    }
    void SetSerializedData(const String& value) { m_serializedData = value; }

    bool HasUrlsWithMetadata() { return !!m_urlsWithMetadata; }
    protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>* GetUrlsWithMetadata(protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>* defaultValue) {
       return m_urlsWithMetadata ? m_urlsWithMetadata.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>>& GetUrlsWithMetadata() const {
       return m_urlsWithMetadata;
    }
    void SetUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value) { m_urlsWithMetadata = std::move(value); }

    bool HasUrnUuid() { return !!m_urnUuid; }
    String GetUrnUuid(const String& defaultValue) const {
       return m_urnUuid.value_or(defaultValue);
    }
    const std::optional<String>& GetUrnUuid() const {
       return m_urnUuid;
    }
    void SetUrnUuid(const String& value) { m_urnUuid = value; }

    bool HasKey() { return !!m_key; }
    String GetKey(const String& defaultValue) const {
       return m_key.value_or(defaultValue);
    }
    const std::optional<String>& GetKey() const {
       return m_key;
    }
    void SetKey(const String& value) { m_key = value; }

    bool HasValue() { return !!m_value; }
    String GetValue(const String& defaultValue) const {
       return m_value.value_or(defaultValue);
    }
    const std::optional<String>& GetValue() const {
       return m_value;
    }
    void SetValue(const String& value) { m_value = value; }

    bool HasIgnoreIfPresent() { return !!m_ignoreIfPresent; }
    bool GetIgnoreIfPresent(bool defaultValue) const {
       return m_ignoreIfPresent.value_or(defaultValue);
    }
    const std::optional<bool>& GetIgnoreIfPresent() const {
       return m_ignoreIfPresent;
    }
    void SetIgnoreIfPresent(bool value) { m_ignoreIfPresent = value; }

    bool HasWorkletOrdinal() { return !!m_workletOrdinal; }
    int GetWorkletOrdinal(int defaultValue) const {
       return m_workletOrdinal.value_or(defaultValue);
    }
    const std::optional<int>& GetWorkletOrdinal() const {
       return m_workletOrdinal;
    }
    void SetWorkletOrdinal(int value) { m_workletOrdinal = value; }

    bool HasWorkletTargetId() { return !!m_workletTargetId; }
    String GetWorkletTargetId(const String& defaultValue) const {
       return m_workletTargetId.value_or(defaultValue);
    }
    const std::optional<String>& GetWorkletTargetId() const {
       return m_workletTargetId;
    }
    void SetWorkletTargetId(const String& value) { m_workletTargetId = value; }

    bool HasWithLock() { return !!m_withLock; }
    String GetWithLock(const String& defaultValue) const {
       return m_withLock.value_or(defaultValue);
    }
    const std::optional<String>& GetWithLock() const {
       return m_withLock;
    }
    void SetWithLock(const String& value) { m_withLock = value; }

    bool HasBatchUpdateId() { return !!m_batchUpdateId; }
    String GetBatchUpdateId(const String& defaultValue) const {
       return m_batchUpdateId.value_or(defaultValue);
    }
    const std::optional<String>& GetBatchUpdateId() const {
       return m_batchUpdateId;
    }
    void SetBatchUpdateId(const String& value) { m_batchUpdateId = value; }

    bool HasBatchSize() { return !!m_batchSize; }
    int GetBatchSize(int defaultValue) const {
       return m_batchSize.value_or(defaultValue);
    }
    const std::optional<int>& GetBatchSize() const {
       return m_batchSize;
    }
    void SetBatchSize(int value) { m_batchSize = value; }

    template<int STATE>
    class SharedStorageAccessParamsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        SharedStorageAccessParamsBuilder<STATE>& SetScriptSourceUrl(const String& value)
        {
            m_result->SetScriptSourceUrl(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetDataOrigin(const String& value)
        {
            m_result->SetDataOrigin(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetOperationName(const String& value)
        {
            m_result->SetOperationName(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetOperationId(const String& value)
        {
            m_result->SetOperationId(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetKeepAlive(bool value)
        {
            m_result->SetKeepAlive(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value)
        {
            m_result->SetPrivateAggregationConfig(std::move(value));
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetSerializedData(const String& value)
        {
            m_result->SetSerializedData(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value)
        {
            m_result->SetUrlsWithMetadata(std::move(value));
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetUrnUuid(const String& value)
        {
            m_result->SetUrnUuid(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetKey(const String& value)
        {
            m_result->SetKey(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetValue(const String& value)
        {
            m_result->SetValue(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetIgnoreIfPresent(bool value)
        {
            m_result->SetIgnoreIfPresent(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetWorkletOrdinal(int value)
        {
            m_result->SetWorkletOrdinal(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetWorkletTargetId(const String& value)
        {
            m_result->SetWorkletTargetId(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetWithLock(const String& value)
        {
            m_result->SetWithLock(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetBatchUpdateId(const String& value)
        {
            m_result->SetBatchUpdateId(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetBatchSize(int value)
        {
            m_result->SetBatchSize(value);
            return *this;
        }

        std::unique_ptr<SharedStorageAccessParams> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageAccessParams;
        SharedStorageAccessParamsBuilder() : m_result(new SharedStorageAccessParams()) { }

        template<int STEP> SharedStorageAccessParamsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageAccessParamsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageAccessParams> m_result;
    };

    static SharedStorageAccessParamsBuilder<0> Create()
    {
        return SharedStorageAccessParamsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageAccessParams()
    {
    }

    std::optional<String> m_scriptSourceUrl;
    std::optional<String> m_dataOrigin;
    std::optional<String> m_operationName;
    std::optional<String> m_operationId;
    std::optional<bool> m_keepAlive;
    std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> m_privateAggregationConfig;
    std::optional<String> m_serializedData;
    std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> m_urlsWithMetadata;
    std::optional<String> m_urnUuid;
    std::optional<String> m_key;
    std::optional<String> m_value;
    std::optional<bool> m_ignoreIfPresent;
    std::optional<int> m_workletOrdinal;
    std::optional<String> m_workletTargetId;
    std::optional<String> m_withLock;
    std::optional<String> m_batchUpdateId;
    std::optional<int> m_batchSize;
};


class  StorageBucket : public ::crdtp::ProtocolObject<StorageBucket> {
public:
    ~StorageBucket() override { }

    String GetStorageKey() { return m_storageKey; }
    void SetStorageKey(const String& value) { m_storageKey = value; }

    bool HasName() { return !!m_name; }
    String GetName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& GetName() const {
       return m_name;
    }
    void SetName(const String& value) { m_name = value; }

    template<int STATE>
    class StorageBucketBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StorageKeySet = 1 << 1,
            AllFieldsSet = (StorageKeySet | 0)};


        StorageBucketBuilder<STATE | StorageKeySet>& SetStorageKey(const String& value)
        {
            static_assert(!(STATE & StorageKeySet), "property storageKey should not be set yet");
            m_result->SetStorageKey(value);
            return castState<StorageKeySet>();
        }

        StorageBucketBuilder<STATE>& SetName(const String& value)
        {
            m_result->SetName(value);
            return *this;
        }

        std::unique_ptr<StorageBucket> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StorageBucket;
        StorageBucketBuilder() : m_result(new StorageBucket()) { }

        template<int STEP> StorageBucketBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StorageBucketBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::StorageBucket> m_result;
    };

    static StorageBucketBuilder<0> Create()
    {
        return StorageBucketBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StorageBucket()
    {
    }

    String m_storageKey;
    std::optional<String> m_name;
};


class  StorageBucketInfo : public ::crdtp::ProtocolObject<StorageBucketInfo> {
public:
    ~StorageBucketInfo() override { }

    protocol::Storage::StorageBucket* GetBucket() { return m_bucket.get(); }
    void SetBucket(std::unique_ptr<protocol::Storage::StorageBucket> value) { m_bucket = std::move(value); }

    String GetId() { return m_id; }
    void SetId(const String& value) { m_id = value; }

    double GetExpiration() { return m_expiration; }
    void SetExpiration(double value) { m_expiration = value; }

    double GetQuota() { return m_quota; }
    void SetQuota(double value) { m_quota = value; }

    bool GetPersistent() { return m_persistent; }
    void SetPersistent(bool value) { m_persistent = value; }

    String GetDurability() { return m_durability; }
    void SetDurability(const String& value) { m_durability = value; }

    template<int STATE>
    class StorageBucketInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BucketSet = 1 << 1,
            IdSet = 1 << 2,
            ExpirationSet = 1 << 3,
            QuotaSet = 1 << 4,
            PersistentSet = 1 << 5,
            DurabilitySet = 1 << 6,
            AllFieldsSet = (BucketSet | IdSet | ExpirationSet | QuotaSet | PersistentSet | DurabilitySet | 0)};


        StorageBucketInfoBuilder<STATE | BucketSet>& SetBucket(std::unique_ptr<protocol::Storage::StorageBucket> value)
        {
            static_assert(!(STATE & BucketSet), "property bucket should not be set yet");
            m_result->SetBucket(std::move(value));
            return castState<BucketSet>();
        }

        StorageBucketInfoBuilder<STATE | IdSet>& SetId(const String& value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->SetId(value);
            return castState<IdSet>();
        }

        StorageBucketInfoBuilder<STATE | ExpirationSet>& SetExpiration(double value)
        {
            static_assert(!(STATE & ExpirationSet), "property expiration should not be set yet");
            m_result->SetExpiration(value);
            return castState<ExpirationSet>();
        }

        StorageBucketInfoBuilder<STATE | QuotaSet>& SetQuota(double value)
        {
            static_assert(!(STATE & QuotaSet), "property quota should not be set yet");
            m_result->SetQuota(value);
            return castState<QuotaSet>();
        }

        StorageBucketInfoBuilder<STATE | PersistentSet>& SetPersistent(bool value)
        {
            static_assert(!(STATE & PersistentSet), "property persistent should not be set yet");
            m_result->SetPersistent(value);
            return castState<PersistentSet>();
        }

        StorageBucketInfoBuilder<STATE | DurabilitySet>& SetDurability(const String& value)
        {
            static_assert(!(STATE & DurabilitySet), "property durability should not be set yet");
            m_result->SetDurability(value);
            return castState<DurabilitySet>();
        }

        std::unique_ptr<StorageBucketInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StorageBucketInfo;
        StorageBucketInfoBuilder() : m_result(new StorageBucketInfo()) { }

        template<int STEP> StorageBucketInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StorageBucketInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::StorageBucketInfo> m_result;
    };

    static StorageBucketInfoBuilder<0> Create()
    {
        return StorageBucketInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StorageBucketInfo()
    {
          m_expiration = 0;
          m_quota = 0;
          m_persistent = false;
    }

    std::unique_ptr<protocol::Storage::StorageBucket> m_bucket;
    String m_id;
    double m_expiration;
    double m_quota;
    bool m_persistent;
    String m_durability;
};


class  AttributionReportingFilterDataEntry : public ::crdtp::ProtocolObject<AttributionReportingFilterDataEntry> {
public:
    ~AttributionReportingFilterDataEntry() override { }

    String GetKey() { return m_key; }
    void SetKey(const String& value) { m_key = value; }

    protocol::Array<String>* GetValues() { return m_values.get(); }
    void SetValues(std::unique_ptr<protocol::Array<String>> value) { m_values = std::move(value); }

    template<int STATE>
    class AttributionReportingFilterDataEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValuesSet = 1 << 2,
            AllFieldsSet = (KeySet | ValuesSet | 0)};


        AttributionReportingFilterDataEntryBuilder<STATE | KeySet>& SetKey(const String& value)
        {
            static_assert(!(STATE & KeySet), "property key should not be set yet");
            m_result->SetKey(value);
            return castState<KeySet>();
        }

        AttributionReportingFilterDataEntryBuilder<STATE | ValuesSet>& SetValues(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & ValuesSet), "property values should not be set yet");
            m_result->SetValues(std::move(value));
            return castState<ValuesSet>();
        }

        std::unique_ptr<AttributionReportingFilterDataEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterDataEntry;
        AttributionReportingFilterDataEntryBuilder() : m_result(new AttributionReportingFilterDataEntry()) { }

        template<int STEP> AttributionReportingFilterDataEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterDataEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterDataEntry> m_result;
    };

    static AttributionReportingFilterDataEntryBuilder<0> Create()
    {
        return AttributionReportingFilterDataEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterDataEntry()
    {
    }

    String m_key;
    std::unique_ptr<protocol::Array<String>> m_values;
};


class  AttributionReportingFilterConfig : public ::crdtp::ProtocolObject<AttributionReportingFilterConfig> {
public:
    ~AttributionReportingFilterConfig() override { }

    protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>* GetFilterValues() { return m_filterValues.get(); }
    void SetFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) { m_filterValues = std::move(value); }

    bool HasLookbackWindow() { return !!m_lookbackWindow; }
    int GetLookbackWindow(int defaultValue) const {
       return m_lookbackWindow.value_or(defaultValue);
    }
    const std::optional<int>& GetLookbackWindow() const {
       return m_lookbackWindow;
    }
    void SetLookbackWindow(int value) { m_lookbackWindow = value; }

    template<int STATE>
    class AttributionReportingFilterConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FilterValuesSet = 1 << 1,
            AllFieldsSet = (FilterValuesSet | 0)};


        AttributionReportingFilterConfigBuilder<STATE | FilterValuesSet>& SetFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value)
        {
            static_assert(!(STATE & FilterValuesSet), "property filterValues should not be set yet");
            m_result->SetFilterValues(std::move(value));
            return castState<FilterValuesSet>();
        }

        AttributionReportingFilterConfigBuilder<STATE>& SetLookbackWindow(int value)
        {
            m_result->SetLookbackWindow(value);
            return *this;
        }

        std::unique_ptr<AttributionReportingFilterConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterConfig;
        AttributionReportingFilterConfigBuilder() : m_result(new AttributionReportingFilterConfig()) { }

        template<int STEP> AttributionReportingFilterConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterConfig> m_result;
    };

    static AttributionReportingFilterConfigBuilder<0> Create()
    {
        return AttributionReportingFilterConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterConfig()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> m_filterValues;
    std::optional<int> m_lookbackWindow;
};


class  AttributionReportingFilterPair : public ::crdtp::ProtocolObject<AttributionReportingFilterPair> {
public:
    ~AttributionReportingFilterPair() override { }

    protocol::Array<protocol::Storage::AttributionReportingFilterConfig>* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) { m_filters = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingFilterConfig>* GetNotFilters() { return m_notFilters.get(); }
    void SetNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) { m_notFilters = std::move(value); }

    template<int STATE>
    class AttributionReportingFilterPairBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            NotFiltersSet = 1 << 2,
            AllFieldsSet = (FiltersSet | NotFiltersSet | 0)};


        AttributionReportingFilterPairBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        AttributionReportingFilterPairBuilder<STATE | NotFiltersSet>& SetNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value)
        {
            static_assert(!(STATE & NotFiltersSet), "property notFilters should not be set yet");
            m_result->SetNotFilters(std::move(value));
            return castState<NotFiltersSet>();
        }

        std::unique_ptr<AttributionReportingFilterPair> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterPair;
        AttributionReportingFilterPairBuilder() : m_result(new AttributionReportingFilterPair()) { }

        template<int STEP> AttributionReportingFilterPairBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterPairBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_result;
    };

    static AttributionReportingFilterPairBuilder<0> Create()
    {
        return AttributionReportingFilterPairBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterPair()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> m_filters;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> m_notFilters;
};


class  AttributionReportingAggregationKeysEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregationKeysEntry> {
public:
    ~AttributionReportingAggregationKeysEntry() override { }

    String GetKey() { return m_key; }
    void SetKey(const String& value) { m_key = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    template<int STATE>
    class AttributionReportingAggregationKeysEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (KeySet | ValueSet | 0)};


        AttributionReportingAggregationKeysEntryBuilder<STATE | KeySet>& SetKey(const String& value)
        {
            static_assert(!(STATE & KeySet), "property key should not be set yet");
            m_result->SetKey(value);
            return castState<KeySet>();
        }

        AttributionReportingAggregationKeysEntryBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<AttributionReportingAggregationKeysEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregationKeysEntry;
        AttributionReportingAggregationKeysEntryBuilder() : m_result(new AttributionReportingAggregationKeysEntry()) { }

        template<int STEP> AttributionReportingAggregationKeysEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregationKeysEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregationKeysEntry> m_result;
    };

    static AttributionReportingAggregationKeysEntryBuilder<0> Create()
    {
        return AttributionReportingAggregationKeysEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregationKeysEntry()
    {
    }

    String m_key;
    String m_value;
};


class  AttributionReportingEventReportWindows : public ::crdtp::ProtocolObject<AttributionReportingEventReportWindows> {
public:
    ~AttributionReportingEventReportWindows() override { }

    int GetStart() { return m_start; }
    void SetStart(int value) { m_start = value; }

    protocol::Array<int>* GetEnds() { return m_ends.get(); }
    void SetEnds(std::unique_ptr<protocol::Array<int>> value) { m_ends = std::move(value); }

    template<int STATE>
    class AttributionReportingEventReportWindowsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StartSet = 1 << 1,
            EndsSet = 1 << 2,
            AllFieldsSet = (StartSet | EndsSet | 0)};


        AttributionReportingEventReportWindowsBuilder<STATE | StartSet>& SetStart(int value)
        {
            static_assert(!(STATE & StartSet), "property start should not be set yet");
            m_result->SetStart(value);
            return castState<StartSet>();
        }

        AttributionReportingEventReportWindowsBuilder<STATE | EndsSet>& SetEnds(std::unique_ptr<protocol::Array<int>> value)
        {
            static_assert(!(STATE & EndsSet), "property ends should not be set yet");
            m_result->SetEnds(std::move(value));
            return castState<EndsSet>();
        }

        std::unique_ptr<AttributionReportingEventReportWindows> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingEventReportWindows;
        AttributionReportingEventReportWindowsBuilder() : m_result(new AttributionReportingEventReportWindows()) { }

        template<int STEP> AttributionReportingEventReportWindowsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingEventReportWindowsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> m_result;
    };

    static AttributionReportingEventReportWindowsBuilder<0> Create()
    {
        return AttributionReportingEventReportWindowsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingEventReportWindows()
    {
          m_start = 0;
    }

    int m_start;
    std::unique_ptr<protocol::Array<int>> m_ends;
};


class  AttributionReportingAggregatableDebugReportingData : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDebugReportingData> {
public:
    ~AttributionReportingAggregatableDebugReportingData() override { }

    String GetKeyPiece() { return m_keyPiece; }
    void SetKeyPiece(const String& value) { m_keyPiece = value; }

    double GetValue() { return m_value; }
    void SetValue(double value) { m_value = value; }

    protocol::Array<String>* GetTypes() { return m_types.get(); }
    void SetTypes(std::unique_ptr<protocol::Array<String>> value) { m_types = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableDebugReportingDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            ValueSet = 1 << 2,
            TypesSet = 1 << 3,
            AllFieldsSet = (KeyPieceSet | ValueSet | TypesSet | 0)};


        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | KeyPieceSet>& SetKeyPiece(const String& value)
        {
            static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
            m_result->SetKeyPiece(value);
            return castState<KeyPieceSet>();
        }

        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | ValueSet>& SetValue(double value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | TypesSet>& SetTypes(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & TypesSet), "property types should not be set yet");
            m_result->SetTypes(std::move(value));
            return castState<TypesSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableDebugReportingData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDebugReportingData;
        AttributionReportingAggregatableDebugReportingDataBuilder() : m_result(new AttributionReportingAggregatableDebugReportingData()) { }

        template<int STEP> AttributionReportingAggregatableDebugReportingDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDebugReportingDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingData> m_result;
    };

    static AttributionReportingAggregatableDebugReportingDataBuilder<0> Create()
    {
        return AttributionReportingAggregatableDebugReportingDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDebugReportingData()
    {
          m_value = 0;
    }

    String m_keyPiece;
    double m_value;
    std::unique_ptr<protocol::Array<String>> m_types;
};


class  AttributionReportingAggregatableDebugReportingConfig : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDebugReportingConfig> {
public:
    ~AttributionReportingAggregatableDebugReportingConfig() override { }

    bool HasBudget() { return !!m_budget; }
    double GetBudget(double defaultValue) const {
       return m_budget.value_or(defaultValue);
    }
    const std::optional<double>& GetBudget() const {
       return m_budget;
    }
    void SetBudget(double value) { m_budget = value; }

    String GetKeyPiece() { return m_keyPiece; }
    void SetKeyPiece(const String& value) { m_keyPiece = value; }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>* GetDebugData() { return m_debugData.get(); }
    void SetDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value) { m_debugData = std::move(value); }

    bool HasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String GetAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void SetAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }

    template<int STATE>
    class AttributionReportingAggregatableDebugReportingConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            DebugDataSet = 1 << 2,
            AllFieldsSet = (KeyPieceSet | DebugDataSet | 0)};


        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& SetBudget(double value)
        {
            m_result->SetBudget(value);
            return *this;
        }

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | KeyPieceSet>& SetKeyPiece(const String& value)
        {
            static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
            m_result->SetKeyPiece(value);
            return castState<KeyPieceSet>();
        }

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | DebugDataSet>& SetDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value)
        {
            static_assert(!(STATE & DebugDataSet), "property debugData should not be set yet");
            m_result->SetDebugData(std::move(value));
            return castState<DebugDataSet>();
        }

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& SetAggregationCoordinatorOrigin(const String& value)
        {
            m_result->SetAggregationCoordinatorOrigin(value);
            return *this;
        }

        std::unique_ptr<AttributionReportingAggregatableDebugReportingConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDebugReportingConfig;
        AttributionReportingAggregatableDebugReportingConfigBuilder() : m_result(new AttributionReportingAggregatableDebugReportingConfig()) { }

        template<int STEP> AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_result;
    };

    static AttributionReportingAggregatableDebugReportingConfigBuilder<0> Create()
    {
        return AttributionReportingAggregatableDebugReportingConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDebugReportingConfig()
    {
    }

    std::optional<double> m_budget;
    String m_keyPiece;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> m_debugData;
    std::optional<String> m_aggregationCoordinatorOrigin;
};


class  AttributionScopesData : public ::crdtp::ProtocolObject<AttributionScopesData> {
public:
    ~AttributionScopesData() override { }

    protocol::Array<String>* GetValues() { return m_values.get(); }
    void SetValues(std::unique_ptr<protocol::Array<String>> value) { m_values = std::move(value); }

    double GetLimit() { return m_limit; }
    void SetLimit(double value) { m_limit = value; }

    double GetMaxEventStates() { return m_maxEventStates; }
    void SetMaxEventStates(double value) { m_maxEventStates = value; }

    template<int STATE>
    class AttributionScopesDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValuesSet = 1 << 1,
            LimitSet = 1 << 2,
            MaxEventStatesSet = 1 << 3,
            AllFieldsSet = (ValuesSet | LimitSet | MaxEventStatesSet | 0)};


        AttributionScopesDataBuilder<STATE | ValuesSet>& SetValues(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & ValuesSet), "property values should not be set yet");
            m_result->SetValues(std::move(value));
            return castState<ValuesSet>();
        }

        AttributionScopesDataBuilder<STATE | LimitSet>& SetLimit(double value)
        {
            static_assert(!(STATE & LimitSet), "property limit should not be set yet");
            m_result->SetLimit(value);
            return castState<LimitSet>();
        }

        AttributionScopesDataBuilder<STATE | MaxEventStatesSet>& SetMaxEventStates(double value)
        {
            static_assert(!(STATE & MaxEventStatesSet), "property maxEventStates should not be set yet");
            m_result->SetMaxEventStates(value);
            return castState<MaxEventStatesSet>();
        }

        std::unique_ptr<AttributionScopesData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionScopesData;
        AttributionScopesDataBuilder() : m_result(new AttributionScopesData()) { }

        template<int STEP> AttributionScopesDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionScopesDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionScopesData> m_result;
    };

    static AttributionScopesDataBuilder<0> Create()
    {
        return AttributionScopesDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionScopesData()
    {
          m_limit = 0;
          m_maxEventStates = 0;
    }

    std::unique_ptr<protocol::Array<String>> m_values;
    double m_limit;
    double m_maxEventStates;
};


class  AttributionReportingNamedBudgetDef : public ::crdtp::ProtocolObject<AttributionReportingNamedBudgetDef> {
public:
    ~AttributionReportingNamedBudgetDef() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    int GetBudget() { return m_budget; }
    void SetBudget(int value) { m_budget = value; }

    template<int STATE>
    class AttributionReportingNamedBudgetDefBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            BudgetSet = 1 << 2,
            AllFieldsSet = (NameSet | BudgetSet | 0)};


        AttributionReportingNamedBudgetDefBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        AttributionReportingNamedBudgetDefBuilder<STATE | BudgetSet>& SetBudget(int value)
        {
            static_assert(!(STATE & BudgetSet), "property budget should not be set yet");
            m_result->SetBudget(value);
            return castState<BudgetSet>();
        }

        std::unique_ptr<AttributionReportingNamedBudgetDef> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingNamedBudgetDef;
        AttributionReportingNamedBudgetDefBuilder() : m_result(new AttributionReportingNamedBudgetDef()) { }

        template<int STEP> AttributionReportingNamedBudgetDefBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingNamedBudgetDefBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingNamedBudgetDef> m_result;
    };

    static AttributionReportingNamedBudgetDefBuilder<0> Create()
    {
        return AttributionReportingNamedBudgetDefBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingNamedBudgetDef()
    {
          m_budget = 0;
    }

    String m_name;
    int m_budget;
};


class  AttributionReportingSourceRegistration : public ::crdtp::ProtocolObject<AttributionReportingSourceRegistration> {
public:
    ~AttributionReportingSourceRegistration() override { }

    double GetTime() { return m_time; }
    void SetTime(double value) { m_time = value; }

    int GetExpiry() { return m_expiry; }
    void SetExpiry(int value) { m_expiry = value; }

    protocol::Array<double>* GetTriggerData() { return m_triggerData.get(); }
    void SetTriggerData(std::unique_ptr<protocol::Array<double>> value) { m_triggerData = std::move(value); }

    protocol::Storage::AttributionReportingEventReportWindows* GetEventReportWindows() { return m_eventReportWindows.get(); }
    void SetEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value) { m_eventReportWindows = std::move(value); }

    int GetAggregatableReportWindow() { return m_aggregatableReportWindow; }
    void SetAggregatableReportWindow(int value) { m_aggregatableReportWindow = value; }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    String GetSourceOrigin() { return m_sourceOrigin; }
    void SetSourceOrigin(const String& value) { m_sourceOrigin = value; }

    String GetReportingOrigin() { return m_reportingOrigin; }
    void SetReportingOrigin(const String& value) { m_reportingOrigin = value; }

    protocol::Array<String>* GetDestinationSites() { return m_destinationSites.get(); }
    void SetDestinationSites(std::unique_ptr<protocol::Array<String>> value) { m_destinationSites = std::move(value); }

    String GetEventId() { return m_eventId; }
    void SetEventId(const String& value) { m_eventId = value; }

    String GetPriority() { return m_priority; }
    void SetPriority(const String& value) { m_priority = value; }

    protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>* GetFilterData() { return m_filterData.get(); }
    void SetFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) { m_filterData = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>* GetAggregationKeys() { return m_aggregationKeys.get(); }
    void SetAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value) { m_aggregationKeys = std::move(value); }

    bool HasDebugKey() { return !!m_debugKey; }
    String GetDebugKey(const String& defaultValue) const {
       return m_debugKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDebugKey() const {
       return m_debugKey;
    }
    void SetDebugKey(const String& value) { m_debugKey = value; }

    String GetTriggerDataMatching() { return m_triggerDataMatching; }
    void SetTriggerDataMatching(const String& value) { m_triggerDataMatching = value; }

    String GetDestinationLimitPriority() { return m_destinationLimitPriority; }
    void SetDestinationLimitPriority(const String& value) { m_destinationLimitPriority = value; }

    protocol::Storage::AttributionReportingAggregatableDebugReportingConfig* GetAggregatableDebugReportingConfig() { return m_aggregatableDebugReportingConfig.get(); }
    void SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) { m_aggregatableDebugReportingConfig = std::move(value); }

    bool HasScopesData() { return !!m_scopesData; }
    protocol::Storage::AttributionScopesData* GetScopesData(protocol::Storage::AttributionScopesData* defaultValue) {
       return m_scopesData ? m_scopesData.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Storage::AttributionScopesData>& GetScopesData() const {
       return m_scopesData;
    }
    void SetScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value) { m_scopesData = std::move(value); }

    int GetMaxEventLevelReports() { return m_maxEventLevelReports; }
    void SetMaxEventLevelReports(int value) { m_maxEventLevelReports = value; }

    protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>* GetNamedBudgets() { return m_namedBudgets.get(); }
    void SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value) { m_namedBudgets = std::move(value); }

    bool GetDebugReporting() { return m_debugReporting; }
    void SetDebugReporting(bool value) { m_debugReporting = value; }

    double GetEventLevelEpsilon() { return m_eventLevelEpsilon; }
    void SetEventLevelEpsilon(double value) { m_eventLevelEpsilon = value; }

    template<int STATE>
    class AttributionReportingSourceRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TimeSet = 1 << 1,
            ExpirySet = 1 << 2,
            TriggerDataSet = 1 << 3,
            EventReportWindowsSet = 1 << 4,
            AggregatableReportWindowSet = 1 << 5,
            TypeSet = 1 << 6,
            SourceOriginSet = 1 << 7,
            ReportingOriginSet = 1 << 8,
            DestinationSitesSet = 1 << 9,
            EventIdSet = 1 << 10,
            PrioritySet = 1 << 11,
            FilterDataSet = 1 << 12,
            AggregationKeysSet = 1 << 13,
            TriggerDataMatchingSet = 1 << 14,
            DestinationLimitPrioritySet = 1 << 15,
            AggregatableDebugReportingConfigSet = 1 << 16,
            MaxEventLevelReportsSet = 1 << 17,
            NamedBudgetsSet = 1 << 18,
            DebugReportingSet = 1 << 19,
            EventLevelEpsilonSet = 1 << 20,
            AllFieldsSet = (TimeSet | ExpirySet | TriggerDataSet | EventReportWindowsSet | AggregatableReportWindowSet | TypeSet | SourceOriginSet | ReportingOriginSet | DestinationSitesSet | EventIdSet | PrioritySet | FilterDataSet | AggregationKeysSet | TriggerDataMatchingSet | DestinationLimitPrioritySet | AggregatableDebugReportingConfigSet | MaxEventLevelReportsSet | NamedBudgetsSet | DebugReportingSet | EventLevelEpsilonSet | 0)};


        AttributionReportingSourceRegistrationBuilder<STATE | TimeSet>& SetTime(double value)
        {
            static_assert(!(STATE & TimeSet), "property time should not be set yet");
            m_result->SetTime(value);
            return castState<TimeSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | ExpirySet>& SetExpiry(int value)
        {
            static_assert(!(STATE & ExpirySet), "property expiry should not be set yet");
            m_result->SetExpiry(value);
            return castState<ExpirySet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | TriggerDataSet>& SetTriggerData(std::unique_ptr<protocol::Array<double>> value)
        {
            static_assert(!(STATE & TriggerDataSet), "property triggerData should not be set yet");
            m_result->SetTriggerData(std::move(value));
            return castState<TriggerDataSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | EventReportWindowsSet>& SetEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value)
        {
            static_assert(!(STATE & EventReportWindowsSet), "property eventReportWindows should not be set yet");
            m_result->SetEventReportWindows(std::move(value));
            return castState<EventReportWindowsSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | AggregatableReportWindowSet>& SetAggregatableReportWindow(int value)
        {
            static_assert(!(STATE & AggregatableReportWindowSet), "property aggregatableReportWindow should not be set yet");
            m_result->SetAggregatableReportWindow(value);
            return castState<AggregatableReportWindowSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | SourceOriginSet>& SetSourceOrigin(const String& value)
        {
            static_assert(!(STATE & SourceOriginSet), "property sourceOrigin should not be set yet");
            m_result->SetSourceOrigin(value);
            return castState<SourceOriginSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | ReportingOriginSet>& SetReportingOrigin(const String& value)
        {
            static_assert(!(STATE & ReportingOriginSet), "property reportingOrigin should not be set yet");
            m_result->SetReportingOrigin(value);
            return castState<ReportingOriginSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | DestinationSitesSet>& SetDestinationSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & DestinationSitesSet), "property destinationSites should not be set yet");
            m_result->SetDestinationSites(std::move(value));
            return castState<DestinationSitesSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | EventIdSet>& SetEventId(const String& value)
        {
            static_assert(!(STATE & EventIdSet), "property eventId should not be set yet");
            m_result->SetEventId(value);
            return castState<EventIdSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | PrioritySet>& SetPriority(const String& value)
        {
            static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
            m_result->SetPriority(value);
            return castState<PrioritySet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | FilterDataSet>& SetFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value)
        {
            static_assert(!(STATE & FilterDataSet), "property filterData should not be set yet");
            m_result->SetFilterData(std::move(value));
            return castState<FilterDataSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | AggregationKeysSet>& SetAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value)
        {
            static_assert(!(STATE & AggregationKeysSet), "property aggregationKeys should not be set yet");
            m_result->SetAggregationKeys(std::move(value));
            return castState<AggregationKeysSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE>& SetDebugKey(const String& value)
        {
            m_result->SetDebugKey(value);
            return *this;
        }

        AttributionReportingSourceRegistrationBuilder<STATE | TriggerDataMatchingSet>& SetTriggerDataMatching(const String& value)
        {
            static_assert(!(STATE & TriggerDataMatchingSet), "property triggerDataMatching should not be set yet");
            m_result->SetTriggerDataMatching(value);
            return castState<TriggerDataMatchingSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | DestinationLimitPrioritySet>& SetDestinationLimitPriority(const String& value)
        {
            static_assert(!(STATE & DestinationLimitPrioritySet), "property destinationLimitPriority should not be set yet");
            m_result->SetDestinationLimitPriority(value);
            return castState<DestinationLimitPrioritySet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | AggregatableDebugReportingConfigSet>& SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value)
        {
            static_assert(!(STATE & AggregatableDebugReportingConfigSet), "property aggregatableDebugReportingConfig should not be set yet");
            m_result->SetAggregatableDebugReportingConfig(std::move(value));
            return castState<AggregatableDebugReportingConfigSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE>& SetScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value)
        {
            m_result->SetScopesData(std::move(value));
            return *this;
        }

        AttributionReportingSourceRegistrationBuilder<STATE | MaxEventLevelReportsSet>& SetMaxEventLevelReports(int value)
        {
            static_assert(!(STATE & MaxEventLevelReportsSet), "property maxEventLevelReports should not be set yet");
            m_result->SetMaxEventLevelReports(value);
            return castState<MaxEventLevelReportsSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | NamedBudgetsSet>& SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value)
        {
            static_assert(!(STATE & NamedBudgetsSet), "property namedBudgets should not be set yet");
            m_result->SetNamedBudgets(std::move(value));
            return castState<NamedBudgetsSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | DebugReportingSet>& SetDebugReporting(bool value)
        {
            static_assert(!(STATE & DebugReportingSet), "property debugReporting should not be set yet");
            m_result->SetDebugReporting(value);
            return castState<DebugReportingSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | EventLevelEpsilonSet>& SetEventLevelEpsilon(double value)
        {
            static_assert(!(STATE & EventLevelEpsilonSet), "property eventLevelEpsilon should not be set yet");
            m_result->SetEventLevelEpsilon(value);
            return castState<EventLevelEpsilonSet>();
        }

        std::unique_ptr<AttributionReportingSourceRegistration> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingSourceRegistration;
        AttributionReportingSourceRegistrationBuilder() : m_result(new AttributionReportingSourceRegistration()) { }

        template<int STEP> AttributionReportingSourceRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingSourceRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> m_result;
    };

    static AttributionReportingSourceRegistrationBuilder<0> Create()
    {
        return AttributionReportingSourceRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingSourceRegistration()
    {
          m_time = 0;
          m_expiry = 0;
          m_aggregatableReportWindow = 0;
          m_maxEventLevelReports = 0;
          m_debugReporting = false;
          m_eventLevelEpsilon = 0;
    }

    double m_time;
    int m_expiry;
    std::unique_ptr<protocol::Array<double>> m_triggerData;
    std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> m_eventReportWindows;
    int m_aggregatableReportWindow;
    String m_type;
    String m_sourceOrigin;
    String m_reportingOrigin;
    std::unique_ptr<protocol::Array<String>> m_destinationSites;
    String m_eventId;
    String m_priority;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> m_filterData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> m_aggregationKeys;
    std::optional<String> m_debugKey;
    String m_triggerDataMatching;
    String m_destinationLimitPriority;
    std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_aggregatableDebugReportingConfig;
    std::unique_ptr<protocol::Storage::AttributionScopesData> m_scopesData;
    int m_maxEventLevelReports;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> m_namedBudgets;
    bool m_debugReporting;
    double m_eventLevelEpsilon;
};


class  AttributionReportingAggregatableValueDictEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregatableValueDictEntry> {
public:
    ~AttributionReportingAggregatableValueDictEntry() override { }

    String GetKey() { return m_key; }
    void SetKey(const String& value) { m_key = value; }

    double GetValue() { return m_value; }
    void SetValue(double value) { m_value = value; }

    String GetFilteringId() { return m_filteringId; }
    void SetFilteringId(const String& value) { m_filteringId = value; }

    template<int STATE>
    class AttributionReportingAggregatableValueDictEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            FilteringIdSet = 1 << 3,
            AllFieldsSet = (KeySet | ValueSet | FilteringIdSet | 0)};


        AttributionReportingAggregatableValueDictEntryBuilder<STATE | KeySet>& SetKey(const String& value)
        {
            static_assert(!(STATE & KeySet), "property key should not be set yet");
            m_result->SetKey(value);
            return castState<KeySet>();
        }

        AttributionReportingAggregatableValueDictEntryBuilder<STATE | ValueSet>& SetValue(double value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        AttributionReportingAggregatableValueDictEntryBuilder<STATE | FilteringIdSet>& SetFilteringId(const String& value)
        {
            static_assert(!(STATE & FilteringIdSet), "property filteringId should not be set yet");
            m_result->SetFilteringId(value);
            return castState<FilteringIdSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableValueDictEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableValueDictEntry;
        AttributionReportingAggregatableValueDictEntryBuilder() : m_result(new AttributionReportingAggregatableValueDictEntry()) { }

        template<int STEP> AttributionReportingAggregatableValueDictEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableValueDictEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableValueDictEntry> m_result;
    };

    static AttributionReportingAggregatableValueDictEntryBuilder<0> Create()
    {
        return AttributionReportingAggregatableValueDictEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableValueDictEntry()
    {
          m_value = 0;
    }

    String m_key;
    double m_value;
    String m_filteringId;
};


class  AttributionReportingAggregatableValueEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregatableValueEntry> {
public:
    ~AttributionReportingAggregatableValueEntry() override { }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>* GetValues() { return m_values.get(); }
    void SetValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value) { m_values = std::move(value); }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableValueEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValuesSet = 1 << 1,
            FiltersSet = 1 << 2,
            AllFieldsSet = (ValuesSet | FiltersSet | 0)};


        AttributionReportingAggregatableValueEntryBuilder<STATE | ValuesSet>& SetValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value)
        {
            static_assert(!(STATE & ValuesSet), "property values should not be set yet");
            m_result->SetValues(std::move(value));
            return castState<ValuesSet>();
        }

        AttributionReportingAggregatableValueEntryBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableValueEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableValueEntry;
        AttributionReportingAggregatableValueEntryBuilder() : m_result(new AttributionReportingAggregatableValueEntry()) { }

        template<int STEP> AttributionReportingAggregatableValueEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableValueEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableValueEntry> m_result;
    };

    static AttributionReportingAggregatableValueEntryBuilder<0> Create()
    {
        return AttributionReportingAggregatableValueEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableValueEntry()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> m_values;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class  AttributionReportingEventTriggerData : public ::crdtp::ProtocolObject<AttributionReportingEventTriggerData> {
public:
    ~AttributionReportingEventTriggerData() override { }

    String GetData() { return m_data; }
    void SetData(const String& value) { m_data = value; }

    String GetPriority() { return m_priority; }
    void SetPriority(const String& value) { m_priority = value; }

    bool HasDedupKey() { return !!m_dedupKey; }
    String GetDedupKey(const String& defaultValue) const {
       return m_dedupKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDedupKey() const {
       return m_dedupKey;
    }
    void SetDedupKey(const String& value) { m_dedupKey = value; }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingEventTriggerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DataSet = 1 << 1,
            PrioritySet = 1 << 2,
            FiltersSet = 1 << 3,
            AllFieldsSet = (DataSet | PrioritySet | FiltersSet | 0)};


        AttributionReportingEventTriggerDataBuilder<STATE | DataSet>& SetData(const String& value)
        {
            static_assert(!(STATE & DataSet), "property data should not be set yet");
            m_result->SetData(value);
            return castState<DataSet>();
        }

        AttributionReportingEventTriggerDataBuilder<STATE | PrioritySet>& SetPriority(const String& value)
        {
            static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
            m_result->SetPriority(value);
            return castState<PrioritySet>();
        }

        AttributionReportingEventTriggerDataBuilder<STATE>& SetDedupKey(const String& value)
        {
            m_result->SetDedupKey(value);
            return *this;
        }

        AttributionReportingEventTriggerDataBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingEventTriggerData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingEventTriggerData;
        AttributionReportingEventTriggerDataBuilder() : m_result(new AttributionReportingEventTriggerData()) { }

        template<int STEP> AttributionReportingEventTriggerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingEventTriggerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingEventTriggerData> m_result;
    };

    static AttributionReportingEventTriggerDataBuilder<0> Create()
    {
        return AttributionReportingEventTriggerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingEventTriggerData()
    {
    }

    String m_data;
    String m_priority;
    std::optional<String> m_dedupKey;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class  AttributionReportingAggregatableTriggerData : public ::crdtp::ProtocolObject<AttributionReportingAggregatableTriggerData> {
public:
    ~AttributionReportingAggregatableTriggerData() override { }

    String GetKeyPiece() { return m_keyPiece; }
    void SetKeyPiece(const String& value) { m_keyPiece = value; }

    protocol::Array<String>* GetSourceKeys() { return m_sourceKeys.get(); }
    void SetSourceKeys(std::unique_ptr<protocol::Array<String>> value) { m_sourceKeys = std::move(value); }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableTriggerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            SourceKeysSet = 1 << 2,
            FiltersSet = 1 << 3,
            AllFieldsSet = (KeyPieceSet | SourceKeysSet | FiltersSet | 0)};


        AttributionReportingAggregatableTriggerDataBuilder<STATE | KeyPieceSet>& SetKeyPiece(const String& value)
        {
            static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
            m_result->SetKeyPiece(value);
            return castState<KeyPieceSet>();
        }

        AttributionReportingAggregatableTriggerDataBuilder<STATE | SourceKeysSet>& SetSourceKeys(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & SourceKeysSet), "property sourceKeys should not be set yet");
            m_result->SetSourceKeys(std::move(value));
            return castState<SourceKeysSet>();
        }

        AttributionReportingAggregatableTriggerDataBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableTriggerData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableTriggerData;
        AttributionReportingAggregatableTriggerDataBuilder() : m_result(new AttributionReportingAggregatableTriggerData()) { }

        template<int STEP> AttributionReportingAggregatableTriggerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableTriggerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableTriggerData> m_result;
    };

    static AttributionReportingAggregatableTriggerDataBuilder<0> Create()
    {
        return AttributionReportingAggregatableTriggerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableTriggerData()
    {
    }

    String m_keyPiece;
    std::unique_ptr<protocol::Array<String>> m_sourceKeys;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class  AttributionReportingAggregatableDedupKey : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDedupKey> {
public:
    ~AttributionReportingAggregatableDedupKey() override { }

    bool HasDedupKey() { return !!m_dedupKey; }
    String GetDedupKey(const String& defaultValue) const {
       return m_dedupKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDedupKey() const {
       return m_dedupKey;
    }
    void SetDedupKey(const String& value) { m_dedupKey = value; }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableDedupKeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AllFieldsSet = (FiltersSet | 0)};


        AttributionReportingAggregatableDedupKeyBuilder<STATE>& SetDedupKey(const String& value)
        {
            m_result->SetDedupKey(value);
            return *this;
        }

        AttributionReportingAggregatableDedupKeyBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableDedupKey> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDedupKey;
        AttributionReportingAggregatableDedupKeyBuilder() : m_result(new AttributionReportingAggregatableDedupKey()) { }

        template<int STEP> AttributionReportingAggregatableDedupKeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDedupKeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDedupKey> m_result;
    };

    static AttributionReportingAggregatableDedupKeyBuilder<0> Create()
    {
        return AttributionReportingAggregatableDedupKeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDedupKey()
    {
    }

    std::optional<String> m_dedupKey;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class  AttributionReportingNamedBudgetCandidate : public ::crdtp::ProtocolObject<AttributionReportingNamedBudgetCandidate> {
public:
    ~AttributionReportingNamedBudgetCandidate() override { }

    bool HasName() { return !!m_name; }
    String GetName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& GetName() const {
       return m_name;
    }
    void SetName(const String& value) { m_name = value; }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingNamedBudgetCandidateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AllFieldsSet = (FiltersSet | 0)};


        AttributionReportingNamedBudgetCandidateBuilder<STATE>& SetName(const String& value)
        {
            m_result->SetName(value);
            return *this;
        }

        AttributionReportingNamedBudgetCandidateBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingNamedBudgetCandidate> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingNamedBudgetCandidate;
        AttributionReportingNamedBudgetCandidateBuilder() : m_result(new AttributionReportingNamedBudgetCandidate()) { }

        template<int STEP> AttributionReportingNamedBudgetCandidateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingNamedBudgetCandidateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingNamedBudgetCandidate> m_result;
    };

    static AttributionReportingNamedBudgetCandidateBuilder<0> Create()
    {
        return AttributionReportingNamedBudgetCandidateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingNamedBudgetCandidate()
    {
    }

    std::optional<String> m_name;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class  AttributionReportingTriggerRegistration : public ::crdtp::ProtocolObject<AttributionReportingTriggerRegistration> {
public:
    ~AttributionReportingTriggerRegistration() override { }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    bool HasDebugKey() { return !!m_debugKey; }
    String GetDebugKey(const String& defaultValue) const {
       return m_debugKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDebugKey() const {
       return m_debugKey;
    }
    void SetDebugKey(const String& value) { m_debugKey = value; }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>* GetAggregatableDedupKeys() { return m_aggregatableDedupKeys.get(); }
    void SetAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value) { m_aggregatableDedupKeys = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>* GetEventTriggerData() { return m_eventTriggerData.get(); }
    void SetEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value) { m_eventTriggerData = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>* GetAggregatableTriggerData() { return m_aggregatableTriggerData.get(); }
    void SetAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value) { m_aggregatableTriggerData = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>* GetAggregatableValues() { return m_aggregatableValues.get(); }
    void SetAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value) { m_aggregatableValues = std::move(value); }

    int GetAggregatableFilteringIdMaxBytes() { return m_aggregatableFilteringIdMaxBytes; }
    void SetAggregatableFilteringIdMaxBytes(int value) { m_aggregatableFilteringIdMaxBytes = value; }

    bool GetDebugReporting() { return m_debugReporting; }
    void SetDebugReporting(bool value) { m_debugReporting = value; }

    bool HasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String GetAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void SetAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }

    String GetSourceRegistrationTimeConfig() { return m_sourceRegistrationTimeConfig; }
    void SetSourceRegistrationTimeConfig(const String& value) { m_sourceRegistrationTimeConfig = value; }

    bool HasTriggerContextId() { return !!m_triggerContextId; }
    String GetTriggerContextId(const String& defaultValue) const {
       return m_triggerContextId.value_or(defaultValue);
    }
    const std::optional<String>& GetTriggerContextId() const {
       return m_triggerContextId;
    }
    void SetTriggerContextId(const String& value) { m_triggerContextId = value; }

    protocol::Storage::AttributionReportingAggregatableDebugReportingConfig* GetAggregatableDebugReportingConfig() { return m_aggregatableDebugReportingConfig.get(); }
    void SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) { m_aggregatableDebugReportingConfig = std::move(value); }

    protocol::Array<String>* GetScopes() { return m_scopes.get(); }
    void SetScopes(std::unique_ptr<protocol::Array<String>> value) { m_scopes = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>* GetNamedBudgets() { return m_namedBudgets.get(); }
    void SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value) { m_namedBudgets = std::move(value); }

    template<int STATE>
    class AttributionReportingTriggerRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AggregatableDedupKeysSet = 1 << 2,
            EventTriggerDataSet = 1 << 3,
            AggregatableTriggerDataSet = 1 << 4,
            AggregatableValuesSet = 1 << 5,
            AggregatableFilteringIdMaxBytesSet = 1 << 6,
            DebugReportingSet = 1 << 7,
            SourceRegistrationTimeConfigSet = 1 << 8,
            AggregatableDebugReportingConfigSet = 1 << 9,
            ScopesSet = 1 << 10,
            NamedBudgetsSet = 1 << 11,
            AllFieldsSet = (FiltersSet | AggregatableDedupKeysSet | EventTriggerDataSet | AggregatableTriggerDataSet | AggregatableValuesSet | AggregatableFilteringIdMaxBytesSet | DebugReportingSet | SourceRegistrationTimeConfigSet | AggregatableDebugReportingConfigSet | ScopesSet | NamedBudgetsSet | 0)};


        AttributionReportingTriggerRegistrationBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE>& SetDebugKey(const String& value)
        {
            m_result->SetDebugKey(value);
            return *this;
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableDedupKeysSet>& SetAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value)
        {
            static_assert(!(STATE & AggregatableDedupKeysSet), "property aggregatableDedupKeys should not be set yet");
            m_result->SetAggregatableDedupKeys(std::move(value));
            return castState<AggregatableDedupKeysSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | EventTriggerDataSet>& SetEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value)
        {
            static_assert(!(STATE & EventTriggerDataSet), "property eventTriggerData should not be set yet");
            m_result->SetEventTriggerData(std::move(value));
            return castState<EventTriggerDataSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableTriggerDataSet>& SetAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value)
        {
            static_assert(!(STATE & AggregatableTriggerDataSet), "property aggregatableTriggerData should not be set yet");
            m_result->SetAggregatableTriggerData(std::move(value));
            return castState<AggregatableTriggerDataSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableValuesSet>& SetAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value)
        {
            static_assert(!(STATE & AggregatableValuesSet), "property aggregatableValues should not be set yet");
            m_result->SetAggregatableValues(std::move(value));
            return castState<AggregatableValuesSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableFilteringIdMaxBytesSet>& SetAggregatableFilteringIdMaxBytes(int value)
        {
            static_assert(!(STATE & AggregatableFilteringIdMaxBytesSet), "property aggregatableFilteringIdMaxBytes should not be set yet");
            m_result->SetAggregatableFilteringIdMaxBytes(value);
            return castState<AggregatableFilteringIdMaxBytesSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | DebugReportingSet>& SetDebugReporting(bool value)
        {
            static_assert(!(STATE & DebugReportingSet), "property debugReporting should not be set yet");
            m_result->SetDebugReporting(value);
            return castState<DebugReportingSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE>& SetAggregationCoordinatorOrigin(const String& value)
        {
            m_result->SetAggregationCoordinatorOrigin(value);
            return *this;
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | SourceRegistrationTimeConfigSet>& SetSourceRegistrationTimeConfig(const String& value)
        {
            static_assert(!(STATE & SourceRegistrationTimeConfigSet), "property sourceRegistrationTimeConfig should not be set yet");
            m_result->SetSourceRegistrationTimeConfig(value);
            return castState<SourceRegistrationTimeConfigSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE>& SetTriggerContextId(const String& value)
        {
            m_result->SetTriggerContextId(value);
            return *this;
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableDebugReportingConfigSet>& SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value)
        {
            static_assert(!(STATE & AggregatableDebugReportingConfigSet), "property aggregatableDebugReportingConfig should not be set yet");
            m_result->SetAggregatableDebugReportingConfig(std::move(value));
            return castState<AggregatableDebugReportingConfigSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | ScopesSet>& SetScopes(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & ScopesSet), "property scopes should not be set yet");
            m_result->SetScopes(std::move(value));
            return castState<ScopesSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | NamedBudgetsSet>& SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value)
        {
            static_assert(!(STATE & NamedBudgetsSet), "property namedBudgets should not be set yet");
            m_result->SetNamedBudgets(std::move(value));
            return castState<NamedBudgetsSet>();
        }

        std::unique_ptr<AttributionReportingTriggerRegistration> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingTriggerRegistration;
        AttributionReportingTriggerRegistrationBuilder() : m_result(new AttributionReportingTriggerRegistration()) { }

        template<int STEP> AttributionReportingTriggerRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingTriggerRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> m_result;
    };

    static AttributionReportingTriggerRegistrationBuilder<0> Create()
    {
        return AttributionReportingTriggerRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingTriggerRegistration()
    {
          m_aggregatableFilteringIdMaxBytes = 0;
          m_debugReporting = false;
    }

    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
    std::optional<String> m_debugKey;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> m_aggregatableDedupKeys;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> m_eventTriggerData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> m_aggregatableTriggerData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> m_aggregatableValues;
    int m_aggregatableFilteringIdMaxBytes;
    bool m_debugReporting;
    std::optional<String> m_aggregationCoordinatorOrigin;
    String m_sourceRegistrationTimeConfig;
    std::optional<String> m_triggerContextId;
    std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_aggregatableDebugReportingConfig;
    std::unique_ptr<protocol::Array<String>> m_scopes;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> m_namedBudgets;
};


class  RelatedWebsiteSet : public ::crdtp::ProtocolObject<RelatedWebsiteSet> {
public:
    ~RelatedWebsiteSet() override { }

    protocol::Array<String>* GetPrimarySites() { return m_primarySites.get(); }
    void SetPrimarySites(std::unique_ptr<protocol::Array<String>> value) { m_primarySites = std::move(value); }

    protocol::Array<String>* GetAssociatedSites() { return m_associatedSites.get(); }
    void SetAssociatedSites(std::unique_ptr<protocol::Array<String>> value) { m_associatedSites = std::move(value); }

    protocol::Array<String>* GetServiceSites() { return m_serviceSites.get(); }
    void SetServiceSites(std::unique_ptr<protocol::Array<String>> value) { m_serviceSites = std::move(value); }

    template<int STATE>
    class RelatedWebsiteSetBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PrimarySitesSet = 1 << 1,
            AssociatedSitesSet = 1 << 2,
            ServiceSitesSet = 1 << 3,
            AllFieldsSet = (PrimarySitesSet | AssociatedSitesSet | ServiceSitesSet | 0)};


        RelatedWebsiteSetBuilder<STATE | PrimarySitesSet>& SetPrimarySites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & PrimarySitesSet), "property primarySites should not be set yet");
            m_result->SetPrimarySites(std::move(value));
            return castState<PrimarySitesSet>();
        }

        RelatedWebsiteSetBuilder<STATE | AssociatedSitesSet>& SetAssociatedSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & AssociatedSitesSet), "property associatedSites should not be set yet");
            m_result->SetAssociatedSites(std::move(value));
            return castState<AssociatedSitesSet>();
        }

        RelatedWebsiteSetBuilder<STATE | ServiceSitesSet>& SetServiceSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & ServiceSitesSet), "property serviceSites should not be set yet");
            m_result->SetServiceSites(std::move(value));
            return castState<ServiceSitesSet>();
        }

        std::unique_ptr<RelatedWebsiteSet> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RelatedWebsiteSet;
        RelatedWebsiteSetBuilder() : m_result(new RelatedWebsiteSet()) { }

        template<int STEP> RelatedWebsiteSetBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RelatedWebsiteSetBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::RelatedWebsiteSet> m_result;
    };

    static RelatedWebsiteSetBuilder<0> Create()
    {
        return RelatedWebsiteSetBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RelatedWebsiteSet()
    {
    }

    std::unique_ptr<protocol::Array<String>> m_primarySites;
    std::unique_ptr<protocol::Array<String>> m_associatedSites;
    std::unique_ptr<protocol::Array<String>> m_serviceSites;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    class  RunBounceTrackingMitigationsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<String>> deletedSites) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RunBounceTrackingMitigationsCallback() { }
    };
    virtual void RunBounceTrackingMitigations(std::unique_ptr<RunBounceTrackingMitigationsCallback> callback) = 0;
    class  GetRelatedWebsiteSetsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Storage::RelatedWebsiteSet>> sets) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetRelatedWebsiteSetsCallback() { }
    };
    virtual void GetRelatedWebsiteSets(std::unique_ptr<GetRelatedWebsiteSetsCallback> callback) = 0;
    virtual DispatchResponse GetAffectedUrlsForThirdPartyCookieMetadata(const String& in_firstPartyUrl, std::unique_ptr<protocol::Array<String>> in_thirdPartyUrls, std::unique_ptr<protocol::Array<String>>* out_matchedUrls) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void CacheStorageContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& cacheName);
    void CacheStorageListUpdated(const String& origin, const String& storageKey, const String& bucketId);
    void IndexedDBContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& databaseName, const String& objectStoreName);
    void IndexedDBListUpdated(const String& origin, const String& storageKey, const String& bucketId);
    void InterestGroupAccessed(double accessTime, const String& type, const String& ownerOrigin, const String& name, std::optional<String> componentSellerOrigin = {}, std::optional<double> bid = {}, std::optional<String> bidCurrency = {}, std::optional<String> uniqueAuctionId = {});
    void InterestGroupAuctionEventOccurred(double eventTime, const String& type, const String& uniqueAuctionId, std::optional<String> parentAuctionId = {}, std::unique_ptr<protocol::DictionaryValue> auctionConfig = {});
    void InterestGroupAuctionNetworkRequestCreated(const String& type, const String& requestId, std::unique_ptr<protocol::Array<String>> auctions);
    void SharedStorageAccessed(double accessTime, const String& scope, const String& method, const String& mainFrameId, const String& ownerOrigin, const String& ownerSite, std::unique_ptr<protocol::Storage::SharedStorageAccessParams> params);
    void SharedStorageWorkletOperationExecutionFinished(double finishedTime, int executionTime, const String& method, const String& operationId, const String& workletTargetId, const String& mainFrameId, const String& ownerOrigin);
    void StorageBucketCreatedOrUpdated(std::unique_ptr<protocol::Storage::StorageBucketInfo> bucketInfo);
    void StorageBucketDeleted(const String& bucketId);
    void AttributionReportingSourceRegistered(std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> registration, const String& result);
    void AttributionReportingTriggerRegistered(std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> registration, const String& eventLevel, const String& aggregatable);
    void AttributionReportingReportSent(const String& url, std::unique_ptr<protocol::DictionaryValue> body, const String& result, std::optional<int> netError = {}, std::optional<String> netErrorName = {}, std::optional<int> httpStatusCode = {});
    void AttributionReportingVerboseDebugReportSent(const String& url, std::unique_ptr<protocol::Array<protocol::DictionaryValue>> body = {}, std::optional<int> netError = {}, std::optional<String> netErrorName = {}, std::optional<int> httpStatusCode = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Storage
} // namespace protocol

#endif // !defined(protocol_Storage_h)
