// This file is generated by Forward_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Forward_h
#define protocol_Forward_h


#include <memory>
#include <vector>

#include "third_party/inspector_protocol/crdtp/error_support.h"
#include "third_party/inspector_protocol/crdtp/dispatch.h"
#include "third_party/inspector_protocol/crdtp/frontend_channel.h"
#include "third_party/inspector_protocol/crdtp/protocol_core.h"

#include "third_party/inspector_protocol/crdtp/chromium/protocol_traits.h"

namespace protocol {

using DispatchResponse = crdtp::DispatchResponse;
using ErrorSupport = crdtp::ErrorSupport;
using Serializable = crdtp::Serializable;
using FrontendChannel = crdtp::FrontendChannel;
using DomainDispatcher = crdtp::DomainDispatcher;
using UberDispatcher = crdtp::UberDispatcher;
using Response = DispatchResponse;

using DictionaryValue = crdtp::traits::DictionaryValue;
using Object = crdtp::traits::DictionaryValue;
using ListValue = crdtp::traits::ListValue;
using Value = crdtp::traits::Value;
using String = crdtp::traits::String;
using Binary = crdtp::Binary;

namespace detail {

template <typename T>
struct ArrayTypedef { typedef std::vector<std::unique_ptr<T>> type; };

template <>
struct ArrayTypedef<String> { typedef std::vector<String> type; };

template <>
struct ArrayTypedef<int> { typedef std::vector<int> type; };

template <>
struct ArrayTypedef<double> { typedef std::vector<double> type; };

template <>
struct ArrayTypedef<bool> { typedef std::vector<bool> type; };

template <>
struct ArrayTypedef<Binary> { typedef std::vector<Binary> type; };

}  // namespace detail

template <typename T>
using Array = typename detail::ArrayTypedef<T>::type;

} // namespace protocol

#endif // !defined(protocol_Forward_h)
