// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Extensions_h
#define protocol_Extensions_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace protocol {
namespace Extensions {
using StorageArea = String;

// ------------- Forward and enum declarations.

namespace StorageAreaEnum {
 extern const char Session[];
 extern const char Local[];
 extern const char Sync[];
 extern const char Managed[];
} // namespace StorageAreaEnum

// ------------- Type and builder declarations.

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    class  LoadUnpackedCallback {
    public:
        virtual void sendSuccess(const String& id) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~LoadUnpackedCallback() { }
    };
    virtual void LoadUnpacked(const String& in_path, std::unique_ptr<LoadUnpackedCallback> callback) = 0;
    class  UninstallCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~UninstallCallback() { }
    };
    virtual void Uninstall(const String& in_id, std::unique_ptr<UninstallCallback> callback) = 0;
    class  GetStorageItemsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::DictionaryValue> data) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetStorageItemsCallback() { }
    };
    virtual void GetStorageItems(const String& in_id, const String& in_storageArea, std::unique_ptr<protocol::Array<String>> in_keys, std::unique_ptr<GetStorageItemsCallback> callback) = 0;
    class  RemoveStorageItemsCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RemoveStorageItemsCallback() { }
    };
    virtual void RemoveStorageItems(const String& in_id, const String& in_storageArea, std::unique_ptr<protocol::Array<String>> in_keys, std::unique_ptr<RemoveStorageItemsCallback> callback) = 0;
    class  ClearStorageItemsCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearStorageItemsCallback() { }
    };
    virtual void ClearStorageItems(const String& in_id, const String& in_storageArea, std::unique_ptr<ClearStorageItemsCallback> callback) = 0;
    class  SetStorageItemsCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetStorageItemsCallback() { }
    };
    virtual void SetStorageItems(const String& in_id, const String& in_storageArea, std::unique_ptr<protocol::DictionaryValue> in_values, std::unique_ptr<SetStorageItemsCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Extensions
} // namespace protocol

#endif // !defined(protocol_Extensions_h)
