// chrome/browser/contextual_tasks/contextual_tasks.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UuidSpec as mojoBase_mojom_UuidSpec,
  Uuid as mojoBase_mojom_Uuid
} from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'contextual_tasks.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getThreadUrl(): Promise<{
        url: url_mojom_Url, }>;
  getUrlForTask(uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url, }>;
  setTaskId(uuid: mojoBase_mojom_Uuid): void;
  setThreadTitle(title: string): void;
  showUi(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getThreadUrl(): Promise<{
        url: url_mojom_Url, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetThreadUrl_ParamsSpec.$,
        PageHandler_GetThreadUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getUrlForTask(
      uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_GetUrlForTask_ParamsSpec.$,
        PageHandler_GetUrlForTask_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  setTaskId(
      uuid: mojoBase_mojom_Uuid): void {
    this.proxy.sendMessage(
        2,
        PageHandler_SetTaskId_ParamsSpec.$,
        null,
        [
          uuid
        ],
        false);
  }

  setThreadTitle(
      title: string): void {
    this.proxy.sendMessage(
        3,
        PageHandler_SetThreadTitle_ParamsSpec.$,
        null,
        [
          title
        ],
        false);
  }

  showUi(): void {
    this.proxy.sendMessage(
        4,
        PageHandler_ShowUi_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetThreadUrl_ParamsSpec.$,
        PageHandler_GetThreadUrl_ResponseParamsSpec.$,
        impl.getThreadUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetUrlForTask_ParamsSpec.$,
        PageHandler_GetUrlForTask_ResponseParamsSpec.$,
        impl.getUrlForTask.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_SetTaskId_ParamsSpec.$,
        null,
        impl.setTaskId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_SetThreadTitle_ParamsSpec.$,
        null,
        impl.setThreadTitle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_ShowUi_ParamsSpec.$,
        null,
        impl.showUi.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "contextual_tasks.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getThreadUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getUrlForTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTaskId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setThreadTitle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getThreadUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetThreadUrl_ParamsSpec.$,
        PageHandler_GetThreadUrl_ResponseParamsSpec.$,
        this.getThreadUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getUrlForTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetUrlForTask_ParamsSpec.$,
        PageHandler_GetUrlForTask_ResponseParamsSpec.$,
        this.getUrlForTask.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setTaskId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_SetTaskId_ParamsSpec.$,
        null,
        this.setTaskId.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setThreadTitle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_SetThreadTitle_ParamsSpec.$,
        null,
        this.setThreadTitle.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showUi =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_ShowUi_ParamsSpec.$,
        null,
        this.showUi.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'contextual_tasks.mojom.Page',
        scope);
  }
}

export interface PageInterface {
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(_impl: PageInterface) {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "contextual_tasks.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'contextual_tasks.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, pageHandler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      pageHandler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          pageHandler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "contextual_tasks.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageHandler_GetThreadUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetThreadUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetUrlForTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetUrlForTask_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetTaskId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetThreadTitle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowUi_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageHandler_GetThreadUrl_ParamsMojoType {
}


export type PageHandler_GetThreadUrl_Params = PageHandler_GetThreadUrl_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetThreadUrl_ParamsMojoType>(
    PageHandler_GetThreadUrl_ParamsSpec.$,
    'PageHandler_GetThreadUrl_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetThreadUrl_ResponseParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_GetThreadUrl_ResponseParams = PageHandler_GetThreadUrl_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetThreadUrl_ResponseParamsMojoType>(
    PageHandler_GetThreadUrl_ResponseParamsSpec.$,
    'PageHandler_GetThreadUrl_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetThreadUrl_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetUrlForTask_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type PageHandler_GetUrlForTask_Params = PageHandler_GetUrlForTask_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetUrlForTask_ParamsMojoType>(
    PageHandler_GetUrlForTask_ParamsSpec.$,
    'PageHandler_GetUrlForTask_Params',
    [
      mojo.internal.StructField<PageHandler_GetUrlForTask_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetUrlForTask_ResponseParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_GetUrlForTask_ResponseParams = PageHandler_GetUrlForTask_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetUrlForTask_ResponseParamsMojoType>(
    PageHandler_GetUrlForTask_ResponseParamsSpec.$,
    'PageHandler_GetUrlForTask_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetUrlForTask_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetTaskId_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type PageHandler_SetTaskId_Params = PageHandler_SetTaskId_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetTaskId_ParamsMojoType>(
    PageHandler_SetTaskId_ParamsSpec.$,
    'PageHandler_SetTaskId_Params',
    [
      mojo.internal.StructField<PageHandler_SetTaskId_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetThreadTitle_ParamsMojoType {
  title: string;
}


export type PageHandler_SetThreadTitle_Params = PageHandler_SetThreadTitle_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetThreadTitle_ParamsMojoType>(
    PageHandler_SetThreadTitle_ParamsSpec.$,
    'PageHandler_SetThreadTitle_Params',
    [
      mojo.internal.StructField<PageHandler_SetThreadTitle_ParamsMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowUi_ParamsMojoType {
}


export type PageHandler_ShowUi_Params = PageHandler_ShowUi_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowUi_ParamsMojoType>(
    PageHandler_ShowUi_ParamsSpec.$,
    'PageHandler_ShowUi_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  pageHandler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'pageHandler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



