// chrome/browser/actor/ui/actor_overlay.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_H_
#define CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/actor/ui/actor_overlay.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/actor/ui/actor_overlay.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/actor/ui/actor_overlay.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace actor::ui::mojom {

class ActorOverlayPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class ActorOverlayPageHandlerFactoryStub;

class ActorOverlayPageHandlerFactoryRequestValidator;


class ActorOverlayPageHandlerFactory
    : public ActorOverlayPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.ui.mojom.ActorOverlayPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActorOverlayPageHandlerFactoryInterfaceBase;
  using Proxy_ = ActorOverlayPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActorOverlayPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ActorOverlayPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActorOverlayPageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<ActorOverlayPage> page, ::mojo::PendingReceiver<ActorOverlayPageHandler> receiver) = 0;
};

class ActorOverlayPageHandlerProxy;

template <typename ImplRefTraits>
class ActorOverlayPageHandlerStub;

class ActorOverlayPageHandlerRequestValidator;


class ActorOverlayPageHandler
    : public ActorOverlayPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.ui.mojom.ActorOverlayPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActorOverlayPageHandlerInterfaceBase;
  using Proxy_ = ActorOverlayPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActorOverlayPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ActorOverlayPageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnHoverStatusChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnHoverStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActorOverlayPageHandler() = default;

  virtual void OnHoverStatusChanged(bool is_hovering) = 0;
};

class ActorOverlayPageProxy;

template <typename ImplRefTraits>
class ActorOverlayPageStub;

class ActorOverlayPageRequestValidator;


class ActorOverlayPage
    : public ActorOverlayPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.ui.mojom.ActorOverlayPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActorOverlayPageInterfaceBase;
  using Proxy_ = ActorOverlayPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActorOverlayPageStub<ImplRefTraits>;

  using RequestValidator_ = ActorOverlayPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetScrimBackgroundMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetScrimBackground_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActorOverlayPage() = default;

  virtual void SetScrimBackground(bool is_visible) = 0;
};



class  ActorOverlayPageHandlerFactoryProxy
    : public ActorOverlayPageHandlerFactory {
 public:
  using InterfaceType = ActorOverlayPageHandlerFactory;

  explicit ActorOverlayPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<ActorOverlayPage> page, ::mojo::PendingReceiver<ActorOverlayPageHandler> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ActorOverlayPageHandlerProxy
    : public ActorOverlayPageHandler {
 public:
  using InterfaceType = ActorOverlayPageHandler;

  explicit ActorOverlayPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnHoverStatusChanged(bool is_hovering) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ActorOverlayPageProxy
    : public ActorOverlayPage {
 public:
  using InterfaceType = ActorOverlayPage;

  explicit ActorOverlayPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetScrimBackground(bool is_visible) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ActorOverlayPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(ActorOverlayPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActorOverlayPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActorOverlayPageHandlerFactory>>
class ActorOverlayPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActorOverlayPageHandlerFactoryStub() = default;
  ~ActorOverlayPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActorOverlayPageHandlerStubDispatch {
 public:
  static bool Accept(ActorOverlayPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActorOverlayPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActorOverlayPageHandler>>
class ActorOverlayPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActorOverlayPageHandlerStub() = default;
  ~ActorOverlayPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActorOverlayPageStubDispatch {
 public:
  static bool Accept(ActorOverlayPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActorOverlayPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActorOverlayPage>>
class ActorOverlayPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActorOverlayPageStub() = default;
  ~ActorOverlayPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActorOverlayPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ActorOverlayPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ActorOverlayPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // actor::ui::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_H_