from jinja2.runtime import LoopContext, Macro, Markup, Namespace, TemplateNotFound, TemplateReference, TemplateRuntimeError, Undefined, escape, identity, internalcode, markup_join, missing, str_join
name = 'mojolpm.cc.tmpl'

def root(context, missing=missing):
    resolve = context.resolve_or_missing
    undefined = environment.undefined
    concat = environment.concat
    cond_expr_undefined = Undefined
    if 0: yield None
    l_0_module = resolve('module')
    l_0_all_extra_traits_headers = resolve('all_extra_traits_headers')
    l_0_structs = resolve('structs')
    l_0_unions = resolve('unions')
    l_0_all_enums = resolve('all_enums')
    l_0_interfaces = resolve('interfaces')
    l_0_util = l_0_from_proto = l_0_to_proto = l_0_traits_specialization = missing
    try:
        t_1 = environment.filters['camel_to_under']
    except KeyError:
        @internalcode
        def t_1(*unused):
            raise TemplateRuntimeError("No filter named 'camel_to_under' found.")
    try:
        t_2 = environment.filters['cpp_wrapper_param_type']
    except KeyError:
        @internalcode
        def t_2(*unused):
            raise TemplateRuntimeError("No filter named 'cpp_wrapper_param_type' found.")
    try:
        t_3 = environment.filters['cpp_wrapper_type']
    except KeyError:
        @internalcode
        def t_3(*unused):
            raise TemplateRuntimeError("No filter named 'cpp_wrapper_type' found.")
    try:
        t_4 = environment.filters['default_constructor_args']
    except KeyError:
        @internalcode
        def t_4(*unused):
            raise TemplateRuntimeError("No filter named 'default_constructor_args' found.")
    try:
        t_5 = environment.filters['get_qualified_name_for_kind']
    except KeyError:
        @internalcode
        def t_5(*unused):
            raise TemplateRuntimeError("No filter named 'get_qualified_name_for_kind' found.")
    try:
        t_6 = environment.filters['indent']
    except KeyError:
        @internalcode
        def t_6(*unused):
            raise TemplateRuntimeError("No filter named 'indent' found.")
    try:
        t_7 = environment.filters['is_array_kind']
    except KeyError:
        @internalcode
        def t_7(*unused):
            raise TemplateRuntimeError("No filter named 'is_array_kind' found.")
    try:
        t_8 = environment.filters['is_associated_kind']
    except KeyError:
        @internalcode
        def t_8(*unused):
            raise TemplateRuntimeError("No filter named 'is_associated_kind' found.")
    try:
        t_9 = environment.filters['is_interface_kind']
    except KeyError:
        @internalcode
        def t_9(*unused):
            raise TemplateRuntimeError("No filter named 'is_interface_kind' found.")
    try:
        t_10 = environment.filters['is_map_kind']
    except KeyError:
        @internalcode
        def t_10(*unused):
            raise TemplateRuntimeError("No filter named 'is_map_kind' found.")
    try:
        t_11 = environment.filters['is_non_const_ref_kind']
    except KeyError:
        @internalcode
        def t_11(*unused):
            raise TemplateRuntimeError("No filter named 'is_non_const_ref_kind' found.")
    try:
        t_12 = environment.filters['is_nullable_kind']
    except KeyError:
        @internalcode
        def t_12(*unused):
            raise TemplateRuntimeError("No filter named 'is_nullable_kind' found.")
    try:
        t_13 = environment.filters['to_unnullable_kind']
    except KeyError:
        @internalcode
        def t_13(*unused):
            raise TemplateRuntimeError("No filter named 'to_unnullable_kind' found.")
    try:
        t_14 = environment.filters['under_to_camel']
    except KeyError:
        @internalcode
        def t_14(*unused):
            raise TemplateRuntimeError("No filter named 'under_to_camel' found.")
    pass
    yield '// Copyright 2019 The Chromium Authors\n// Use of this source code is governed by a BSD-style license that can be\n// found in the LICENSE file.\n\n#include "'
    yield str(environment.getattr((undefined(name='module') if l_0_module is missing else l_0_module), 'path'))
    yield '-mojolpm.h"\n\n#include <functional>\n\n#include "base/functional/bind.h"\n#include "ipc/ipc_message_utils.h"\n#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"\n\n'
    for l_1_extra_traits_header in (undefined(name='all_extra_traits_headers') if l_0_all_extra_traits_headers is missing else l_0_all_extra_traits_headers):
        _loop_vars = {}
        pass
        yield '\n#include "'
        yield str(l_1_extra_traits_header)
        yield '"'
    l_1_extra_traits_header = missing
    l_0_util = context.vars['util'] = environment.get_template('mojolpm_macros.tmpl', 'mojolpm.cc.tmpl')._get_default_module(context)
    context.exported_vars.discard('util')
    l_0_from_proto = context.vars['from_proto'] = environment.get_template('mojolpm_from_proto_macros.tmpl', 'mojolpm.cc.tmpl')._get_default_module(context)
    context.exported_vars.discard('from_proto')
    l_0_to_proto = context.vars['to_proto'] = environment.get_template('mojolpm_to_proto_macros.tmpl', 'mojolpm.cc.tmpl')._get_default_module(context)
    context.exported_vars.discard('to_proto')
    l_0_traits_specialization = context.vars['traits_specialization'] = environment.get_template('mojolpm_traits_specialization_macros.tmpl', 'mojolpm.cc.tmpl')._get_default_module(context)
    context.exported_vars.discard('traits_specialization')
    yield '\n\nnamespace mojo {'
    for l_1_struct in (undefined(name='structs') if l_0_structs is missing else l_0_structs):
        _loop_vars = {}
        pass
        yield str(context.call(environment.getattr((undefined(name='traits_specialization') if l_0_traits_specialization is missing else l_0_traits_specialization), 'define_struct'), l_1_struct, _loop_vars=_loop_vars))
    l_1_struct = missing
    for l_1_union in (undefined(name='unions') if l_0_unions is missing else l_0_unions):
        _loop_vars = {}
        pass
        yield '\n'
        yield str(context.call(environment.getattr((undefined(name='traits_specialization') if l_0_traits_specialization is missing else l_0_traits_specialization), 'define_union'), l_1_union, _loop_vars=_loop_vars))
    l_1_union = missing
    yield '\n} // namespace mojo\n\nnamespace mojolpm {'
    for l_1_enum in (undefined(name='all_enums') if l_0_all_enums is missing else l_0_all_enums):
        _loop_vars = {}
        pass
        yield str(context.call(environment.getattr((undefined(name='from_proto') if l_0_from_proto is missing else l_0_from_proto), 'define_enum'), l_1_enum, _loop_vars=_loop_vars))
        yield str(context.call(environment.getattr((undefined(name='to_proto') if l_0_to_proto is missing else l_0_to_proto), 'define_enum'), l_1_enum, _loop_vars=_loop_vars))
    l_1_enum = missing
    for l_1_struct in (undefined(name='structs') if l_0_structs is missing else l_0_structs):
        l_1_proto_type = l_1_struct_type = missing
        _loop_vars = {}
        pass
        l_1_proto_type = str_join(('::mojolpm', t_5(l_1_struct, flatten_nested_kind=True), ))
        _loop_vars['proto_type'] = l_1_proto_type
        l_1_struct_type = str_join(((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type), '_ProtoStruct', ))
        _loop_vars['struct_type'] = l_1_struct_type
        for l_2_field in environment.getattr(l_1_struct, 'fields'):
            l_2_name = l_2_kind = missing
            _loop_vars = {}
            pass
            l_2_name = t_1(environment.getattr(l_2_field, 'name'))
            _loop_vars['name'] = l_2_name
            l_2_kind = environment.getattr(l_2_field, 'kind')
            _loop_vars['kind'] = l_2_kind
            if (t_7((undefined(name='kind') if l_2_kind is missing else l_2_kind)) or t_10((undefined(name='kind') if l_2_kind is missing else l_2_kind))):
                pass
                yield str(context.call(environment.getattr((undefined(name='from_proto') if l_0_from_proto is missing else l_0_from_proto), 'define'), (undefined(name='struct_type') if l_1_struct_type is missing else l_1_struct_type), (undefined(name='kind') if l_2_kind is missing else l_2_kind), (undefined(name='name') if l_2_name is missing else l_2_name), _loop_vars=_loop_vars))
                yield str(context.call(environment.getattr((undefined(name='to_proto') if l_0_to_proto is missing else l_0_to_proto), 'define'), (undefined(name='struct_type') if l_1_struct_type is missing else l_1_struct_type), (undefined(name='kind') if l_2_kind is missing else l_2_kind), (undefined(name='name') if l_2_name is missing else l_2_name), _loop_vars=_loop_vars))
        l_2_field = l_2_name = l_2_kind = missing
        yield str(context.call(environment.getattr((undefined(name='from_proto') if l_0_from_proto is missing else l_0_from_proto), 'define_struct'), l_1_struct, _loop_vars=_loop_vars))
        yield str(context.call(environment.getattr((undefined(name='to_proto') if l_0_to_proto is missing else l_0_to_proto), 'define_struct'), l_1_struct, _loop_vars=_loop_vars))
    l_1_struct = l_1_proto_type = l_1_struct_type = missing
    for l_1_union in (undefined(name='unions') if l_0_unions is missing else l_0_unions):
        l_1_proto_type = l_1_union_type = missing
        _loop_vars = {}
        pass
        l_1_proto_type = str_join(('::mojolpm', t_5(l_1_union, flatten_nested_kind=True), ))
        _loop_vars['proto_type'] = l_1_proto_type
        l_1_union_type = str_join(((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type), '_ProtoUnion', ))
        _loop_vars['union_type'] = l_1_union_type
        for l_2_field in environment.getattr(l_1_union, 'fields'):
            l_2_name = l_2_kind = missing
            _loop_vars = {}
            pass
            l_2_name = t_1(environment.getattr(l_2_field, 'name'))
            _loop_vars['name'] = l_2_name
            l_2_kind = environment.getattr(l_2_field, 'kind')
            _loop_vars['kind'] = l_2_kind
            if (t_7((undefined(name='kind') if l_2_kind is missing else l_2_kind)) or t_10((undefined(name='kind') if l_2_kind is missing else l_2_kind))):
                pass
                yield str(context.call(environment.getattr((undefined(name='from_proto') if l_0_from_proto is missing else l_0_from_proto), 'define'), (undefined(name='union_type') if l_1_union_type is missing else l_1_union_type), (undefined(name='kind') if l_2_kind is missing else l_2_kind), (undefined(name='name') if l_2_name is missing else l_2_name), _loop_vars=_loop_vars))
                yield str(context.call(environment.getattr((undefined(name='to_proto') if l_0_to_proto is missing else l_0_to_proto), 'define'), (undefined(name='union_type') if l_1_union_type is missing else l_1_union_type), (undefined(name='kind') if l_2_kind is missing else l_2_kind), (undefined(name='name') if l_2_name is missing else l_2_name), _loop_vars=_loop_vars))
        l_2_field = l_2_name = l_2_kind = missing
        yield str(context.call(environment.getattr((undefined(name='from_proto') if l_0_from_proto is missing else l_0_from_proto), 'define_union'), l_1_union, _loop_vars=_loop_vars))
        yield str(context.call(environment.getattr((undefined(name='to_proto') if l_0_to_proto is missing else l_0_to_proto), 'define_union'), l_1_union, _loop_vars=_loop_vars))
    l_1_union = l_1_proto_type = l_1_union_type = missing
    l_1_loop = missing
    for l_1_interface, l_1_loop in LoopContext((undefined(name='interfaces') if l_0_interfaces is missing else l_0_interfaces), undefined):
        l_1_mojom_type = l_1_proto_type = missing
        _loop_vars = {}
        pass
        l_1_mojom_type = t_5(l_1_interface, flatten_nested_kind=True)
        _loop_vars['mojom_type'] = l_1_mojom_type
        l_1_proto_type = str_join(('::mojolpm', t_5(l_1_interface, flatten_nested_kind=True), ))
        _loop_vars['proto_type'] = l_1_proto_type
        yield '\nclass '
        yield str(environment.getattr(l_1_interface, 'name'))
        yield 'Impl : public '
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield ' {\n public:\n  '
        yield str(environment.getattr(l_1_interface, 'name'))
        yield 'Impl() {\n  }'
        l_2_loop = missing
        for l_2_method, l_2_loop in LoopContext(environment.getattr(l_1_interface, 'methods'), undefined):
            _loop_vars = {}
            pass
            yield '\n\n  void '
            yield str(environment.getattr(l_2_method, 'name'))
            yield '(\n'
            l_3_loop = missing
            for l_3_param, l_3_loop in LoopContext(environment.getattr(l_2_method, 'parameters'), undefined):
                l_3_name = l_3_kind = l_3_param_mojom_type = missing
                _loop_vars = {}
                pass
                l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                _loop_vars['name'] = l_3_name
                l_3_kind = environment.getattr(l_3_param, 'kind')
                _loop_vars['kind'] = l_3_kind
                l_3_param_mojom_type = t_2((undefined(name='kind') if l_3_kind is missing else l_3_kind), add_same_module_namespaces=True)
                _loop_vars['param_mojom_type'] = l_3_param_mojom_type
                yield str((',\n' if (not environment.getattr(l_3_loop, 'first')) else cond_expr_undefined("the inline if-expression on line 82 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                yield '      '
                yield str((undefined(name='param_mojom_type') if l_3_param_mojom_type is missing else l_3_param_mojom_type))
                yield ' '
                yield str((undefined(name='name') if l_3_name is missing else l_3_name))
            l_3_loop = l_3_param = l_3_name = l_3_kind = l_3_param_mojom_type = missing
            if (environment.getattr(l_2_method, 'response_parameters') != None):
                pass
                yield str((',\n' if environment.getattr(l_2_method, 'parameters') else cond_expr_undefined("the inline if-expression on line 85 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                yield '    '
                yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
                yield '::'
                yield str(environment.getattr(l_2_method, 'name'))
                yield 'Callback callback'
            yield ') override {'
            for l_3_param in environment.getattr(l_2_method, 'parameters'):
                l_3_name = l_3_kind = missing
                _loop_vars = {}
                pass
                l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                _loop_vars['name'] = l_3_name
                l_3_kind = environment.getattr(l_3_param, 'kind')
                _loop_vars['kind'] = l_3_kind
                yield str(t_6(context.call(environment.getattr((undefined(name='util') if l_0_util is missing else l_0_util), 'add_instance'), (undefined(name='kind') if l_3_kind is missing else l_3_kind), (undefined(name='name') if l_3_name is missing else l_3_name), False, _loop_vars=_loop_vars), 2, True))
            l_3_param = l_3_name = l_3_kind = missing
            yield '\n    mojolpmdbg("'
            yield str(environment.getattr(l_1_interface, 'name'))
            yield 'Impl.'
            yield str(environment.getattr(l_2_method, 'name'))
            yield '\\n");'
            if (environment.getattr(l_2_method, 'response_parameters') != None):
                pass
                yield '\n    mojolpm::GetContext()->AddInstance<'
                yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
                yield '::'
                yield str(environment.getattr(l_2_method, 'name'))
                yield 'Callback>(std::move(callback));'
            yield '\n  }'
        l_2_loop = l_2_method = missing
        yield '\n};\n\nbool FromProto(uint32_t input,\n               ::mojo::PendingRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>& output) {\n  bool result = false;\n  ::mojo::Remote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>* output_ptr = nullptr;\n\n  if (input) {\n    output_ptr = mojolpm::GetContext()->GetInstance<::mojo::Remote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>>(input);\n    if (output_ptr) {\n      // TODO(markbrand): look for a cleaner way to handle this check.\n      if (!output_ptr->is_bound() || (output_ptr->internal_state()\n          && output_ptr->internal_state()->has_pending_callbacks())) {\n        // not safe to Unbind, so fail instead.\n        output_ptr = nullptr;\n      } else {\n        output = output_ptr->Unbind();\n        result = true;\n      }\n    }\n  } else {\n    auto impl = std::make_unique<'
        yield str(environment.getattr(l_1_interface, 'name'))
        yield 'Impl>();\n    auto receiver_ptr =\n      std::make_unique<::mojo::Receiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>>(\n        impl.get(), output.InitWithNewPipeAndPassReceiver());\n    mojolpm::GetContext()->AddInstance(std::move(impl));\n    mojolpm::GetContext()->AddInstance(std::move(receiver_ptr));\n    result = true;\n  }\n\n  return result;\n}\n\nbool ToProto(::mojo::PendingRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>&& input,\n             uint32_t& output) {\n  ::mojo::Remote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '> remote(std::move(input));\n  int next_id = NextId<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>();\n  output = mojolpm::GetContext()->AddInstance(next_id, std::move(remote));\n  return true;\n}\n\nbool FromProto(uint32_t input,\n               ::mojo::PendingReceiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>& output) {\n  ::mojo::Remote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '> remote = ::mojo::Remote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>();\n  output = remote.BindNewPipeAndPassReceiver();\n  mojolpm::GetContext()->AddInstance(input, std::move(remote));\n  return true;\n}\n\nbool ToProto(::mojo::PendingReceiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>&& input,\n             uint32_t& output) {\n  // This should only get called from callbacks into the fuzzer, ie from one of\n  // the XxxImpls or from a return callback. Since that is the case, we want to\n  // bind the receiver and store it.\n\n  auto impl = std::make_unique<'
        yield str(environment.getattr(l_1_interface, 'name'))
        yield 'Impl>();\n  auto receiver_ptr = std::make_unique<::mojo::Receiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>>(\n    impl.get(), std::move(input));\n  mojolpm::GetContext()->AddInstance(std::move(impl));\n  output = mojolpm::GetContext()->AddInstance(std::move(receiver_ptr));\n  return true;\n}\n\nbool FromProto(uint32_t input,\n               ::mojo::PendingAssociatedRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>& output) {\n  mojolpmdbg("PendingAssociatedRemote '
        yield str(environment.getattr(l_1_interface, 'name'))
        yield '\\n");\n  bool result = false;\n  ::mojo::AssociatedRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>* output_ptr;\n\n  if (input) {\n    output_ptr = mojolpm::GetContext()->GetInstance<::mojo::AssociatedRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>>(input);\n    if (output_ptr) {\n      // TODO(markbrand): look for a cleaner way to handle this check.\n      if (!output_ptr->is_bound() || (output_ptr->internal_state()\n          && output_ptr->internal_state()->has_pending_callbacks())) {\n        // not safe to Unbind, so fail instead.\n        output_ptr = nullptr;\n      } else {\n        output = output_ptr->Unbind();\n        result = true;\n      }\n    }\n  } else {\n    auto impl = std::make_unique<'
        yield str(environment.getattr(l_1_interface, 'name'))
        yield 'Impl>();\n    auto receiver_ptr =\n      std::make_unique<::mojo::AssociatedReceiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>>(\n        impl.get(), output.InitWithNewEndpointAndPassReceiver());\n    mojolpm::GetContext()->AddInstance(std::move(impl));\n    mojolpm::GetContext()->AddInstance(std::move(receiver_ptr));\n    result = true;\n  }\n\n  return result;\n}\n\nbool ToProto(::mojo::PendingAssociatedRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>&& input,\n             uint32_t& output) {\n  ::mojo::AssociatedRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '> remote(std::move(input));\n  int next_id = NextId<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>();\n  output = mojolpm::GetContext()->AddInstance(next_id, std::move(remote));\n  return true;\n}\n\nbool FromProto(uint32_t input,\n               ::mojo::PendingAssociatedReceiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>& output) {\n  ::mojo::AssociatedRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '> remote = ::mojo::AssociatedRemote<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>();\n  output = remote.BindNewEndpointAndPassReceiver();\n  mojolpm::GetContext()->AddInstance(input, std::move(remote));\n  return true;\n}\n\nbool ToProto(::mojo::PendingAssociatedReceiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>&& input,\n             uint32_t& output) {\n  // This should only get called from callbacks into the fuzzer, ie from one of\n  // the XxxImpls or from a return callback. Since that is the case, we want to\n  // bind the receiver and store it.\n\n  auto impl = std::make_unique<'
        yield str(environment.getattr(l_1_interface, 'name'))
        yield 'Impl>();\n  auto receiver_ptr = std::make_unique<::mojo::AssociatedReceiver<'
        yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
        yield '>>(\n    impl.get(), std::move(input));\n  mojolpm::GetContext()->AddInstance(std::move(impl));\n  output = mojolpm::GetContext()->AddInstance(std::move(receiver_ptr));\n  return true;\n}\n'
        for l_2_method in environment.getattr(l_1_interface, 'methods'):
            l_2_method_type = missing
            _loop_vars = {}
            pass
            l_2_method_type = str_join(((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type), '::', environment.getattr(l_1_interface, 'name'), '_', environment.getattr(l_2_method, 'name'), ))
            _loop_vars['method_type'] = l_2_method_type
            for l_3_param in environment.getattr(l_2_method, 'parameters'):
                l_3_name = l_3_kind = missing
                _loop_vars = {}
                pass
                l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                _loop_vars['name'] = l_3_name
                l_3_kind = environment.getattr(l_3_param, 'kind')
                _loop_vars['kind'] = l_3_kind
                if (t_7((undefined(name='kind') if l_3_kind is missing else l_3_kind)) or t_10((undefined(name='kind') if l_3_kind is missing else l_3_kind))):
                    pass
                    yield str(context.call(environment.getattr((undefined(name='from_proto') if l_0_from_proto is missing else l_0_from_proto), 'define'), (undefined(name='method_type') if l_2_method_type is missing else l_2_method_type), (undefined(name='kind') if l_3_kind is missing else l_3_kind), (undefined(name='name') if l_3_name is missing else l_3_name), _loop_vars=_loop_vars))
                    yield '\n'
                    yield str(context.call(environment.getattr((undefined(name='to_proto') if l_0_to_proto is missing else l_0_to_proto), 'define'), (undefined(name='method_type') if l_2_method_type is missing else l_2_method_type), (undefined(name='kind') if l_3_kind is missing else l_3_kind), (undefined(name='name') if l_3_name is missing else l_3_name), _loop_vars=_loop_vars))
            l_3_param = l_3_name = l_3_kind = missing
        l_2_method = l_2_method_type = missing
        for l_2_method in environment.getattr(l_1_interface, 'methods'):
            l_2_method_type = resolve('method_type')
            _loop_vars = {}
            pass
            if (environment.getattr(l_2_method, 'response_parameters') != None):
                pass
                l_2_method_type = str_join(((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type), '::', environment.getattr(l_1_interface, 'name'), '_', environment.getattr(l_2_method, 'name'), 'Response', ))
                _loop_vars['method_type'] = l_2_method_type
                for l_3_param in environment.getattr(l_2_method, 'response_parameters'):
                    l_3_name = l_3_kind = missing
                    _loop_vars = {}
                    pass
                    l_3_name = environment.getattr(l_3_param, 'name')
                    _loop_vars['name'] = l_3_name
                    l_3_kind = environment.getattr(l_3_param, 'kind')
                    _loop_vars['kind'] = l_3_kind
                    if (t_7((undefined(name='kind') if l_3_kind is missing else l_3_kind)) or t_10((undefined(name='kind') if l_3_kind is missing else l_3_kind))):
                        pass
                        yield str(context.call(environment.getattr((undefined(name='from_proto') if l_0_from_proto is missing else l_0_from_proto), 'define'), (undefined(name='method_type') if l_2_method_type is missing else l_2_method_type), (undefined(name='kind') if l_3_kind is missing else l_3_kind), (undefined(name='name') if l_3_name is missing else l_3_name), _loop_vars=_loop_vars))
                        yield str(context.call(environment.getattr((undefined(name='to_proto') if l_0_to_proto is missing else l_0_to_proto), 'define'), (undefined(name='method_type') if l_2_method_type is missing else l_2_method_type), (undefined(name='kind') if l_3_kind is missing else l_3_kind), (undefined(name='name') if l_3_name is missing else l_3_name), _loop_vars=_loop_vars))
                l_3_param = l_3_name = l_3_kind = missing
        l_2_method = l_2_method_type = missing
    l_1_loop = l_1_interface = l_1_mojom_type = l_1_proto_type = missing
    l_1_loop = missing
    for l_1_interface, l_1_loop in LoopContext((undefined(name='interfaces') if l_0_interfaces is missing else l_0_interfaces), undefined):
        l_1_mojom_type = l_1_proto_type = missing
        _loop_vars = {}
        pass
        l_1_mojom_type = t_5(l_1_interface, flatten_nested_kind=True)
        _loop_vars['mojom_type'] = l_1_mojom_type
        l_1_proto_type = str_join(('::mojolpm', t_5(l_1_interface, flatten_nested_kind=True), ))
        _loop_vars['proto_type'] = l_1_proto_type
        if environment.getattr(l_1_interface, 'methods'):
            pass
            yield '\nbool HandleRemoteAction(const '
            yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
            yield '::RemoteAction& input) {\n  bool result = true;\n\n  switch (input.method_case()) {'
            for l_2_method in environment.getattr(l_1_interface, 'methods'):
                _loop_vars = {}
                pass
                yield '\n    case '
                yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
                yield '::RemoteAction::k'
                yield str(t_14(str_join(('m_', environment.getattr(l_2_method, 'name'), ))))
                yield ': {\n      result = HandleRemoteCall(input.id(), input.'
                yield str(t_1(str_join(('m', environment.getattr(l_2_method, 'name'), ))))
                yield '());\n    } break;'
            l_2_method = missing
            yield '\n    case '
            yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
            yield '::RemoteAction::kReset: {\n      mojolpm::GetContext()->GetAndRemoveInstance<::mojo::Remote<'
            yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
            yield '>>(input.id());\n    } break;\n\n    default: {\n      result = false;\n    }\n  }\n\n  return result;\n}\n\nbool HandleAssociatedRemoteAction(const '
            yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
            yield '::AssociatedRemoteAction& input) {\n  bool result = true;\n\n  switch (input.method_case()) {'
            for l_2_method in environment.getattr(l_1_interface, 'methods'):
                _loop_vars = {}
                pass
                yield '\n    case '
                yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
                yield '::AssociatedRemoteAction::k'
                yield str(t_14(str_join(('m_', environment.getattr(l_2_method, 'name'), ))))
                yield ': {\n      result = HandleAssociatedRemoteCall(input.id(), input.'
                yield str(t_1(str_join(('m', environment.getattr(l_2_method, 'name'), ))))
                yield '());\n    } break;'
            l_2_method = missing
            yield '\n    case '
            yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
            yield '::AssociatedRemoteAction::kReset: {\n      mojolpm::GetContext()->GetAndRemoveInstance<::mojo::AssociatedRemote<'
            yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
            yield '>>(input.id());\n    } break;\n\n    default: {\n      result = false;\n    }\n  }\n\n  return result;\n}\n\nbool HandleReceiverAction(\n    const '
            yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
            yield '::ReceiverAction& input) {\n  bool result = true;\n  switch (input.response_case()) {'
            for l_2_method in environment.getattr(l_1_interface, 'methods'):
                _loop_vars = {}
                pass
                yield '\n    case '
                yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
                yield '::ReceiverAction::k'
                yield str(t_14(str_join(('m_', environment.getattr(l_2_method, 'name'), '_response', ))))
                yield ': {\n      result = HandleResponse(input.id(), input.'
                yield str(t_1(str_join(('m', environment.getattr(l_2_method, 'name'), '_response', ))))
                yield '());\n    } break;'
            l_2_method = missing
            yield '\n\n    default: {\n      result = false;\n    }\n  }\n\n  return result;\n}\n'
            l_2_loop = missing
            for l_2_method, l_2_loop in LoopContext(environment.getattr(l_1_interface, 'methods'), undefined):
                l_2_result_param = resolve('result_param')
                l_2_param_type = resolve('param_type')
                l_2_response_type = resolve('response_type')
                l_2_container = resolve('container')
                _loop_vars = {}
                pass
                if (environment.getattr(l_2_method, 'result_response') != None):
                    pass
                    l_2_result_param = environment.getitem(environment.getattr(l_2_method, 'response_parameters'), 0)
                    _loop_vars['result_param'] = l_2_result_param
                    l_2_param_type = t_2(environment.getattr((undefined(name='result_param') if l_2_result_param is missing else l_2_result_param), 'kind'), add_same_module_namespaces=True)
                    _loop_vars['param_type'] = l_2_param_type
                    l_2_response_type = t_5(environment.getattr((undefined(name='result_param') if l_2_result_param is missing else l_2_result_param), 'kind'))
                    _loop_vars['response_type'] = l_2_response_type
                    yield '\nstatic '
                    yield str((undefined(name='param_type') if l_2_param_type is missing else l_2_param_type))
                    yield ' '
                    yield str(environment.getattr(l_1_interface, 'name'))
                    yield '_'
                    yield str(environment.getattr(l_2_method, 'name'))
                    yield 'Transform(base::expected<\n    '
                    yield str(t_3(environment.getattr(environment.getattr(l_2_method, 'result_response'), 'success_kind'), add_same_module_namespaces=True))
                    yield ',\n    '
                    yield str(t_3(environment.getattr(environment.getattr(l_2_method, 'result_response'), 'failure_kind'), add_same_module_namespaces=True))
                    yield '> in) {\n  return in.has_value() ? '
                    yield str((undefined(name='response_type') if l_2_response_type is missing else l_2_response_type))
                    yield '::NewSuccess(std::move(in.value())) :\n                          '
                    yield str((undefined(name='response_type') if l_2_response_type is missing else l_2_response_type))
                    yield '::NewFailure(std::move(in.error()));\n}\n'
                if (environment.getattr(l_2_method, 'response_parameters') != None):
                    pass
                    yield '\nstatic void '
                    yield str(environment.getattr(l_1_interface, 'name'))
                    yield '_'
                    yield str(environment.getattr(l_2_method, 'name'))
                    yield 'Callback('
                    l_3_loop = missing
                    for l_3_param, l_3_loop in LoopContext(environment.getattr(l_2_method, 'response_parameters'), undefined):
                        l_3_name = l_3_kind = l_3_param_mojom_type = missing
                        _loop_vars = {}
                        pass
                        l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                        _loop_vars['name'] = l_3_name
                        l_3_kind = environment.getattr(l_3_param, 'kind')
                        _loop_vars['kind'] = l_3_kind
                        l_3_param_mojom_type = t_2((undefined(name='kind') if l_3_kind is missing else l_3_kind), add_same_module_namespaces=True)
                        _loop_vars['param_mojom_type'] = l_3_param_mojom_type
                        yield str((',' if (not environment.getattr(l_3_loop, 'first')) else cond_expr_undefined("the inline if-expression on line 332 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                        yield '\n  '
                        yield str((undefined(name='param_mojom_type') if l_3_param_mojom_type is missing else l_3_param_mojom_type))
                        yield ' param_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                    l_3_loop = l_3_param = l_3_name = l_3_kind = l_3_param_mojom_type = missing
                    yield ') {'
                    for l_3_param in environment.getattr(l_2_method, 'response_parameters'):
                        l_3_name = l_3_kind = missing
                        _loop_vars = {}
                        pass
                        l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                        _loop_vars['name'] = l_3_name
                        l_3_kind = environment.getattr(l_3_param, 'kind')
                        _loop_vars['kind'] = l_3_kind
                        yield '\n'
                        yield str(context.call(environment.getattr((undefined(name='util') if l_0_util is missing else l_0_util), 'add_instance'), (undefined(name='kind') if l_3_kind is missing else l_3_kind), str_join(('param_', (undefined(name='name') if l_3_name is missing else l_3_name), )), False, _loop_vars=_loop_vars))
                    l_3_param = l_3_name = l_3_kind = missing
                    yield '\n  mojolpmdbg("'
                    yield str(environment.getattr(l_1_interface, 'name'))
                    yield '.'
                    yield str(environment.getattr(l_2_method, 'name'))
                    yield 'Callback\\n");\n}\n'
                yield '\ntemplate <typename T>\nbool HandleCall(uint32_t instance_id,\n                      const '
                yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
                yield '::'
                yield str(environment.getattr(l_1_interface, 'name'))
                yield '_'
                yield str(environment.getattr(l_2_method, 'name'))
                yield '& input) {\n  T* instance =\n    mojolpm::GetContext()->GetInstance<T>(instance_id);\n  if (!instance || !instance->is_bound() || !instance->is_connected()) {\n    return false;\n  }\n\n  mojolpm::GetContext()->StartDeserialization();\n\n  bool mojolpm_result = true;'
                for l_3_param in environment.getattr(l_2_method, 'parameters'):
                    l_3_unnullable_kind = resolve('unnullable_kind')
                    l_3_param_maybe_mojom_type = resolve('param_maybe_mojom_type')
                    l_3_name = l_3_kind = l_3_param_mojom_type = missing
                    _loop_vars = {}
                    pass
                    l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                    _loop_vars['name'] = l_3_name
                    l_3_kind = environment.getattr(l_3_param, 'kind')
                    _loop_vars['kind'] = l_3_kind
                    l_3_param_mojom_type = t_3((undefined(name='kind') if l_3_kind is missing else l_3_kind), add_same_module_namespaces=True)
                    _loop_vars['param_mojom_type'] = l_3_param_mojom_type
                    yield '\n  '
                    yield str((undefined(name='param_mojom_type') if l_3_param_mojom_type is missing else l_3_param_mojom_type))
                    yield ' local_'
                    yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                    yield '{'
                    yield str(t_4((undefined(name='kind') if l_3_kind is missing else l_3_kind)))
                    yield '};'
                    if t_12((undefined(name='kind') if l_3_kind is missing else l_3_kind)):
                        pass
                        l_3_unnullable_kind = t_13((undefined(name='kind') if l_3_kind is missing else l_3_kind))
                        _loop_vars['unnullable_kind'] = l_3_unnullable_kind
                        l_3_param_maybe_mojom_type = t_3((undefined(name='unnullable_kind') if l_3_unnullable_kind is missing else l_3_unnullable_kind), add_same_module_namespaces=True)
                        _loop_vars['param_maybe_mojom_type'] = l_3_param_maybe_mojom_type
                        yield '\n  '
                        yield str((undefined(name='param_maybe_mojom_type') if l_3_param_maybe_mojom_type is missing else l_3_param_maybe_mojom_type))
                        yield ' local_maybe_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield '{'
                        yield str(t_4((undefined(name='unnullable_kind') if l_3_unnullable_kind is missing else l_3_unnullable_kind)))
                        yield '};'
                l_3_param = l_3_name = l_3_kind = l_3_param_mojom_type = l_3_unnullable_kind = l_3_param_maybe_mojom_type = missing
                for l_3_param in environment.getattr(l_2_method, 'parameters'):
                    l_3_name = l_3_kind = missing
                    _loop_vars = {}
                    pass
                    l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                    _loop_vars['name'] = l_3_name
                    l_3_kind = environment.getattr(l_3_param, 'kind')
                    _loop_vars['kind'] = l_3_kind
                    if (not t_12((undefined(name='kind') if l_3_kind is missing else l_3_kind))):
                        pass
                        yield '\n  mojolpm_result &= FromProto(input.m_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield '(), local_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield ');'
                    else:
                        pass
                        yield '\n  if (FromProto(input.m_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield '(), local_maybe_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield ')) {\n    local_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield ' = std::move(local_maybe_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield ');\n  }'
                l_3_param = l_3_name = l_3_kind = missing
                yield '\n  if (mojolpm_result) {\n    (*instance)->'
                yield str(environment.getattr(l_2_method, 'name'))
                yield '('
                l_3_loop = missing
                for l_3_param, l_3_loop in LoopContext(environment.getattr(l_2_method, 'parameters'), undefined):
                    l_3_name = l_3_kind = missing
                    _loop_vars = {}
                    pass
                    l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                    _loop_vars['name'] = l_3_name
                    l_3_kind = environment.getattr(l_3_param, 'kind')
                    _loop_vars['kind'] = l_3_kind
                    if t_11((undefined(name='kind') if l_3_kind is missing else l_3_kind)):
                        pass
                        yield '\n      local_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield str((',' if (not environment.getattr(l_3_loop, 'last')) else cond_expr_undefined("the inline if-expression on line 385 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                    else:
                        pass
                        yield '\n      std::move(local_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield ')'
                        yield str((',' if (not environment.getattr(l_3_loop, 'last')) else cond_expr_undefined("the inline if-expression on line 387 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                        yield '\n'
                l_3_loop = l_3_param = l_3_name = l_3_kind = missing
                if (environment.getattr(l_2_method, 'response_parameters') != None):
                    pass
                    yield str((',' if environment.getattr(l_2_method, 'parameters') else cond_expr_undefined("the inline if-expression on line 391 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                    if (environment.getattr(l_2_method, 'result_response') != None):
                        pass
                        yield 'base::BindOnce(&'
                        yield str(environment.getattr(l_1_interface, 'name'))
                        yield '_'
                        yield str(environment.getattr(l_2_method, 'name'))
                        yield 'Transform)\n        .Then(base::BindOnce(&'
                        yield str(environment.getattr(l_1_interface, 'name'))
                        yield '_'
                        yield str(environment.getattr(l_2_method, 'name'))
                        yield 'Callback)));'
                    else:
                        pass
                        yield 'base::BindOnce(&'
                        yield str(environment.getattr(l_1_interface, 'name'))
                        yield '_'
                        yield str(environment.getattr(l_2_method, 'name'))
                        yield 'Callback));'
                else:
                    pass
                    yield ');'
                yield '\n    mojolpm::GetContext()->EndDeserialization(Context::Rollback::kNoRollback);\n  } else {\n    mojolpm::GetContext()->EndDeserialization(Context::Rollback::kRollback);\n    mojolpmdbg("call failed\\n");\n  }\n\n  return mojolpm_result;\n}\n\nbool HandleRemoteCall(\n    uint32_t instance_id, const '
                yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
                yield '::'
                yield str(environment.getattr(l_1_interface, 'name'))
                yield '_'
                yield str(environment.getattr(l_2_method, 'name'))
                yield '& input) {\n  mojolpmdbg("HandleRemoteCall('
                yield str(environment.getattr(l_1_interface, 'name'))
                yield '::'
                yield str(environment.getattr(l_2_method, 'name'))
                yield ')\\n");\n  return HandleCall<::mojo::Remote<'
                yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
                yield '>>(instance_id, input);\n}\n\nbool HandleAssociatedRemoteCall(\n    uint32_t instance_id, const '
                yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
                yield '::'
                yield str(environment.getattr(l_1_interface, 'name'))
                yield '_'
                yield str(environment.getattr(l_2_method, 'name'))
                yield '& input) {\n  mojolpmdbg("HandleAssociatedRemoteCall('
                yield str(environment.getattr(l_1_interface, 'name'))
                yield '::'
                yield str(environment.getattr(l_2_method, 'name'))
                yield ')\\n");\n  return HandleCall<::mojo::AssociatedRemote<'
                yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
                yield '>>(instance_id, input);\n}\n\nbool HandleResponse(\n    uint32_t callback_id, const '
                yield str((undefined(name='proto_type') if l_1_proto_type is missing else l_1_proto_type))
                yield '::'
                yield str(environment.getattr(l_1_interface, 'name'))
                yield '_'
                yield str(environment.getattr(l_2_method, 'name'))
                yield 'Response& input) {\n  mojolpmdbg("HandleResponse('
                yield str(environment.getattr(l_1_interface, 'name'))
                yield '::'
                yield str(environment.getattr(l_2_method, 'name'))
                yield ')\\n");'
                if (environment.getattr(l_2_method, 'response_parameters') == None):
                    pass
                    yield '\n  return true;'
                else:
                    pass
                    yield '\n  auto mojolpm_callback = mojolpm::GetContext()->GetAndRemoveInstance<\n    '
                    yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
                    yield '::'
                    yield str(environment.getattr(l_2_method, 'name'))
                    yield 'Callback>(callback_id);\n\n  if (!mojolpm_callback) {\n    return true;\n  }\n\n  mojolpm::GetContext()->StartDeserialization();\n\n  bool mojolpm_result = true;'
                    for l_3_param in environment.getattr(l_2_method, 'response_parameters'):
                        l_3_unnullable_kind = resolve('unnullable_kind')
                        l_3_param_maybe_mojom_type = resolve('param_maybe_mojom_type')
                        l_3_name = l_3_kind = l_3_param_mojom_type = missing
                        _loop_vars = {}
                        pass
                        l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                        _loop_vars['name'] = l_3_name
                        l_3_kind = environment.getattr(l_3_param, 'kind')
                        _loop_vars['kind'] = l_3_kind
                        l_3_param_mojom_type = t_3((undefined(name='kind') if l_3_kind is missing else l_3_kind), add_same_module_namespaces=True)
                        _loop_vars['param_mojom_type'] = l_3_param_mojom_type
                        yield '\n  '
                        yield str((undefined(name='param_mojom_type') if l_3_param_mojom_type is missing else l_3_param_mojom_type))
                        yield ' local_'
                        yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                        yield '{'
                        yield str(t_4((undefined(name='kind') if l_3_kind is missing else l_3_kind)))
                        yield '};'
                        if t_12((undefined(name='kind') if l_3_kind is missing else l_3_kind)):
                            pass
                            l_3_unnullable_kind = t_13((undefined(name='kind') if l_3_kind is missing else l_3_kind))
                            _loop_vars['unnullable_kind'] = l_3_unnullable_kind
                            l_3_param_maybe_mojom_type = t_3((undefined(name='unnullable_kind') if l_3_unnullable_kind is missing else l_3_unnullable_kind), add_same_module_namespaces=True)
                            _loop_vars['param_maybe_mojom_type'] = l_3_param_maybe_mojom_type
                            yield '\n  '
                            yield str((undefined(name='param_maybe_mojom_type') if l_3_param_maybe_mojom_type is missing else l_3_param_maybe_mojom_type))
                            yield ' local_maybe_'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield '{'
                            yield str(t_4((undefined(name='unnullable_kind') if l_3_unnullable_kind is missing else l_3_unnullable_kind)))
                            yield '};'
                    l_3_param = l_3_name = l_3_kind = l_3_param_mojom_type = l_3_unnullable_kind = l_3_param_maybe_mojom_type = missing
                    for l_3_param in environment.getattr(l_2_method, 'response_parameters'):
                        l_3_name = l_3_kind = missing
                        _loop_vars = {}
                        pass
                        l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                        _loop_vars['name'] = l_3_name
                        l_3_kind = environment.getattr(l_3_param, 'kind')
                        _loop_vars['kind'] = l_3_kind
                        if (not t_12((undefined(name='kind') if l_3_kind is missing else l_3_kind))):
                            pass
                            yield '\n  mojolpm_result &= FromProto(input.m_'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield '(), local_'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield ');\n  mojolpmdbg("'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield ' %i\\n", mojolpm_result);'
                        else:
                            pass
                            yield '\n  if (FromProto(input.m_'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield '(), local_maybe_'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield ')) {\n    local_'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield ' = std::move(local_maybe_'
                            yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                            yield ');\n  }'
                    l_3_param = l_3_name = l_3_kind = missing
                    yield '\n  if (mojolpm_result) {'
                    if (environment.getattr(l_2_method, 'result_response') != None):
                        pass
                        l_2_container = ('local_' + environment.getattr(environment.getitem(environment.getattr(l_2_method, 'response_parameters'), 0), 'name'))
                        _loop_vars['container'] = l_2_container
                        yield '\n    if ('
                        yield str((undefined(name='container') if l_2_container is missing else l_2_container))
                        yield '->is_success()) {\n      std::move(*mojolpm_callback).Run(base::ok(std::move('
                        yield str((undefined(name='container') if l_2_container is missing else l_2_container))
                        yield '->get_success())));\n    } else {\n      std::move(*mojolpm_callback).Run(base::unexpected(std::move('
                        yield str((undefined(name='container') if l_2_container is missing else l_2_container))
                        yield '->get_failure())));\n    }'
                    else:
                        pass
                        yield 'std::move(*mojolpm_callback).Run('
                        l_3_loop = missing
                        for l_3_param, l_3_loop in LoopContext(environment.getattr(l_2_method, 'response_parameters'), undefined):
                            l_3_name = l_3_kind = missing
                            _loop_vars = {}
                            pass
                            l_3_name = t_1(environment.getattr(l_3_param, 'name'))
                            _loop_vars['name'] = l_3_name
                            l_3_kind = environment.getattr(l_3_param, 'kind')
                            _loop_vars['kind'] = l_3_kind
                            if (t_9((undefined(name='kind') if l_3_kind is missing else l_3_kind)) or t_8((undefined(name='kind') if l_3_kind is missing else l_3_kind))):
                                pass
                                yield '\n      '
                                yield str(t_2((undefined(name='kind') if l_3_kind is missing else l_3_kind), add_same_module_namespaces=True))
                                yield '(std::move(local_'
                                yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                                yield '))'
                                yield str((',' if (not environment.getattr(l_3_loop, 'last')) else cond_expr_undefined("the inline if-expression on line 476 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                            else:
                                pass
                                yield '\n      std::move(local_'
                                yield str((undefined(name='name') if l_3_name is missing else l_3_name))
                                yield ')'
                                yield str((',' if (not environment.getattr(l_3_loop, 'last')) else cond_expr_undefined("the inline if-expression on line 478 in 'mojolpm.cc.tmpl' evaluated to false and no else section was defined.")))
                        l_3_loop = l_3_param = l_3_name = l_3_kind = missing
                        yield ');'
                    yield '\n    mojolpm::GetContext()->EndDeserialization(Context::Rollback::kNoRollback);\n  } else {\n    mojolpm::GetContext()->EndDeserialization(Context::Rollback::kRollback);\n    mojolpm::GetContext()->AddInstance<\n      '
                    yield str((undefined(name='mojom_type') if l_1_mojom_type is missing else l_1_mojom_type))
                    yield '::'
                    yield str(environment.getattr(l_2_method, 'name'))
                    yield 'Callback>(callback_id, std::move(*mojolpm_callback));\n  }\n\n  return mojolpm_result;'
                yield '\n}\n'
            l_2_loop = l_2_method = l_2_result_param = l_2_param_type = l_2_response_type = l_2_container = missing
    l_1_loop = l_1_interface = l_1_mojom_type = l_1_proto_type = missing
    yield '}  // namespace mojolpm'

blocks = {}
debug_info = '5=103&13=105&14=109&17=112&18=114&19=116&20=118&23=121&24=124&27=126&28=130&33=133&34=136&35=137&38=139&39=143&40=145&41=147&42=151&43=153&44=155&45=157&46=158&49=160&50=161&53=163&54=167&55=169&56=171&57=175&58=177&59=179&60=181&61=182&64=184&65=185&68=188&69=192&70=194&71=197&73=201&76=204&77=208&78=211&79=215&80=217&81=219&82=221&84=227&85=229&88=236&89=240&90=242&91=244&93=247&94=251&95=254&102=261&104=263&107=265&120=267&122=269&132=271&134=273&135=275&141=277&142=279&148=283&154=285&155=287&163=289&164=291&166=293&169=295&182=297&184=299&194=301&196=303&197=305&203=307&204=309&210=313&216=315&217=317&224=319&225=323&226=325&227=329&228=331&229=333&230=335&231=337&235=340&236=344&237=346&238=348&239=352&240=354&241=356&242=358&243=359&250=364&251=368&252=370&253=372&254=375&258=377&259=381&260=385&263=389&264=391&275=393&279=395&280=399&281=403&284=407&285=409&297=411&300=413&301=417&302=421&313=426&315=433&316=435&317=437&318=439&319=442&320=448&321=450&322=452&323=454&327=456&328=459&329=464&330=468&331=470&332=472&333=476&336=481&337=485&338=487&339=490&341=493&346=498&356=504&357=510&358=512&359=514&360=517&361=523&362=525&363=527&364=530&368=537&369=541&370=543&371=545&372=548&374=555&375=559&380=565&381=568&382=572&383=574&384=576&385=579&387=584&390=589&391=591&392=592&393=595&394=599&396=606&411=614&412=620&413=624&417=626&418=632&419=636&423=638&424=644&425=648&429=654&438=658&439=664&440=666&441=668&442=671&443=677&444=679&445=681&446=684&450=691&451=695&452=697&453=699&454=702&455=706&457=711&458=715&463=721&464=723&465=726&466=728&468=730&472=736&473=740&474=742&475=744&476=747&478=755&487=761'